/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.notifications;

import akka.util.Timeout;
import java.io.Serializable;
import java.time.Instant;
import java.util.UUID;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.ui.listener.ProcessChangeEvent;
import pl.touk.nussknacker.ui.notifications.CurrentDeployments;
import pl.touk.nussknacker.ui.notifications.DataToRefresh$;
import pl.touk.nussknacker.ui.notifications.Notification;
import pl.touk.nussknacker.ui.notifications.NotificationEvent;
import pl.touk.nussknacker.ui.notifications.NotificationType$;
import pl.touk.nussknacker.ui.notifications.NotificationsListener;
import pl.touk.nussknacker.ui.process.deployment.DeployInfo;
import pl.touk.nussknacker.ui.process.deployment.DeploymentActionType;
import pl.touk.nussknacker.ui.process.deployment.DeploymentActionType$Cancel$;
import pl.touk.nussknacker.ui.process.deployment.DeploymentActionType$Deployment$;
import pl.touk.nussknacker.ui.process.deployment.DeploymentStatusResponse;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\u0005\n\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tA\u0001\u0011\t\u0011)A\u0005C!)A\u0005\u0001C\u0001K!)!\u0002\u0001C\u0001S!)a\r\u0001C\u0005O\")Q\u000e\u0001C\u0005]\")1\u000f\u0001C\u0005i\n\u0019bj\u001c;jM&\u001c\u0017\r^5p]N+'O^5dK*\u0011!bC\u0001\u000e]>$\u0018NZ5dCRLwN\\:\u000b\u00051i\u0011AA;j\u0015\tqq\"A\u0006okN\u001c8N\\1dW\u0016\u0014(B\u0001\t\u0012\u0003\u0011!x.^6\u000b\u0003I\t!\u0001\u001d7\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002%\r,(O]3oi\u0012+\u0007\u000f\\8z[\u0016tGo\u001d\t\u0003;yi\u0011!C\u0005\u0003?%\u0011!cQ;se\u0016tG\u000fR3qY>LX.\u001a8ug\u0006)1\u000f^8sKB\u0011QDI\u0005\u0003G%\u0011QCT8uS\u001aL7-\u0019;j_:\u001cH*[:uK:,'/\u0001\u0004=S:LGO\u0010\u000b\u0004M\u001dB\u0003CA\u000f\u0001\u0011\u0015Y2\u00011\u0001\u001d\u0011\u0015\u00013\u00011\u0001\")\rQs*\u0017\u000b\u0004W\u0001+\u0005c\u0001\u00170c5\tQF\u0003\u0002//\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Aj#A\u0002$viV\u0014X\rE\u00023uur!a\r\u001d\u000f\u0005Q:T\"A\u001b\u000b\u0005Y\u001a\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\tIt#A\u0004qC\u000e\\\u0017mZ3\n\u0005mb$\u0001\u0002'jgRT!!O\f\u0011\u0005uq\u0014BA \n\u00051qu\u000e^5gS\u000e\fG/[8o\u0011\u0015\tE\u0001q\u0001C\u0003\t)7\r\u0005\u0002-\u0007&\u0011A)\f\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQA\u0012\u0003A\u0004\u001d\u000bq\u0001^5nK>,H\u000f\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!Q\u000f^5m\u0015\u0005a\u0015\u0001B1lW\u0006L!AT%\u0003\u000fQKW.Z8vi\")\u0001\u000b\u0002a\u0001#\u0006!Qo]3s!\t\u0011v+D\u0001T\u0015\t!V+A\u0002ba&T!AV\u0006\u0002\u0011M,7-\u001e:jifL!\u0001W*\u0003\u00151{wmZ3e+N,'\u000fC\u0003[\t\u0001\u00071,\u0001\no_RLg-[2bi&|gn]!gi\u0016\u0014\bc\u0001\f]=&\u0011Ql\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001\u0002;j[\u0016T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\n9\u0011J\\:uC:$\u0018aD;tKJ$U\r\u001d7ps6,g\u000e^:\u0015\u0007!\\G\u000eE\u00023SvJ!A\u001b\u001f\u0003\u0007M+\u0017\u000fC\u0003Q\u000b\u0001\u0007\u0011\u000bC\u0003[\u000b\u0001\u00071,\u0001\u0010qe\u0016\u0004\u0018M]3EKBdw._7f]Rtu\u000e^5gS\u000e\fG/[8ogR\u0011qN\u001d\u000b\u0004WA\f\b\"B!\u0007\u0001\b\u0011\u0005\"\u0002$\u0007\u0001\b9\u0005\"\u0002)\u0007\u0001\u0004\t\u0016aH2veJ,g\u000e\u001e#fa2|\u00170\\3oiR{gj\u001c;jM&\u001c\u0017\r^5p]R!Q(^A\u0001\u0011\u00151x\u00011\u0001x\u0003-\u0001(o\\2fgNt\u0015-\\3\u0011\u0005atX\"A=\u000b\u0005i\\\u0018a\u00029s_\u000e,7o\u001d\u0006\u0003)rT!!`\u0007\u0002\r\u0015tw-\u001b8f\u0013\ty\u0018PA\u0006Qe>\u001cWm]:OC6,\u0007bBA\u0002\u000f\u0001\u0007\u0011QA\u0001\u000fI\u0016\u0004Hn\\=nK:$\u0018J\u001c4p!\u0011\t9!a\u0004\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t!\u0002Z3qY>LX.\u001a8u\u0015\tQ8\"\u0003\u0003\u0002\u0012\u0005%!A\u0003#fa2|\u00170\u00138g_\u0002")
public class NotificationService {
    private final CurrentDeployments currentDeployments;
    private final NotificationsListener store;

    public Future<List<Notification>> notifications(LoggedUser user, Option<Instant> notificationsAfter, ExecutionContext ec, Timeout timeout) {
        return Future$.MODULE$.sequence((IterableOnce)new .colon.colon(this.prepareDeploymentNotifications(user, ec, timeout), (List)new .colon.colon((Object)Future$.MODULE$.successful(this.userDeployments(user, notificationsAfter)), (List)Nil$.MODULE$)), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)x$3 -> (List)x$3.flatten(Predef$.MODULE$.$conforms()), ec);
    }

    private Seq<Notification> userDeployments(LoggedUser user, Option<Instant> notificationsAfter) {
        return this.store.dataFor(user, notificationsAfter).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends NotificationEvent, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String id = A1.id();
                    ProcessChangeEvent processChangeEvent = A1.event();
                    ProcessName name = A1.scenarioName();
                    if (processChangeEvent instanceof ProcessChangeEvent.OnDeployActionFailed) {
                        ProcessChangeEvent.OnDeployActionFailed onDeployActionFailed = (ProcessChangeEvent.OnDeployActionFailed)processChangeEvent;
                        Throwable reason = onDeployActionFailed.reason();
                        return (B1)new Notification(id, (Option<ProcessName>)new Some((Object)name), "Deployment of " + name.value() + " failed with " + reason.getMessage(), (Option<Enumeration.Value>)new Some((Object)NotificationType$.MODULE$.error()), (List<Enumeration.Value>)new .colon.colon((Object)DataToRefresh$.MODULE$.state(), (List)Nil$.MODULE$));
                    }
                }
                if (A1 != null) {
                    String id = A1.id();
                    ProcessName name = A1.scenarioName();
                    if (A1.event() instanceof ProcessChangeEvent.OnDeployActionSuccess) {
                        return (B1)new Notification(id, (Option<ProcessName>)new Some((Object)name), "Deployment finished", (Option<Enumeration.Value>)None$.MODULE$, (List<Enumeration.Value>)new .colon.colon((Object)DataToRefresh$.MODULE$.versions(), (List)new .colon.colon((Object)DataToRefresh$.MODULE$.activity(), (List)Nil$.MODULE$)));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(NotificationEvent x1) {
                ProcessChangeEvent processChangeEvent;
                NotificationEvent notificationEvent = x1;
                if (notificationEvent != null && (processChangeEvent = notificationEvent.event()) instanceof ProcessChangeEvent.OnDeployActionFailed) {
                    return true;
                }
                return notificationEvent != null && notificationEvent.event() instanceof ProcessChangeEvent.OnDeployActionSuccess;
            }
        });
    }

    private Future<List<Notification>> prepareDeploymentNotifications(LoggedUser user, ExecutionContext ec, Timeout timeout) {
        return this.currentDeployments.retrieve(timeout).map((Function1 & Serializable)x0$1 -> {
            DeploymentStatusResponse deploymentStatusResponse = x0$1;
            if (deploymentStatusResponse != null) {
                Map<ProcessName, DeployInfo> deploymentInfos = deploymentStatusResponse.deploymentInfo();
                return ((IterableOnceOps)((IterableOps)deploymentInfos.filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)NotificationService.$anonfun$prepareDeploymentNotifications$2(user, x$4)))).map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        ProcessName k = (ProcessName)tuple2._1();
                        DeployInfo v = (DeployInfo)tuple2._2();
                        return this.currentDeploymentToNotification(k, v);
                    }
                    throw new MatchError((Object)tuple2);
                })).toList();
            }
            throw new MatchError((Object)deploymentStatusResponse);
        }, ec);
    }

    private Notification currentDeploymentToNotification(ProcessName processName, DeployInfo deploymentInfo) {
        String string;
        DeploymentActionType deploymentActionType = deploymentInfo.action();
        if (DeploymentActionType$Deployment$.MODULE$.equals(deploymentActionType)) {
            string = "deployed";
        } else if (DeploymentActionType$Cancel$.MODULE$.equals(deploymentActionType)) {
            string = "cancelled";
        } else {
            throw new MatchError((Object)deploymentActionType);
        }
        String actionString = string;
        return new Notification(UUID.randomUUID().toString(), (Option<ProcessName>)None$.MODULE$, "Scenario " + processName.value() + " is being " + actionString + " by " + deploymentInfo.userId(), (Option<Enumeration.Value>)new Some((Object)NotificationType$.MODULE$.success()), (List<Enumeration.Value>)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$prepareDeploymentNotifications$2(LoggedUser user$3, Tuple2 x$4) {
        String string = ((DeployInfo)x$4._2()).userId();
        String string2 = user$3.username();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public NotificationService(CurrentDeployments currentDeployments, NotificationsListener store) {
        this.currentDeployments = currentDeployments;
        this.store = store;
    }
}

