/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.notifications;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.ui.listener.ProcessChangeEvent;
import pl.touk.nussknacker.ui.listener.ProcessChangeListener;
import pl.touk.nussknacker.ui.listener.User;
import pl.touk.nussknacker.ui.notifications.NotificationConfig;
import pl.touk.nussknacker.ui.notifications.NotificationEvent;
import pl.touk.nussknacker.ui.notifications.NotificationsListener$;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001B\b\u0011\u0001mA\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!A\u0011\u000b\u0001B\u0001B\u0003%!\u000bC\u0003[\u0001\u0011\u00051\fC\u0003a\u0001\u0011\u0005\u0013\rC\u0003v\u0001\u0011%a\u000f\u0003\u0004}\u0001\u0011\u0005\u0001# \u0005\n\u0003c\u0001\u0001\u0019!C\u0005\u0003gA\u0011\"!\u000e\u0001\u0001\u0004%I!a\u000e\t\u000f\u0005u\u0002\u0001)Q\u0005}\u001eI\u0011q\t\t\u0002\u0002#\u0005\u0011\u0011\n\u0004\t\u001fA\t\t\u0011#\u0001\u0002L!1!\f\u0004C\u0001\u0003\u001bB\u0011\"a\u0014\r#\u0003%\t!!\u0015\u0003+9{G/\u001b4jG\u0006$\u0018n\u001c8t\u0019&\u001cH/\u001a8fe*\u0011\u0011CE\u0001\u000e]>$\u0018NZ5dCRLwN\\:\u000b\u0005M!\u0012AA;j\u0015\t)b#A\u0006okN\u001c8N\\1dW\u0016\u0014(BA\f\u0019\u0003\u0011!x.^6\u000b\u0003e\t!\u0001\u001d7\u0004\u0001M!\u0001\u0001\b\u0012)!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111EJ\u0007\u0002I)\u0011QEE\u0001\tY&\u001cH/\u001a8fe&\u0011q\u0005\n\u0002\u0016!J|7-Z:t\u0007\"\fgnZ3MSN$XM\\3s!\tI\u0003'D\u0001+\u0015\tYC&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002.]\u0005AA/\u001f9fg\u00064WMC\u00010\u0003\r\u0019w.\\\u0005\u0003c)\u00121\u0002T1{s2{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"\u0001N\u001b\u000e\u0003AI!A\u000e\t\u0003%9{G/\u001b4jG\u0006$\u0018n\u001c8D_:4\u0017nZ\u0001\nM\u0016$8\r\u001b(b[\u0016\u0004B!H\u001d<\u000b&\u0011!H\b\u0002\n\rVt7\r^5p]F\u0002\"\u0001P\"\u000e\u0003uR!AP \u0002\u000fA\u0014xnY3tg*\u0011\u0001)Q\u0001\u0004CBL'B\u0001\"\u0015\u0003\u0019)gnZ5oK&\u0011A)\u0010\u0002\n!J|7-Z:t\u0013\u0012\u00042AR%L\u001b\u00059%B\u0001%\u001f\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0015\u001e\u0013aAR;ukJ,\u0007cA\u000fM\u001d&\u0011QJ\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005qz\u0015B\u0001)>\u0005-\u0001&o\\2fgNt\u0015-\\3\u0002\u000b\rdwnY6\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016\u0001\u0002;j[\u0016T\u0011aV\u0001\u0005U\u00064\u0018-\u0003\u0002Z)\n)1\t\\8dW\u00061A(\u001b8jiz\"B\u0001X/_?B\u0011A\u0007\u0001\u0005\u0006e\u0011\u0001\ra\r\u0005\u0006o\u0011\u0001\r\u0001\u000f\u0005\b#\u0012\u0001\n\u00111\u0001S\u0003\u0019A\u0017M\u001c3mKR\u0011!\r\u001d\u000b\u0004G\u001a\\\u0007CA\u000fe\u0013\t)gD\u0001\u0003V]&$\b\"B4\u0006\u0001\bA\u0017AA3d!\t1\u0015.\u0003\u0002k\u000f\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006Y\u0016\u0001\u001d!\\\u0001\u0005kN,'\u000f\u0005\u0002$]&\u0011q\u000e\n\u0002\u0005+N,'\u000fC\u0003r\u000b\u0001\u0007!/A\u0003fm\u0016tG\u000f\u0005\u0002$g&\u0011A\u000f\n\u0002\u0013!J|7-Z:t\u0007\"\fgnZ3Fm\u0016tG/\u0001\fgS2$XM](mI:{G/\u001b4jG\u0006$\u0018n\u001c8t)\t\u0019w\u000fC\u0003y\r\u0001\u0007\u00110A\u0002o_^\u0004\"a\u0015>\n\u0005m$&aB%ogR\fg\u000e^\u0001\bI\u0006$\u0018MR8s)\u0015q\u00181DA\u0016!\u0015y\u0018qBA\u000b\u001d\u0011\t\t!a\u0003\u000f\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002\u001b\u0003\u0019a$o\\8u}%\tq$C\u0002\u0002\u000ey\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0012\u0005M!\u0001\u0002'jgRT1!!\u0004\u001f!\r!\u0014qC\u0005\u0004\u00033\u0001\"!\u0005(pi&4\u0017nY1uS>tWI^3oi\"1An\u0002a\u0001\u0003;\u0001B!a\b\u0002(5\u0011\u0011\u0011\u0005\u0006\u0004\u0001\u0006\r\"bAA\u0013%\u0005A1/Z2ve&$\u00180\u0003\u0003\u0002*\u0005\u0005\"A\u0003'pO\u001e,G-V:fe\"9\u0011QF\u0004A\u0002\u0005=\u0012A\u00058pi&4\u0017nY1uS>t7/\u00114uKJ\u00042!\b'z\u0003\u0011!\u0017\r^1\u0016\u0003y\f\u0001\u0002Z1uC~#S-\u001d\u000b\u0004G\u0006e\u0002\u0002CA\u001e\u0013\u0005\u0005\t\u0019\u0001@\u0002\u0007a$\u0013'A\u0003eCR\f\u0007\u0005K\u0002\u000b\u0003\u0003\u00022!HA\"\u0013\r\t)E\b\u0002\tm>d\u0017\r^5mK\u0006)bj\u001c;jM&\u001c\u0017\r^5p]Nd\u0015n\u001d;f]\u0016\u0014\bC\u0001\u001b\r'\taA\u0004\u0006\u0002\u0002J\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a\u0015+\u0007I\u000b)f\u000b\u0002\u0002XA!\u0011\u0011LA2\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013!C;oG\",7m[3e\u0015\r\t\tGH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA3\u00037\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class NotificationsListener
implements ProcessChangeListener,
LazyLogging {
    private final NotificationConfig config;
    private final Function1<ProcessId, Future<Option<ProcessName>>> fetchName;
    private final Clock clock;
    private volatile List<NotificationEvent> data;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Clock $lessinit$greater$default$3() {
        return NotificationsListener$.MODULE$.$lessinit$greater$default$3();
    }

    private Logger logger$lzycompute() {
        NotificationsListener notificationsListener = this;
        synchronized (notificationsListener) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private List<NotificationEvent> data() {
        return this.data;
    }

    private void data_$eq(List<NotificationEvent> x$1) {
        this.data = x$1;
    }

    public void handle(ProcessChangeEvent event, ExecutionContext ec, User user) {
        Instant now = Instant.now(this.clock);
        ((Future)this.fetchName.apply((Object)event.processId())).onComplete((Function1 & Serializable)x0$1 -> {
            NotificationsListener.$anonfun$handle$1(this, event, now, user, x0$1);
            return BoxedUnit.UNIT;
        }, ec);
        this.filterOldNotifications(now);
    }

    private synchronized void filterOldNotifications(Instant now) {
        this.data_$eq((List<NotificationEvent>)this.data().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NotificationsListener.$anonfun$filterOldNotifications$1(this, now, x$1))));
    }

    public List<NotificationEvent> dataFor(LoggedUser user, Option<Instant> notificationsAfter) {
        this.filterOldNotifications(Instant.now(this.clock));
        return this.data().filter((Function1 & Serializable)event -> BoxesRunTime.boxToBoolean((boolean)NotificationsListener.$anonfun$dataFor$1(user, notificationsAfter, event)));
    }

    public static final /* synthetic */ void $anonfun$handle$1(NotificationsListener $this, ProcessChangeEvent event$1, Instant now$1, User user$1, Try x0$1) {
        Option option;
        boolean bl = false;
        Success success = null;
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("Failed to retrieve scenario name for id: " + event$1.processId(), e);
                return;
            }
            return;
        }
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option2 = (Option)success.value();
            if (None$.MODULE$.equals(option2)) {
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error("Failed to retrieve scenario name for id: {}", (Object)event$1.processId());
                    return;
                }
                return;
            }
        }
        if (bl && (option = (Option)success.value()) instanceof Some) {
            Some some = (Some)option;
            ProcessName scenarioName = (ProcessName)some.value();
            NotificationsListener notificationsListener = $this;
            synchronized (notificationsListener) {
                NotificationEvent notificationEvent = new NotificationEvent(UUID.randomUUID().toString(), event$1, now$1, user$1, scenarioName);
                $this.data_$eq((List<NotificationEvent>)$this.data().$colon$colon((Object)notificationEvent));
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$filterOldNotifications$1(NotificationsListener $this, Instant now$2, NotificationEvent x$1) {
        return x$1.date().isAfter(now$2.minus($this.config.duration().toMillis(), ChronoUnit.MILLIS));
    }

    public static final /* synthetic */ boolean $anonfun$dataFor$1(LoggedUser user$2, Option notificationsAfter$1, NotificationEvent event) {
        String string = event.user().id();
        String string2 = user$2.id();
        return !(string != null ? !string.equals(string2) : string2 != null) && !notificationsAfter$1.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isAfter(event.date())));
    }

    public NotificationsListener(NotificationConfig config, Function1<ProcessId, Future<Option<ProcessName>>> fetchName, Clock clock) {
        this.config = config;
        this.fetchName = fetchName;
        this.clock = clock;
        LazyLogging.$init$((LazyLogging)this);
        this.data = Nil$.MODULE$;
    }
}

