/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.util;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.io.ResourceResolverFactory;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.graph.evaluatedparam;
import pl.touk.nussknacker.engine.graph.expression.Expression;
import pl.touk.nussknacker.engine.graph.node;
import pl.touk.nussknacker.engine.graph.variable;
import pl.touk.nussknacker.restmodel.displayedgraph.DisplayableProcess;
import pl.touk.nussknacker.restmodel.processdetails;
import pl.touk.nussknacker.ui.process.repository.DbProcessActivityRepository;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scala.xml.XML$;

public final class PdfExporter$
implements LazyLogging {
    public static final PdfExporter$ MODULE$ = new PdfExporter$();
    private static final FopFactory fopFactory;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        fopFactory = new FopConfParser(MODULE$.getClass().getResourceAsStream("/fop/config.xml"), new URI("http://touk.pl"), ResourceResolverFactory.createDefaultResourceResolver()).getFopFactoryBuilder().build();
    }

    private Logger logger$lzycompute() {
        PdfExporter$ pdfExporter$ = this;
        synchronized (pdfExporter$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private FopFactory fopFactory() {
        return fopFactory;
    }

    public byte[] exportToPdf(String svg, processdetails.BaseProcessDetails<DisplayableProcess> processDetails, DbProcessActivityRepository.ProcessActivity processActivity) {
        this.initFontsIfNeeded();
        Elem fopXml = this.prepareFopXml(svg.replaceAll("\u00a0", " ").replaceAll("[^\\p{ASCII}]", ""), processDetails, processActivity, (DisplayableProcess)processDetails.json());
        return this.createPdf(fopXml);
    }

    private String format(Instant instant) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss [VV]");
        return instant.atZone(ZoneId.systemDefault()).format(formatter);
    }

    private synchronized void initFontsIfNeeded() {
        File dir = new File("/tmp/fop/fonts");
        dir.mkdirs();
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"OpenSans-BoldItalic.ttf", "OpenSans-Bold.ttf", "OpenSans-ExtraBoldItalic.ttf", "OpenSans-ExtraBold.ttf", "OpenSans-Italic.ttf", "OpenSans-LightItalic.ttf", "OpenSans-Light.ttf", "OpenSans-Regular.ttf", "OpenSans-SemiboldItalic.ttf", "OpenSans-Semibold.ttf"}))).filterNot((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)PdfExporter$.$anonfun$initFontsIfNeeded$1(dir, name))).foreach((Function1 & Serializable)name -> BoxesRunTime.boxToInteger((int)PdfExporter$.$anonfun$initFontsIfNeeded$2(dir, name)));
    }

    private byte[] createPdf(Elem fopXml) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Fop fop = this.fopFactory().newFop("application/pdf", (OutputStream)out);
        StreamSource src = new StreamSource(new ByteArrayInputStream(fopXml.toString().getBytes(StandardCharsets.UTF_8)));
        TransformerFactory.newInstance().newTransformer().transform(src, new SAXResult(fop.getDefaultHandler()));
        return out.toByteArray();
    }

    private Elem prepareFopXml(String svg, processdetails.BaseProcessDetails<DisplayableProcess> processDetails, DbProcessActivityRepository.ProcessActivity processActivity, DisplayableProcess displayableProcess) {
        Elem diagram = (Elem)XML$.MODULE$.loadString(svg);
        processdetails.ProcessVersion currentVersion = (processdetails.ProcessVersion)processDetails.history().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PdfExporter$.$anonfun$prepareFopXml$1(processDetails, x$1))).get();
        TopScope$ $tmpscope = TopScope$.MODULE$;
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, "http://www.w3.org/1999/XSL/Format", (NamespaceBinding)$tmpscope);
        Null$ $md = Null$.MODULE$;
        $md = new PrefixedAttribute("xml", "lang", (Seq)new Text("en"), (MetaData)$md);
        $md = new UnprefixedAttribute("font-size", (Seq)new Text("12pt"), (MetaData)$md);
        $md = new UnprefixedAttribute("font-family", (Seq)new Text("OpenSans"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("master-name", (Seq)new Text("left"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("page-height", (Seq)new Text("29.7cm"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("page-width", (Seq)new Text("21cm"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("margin-top", (Seq)new Text("1cm"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("margin-bottom", (Seq)new Text("2cm"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("margin-left", (Seq)new Text("1.5cm"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("margin-right", (Seq)new Text("1.5cm"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("margin-bottom", (Seq)new Text("2cm"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("margin-top", (Seq)new Text("0.5cm"), (MetaData)$md3);
        $buf3.$amp$plus((Object)new Elem(null, "region-body", (MetaData)$md3, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("extent", (Seq)new Text("0.5cm"), (MetaData)$md4);
        $buf3.$amp$plus((Object)new Elem(null, "region-after", (MetaData)$md4, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "simple-page-master", (MetaData)$md2, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n\n      "));
        $buf.$amp$plus((Object)new Elem(null, "layout-master-set", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("master-reference", (Seq)new Text("left"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("id", (Seq)new Text("N2528"), (MetaData)$md5);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("flow-name", (Seq)new Text("xsl-region-after"), (MetaData)$md6);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("font-size", (Seq)new Text("10pt"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("text-align-last", (Seq)new Text("center"), (MetaData)$md7);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "page-number", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "block", (MetaData)$md7, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "static-content", (MetaData)$md6, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n\n        "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("flow-name", (Seq)new Text("xsl-region-body"), (MetaData)$md8);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("text-align", (Seq)new Text("center"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("font-size", (Seq)new Text("16pt"), (MetaData)$md9);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf8.$amp$plus((Object)processDetails.name());
        $buf8.$amp$plus((Object)new Text("\n            (\n            "));
        $buf8.$amp$plus((Object)processDetails.processCategory());
        $buf8.$amp$plus((Object)new Text("\n            )\n          "));
        $buf7.$amp$plus((Object)new Elem(null, "block", (MetaData)$md9, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("space-before.minimum", (Seq)new Text("1em"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("font-size", (Seq)new Text("14pt"), (MetaData)$md10);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n              Version:\n              "));
        $buf10.$amp$plus((Object)processDetails.processVersionId());
        $buf10.$amp$plus((Object)new Text("\n            "));
        $buf9.$amp$plus((Object)new Elem(null, "block", (MetaData)$md10, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("space-before.minimum", (Seq)new Text("0.5em"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("font-size", (Seq)new Text("14pt"), (MetaData)$md11);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n              Saved by\n              "));
        $buf11.$amp$plus((Object)currentVersion.user());
        $buf11.$amp$plus((Object)new Text("\n              at\n              "));
        $buf11.$amp$plus((Object)this.format(currentVersion.createDate()));
        $buf11.$amp$plus((Object)new Text("\n            "));
        $buf9.$amp$plus((Object)new Elem(null, "block", (MetaData)$md11, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("space-before.minimum", (Seq)new Text("0.5em"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("text-align", (Seq)new Text("left"), (MetaData)$md12);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n              "));
        $buf12.$amp$plus(processDetails.description().getOrElse((Function0 & Serializable)() -> ""));
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf9.$amp$plus((Object)new Elem(null, "block", (MetaData)$md12, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("space-before.minimum", (Seq)new Text("3em"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("text-align", (Seq)new Text("center"), (MetaData)$md13);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n              "));
        TopScope$ $tmpscope2 = $scope;
        TopScope$ $scope2 = $tmpscope2 = new NamespaceBinding("svg", "http://www.w3.org/2000/svg", (NamespaceBinding)$tmpscope2);
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("text-align", (Seq)new Text("center"), (MetaData)$md14);
        $md14 = new UnprefixedAttribute("display-align", (Seq)new Text("center"), (MetaData)$md14);
        $md14 = new UnprefixedAttribute("content-height", (Seq)new Text("400pt"), (MetaData)$md14);
        $md14 = new UnprefixedAttribute("content-width", (Seq)new Text("500pt"), (MetaData)$md14);
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n                "));
        $buf14.$amp$plus((Object)diagram);
        $buf14.$amp$plus((Object)new Text("\n              "));
        $buf13.$amp$plus((Object)new Elem(null, "instream-foreign-object", (MetaData)$md14, (NamespaceBinding)$scope2, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf13.$amp$plus((Object)new Text("\n            "));
        $buf9.$amp$plus((Object)new Elem(null, "block", (MetaData)$md13, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf7.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf7.$amp$plus((Object)this.nodesSummary(displayableProcess));
        Null$ $md15 = Null$.MODULE$;
        $md15 = new UnprefixedAttribute("text-align", (Seq)new Text("left"), (MetaData)$md15);
        $md15 = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md15);
        $md15 = new UnprefixedAttribute("font-size", (Seq)new Text("15pt"), (MetaData)$md15);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n          Nodes details\n        "));
        $buf7.$amp$plus((Object)new Elem(null, "block", (MetaData)$md15, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf7.$amp$plus((Object)displayableProcess.nodes().map((Function1 & Serializable)node2 -> MODULE$.nodeDetails((node.NodeData)node2)));
        $buf7.$amp$plus((Object)this.comments(processActivity));
        $buf7.$amp$plus((Object)this.attachments(processActivity));
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "flow", (MetaData)$md8, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "page-sequence", (MetaData)$md5, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n\n    "));
        return new Elem(null, "root", (MetaData)$md, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    /*
     * WARNING - void declaration
     */
    private Elem comments(DbProcessActivityRepository.ProcessActivity processActivity) {
        void var2_2;
        Elem elem;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n    "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("margin-top", (Seq)new Text("5pt"), (MetaData)$md);
        $md = new UnprefixedAttribute("margin-bottom", (Seq)new Text("25pt"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("text-align", (Seq)new Text("left"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("font-size", (Seq)new Text("15pt"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        Comments\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "block", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("table-layout", (Seq)new Text("fixed"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("width", (Seq)new Text("100%"), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ $tmpscope = TopScope$.MODULE$;
        TopScope$ $scope = $tmpscope = new NamespaceBinding("fox", "http://xmlgraphics.apache.org/fop/extensions", (NamespaceBinding)$tmpscope);
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(3)"), (MetaData)$md4);
        $md4 = new PrefixedAttribute("fox", "header", (Seq)new Text("true"), (MetaData)$md4);
        $buf4.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md4, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ $tmpscope2 = TopScope$.MODULE$;
        TopScope$ $scope2 = $tmpscope2 = new NamespaceBinding("fox", "http://xmlgraphics.apache.org/fop/extensions", (NamespaceBinding)$tmpscope2);
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(3)"), (MetaData)$md5);
        $md5 = new PrefixedAttribute("fox", "header", (Seq)new Text("true"), (MetaData)$md5);
        $buf4.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md5, (NamespaceBinding)$scope2, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(7)"), (MetaData)$md6);
        $buf4.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md7);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md8);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Date"));
        $buf7.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n            "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md9);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Author"));
        $buf9.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf6.$amp$plus((Object)new Text("\n            "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md10);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("Comment"));
        $buf11.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf11.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "table-row", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "table-header", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n          "));
        if (processActivity.comments().isEmpty()) {
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("\n            "));
            $buf14.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf14.$amp$plus((Object)new Text("\n          "));
            Elem elem2 = new Elem(null, "table-cell", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14));
            elem = elem2;
        } else {
            elem = ((List)processActivity.comments().sortBy((Function1 & Serializable)x$2 -> x$2.createDate(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)comment -> {
                void var1_1;
                void var3_3;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n              "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md);
                $md = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n                  "));
                $buf3.$amp$plus((Object)MODULE$.format(comment.createDate()));
                $buf3.$amp$plus((Object)new Text("\n                "));
                $buf2.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
                $buf2.$amp$plus((Object)new Text("\n              "));
                $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
                $buf.$amp$plus((Object)new Text("\n              "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md2);
                $md2 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md2);
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)new Text("\n                  "));
                $buf5.$amp$plus((Object)comment.user());
                $buf5.$amp$plus((Object)new Text("\n                "));
                $buf4.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
                $buf4.$amp$plus((Object)new Text("\n              "));
                $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
                $buf.$amp$plus((Object)new Text("\n              "));
                Null$ $md3 = Null$.MODULE$;
                $md3 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md3);
                $md3 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md3);
                NodeBuffer $buf6 = new NodeBuffer();
                $buf6.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf7 = new NodeBuffer();
                $buf7.$amp$plus((Object)new Text("\n                  "));
                $buf7.$amp$plus((Object)comment.content());
                $buf7.$amp$plus((Object)new Text("\n                "));
                $buf6.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
                $buf6.$amp$plus((Object)new Text("\n              "));
                $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
                $buf.$amp$plus((Object)new Text("\n            "));
                return new Elem(null, "table-row", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            });
        }
        $buf13.$amp$plus((Object)elem);
        $buf13.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "table-body", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "table", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "block", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n  "));
        return new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    /*
     * Unable to fully structure code
     */
    private NodeSeq nodeDetails(node.NodeData node) {
        block28: {
            block29: {
                block27: {
                    var4_2 = node;
                    if (!(var4_2 instanceof node.Source) || (var6_4 = (var5_3 = (node.Source)var4_2).ref()) == null) break block27;
                    typ = var6_4.typ();
                    params = var6_4.parameters();
                    var9_7 = new Tuple2((Object)"Type", (Object)typ);
                    v0 = params.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$1(pl.touk.nussknacker.engine.graph.evaluatedparam$Parameter ), (Lpl/touk/nussknacker/engine/graph/evaluatedparam$Parameter;)Lscala/Tuple2;)()).$colon$colon((Object)var9_7);
                    break block28;
                }
                if (!(var4_2 instanceof node.Filter)) break block29;
                var10_8 = (node.Filter)var4_2;
                expression = var10_8.expression();
                v0 = new .colon.colon((Object)new Tuple2((Object)"Expression", (Object)expression.expression()), (List)Nil$.MODULE$);
                break block28;
            }
            if (!(var4_2 instanceof node.Enricher)) ** GOTO lbl-1000
            var12_10 = (node.Enricher)var4_2;
            var13_11 = var12_10.service();
            output = var12_10.output();
            if (var13_11 != null) {
                typ = var13_11.id();
                params = var13_11.parameters();
                var17_15 = new Tuple2((Object)"Type", (Object)typ);
                var18_16 = new Tuple2((Object)"Output", (Object)output);
                v0 = params.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$2(pl.touk.nussknacker.engine.graph.evaluatedparam$Parameter ), (Lpl/touk/nussknacker/engine/graph/evaluatedparam$Parameter;)Lscala/Tuple2;)()).$colon$colon((Object)var18_16).$colon$colon((Object)var17_15);
            } else if (var4_2 instanceof node.Switch) {
                var19_17 = (node.Switch)var4_2;
                expression = var19_17.expression();
                v0 = expression.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$3(pl.touk.nussknacker.engine.graph.expression.Expression ), (Lpl/touk/nussknacker/engine/graph/expression/Expression;)Lscala/Tuple2;)()).toList();
            } else if (var4_2 instanceof node.Processor && (var22_20 = (var21_19 = (node.Processor)var4_2).service()) != null) {
                typ = var22_20.id();
                params = var22_20.parameters();
                var25_23 = new Tuple2((Object)"Type", (Object)typ);
                v0 = params.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$4(pl.touk.nussknacker.engine.graph.evaluatedparam$Parameter ), (Lpl/touk/nussknacker/engine/graph/evaluatedparam$Parameter;)Lscala/Tuple2;)()).$colon$colon((Object)var25_23);
            } else if (var4_2 instanceof node.Sink && (var27_25 = (var26_24 = (node.Sink)var4_2).ref()) != null) {
                typ = var27_25.typ();
                params = var27_25.parameters();
                var30_28 = new Tuple2((Object)"Type", (Object)typ);
                v0 = params.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$5(pl.touk.nussknacker.engine.graph.evaluatedparam$Parameter ), (Lpl/touk/nussknacker/engine/graph/evaluatedparam$Parameter;)Lscala/Tuple2;)()).$colon$colon((Object)var30_28);
            } else if (var4_2 instanceof node.CustomNode) {
                var31_29 = (node.CustomNode)var4_2;
                output = var31_29.outputVar();
                typ = var31_29.nodeType();
                params = var31_29.parameters();
                var35_33 = new Tuple2((Object)"Type", (Object)typ);
                var36_34 = new Tuple2((Object)"Output", output.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$nodeDetails$6(), ()Ljava/lang/String;)()));
                v0 = params.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$7(pl.touk.nussknacker.engine.graph.evaluatedparam$Parameter ), (Lpl/touk/nussknacker/engine/graph/evaluatedparam$Parameter;)Lscala/Tuple2;)()).$colon$colon((Object)var36_34).$colon$colon((Object)var35_33);
            } else if (var4_2 instanceof node.SubprocessInput && (var38_36 = (var37_35 = (node.SubprocessInput)var4_2).ref()) != null) {
                typ = var38_36.id();
                params = var38_36.parameters();
                var41_39 = new Tuple2((Object)"Type", (Object)typ);
                v0 = params.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$8(pl.touk.nussknacker.engine.graph.evaluatedparam$Parameter ), (Lpl/touk/nussknacker/engine/graph/evaluatedparam$Parameter;)Lscala/Tuple2;)()).$colon$colon((Object)var41_39);
            } else if (var4_2 instanceof node.SubprocessInputDefinition) {
                var42_40 = (node.SubprocessInputDefinition)var4_2;
                parameters = var42_40.parameters();
                v0 = parameters.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$9(pl.touk.nussknacker.engine.graph.node$SubprocessInputDefinition$SubprocessParameter ), (Lpl/touk/nussknacker/engine/graph/node$SubprocessInputDefinition$SubprocessParameter;)Lscala/Tuple2;)());
            } else if (var4_2 instanceof node.SubprocessOutputDefinition) {
                var44_42 = (node.SubprocessOutputDefinition)var4_2;
                outputName = var44_42.outputName();
                fields = var44_42.fields();
                var47_45 = new Tuple2((Object)"Output name", (Object)outputName);
                v0 = fields.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$10(pl.touk.nussknacker.engine.graph.variable$Field ), (Lpl/touk/nussknacker/engine/graph/variable$Field;)Lscala/Tuple2;)()).$colon$colon((Object)var47_45);
            } else if (var4_2 instanceof node.Variable) {
                var48_46 = (node.Variable)var4_2;
                name = var48_46.varName();
                expr = var48_46.value();
                var51_49 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)expr.expression());
                v0 = Nil$.MODULE$.$colon$colon((Object)var51_49);
            } else if (var4_2 instanceof node.VariableBuilder) {
                var52_50 = (node.VariableBuilder)var4_2;
                name = var52_50.varName();
                fields = var52_50.fields();
                var55_53 = new Tuple2((Object)"Variable name", (Object)name);
                v0 = fields.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$11(pl.touk.nussknacker.engine.graph.variable$Field ), (Lpl/touk/nussknacker/engine/graph/variable$Field;)Lscala/Tuple2;)()).$colon$colon((Object)var55_53);
            } else if (var4_2 instanceof node.Join) {
                var56_54 = (node.Join)var4_2;
                output = var56_54.outputVar();
                typ = var56_54.nodeType();
                parameters = var56_54.parameters();
                branch = var56_54.branchParameters();
                var61_59 = new Tuple2((Object)"Type", (Object)typ);
                var62_60 = new Tuple2((Object)"Output", output.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$nodeDetails$12(), ()Ljava/lang/String;)()));
                v0 = ((List)parameters.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$13(pl.touk.nussknacker.engine.graph.evaluatedparam$Parameter ), (Lpl/touk/nussknacker/engine/graph/evaluatedparam$Parameter;)Lscala/Tuple2;)()).$plus$plus((IterableOnce)branch.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$14(pl.touk.nussknacker.engine.graph.evaluatedparam$BranchParameters ), (Lpl/touk/nussknacker/engine/graph/evaluatedparam$BranchParameters;)Lscala/collection/immutable/List;)()))).$colon$colon((Object)var62_60).$colon$colon((Object)var61_59);
            } else if (var4_2 instanceof node.Split) {
                var63_61 = new Tuple2((Object)"No parameters", (Object)"");
                v0 = Nil$.MODULE$.$colon$colon((Object)var63_61);
            } else {
                if (var4_2 instanceof node.BranchEndData) {
                    throw new IllegalArgumentException("Should not happen during PDF export");
                }
                if (var4_2 instanceof node.SubprocessUsageOutput) {
                    throw new IllegalArgumentException("Should not happen during PDF export");
                }
                throw new MatchError((Object)var4_2);
            }
        }
        nodeData = v0;
        data = (List)node.additionalFields().flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$16(pl.touk.nussknacker.engine.graph.node$UserDefinedAdditionalNodeFields ), (Lpl/touk/nussknacker/engine/graph/node$UserDefinedAdditionalNodeFields;)Lscala/Option;)()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$17(java.lang.String ), (Ljava/lang/String;)Lscala/Tuple2;)()).toList().$plus$plus((IterableOnce)nodeData);
        if (data.isEmpty()) {
            return NodeSeq$.MODULE$.Empty();
        }
        $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("margin-top", (Seq)new Text("5pt"), (MetaData)$md);
        $md = new UnprefixedAttribute("margin-bottom", (Seq)new Text("25pt"), (MetaData)$md);
        $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("id", node.id(), (MetaData)$md);
        $md = new UnprefixedAttribute("text-align", (Seq)new Text("left"), (MetaData)$md);
        $md = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md);
        $md = new UnprefixedAttribute("font-size", (Seq)new Text("13pt"), (MetaData)$md);
        $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)node.getClass().getSimpleName());
        $buf.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)node.id());
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "block", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)));
        $buf.$amp$plus((Object)new Text("\n        "));
        $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("table-layout", (Seq)new Text("fixed"), (MetaData)$md);
        $md = new UnprefixedAttribute("width", (Seq)new Text("100%"), (MetaData)$md);
        $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n          "));
        $tmpscope = TopScope$.MODULE$;
        $scope = $tmpscope = new NamespaceBinding("fox", "http://xmlgraphics.apache.org/fop/extensions", (NamespaceBinding)$tmpscope);
        $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(2)"), (MetaData)$md);
        $md = new PrefixedAttribute("fox", "header", (Seq)new Text("true"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf.$amp$plus((Object)new Text("\n          "));
        $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(3)"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf.$amp$plus((Object)new Text("\n          "));
        $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)data.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nodeDetails$18(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/xml/Elem;)()));
        $buf.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "table-body", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)));
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)));
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "block", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private String addEmptySpace(String str) {
        return (String)new .colon.colon((Object)")", (List)new .colon.colon((Object)".", (List)new .colon.colon((Object)"(", (List)Nil$.MODULE$))).foldLeft((Object)str, (Function2 & Serializable)(acc, el) -> acc.replace((CharSequence)el, el + '\u200b'));
    }

    /*
     * WARNING - void declaration
     */
    private Elem nodesSummary(DisplayableProcess displayableProcess) {
        void var3_3;
        Elem elem;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("space-after.minimum", (Seq)new Text("3em"), (MetaData)$md);
        $md = new UnprefixedAttribute("page-break-before", (Seq)new Text("always"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("text-align", (Seq)new Text("left"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("font-size", (Seq)new Text("15pt"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        Nodes summary\n      "));
        $buf.$amp$plus((Object)new Elem(null, "block", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("table-layout", (Seq)new Text("fixed"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("width", (Seq)new Text("100%"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        TopScope$ $tmpscope = TopScope$.MODULE$;
        TopScope$ $scope = $tmpscope = new NamespaceBinding("fox", "http://xmlgraphics.apache.org/fop/extensions", (NamespaceBinding)$tmpscope);
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(3)"), (MetaData)$md4);
        $md4 = new PrefixedAttribute("fox", "header", (Seq)new Text("true"), (MetaData)$md4);
        $buf3.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md4, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(2)"), (MetaData)$md5);
        $buf3.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(3)"), (MetaData)$md6);
        $buf3.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md7);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md8);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Node name"));
        $buf6.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n            "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md9);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Type"));
        $buf8.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf5.$amp$plus((Object)new Text("\n            "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md10);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("Description"));
        $buf10.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf10.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)new Elem(null, "table-row", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "table-header", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n          "));
        if (displayableProcess.nodes().isEmpty()) {
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text("\n            "));
            $buf13.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf13.$amp$plus((Object)new Text("\n          "));
            Elem elem2 = new Elem(null, "table-cell", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13));
            elem = elem2;
        } else {
            elem = displayableProcess.nodes().map((Function1 & Serializable)node2 -> {
                void var1_1;
                void var3_3;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n              "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md);
                $md = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md);
                $md = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n                  "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("internal-destination", node2.id(), (MetaData)$md2);
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)new Text("\n                    "));
                $buf4.$amp$plus((Object)node2.id());
                $buf4.$amp$plus((Object)new Text("\n                  "));
                $buf3.$amp$plus((Object)new Elem(null, "basic-link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
                $buf3.$amp$plus((Object)new Text("\n                "));
                $buf2.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
                $buf2.$amp$plus((Object)new Text("\n              "));
                $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
                $buf.$amp$plus((Object)new Text("\n              "));
                Null$ $md3 = Null$.MODULE$;
                $md3 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md3);
                $md3 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md3);
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf6 = new NodeBuffer();
                $buf6.$amp$plus((Object)new Text("\n                  "));
                $buf6.$amp$plus((Object)node2.getClass().getSimpleName());
                $buf6.$amp$plus((Object)new Text("\n                "));
                $buf5.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
                $buf5.$amp$plus((Object)new Text("\n              "));
                $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
                $buf.$amp$plus((Object)new Text("\n              "));
                Null$ $md4 = Null$.MODULE$;
                $md4 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md4);
                $md4 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md4);
                NodeBuffer $buf7 = new NodeBuffer();
                $buf7.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf8 = new NodeBuffer();
                $buf8.$amp$plus((Object)new Text("\n                  "));
                $buf8.$amp$plus(node2.additionalFields().flatMap((Function1 & Serializable)x$4 -> x$4.description()).getOrElse((Function0 & Serializable)() -> ""));
                $buf8.$amp$plus((Object)new Text("\n                "));
                $buf7.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
                $buf7.$amp$plus((Object)new Text("\n              "));
                $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
                $buf.$amp$plus((Object)new Text("\n            "));
                return new Elem(null, "table-row", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            });
        }
        $buf12.$amp$plus((Object)elem);
        $buf12.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "table-body", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "table", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "block", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private Elem attachments(DbProcessActivityRepository.ProcessActivity processActivity) {
        void var3_3;
        if (processActivity.attachments().isEmpty()) {
            return new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$);
        }
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("space-after.minimum", (Seq)new Text("3em"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("text-align", (Seq)new Text("left"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("font-size", (Seq)new Text("15pt"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        Attachments\n      "));
        $buf.$amp$plus((Object)new Elem(null, "block", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("table-layout", (Seq)new Text("fixed"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("width", (Seq)new Text("100%"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        TopScope$ $tmpscope = TopScope$.MODULE$;
        TopScope$ $scope = $tmpscope = new NamespaceBinding("fox", "http://xmlgraphics.apache.org/fop/extensions", (NamespaceBinding)$tmpscope);
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(3)"), (MetaData)$md4);
        $md4 = new PrefixedAttribute("fox", "header", (Seq)new Text("true"), (MetaData)$md4);
        $buf3.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md4, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(3)"), (MetaData)$md5);
        $buf3.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("column-width", (Seq)new Text("proportional-column-width(7)"), (MetaData)$md6);
        $buf3.$amp$plus((Object)new Elem(null, "table-column", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md7);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n\n\n            "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md8);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Date"));
        $buf6.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n            "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md9);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Author"));
        $buf8.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf5.$amp$plus((Object)new Text("\n            "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md10);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("File name"));
        $buf10.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf10.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)new Elem(null, "table-row", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "table-header", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf12.$amp$plus((Object)((List)processActivity.attachments().sortBy((Function1 & Serializable)x$5 -> x$5.createDate(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)attachment -> {
            void var1_1;
            void var3_3;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n\n              "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md);
            $md = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n                  "));
            $buf3.$amp$plus((Object)MODULE$.format(attachment.createDate()));
            $buf3.$amp$plus((Object)new Text("\n                "));
            $buf2.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf2.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n              "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md2);
            $md2 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md2);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n                  "));
            $buf5.$amp$plus((Object)attachment.user());
            $buf5.$amp$plus((Object)new Text("\n                "));
            $buf4.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf4.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n              "));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md3);
            $md3 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md3);
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n                  "));
            $buf7.$amp$plus((Object)attachment.fileName());
            $buf7.$amp$plus((Object)new Text("\n                "));
            $buf6.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf6.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf.$amp$plus((Object)new Text("\n            "));
            return new Elem(null, "table-row", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        }));
        $buf12.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "table-body", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "table", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "block", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    public static final /* synthetic */ boolean $anonfun$initFontsIfNeeded$1(File dir$1, String name) {
        return new File(dir$1, name).exists();
    }

    public static final /* synthetic */ int $anonfun$initFontsIfNeeded$2(File dir$1, String name) {
        return IOUtils.copy((InputStream)MODULE$.getClass().getResourceAsStream("/fop/fonts/" + name), (OutputStream)new FileOutputStream(new File(dir$1, name)));
    }

    public static final /* synthetic */ boolean $anonfun$prepareFopXml$1(processdetails.BaseProcessDetails processDetails$1, processdetails.ProcessVersion x$1) {
        VersionId versionId = x$1.processVersionId();
        VersionId versionId2 = processDetails$1.processVersionId();
        return !(versionId != null ? !versionId.equals(versionId2) : versionId2 != null);
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$1(evaluatedparam.Parameter p) {
        return new Tuple2((Object)p.name(), (Object)p.expression().expression());
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$2(evaluatedparam.Parameter p) {
        return new Tuple2((Object)p.name(), (Object)p.expression().expression());
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$3(Expression e) {
        return new Tuple2((Object)"Expression", (Object)e.expression());
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$4(evaluatedparam.Parameter p) {
        return new Tuple2((Object)p.name(), (Object)p.expression().expression());
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$5(evaluatedparam.Parameter p) {
        return new Tuple2((Object)p.name(), (Object)p.expression().expression());
    }

    public static final /* synthetic */ String $anonfun$nodeDetails$6() {
        return "";
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$7(evaluatedparam.Parameter p) {
        return new Tuple2((Object)p.name(), (Object)p.expression().expression());
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$8(evaluatedparam.Parameter p) {
        return new Tuple2((Object)p.name(), (Object)p.expression().expression());
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$9(node.SubprocessInputDefinition.SubprocessParameter p) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)p.typ().refClazzName());
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$10(variable.Field p) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)p.expression().expression());
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$11(variable.Field p) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)p.expression().expression());
    }

    public static final /* synthetic */ String $anonfun$nodeDetails$12() {
        return "";
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$13(evaluatedparam.Parameter p) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)p.expression().expression());
    }

    public static final /* synthetic */ List $anonfun$nodeDetails$14(evaluatedparam.BranchParameters bp) {
        return bp.parameters().map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)(bp.branchId() + " - " + p.name())), (Object)p.expression().expression()));
    }

    public static final /* synthetic */ Option $anonfun$nodeDetails$16(node.UserDefinedAdditionalNodeFields x$3) {
        return x$3.description();
    }

    public static final /* synthetic */ Tuple2 $anonfun$nodeDetails$17(String naf) {
        return new Tuple2((Object)"Description", (Object)naf);
    }

    public static final /* synthetic */ Elem $anonfun$nodeDetails$18(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n              "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("font-weight", (Seq)new Text("bold"), (MetaData)$md);
            $md = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md);
            $md = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n                  "));
            $buf3.$amp$plus((Object)key);
            $buf3.$amp$plus((Object)new Text("\n                "));
            $buf2.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf2.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            $buf.$amp$plus((Object)new Text("\n              "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("padding-left", (Seq)new Text("1pt"), (MetaData)$md2);
            $md2 = new UnprefixedAttribute("border", (Seq)new Text("1pt solid black"), (MetaData)$md2);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n                  "));
            $buf5.$amp$plus((Object)MODULE$.addEmptySpace(value));
            $buf5.$amp$plus((Object)new Text("\n                "));
            $buf4.$amp$plus((Object)new Elem(null, "block", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf4.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus((Object)new Elem(null, "table-cell", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n            "));
            return new Elem(null, "table-row", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }
        throw new MatchError((Object)tuple2);
    }

    private PdfExporter$() {
    }
}

