/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.component;

import cats.Applicative;
import cats.FlatMap;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.syntax.package;
import com.typesafe.config.Config;
import java.io.Serializable;
import pl.touk.nussknacker.engine.ProcessingTypeData;
import pl.touk.nussknacker.engine.api.component.ComponentGroupName;
import pl.touk.nussknacker.engine.api.component.ComponentId;
import pl.touk.nussknacker.engine.api.component.SingleComponentConfig;
import pl.touk.nussknacker.restmodel.component.package;
import pl.touk.nussknacker.restmodel.definition.package;
import pl.touk.nussknacker.restmodel.displayedgraph.DisplayableProcess;
import pl.touk.nussknacker.restmodel.processdetails;
import pl.touk.nussknacker.ui.EspError;
import pl.touk.nussknacker.ui.component.Component;
import pl.touk.nussknacker.ui.component.ComponentIdProvider;
import pl.touk.nussknacker.ui.component.ComponentNotFoundError;
import pl.touk.nussknacker.ui.component.ComponentService;
import pl.touk.nussknacker.ui.component.DefaultComponentService$;
import pl.touk.nussknacker.ui.config.ComponentLinkConfig;
import pl.touk.nussknacker.ui.config.ComponentLinksConfigExtractor$;
import pl.touk.nussknacker.ui.definition.UIProcessObjectsFactory$;
import pl.touk.nussknacker.ui.process.ProcessCategoryService;
import pl.touk.nussknacker.ui.process.ProcessObjectsFinder$;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.processingtypedata.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.process.subprocess.SubprocessDetails;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\r]x!\u0002\u001c8\u0011\u0003\u0011e!\u0002#8\u0011\u0003)\u0005\"\u0002'\u0002\t\u0003iU\u0001\u0002(\u0002\u0001=CQ!^\u0001\u0005\u0002YDqAa!\u0002\t\u0013\u0011)\tC\u0004\u0003\u0014\u0006!IA!&\t\u000f\r\u001d\u0014\u0001\"\u0003\u0004j!911Q\u0001\u0005\n\r\u0015\u0005bBBI\u0003\u0011%11\u0013\u0005\b\u0007C\u000bA\u0011BBR\r\u0019\u0011Y*\u0001$\u0003\u001e\"Q\u0011\u0011`\u0006\u0003\u0016\u0004%\tAa+\t\u0015\t56B!E!\u0002\u0013\u00119\u0002\u0003\u0006\u00030.\u0011)\u001a!C\u0001\u0005cC!Ba3\f\u0005#\u0005\u000b\u0011\u0002BZ\u0011)\u0011\th\u0003BK\u0002\u0013\u0005!Q\u001a\u0005\u000b\u0005/\\!\u0011#Q\u0001\n\t=\u0007B\u0002'\f\t\u0003\u0011I\u000eC\u0005\u0003b.\t\t\u0011\"\u0001\u0003d\"I!1^\u0006\u0012\u0002\u0013\u0005!Q\u001e\u0005\n\u0007\u0007Y\u0011\u0013!C\u0001\u0007\u000bA\u0011b!\u0003\f#\u0003%\taa\u0003\t\u0013\r=1\"!A\u0005B\rE\u0001\"CB\u0011\u0017\u0005\u0005I\u0011AB\u0012\u0011%\u0019YcCA\u0001\n\u0003\u0019i\u0003C\u0005\u00044-\t\t\u0011\"\u0011\u00046!I1qH\u0006\u0002\u0002\u0013\u00051\u0011\t\u0005\n\u0007\u0017Z\u0011\u0011!C!\u0007\u001bB\u0011b!\u0015\f\u0003\u0003%\tea\u0015\t\u0013\rU3\"!A\u0005B\r]\u0003\"CB-\u0017\u0005\u0005I\u0011IB.\u000f%\u00199,AA\u0001\u0012\u0013\u0019ILB\u0005\u0003\u001c\u0006\t\t\u0011#\u0003\u0004<\"1A*\tC\u0001\u0007'D\u0011b!\u0016\"\u0003\u0003%)ea\u0016\t\u0011U\f\u0013\u0011!CA\u0007+D\u0011b!8\"\u0003\u0003%\tia8\t\u0013\r5\u0018%!A\u0005\n\r=h\u0001\u0002#8\u0001eD\u0001\"`\u0014\u0003\u0002\u0003\u0006IA \u0005\u000b\u0003\u001f9#\u0011!Q\u0001\n\u0005E\u0001BCA\u0017O\t\u0005\t\u0015!\u0003\u00020!Q\u0011qG\u0014\u0003\u0002\u0003\u0006I!!\u000f\t\u0013\u0005}rE!A!\u0002\u0013\u0011\bBCA!O\t\u0005\t\u0015a\u0003\u0002D!1Aj\nC\u0005\u0003\u001fB!\"a\u0018(\u0011\u000b\u0007I\u0011BA1\u0011\u001d\t)h\nC!\u0003oBq!a/(\t\u0003\ni\fC\u0004\u0002p\u001e\"I!!=\t\u000f\t=q\u0005\"\u0003\u0003\u0012!9\u00111X\u0014\u0005\n\te\u0002b\u0002B/O\u0011%!qL\u0001\u0018\t\u00164\u0017-\u001e7u\u0007>l\u0007o\u001c8f]R\u001cVM\u001d<jG\u0016T!\u0001O\u001d\u0002\u0013\r|W\u000e]8oK:$(B\u0001\u001e<\u0003\t)\u0018N\u0003\u0002={\u0005Ya.^:tW:\f7m[3s\u0015\tqt(\u0001\u0003u_V\\'\"\u0001!\u0002\u0005Ad7\u0001\u0001\t\u0003\u0007\u0006i\u0011a\u000e\u0002\u0018\t\u00164\u0017-\u001e7u\u0007>l\u0007o\u001c8f]R\u001cVM\u001d<jG\u0016\u001c\"!\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!I\u0001\u000fD_6\u0004xN\\3oi&#\u0007K]8wS\u0012,'oV5uQ\u0016\u0013(o\u001c:\u0011\tA+vK]\u0007\u0002#*\u0011!kU\u0001\u0005I\u0006$\u0018MC\u0001U\u0003\u0011\u0019\u0017\r^:\n\u0005Y\u000b&!\u0003,bY&$\u0017\r^3e!\rA\u0006m\u0019\b\u00033zs!AW/\u000e\u0003mS!\u0001X!\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0015BA0I\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u00192\u0003\t1K7\u000f\u001e\u0006\u0003?\"\u0003$\u0001Z5\u0011\u0007\r+w-\u0003\u0002go\tY2i\\7q_:,g\u000e^,s_:<7i\u001c8gS\u001e,(/\u0019;j_:\u0004\"\u0001[5\r\u0001\u0011I!nAA\u0001\u0002\u0003\u0015\ta\u001b\u0002\u0004?\u0012\n\u0014C\u00017p!\t9U.\u0003\u0002o\u0011\n9aj\u001c;iS:<\u0007CA$q\u0013\t\t\bJA\u0002B]f\u0004\"aQ:\n\u0005Q<$aE\"p[B|g.\u001a8u\u0013\u0012\u0004&o\u001c<jI\u0016\u0014\u0018!B1qa2LH#C<\u0003|\tu$q\u0010BA)\rA(\u0011\u0010\t\u0003\u0007\u001e\u001a2a\n${!\t\u001950\u0003\u0002}o\t\u00012i\\7q_:,g\u000e^*feZL7-Z\u0001\u0007G>tg-[4\u0011\u0007}\fY!\u0004\u0002\u0002\u0002)\u0019Q0a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\tif\u0004Xm]1gK*\u0011\u0011\u0011B\u0001\u0004G>l\u0017\u0002BA\u0007\u0003\u0003\u0011aaQ8oM&<\u0017A\u00079s_\u000e,7o]5oORK\b/\u001a#bi\u0006\u0004&o\u001c<jI\u0016\u0014\bCBA\n\u0003;\t\t#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003I\u0001(o\\2fgNLgn\u001a;za\u0016$\u0017\r^1\u000b\u0007\u0005m\u0011(A\u0004qe>\u001cWm]:\n\t\u0005}\u0011Q\u0003\u0002\u001b!J|7-Z:tS:<G+\u001f9f\t\u0006$\u0018\r\u0015:pm&$WM\u001d\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE\u001e\u0002\r\u0015tw-\u001b8f\u0013\u0011\tY#!\n\u0003%A\u0013xnY3tg&tw\rV=qK\u0012\u000bG/Y\u0001\u000faJ|7-Z:t'\u0016\u0014h/[2f!\u0011\t\t$a\r\u000e\u0005\u0005e\u0011\u0002BA\u001b\u00033\u0011a\u0002\u0015:pG\u0016\u001c8oU3sm&\u001cW-A\bdCR,wm\u001c:z'\u0016\u0014h/[2f!\u0011\t\t$a\u000f\n\t\u0005u\u0012\u0011\u0004\u0002\u0017!J|7-Z:t\u0007\u0006$XmZ8ssN+'O^5dK\u0006\u00192m\\7q_:,g\u000e^%e!J|g/\u001b3fe\u0006\u0011Qm\u0019\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011\n%\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002N\u0005\u001d#\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u)1\t\t&!\u0016\u0002X\u0005e\u00131LA/)\rA\u00181\u000b\u0005\b\u0003\u0003r\u00039AA\"\u0011\u0015ih\u00061\u0001\u007f\u0011\u001d\tyA\fa\u0001\u0003#Aq!!\f/\u0001\u0004\ty\u0003C\u0004\u000289\u0002\r!!\u000f\t\r\u0005}b\u00061\u0001s\u0003Q\u0019w.\u001c9p]\u0016tG\u000fT5oWN\u001cuN\u001c4jOV\u0011\u00111\r\t\u0005\u0003K\nyG\u0004\u0003\u0002h\u0005-TBAA5\u0015\ti\u0018(\u0003\u0003\u0002n\u0005%\u0014!H\"p[B|g.\u001a8u\u0019&t7n]\"p]\u001aLw-\u0012=ue\u0006\u001cGo\u001c:\n\t\u0005E\u00141\u000f\u0002\u0015\u0007>l\u0007o\u001c8f]Rd\u0015N\\6t\u0007>tg-[4\u000b\t\u00055\u0014\u0011N\u0001\u0012O\u0016$8i\\7q_:,g\u000e^:MSN$H\u0003BA=\u0003O\u0003b!!\u0012\u0002|\u0005}\u0014\u0002BA?\u0003\u000f\u0012aAR;ukJ,\u0007\u0003\u0002-a\u0003\u0003\u0003B!a!\u0002\":!\u0011QQAO\u001d\u0011\t9)!'\u000f\t\u0005%\u0015Q\u0013\b\u0005\u0003\u0017\u000b\u0019J\u0004\u0003\u0002\u000e\u0006Eeb\u0001.\u0002\u0010&\t\u0001)\u0003\u0002?\u007f%\u0011A(P\u0005\u0004\u0003/[\u0014!\u0003:fgRlw\u000eZ3m\u0013\rA\u00141\u0014\u0006\u0004\u0003/[\u0014bA0\u0002 *\u0019\u0001(a'\n\t\u0005\r\u0016Q\u0015\u0002\u0015\u0007>l\u0007o\u001c8f]Rd\u0015n\u001d;FY\u0016lWM\u001c;\u000b\u0007}\u000by\nC\u0004\u0002*B\u0002\r!a+\u0002\tU\u001cXM\u001d\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003\r\t\u0007/\u001b\u0006\u0004\u0003kK\u0014\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005e\u0016q\u0016\u0002\u000b\u0019><w-\u001a3Vg\u0016\u0014\u0018AE4fi\u000e{W\u000e]8oK:$Xk]1hKN$B!a0\u0002`R!\u0011\u0011YAo!\u0019\t)%a\u001f\u0002DB1\u0011QYAh\u0003+tA!a2\u0002L:!\u0011\u0011RAe\u0013\tQ4(C\u0002\u0002Nf\n\u0001\"R:q\u000bJ\u0014xN]\u0005\u0005\u0003#\f\u0019N\u0001\u0004Y\u000bJ\u0014xN\u001d\u0006\u0004\u0003\u001bL\u0004\u0003\u0002-a\u0003/\u0004B!a!\u0002Z&!\u00111\\AS\u0005e\u0019u.\u001c9p]\u0016tG/V:bO\u0016\u001c\u0018J\\*dK:\f'/[8\t\u000f\u0005%\u0016\u0007q\u0001\u0002,\"9\u0011\u0011]\u0019A\u0002\u0005\r\u0018aC2p[B|g.\u001a8u\u0013\u0012\u0004B!!:\u0002l6\u0011\u0011q\u001d\u0006\u0004q\u0005%(\u0002BAY\u0003KIA!!<\u0002h\nY1i\\7q_:,g\u000e^%e\u0003\r*\u0007\u0010\u001e:bGR\u001cu.\u001c9p]\u0016tGo\u001d$s_6\u0004&o\\2fgNLgn\u001a+za\u0016$\u0002\"!\u001f\u0002t\u0006](Q\u0002\u0005\b\u0003k\u0014\u0004\u0019AA\u0011\u0003I\u0001(o\\2fgNLgn\u001a+za\u0016$\u0015\r^1\t\u000f\u0005e(\u00071\u0001\u0002|\u0006q\u0001O]8dKN\u001c\u0018N\\4UsB,\u0007\u0003BA\u007f\u0005\u000fqA!a@\u0003\u00049!\u0011q\u0011B\u0001\u0013\u0011\tY\"a'\n\u0007}\u0013)A\u0003\u0003\u0002\u001c\u0005m\u0015\u0002\u0002B\u0005\u0005\u0017\u0011a\u0002\u0015:pG\u0016\u001c8/\u001b8h)f\u0004XMC\u0002`\u0005\u000bAq!!+3\u0001\u0004\tY+A\u0014fqR\u0014\u0018m\u0019;Vg\u0016\u00148i\\7q_:,g\u000e^:Ge>l\u0007K]8dKN\u001c\u0018N\\4UsB,GCCA=\u0005'\u0011)Ba\n\u0003*!9\u0011Q_\u001aA\u0002\u0005\u0005\u0002bBA}g\u0001\u0007!q\u0003\t\u0005\u00053\u0011\tC\u0004\u0003\u0003\u001c\tu\u0001C\u0001.I\u0013\r\u0011y\u0002S\u0001\u0007!J,G-\u001a4\n\t\t\r\"Q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t}\u0001\nC\u0004\u0002*N\u0002\r!a+\t\u000f\t-2\u00071\u0001\u0003.\u0005y1m\\7q_:,g\u000e^+tC\u001e,7\u000f\u0005\u0005\u0003\u001a\t=\u00121\u001dB\u001a\u0013\u0011\u0011\tD!\n\u0003\u00075\u000b\u0007\u000fE\u0002H\u0005kI1Aa\u000eI\u0005\u0011auN\\4\u0015\t\tm\"Q\t\u000b\u0007\u0005{\u0011yDa\u0011\u0011\r\u0005\u0015\u00131\u0010B\u0017\u0011\u001d\u0011\t\u0005\u000ea\u0002\u0003W\u000b!\u0002\\8hO\u0016$Wk]3s\u0011\u001d\t\t\u0005\u000ea\u0002\u0003\u0007BqAa\u00125\u0001\u0004\u0011I%\u0001\u0006dCR,wm\u001c:jKN\u0004B\u0001\u00171\u0003LA!!Q\nB,\u001d\u0011\u0011yEa\u0015\u000f\t\u0005\u001d'\u0011K\u0005\u0004\u00037I\u0014\u0002\u0002B+\u00033\ta\u0003\u0015:pG\u0016\u001c8oQ1uK\u001e|'/_*feZL7-Z\u0005\u0005\u00053\u0012YF\u0001\u0005DCR,wm\u001c:z\u0015\u0011\u0011)&!\u0007\u0002\u001b\u0011,G-\u001e9mS\u000e\fG/[8o)\u0011\u0011\tGa\u001c\u0011\r\t\r$QNAA\u001b\t\u0011)G\u0003\u0003\u0003h\t%\u0014!C5n[V$\u0018M\u00197f\u0015\r\u0011Y\u0007S\u0001\u000bG>dG.Z2uS>t\u0017bA1\u0003f!9!\u0011O\u001bA\u0002\tM\u0014AC2p[B|g.\u001a8ugB)\u0001L!\u001e\u0002\u0002&\u0019!q\u000f2\u0003\u0011%#XM]1cY\u0016Dq!!\u0011\u0005\u0001\b\t\u0019\u0005C\u0003~\t\u0001\u0007a\u0010C\u0004\u0002\u0010\u0011\u0001\r!!\u0005\t\u000f\u00055B\u00011\u0001\u00020!9\u0011q\u0007\u0003A\u0002\u0005e\u0012\u0001\u00079sKB\f'/Z\"p[B|g.\u001a8u!J|g/\u001b3feR1!q\u0011BH\u0005##BA!#\u0003\u000eB\u0019!1R\u0002\u000e\u0003\u0005Aq!!\u0011\u0006\u0001\b\t\u0019\u0005C\u0004\u0002\u0010\u0015\u0001\r!!\u0005\t\u000f\u0005]R\u00011\u0001\u0002:\u0005IR\r\u001f;sC\u000e$hI]8n!J|7-Z:tS:<G+\u001f9f)!\u00119j!\u0019\u0004d\r\u0015D\u0003\u0002BM\u0007?\u00022Aa#\f\u00055)\u0005\u0010\u001e:bGR,G\rR1uCN11B\u0012BP\u0005K\u00032a\u0012BQ\u0013\r\u0011\u0019\u000b\u0013\u0002\b!J|G-^2u!\rA&qU\u0005\u0004\u0005S\u0013'\u0001D*fe&\fG.\u001b>bE2,WC\u0001B\f\u0003=\u0001(o\\2fgNLgn\u001a+za\u0016\u0004\u0013AE2p[B|g.\u001a8ugVK7i\u001c8gS\u001e,\"Aa-\u0011\t\tU&Q\u0019\b\u0005\u0005o\u0013yL\u0004\u0003\u0003:\nuf\u0002BAE\u0005wK1!a\n<\u0013\rA\u0014QE\u0005\u0005\u0005\u0003\u0014\u0019-A\u000eD_6\u0004xN\\3oiN,\u0016nQ8oM&<W\t\u001f;sC\u000e$xN\u001d\u0006\u0004q\u0005\u0015\u0012\u0002\u0002Bd\u0005\u0013\u0014!cQ8na>tWM\u001c;t+&\u001cuN\u001c4jO*!!\u0011\u0019Bb\u0003M\u0019w.\u001c9p]\u0016tGo]+j\u0007>tg-[4!+\t\u0011y\r\u0005\u0003YA\nE\u0007cA\"\u0003T&\u0019!Q[\u001c\u0003\u0013\r{W\u000e]8oK:$\u0018aC2p[B|g.\u001a8ug\u0002\"\u0002B!'\u0003\\\nu'q\u001c\u0005\b\u0003s\u0014\u0002\u0019\u0001B\f\u0011\u001d\u0011yK\u0005a\u0001\u0005gCqA!\u001d\u0013\u0001\u0004\u0011y-\u0001\u0003d_BLH\u0003\u0003BM\u0005K\u00149O!;\t\u0013\u0005e8\u0003%AA\u0002\t]\u0001\"\u0003BX'A\u0005\t\u0019\u0001BZ\u0011%\u0011\th\u0005I\u0001\u0002\u0004\u0011y-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t=(\u0006\u0002B\f\u0005c\\#Aa=\u0011\t\tU(q`\u0007\u0003\u0005oTAA!?\u0003|\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005{D\u0015AC1o]>$\u0018\r^5p]&!1\u0011\u0001B|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u00199A\u000b\u0003\u00034\nE\u0018AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0007\u001bQCAa4\u0003r\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"aa\u0005\u0011\t\rU1qD\u0007\u0003\u0007/QAa!\u0007\u0004\u001c\u0005!A.\u00198h\u0015\t\u0019i\"\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0012\u0007/\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"a!\n\u0011\u0007\u001d\u001b9#C\u0002\u0004*!\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a\\B\u0018\u0011%\u0019\t$GA\u0001\u0002\u0004\u0019)#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007o\u0001Ra!\u000f\u0004<=l!A!\u001b\n\t\ru\"\u0011\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0004D\r%\u0003cA$\u0004F%\u00191q\t%\u0003\u000f\t{w\u000e\\3b]\"A1\u0011G\u000e\u0002\u0002\u0003\u0007q.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BB\n\u0007\u001fB\u0011b!\r\u001d\u0003\u0003\u0005\ra!\n\u0002\u0011!\f7\u000f[\"pI\u0016$\"a!\n\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"aa\u0005\u0002\r\u0015\fX/\u00197t)\u0011\u0019\u0019e!\u0018\t\u0011\rEr$!AA\u0002=Dq!!\u0011\u0007\u0001\b\t\u0019\u0005C\u0004\u0002v\u001a\u0001\r!!\t\t\u000f\u0005eh\u00011\u0001\u0002|\"9\u0011q\u0007\u0004A\u0002\u0005e\u0012\u0001E4fi\u000e{W\u000e]8oK:$\u0018jY8o)\u0019\u00119ba\u001b\u0004n!9!qV\u0004A\u0002\tM\u0006bBA\u0005\u000f\u0001\u00071q\u000e\t\u0005\u0007c\u001aiH\u0004\u0003\u0004t\red\u0002BAD\u0007kJAaa\u001e\u0002\u001c\u0006QA-\u001a4j]&$\u0018n\u001c8\n\u0007}\u001bYH\u0003\u0003\u0004x\u0005m\u0015\u0002BB@\u0007\u0003\u0013\u0011cQ8na>tWM\u001c;UK6\u0004H.\u0019;f\u0015\ry61P\u0001\u0010O\u0016$8i\\7q_:,g\u000e\u001e#pGR11qQBG\u0007\u001f\u0003RaRBE\u0005/I1aa#I\u0005\u0019y\u0005\u000f^5p]\"9!q\u0016\u0005A\u0002\tM\u0006bBA\u0005\u0011\u0001\u00071qN\u0001\u0010G>l\u0007o\u001c8f]R\u001cuN\u001c4jOR11QSBO\u0007?\u0003RaRBE\u0007/\u0003B!!:\u0004\u001a&!11TAt\u0005U\u0019\u0016N\\4mK\u000e{W\u000e]8oK:$8i\u001c8gS\u001eDqAa,\n\u0001\u0004\u0011\u0019\fC\u0004\u0002\n%\u0001\raa\u001c\u00025\r|W\u000e];uK^\u0013xN\\4D_:4\u0017nZ;sCRLwN\\:\u0015\r\r\u00156\u0011WBZ!\u0011A\u0006ma*1\t\r%6Q\u0016\t\u0005\u0007\u0016\u001cY\u000bE\u0002i\u0007[#!ba,\u000b\u0003\u0003\u0005\tQ!\u0001l\u0005\ryFE\r\u0005\b\u0003CT\u0001\u0019AAr\u0011\u001d\u0011\tH\u0003a\u0001\u0007k\u0003R\u0001\u0017B;\u0005#\fQ\"\u0012=ue\u0006\u001cG/\u001a3ECR\f\u0007c\u0001BFCM)\u0011e!0\u0004JBa1qXBc\u0005/\u0011\u0019La4\u0003\u001a6\u00111\u0011\u0019\u0006\u0004\u0007\u0007D\u0015a\u0002:v]RLW.Z\u0005\u0005\u0007\u000f\u001c\tMA\tBEN$(/Y2u\rVt7\r^5p]N\u0002Baa3\u0004R6\u00111Q\u001a\u0006\u0005\u0007\u001f\u001cY\"\u0001\u0002j_&!!\u0011VBg)\t\u0019I\f\u0006\u0005\u0003\u001a\u000e]7\u0011\\Bn\u0011\u001d\tI\u0010\na\u0001\u0005/AqAa,%\u0001\u0004\u0011\u0019\fC\u0004\u0003r\u0011\u0002\rAa4\u0002\u000fUt\u0017\r\u001d9msR!1\u0011]Bu!\u001595\u0011RBr!%95Q\u001dB\f\u0005g\u0013y-C\u0002\u0004h\"\u0013a\u0001V;qY\u0016\u001c\u0004\"CBvK\u0005\u0005\t\u0019\u0001BM\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007c\u0004Ba!\u0006\u0004t&!1Q_B\f\u0005\u0019y%M[3di\u0002")
public class DefaultComponentService
implements ComponentService {
    private List<ComponentLinkConfig> componentLinksConfig;
    private Config config;
    private final ProcessingTypeDataProvider<ProcessingTypeData> processingTypeDataProvider;
    private final ProcessService processService;
    private final ProcessCategoryService categoryService;
    private final ComponentIdProvider componentIdProvider;
    private final ExecutionContext ec;
    private volatile boolean bitmap$0;

    public static DefaultComponentService apply(Config config, ProcessingTypeDataProvider<ProcessingTypeData> processingTypeDataProvider, ProcessService processService, ProcessCategoryService categoryService, ExecutionContext ec) {
        return DefaultComponentService$.MODULE$.apply(config, processingTypeDataProvider, processService, categoryService, ec);
    }

    private List<ComponentLinkConfig> componentLinksConfig$lzycompute() {
        DefaultComponentService defaultComponentService = this;
        synchronized (defaultComponentService) {
            if (!this.bitmap$0) {
                this.componentLinksConfig = ComponentLinksConfigExtractor$.MODULE$.extract(this.config);
                this.bitmap$0 = true;
            }
        }
        this.config = null;
        return this.componentLinksConfig;
    }

    private List<ComponentLinkConfig> componentLinksConfig() {
        if (!this.bitmap$0) {
            return this.componentLinksConfig$lzycompute();
        }
        return this.componentLinksConfig;
    }

    @Override
    public Future<List<package.ComponentListElement>> getComponentsList(LoggedUser user) {
        return ((Future)package.traverse$.MODULE$.toTraverseOps((Object)this.processingTypeDataProvider.all().toList(), UnorderedFoldable$.MODULE$.catsTraverseForList()).flatTraverse((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String processingType = (String)tuple2._1();
                ProcessingTypeData processingTypeData = (ProcessingTypeData)tuple2._2();
                return this.extractComponentsFromProcessingType(processingTypeData, processingType, user);
            }
            throw new MatchError((Object)tuple2);
        }, (Applicative)Invariant$.MODULE$.catsInstancesForFuture(this.ec), (FlatMap)Invariant$.MODULE$.catsInstancesForList())).map((Function1 & Serializable)components -> {
            List filteredComponents = components.filter((Function1 & Serializable)component -> BoxesRunTime.boxToBoolean((boolean)DefaultComponentService.$anonfun$getComponentsList$3(component)));
            List<package.ComponentListElement> deduplicatedComponents = this.deduplication((Iterable<package.ComponentListElement>)filteredComponents);
            return (List)deduplicatedComponents.sortBy((Function1 & Serializable)component -> package.ComponentListElement$.MODULE$.sortMethod(component), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        }, this.ec);
    }

    @Override
    public Future<Either<EspError, List<package.ComponentUsagesInScenario>>> getComponentUsages(String componentId, LoggedUser user) {
        return this.processService.getProcesses(user, processdetails.ProcessShapeFetchStrategy$.FetchDisplayable$.MODULE$).map((Function1 & Serializable)processes -> {
            Map<ComponentId, List<Tuple2<processdetails.BaseProcessDetails<DisplayableProcess>, List<String>>>> componentsUsage = ProcessObjectsFinder$.MODULE$.computeComponentsUsage($this.componentIdProvider, (List<processdetails.BaseProcessDetails<DisplayableProcess>>)processes);
            return (Either)componentsUsage.get((Object)new ComponentId(componentId)).map((Function1 & Serializable)data -> package$.MODULE$.Right().apply(data.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    processdetails.BaseProcessDetails process = (processdetails.BaseProcessDetails)tuple2._1();
                    List nodesId = (List)tuple2._2();
                    return package.ComponentUsagesInScenario$.MODULE$.apply(process, nodesId);
                }
                throw new MatchError((Object)tuple2);
            }).sortBy((Function1 & Serializable)x$10 -> x$10.id(), (Ordering)Ordering.String$.MODULE$))).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)new ComponentNotFoundError(componentId)));
        }, this.ec);
    }

    private Future<List<package.ComponentListElement>> extractComponentsFromProcessingType(ProcessingTypeData processingTypeData, String processingType, LoggedUser user) {
        List<String> processingTypeCategories;
        List<String> userCategories = this.categoryService.getUserCategories(user);
        List userProcessingTypeCategories = (List)userCategories.intersect(processingTypeCategories = this.categoryService.getProcessingTypeCategories(processingType));
        List list = userProcessingTypeCategories;
        if (Nil$.MODULE$.equals(list)) {
            return Future$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.List().empty(), this.ec);
        }
        return this.getComponentUsages((List<String>)userProcessingTypeCategories, user, this.ec).flatMap((Function1 & Serializable)componentUsages -> this.extractUserComponentsFromProcessingType(processingTypeData, processingType, user, (Map<ComponentId, Object>)componentUsages), this.ec);
    }

    private Future<List<package.ComponentListElement>> extractUserComponentsFromProcessingType(ProcessingTypeData processingTypeData, String processingType, LoggedUser user, Map<ComponentId, Object> componentUsages) {
        return this.processService.getSubProcesses((Option<List<String>>)new Some((Object)new .colon.colon((Object)processingType, (List)Nil$.MODULE$)), user).map((Function1 & Serializable)subprocesses -> {
            package.UIProcessObjects uiProcessObjects = UIProcessObjectsFactory$.MODULE$.prepareUIProcessObjects(processingTypeData.modelData(), processingTypeData.deploymentManager(), processingTypeData.typeSpecificInitialData(), user, (Set<SubprocessDetails>)subprocesses, false, $this.categoryService, processingTypeData.additionalPropertiesConfig(), processingType);
            return uiProcessObjects.componentGroups().flatMap((Function1 & Serializable)group -> group.components().map((Function1 & Serializable)com -> {
                String componentId = $this.componentIdProvider.createComponentId(processingType, com.label(), com.type());
                String icon = DefaultComponentService$.MODULE$.pl$touk$nussknacker$ui$component$DefaultComponentService$$getComponentIcon((Map<String, SingleComponentConfig>)uiProcessObjects.componentsConfig(), (package.ComponentTemplate)com);
                List links = this.createLinks$1(componentId, (package.ComponentTemplate)com, uiProcessObjects);
                long usageCount = BoxesRunTime.unboxToLong((Object)componentUsages.getOrElse((Object)new ComponentId(componentId), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                return new package.ComponentListElement(componentId, com.label(), icon, com.type(), group.name(), com.categories(), links, usageCount);
            }));
        }, this.ec);
    }

    private Future<Map<ComponentId, Object>> getComponentUsages(List<String> categories, LoggedUser loggedUser, ExecutionContext ec) {
        return this.processService.getProcesses(loggedUser, processdetails.ProcessShapeFetchStrategy$.FetchDisplayable$.MODULE$).map((Function1 & Serializable)x$13 -> x$13.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)categories.contains((Object)p.processCategory()))), ec).map((Function1 & Serializable)processes -> ProcessObjectsFinder$.MODULE$.computeComponentsUsageCount($this.componentIdProvider, (List<processdetails.BaseProcessDetails<DisplayableProcess>>)processes), ec);
    }

    private List<package.ComponentListElement> deduplication(Iterable<package.ComponentListElement> components) {
        Map groupedComponents = components.groupBy((Function1 & Serializable)x$14 -> new ComponentId(x$14.id()));
        return ((IterableOnceOps)groupedComponents.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Iterable components = (Iterable)tuple2._2();
                boolean bl = false;
                .colon.colon colon2 = null;
                Iterable iterable = components;
                if (iterable instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)iterable;
                    package.ComponentListElement head = (package.ComponentListElement)colon2.head();
                    List list = colon2.next$access$1();
                    if (Nil$.MODULE$.equals(list)) {
                        return head;
                    }
                }
                if (bl) {
                    package.ComponentListElement head = (package.ComponentListElement)colon2.head();
                    List categories = (List)((StrictOptimizedSeqOps)((IterableOnceOps)components.flatMap((Function1 & Serializable)x$15 -> x$15.categories())).toList().distinct()).sorted((Ordering)Ordering.String$.MODULE$);
                    long usageCount = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)components.map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.usageCount()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    List x$1 = categories;
                    long x$2 = usageCount;
                    String x$3 = head.copy$default$1();
                    String x$4 = head.copy$default$2();
                    String x$5 = head.copy$default$3();
                    Enumeration.Value x$6 = head.copy$default$4();
                    ComponentGroupName x$7 = head.copy$default$5();
                    List x$8 = head.copy$default$7();
                    return head.copy(x$3, x$4, x$5, x$6, x$7, x$1, x$8, x$2);
                }
                throw new MatchError((Object)iterable);
            }
            throw new MatchError((Object)tuple2);
        })).toList();
    }

    public static final /* synthetic */ boolean $anonfun$getComponentsList$3(package.ComponentListElement component) {
        return component.categories().nonEmpty();
    }

    private final List createLinks$1(String componentId, package.ComponentTemplate component, package.UIProcessObjects uiProcessObjects$1) {
        List componentLinks = this.componentLinksConfig().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.isAvailable(component.type()))).map((Function1 & Serializable)x$12 -> x$12.toComponentLink(componentId, component.label()));
        return (List)DefaultComponentService$.MODULE$.pl$touk$nussknacker$ui$component$DefaultComponentService$$getComponentDoc((Map<String, SingleComponentConfig>)uiProcessObjects$1.componentsConfig(), component).map((Function1 & Serializable)docUrl -> package.ComponentLink$.MODULE$.createDocumentationLink(docUrl)).map((Function1 & Serializable)doc -> (List)new .colon.colon(doc, (List)Nil$.MODULE$).$plus$plus((IterableOnce)componentLinks)).getOrElse((Function0 & Serializable)() -> componentLinks);
    }

    public DefaultComponentService(Config config, ProcessingTypeDataProvider<ProcessingTypeData> processingTypeDataProvider, ProcessService processService, ProcessCategoryService categoryService, ComponentIdProvider componentIdProvider, ExecutionContext ec) {
        this.config = config;
        this.processingTypeDataProvider = processingTypeDataProvider;
        this.processService = processService;
        this.categoryService = categoryService;
        this.componentIdProvider = componentIdProvider;
        this.ec = ec;
    }

    private static final class ExtractedData
    implements Product,
    Serializable {
        private final String processingType;
        private final Map<String, SingleComponentConfig> componentsUiConfig;
        private final List<Component> components;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String processingType() {
            return this.processingType;
        }

        public Map<String, SingleComponentConfig> componentsUiConfig() {
            return this.componentsUiConfig;
        }

        public List<Component> components() {
            return this.components;
        }

        public ExtractedData copy(String processingType, Map<String, SingleComponentConfig> componentsUiConfig, List<Component> components) {
            return new ExtractedData(processingType, componentsUiConfig, components);
        }

        public String copy$default$1() {
            return this.processingType();
        }

        public Map<String, SingleComponentConfig> copy$default$2() {
            return this.componentsUiConfig();
        }

        public List<Component> copy$default$3() {
            return this.components();
        }

        public String productPrefix() {
            return "ExtractedData";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.processingType();
                }
                case 1: {
                    return this.componentsUiConfig();
                }
                case 2: {
                    return this.components();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExtractedData;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "processingType";
                }
                case 1: {
                    return "componentsUiConfig";
                }
                case 2: {
                    return "components";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExtractedData)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExtractedData extractedData = (ExtractedData)x$1;
            String string = this.processingType();
            String string2 = extractedData.processingType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Map<String, SingleComponentConfig> map = this.componentsUiConfig();
            Map<String, SingleComponentConfig> map2 = extractedData.componentsUiConfig();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            List<Component> list = this.components();
            List<Component> list2 = extractedData.components();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public ExtractedData(String processingType, Map<String, SingleComponentConfig> componentsUiConfig, List<Component> components) {
            this.processingType = processingType;
            this.componentsUiConfig = componentsUiConfig;
            this.components = components;
            Product.$init$((Product)this);
        }
    }
}

