/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.deployment;

import akka.actor.ActorSystem;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.deployment.DataFreshnessPolicy;
import pl.touk.nussknacker.engine.api.deployment.DeployedScenarioData;
import pl.touk.nussknacker.engine.api.deployment.DeploymentManager;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionType$;
import pl.touk.nussknacker.engine.api.deployment.ProcessState;
import pl.touk.nussknacker.engine.api.deployment.ProcessStateDefinitionManager;
import pl.touk.nussknacker.engine.api.deployment.StateStatus;
import pl.touk.nussknacker.engine.api.deployment.WithDataFreshnessStatus;
import pl.touk.nussknacker.engine.api.deployment.simple.SimpleProcessStateDefinitionManager$;
import pl.touk.nussknacker.engine.api.deployment.simple.SimpleStateStatus$;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.deployment.DeploymentData;
import pl.touk.nussknacker.engine.deployment.ExternalDeploymentId;
import pl.touk.nussknacker.engine.deployment.User;
import pl.touk.nussknacker.restmodel.process.ProcessIdWithName;
import pl.touk.nussknacker.restmodel.processdetails;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.ui.api.ListenerApiUser$;
import pl.touk.nussknacker.ui.db.entity.CommentEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessActionEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessActionId;
import pl.touk.nussknacker.ui.listener.Comment;
import pl.touk.nussknacker.ui.listener.ProcessChangeEvent;
import pl.touk.nussknacker.ui.listener.ProcessChangeListener;
import pl.touk.nussknacker.ui.process.deployment.DeploymentManagerDispatcher;
import pl.touk.nussknacker.ui.process.deployment.DeploymentService;
import pl.touk.nussknacker.ui.process.deployment.DeploymentServiceImpl$;
import pl.touk.nussknacker.ui.process.deployment.LoggedUserConversions$;
import pl.touk.nussknacker.ui.process.deployment.ObsoleteStateDetector$;
import pl.touk.nussknacker.ui.process.deployment.ScenarioResolver;
import pl.touk.nussknacker.ui.process.exception.DeployingInvalidScenarioError$;
import pl.touk.nussknacker.ui.process.exception.ProcessIllegalAction$;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.process.repository.DbProcessActionRepository;
import pl.touk.nussknacker.ui.process.repository.DeploymentComment;
import pl.touk.nussknacker.ui.process.repository.DeploymentComment$;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository$FetchProcessesDetailsQuery$;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository$;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.security.api.NussknackerInternalUser$;
import pl.touk.nussknacker.ui.util.FutureUtils;
import pl.touk.nussknacker.ui.util.FutureUtils$;
import pl.touk.nussknacker.ui.validation.ProcessValidation;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;
import slick.dbio.Effect;
import slick.dbio.NoStream;

@ScalaSignature(bytes="\u0006\u0005\u0011=d\u0001B\u0012%\u0001EB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!Y\u0007A!A!\u0002\u0013a\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u0011Y\u0004!\u0011!Q\u0001\n]D\u0001\" \u0001\u0003\u0002\u0003\u0006IA \u0005\u000b\u0003'\u0001!\u0011!Q\u0001\n\u0005U\u0001BCA\u0013\u0001\t\u0005\t\u0015a\u0003\u0002(!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003s\u0003A\u0011IA^\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDqA!\u000b\u0001\t#\u0011Y\u0003C\u0004\u0003f\u0001!IAa\u001a\t\u000f\t-\u0004\u0001\"\u0003\u0003n!9!Q\u001d\u0001\u0005\n\t\u001d\bbBB\u0006\u0001\u0011%1Q\u0002\u0005\b\u0007G\u0001A\u0011BB\u0013\u0011\u001d\u0019)\u0005\u0001C\t\u0007\u000fBqa!\u0019\u0001\t\u0013\u0019\u0019\u0007C\u0004\u0004\u0010\u0002!\te!%\t\u000f\r=\u0005\u0001\"\u0011\u0004(\"91q\u0012\u0001\u0005\n\ru\u0006bBBo\u0001\u0011%1q\u001c\u0005\b\u0007{\u0004A\u0011BB\u0000\u0011\u001d!\t\u0002\u0001C\u0005\t'Aq\u0001\"\u000b\u0001\t\u0013!Y\u0003C\u0004\u0005L\u0001!\t\u0001\"\u0014\b\u0013\u0011=C%!A\t\u0002\u0011Ec\u0001C\u0012%\u0003\u0003E\t\u0001b\u0015\t\u000f\u0005]\u0002\u0005\"\u0001\u0005V!IAq\u000b\u0011\u0012\u0002\u0013\u0005A\u0011\f\u0002\u0016\t\u0016\u0004Hn\\=nK:$8+\u001a:wS\u000e,\u0017*\u001c9m\u0015\t)c%\u0001\u0006eKBdw._7f]RT!a\n\u0015\u0002\u000fA\u0014xnY3tg*\u0011\u0011FK\u0001\u0003k&T!a\u000b\u0017\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003[9\nA\u0001^8vW*\tq&\u0001\u0002qY\u000e\u00011\u0003\u0002\u00013qq\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a!\u00118z%\u00164\u0007CA\u001d;\u001b\u0005!\u0013BA\u001e%\u0005E!U\r\u001d7ps6,g\u000e^*feZL7-\u001a\t\u0003{\u0011k\u0011A\u0010\u0006\u0003\u007f\u0001\u000bAb]2bY\u0006dwnZ4j]\u001eT!!\u0011\"\u0002\u0011QL\b/Z:bM\u0016T\u0011aQ\u0001\u0004G>l\u0017BA#?\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u0015\u0011L7\u000f]1uG\",'\u000f\u0005\u0002:\u0011&\u0011\u0011\n\n\u0002\u001c\t\u0016\u0004Hn\\=nK:$X*\u00198bO\u0016\u0014H)[:qCR\u001c\u0007.\u001a:\u0002#A\u0014xnY3tgJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002M\u001fFk\u0011!\u0014\u0006\u0003\u001d\u001a\n!B]3q_NLGo\u001c:z\u0013\t\u0001VJA\rGKR\u001c\u0007.\u001b8h!J|7-Z:t%\u0016\u0004xn]5u_JL\bC\u0001*a\u001d\t\u0019VL\u0004\u0002U5:\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bM\u0001\u0007yI|w\u000e\u001e \n\u0003e\u000b!\u0001\u001a2\n\u0005mc\u0016\u0001B;uS2T\u0011!W\u0005\u0003=~\u000b1\u0003\u0012\"J\u001f\u0006\u001bG/[8o\u0013:\u001cH/\u00198dKNT!a\u0017/\n\u0005\u0005\u0014'A\u0001#C\u0015\tqv,\u0001\tbGRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0019A*Z)\n\u0005\u0019l%!\u0007#c!J|7-Z:t\u0003\u000e$\u0018n\u001c8SKB|7/\u001b;pef\f!\u0002\u001a2j_J+hN\\3s!\ta\u0015.\u0003\u0002k\u001b\n\u0001BIQ%P\u0003\u000e$\u0018n\u001c8Sk:tWM]\u0001\u0012aJ|7-Z:t-\u0006d\u0017\u000eZ1uS>t\u0007CA7q\u001b\u0005q'BA8)\u0003)1\u0018\r\\5eCRLwN\\\u0005\u0003c:\u0014\u0011\u0003\u0015:pG\u0016\u001c8OV1mS\u0012\fG/[8o\u0003A\u00198-\u001a8be&|'+Z:pYZ,'\u000f\u0005\u0002:i&\u0011Q\u000f\n\u0002\u0011'\u000e,g.\u0019:j_J+7o\u001c7wKJ\fQ\u0003\u001d:pG\u0016\u001c8o\u00115b]\u001e,G*[:uK:,'\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{Q\u0005AA.[:uK:,'/\u0003\u0002}s\n)\u0002K]8dKN\u001c8\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014\u0018\u0001F:dK:\f'/[8Ti\u0006$X\rV5nK>,H\u000f\u0005\u00034\u007f\u0006\r\u0011bAA\u0001i\t1q\n\u001d;j_:\u0004B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0005ekJ\fG/[8o\u0015\r\ti\u0001N\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\t\u0003\u000f\u0011aBR5oSR,G)\u001e:bi&|g.A\u0003dY>\u001c7\u000e\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\tQLW.\u001a\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005\u0015\u0019En\\2l\u0003\u0019\u0019\u0018p\u001d;f[B!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012!B1di>\u0014(BAA\u0019\u0003\u0011\t7n[1\n\t\u0005U\u00121\u0006\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003w\t\t%a\u0011\u0002F\u0005\u001d\u0013\u0011JA&\u0003\u001b\ny%!\u0015\u0015\t\u0005u\u0012q\b\t\u0003s\u0001Aq!!\n\f\u0001\b\t9\u0003C\u0003G\u0017\u0001\u0007q\tC\u0003K\u0017\u0001\u00071\nC\u0003d\u0017\u0001\u0007A\rC\u0003h\u0017\u0001\u0007\u0001\u000eC\u0003l\u0017\u0001\u0007A\u000eC\u0003s\u0017\u0001\u00071\u000fC\u0003w\u0017\u0001\u0007q\u000fC\u0003~\u0017\u0001\u0007a\u0010C\u0005\u0002\u0014-\u0001\n\u00111\u0001\u0002\u0016\u0005!r-\u001a;EKBdw._3e'\u000e,g.\u0019:j_N$B!a\u0016\u0002\u0010R!\u0011\u0011LAC!\u0019\tY&!\u0018\u0002b5\u0011\u00111B\u0005\u0005\u0003?\nYA\u0001\u0004GkR,(/\u001a\t\u0007\u0003G\ni'a\u001d\u000f\t\u0005\u0015\u0014\u0011\u000e\b\u0004+\u0006\u001d\u0014\"A\u001b\n\u0007\u0005-D'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0014\u0011\u000f\u0002\u0005\u0019&\u001cHOC\u0002\u0002lQ\u0002B!!\u001e\u0002\u00026\u0011\u0011q\u000f\u0006\u0004K\u0005e$\u0002BA>\u0003{\n1!\u00199j\u0015\r\tyHK\u0001\u0007K:<\u0017N\\3\n\t\u0005\r\u0015q\u000f\u0002\u0015\t\u0016\u0004Hn\\=fIN\u001bWM\\1sS>$\u0015\r^1\t\u000f\u0005\u001dE\u0002q\u0001\u0002\n\u0006\u0011Qm\u0019\t\u0005\u00037\nY)\u0003\u0003\u0002\u000e\u0006-!\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u001d\t\t\n\u0004a\u0001\u0003'\u000ba\u0002\u001d:pG\u0016\u001c8/\u001b8h)f\u0004X\r\u0005\u0003\u0002\u0016\u0006Mf\u0002BAL\u0003_sA!!'\u0002,:!\u00111TAT\u001d\u0011\ti*!*\u000f\t\u0005}\u00151\u0015\b\u0004+\u0006\u0005\u0016\"A\u0018\n\u00055r\u0013BA\u0016-\u0013\r\tIKK\u0001\ne\u0016\u001cH/\\8eK2L1aJAW\u0015\r\tIKK\u0005\u0005\u0003W\n\tLC\u0002(\u0003[KA!!.\u00028\nq\u0001K]8dKN\u001c\u0018N\\4UsB,'\u0002BA6\u0003c\u000bQbY1oG\u0016d\u0007K]8dKN\u001cHCBA_\u00037\f9\u000f\u0006\u0004\u0002@\u0006\u001d\u0017\u0011\u001c\t\u0007\u00037\ni&!1\u0011\u0007M\n\u0019-C\u0002\u0002FR\u0012A!\u00168ji\"9\u0011\u0011Z\u0007A\u0004\u0005-\u0017\u0001B;tKJ\u0004B!!4\u0002V6\u0011\u0011q\u001a\u0006\u0005\u0003w\n\tNC\u0002\u0002T\"\n\u0001b]3dkJLG/_\u0005\u0005\u0003/\fyM\u0001\u0006M_\u001e<W\rZ+tKJDq!a\"\u000e\u0001\b\tI\tC\u0004\u0002^6\u0001\r!a8\u0002\u0013A\u0014xnY3tg&#\u0007\u0003BAq\u0003Gl!!!-\n\t\u0005\u0015\u0018\u0011\u0017\u0002\u0012!J|7-Z:t\u0013\u0012<\u0016\u000e\u001e5OC6,\u0007bBAu\u001b\u0001\u0007\u00111^\u0001\u0012I\u0016\u0004Hn\\=nK:$8i\\7nK:$\b\u0003B\u001a\u0000\u0003[\u00042\u0001TAx\u0013\r\t\t0\u0014\u0002\u0012\t\u0016\u0004Hn\\=nK:$8i\\7nK:$\u0018A\u00053fa2|\u0017\u0010\u0015:pG\u0016\u001c8/Q:z]\u000e$\u0002\"a>\u0003\u000e\tE!q\u0005\u000b\u0007\u0003s\u0014IAa\u0003\u0011\r\u0005m\u0013QLA~!\u0019\tY&!\u0018\u0002~B!1g`A\u0000!\u0011\u0011\tA!\u0002\u000e\u0005\t\r!bA\u0013\u0002~%!!q\u0001B\u0002\u0005Q)\u0005\u0010^3s]\u0006dG)\u001a9m_flWM\u001c;JI\"9\u0011\u0011\u001a\bA\u0004\u0005-\u0007bBAD\u001d\u0001\u000f\u0011\u0011\u0012\u0005\b\u0005\u001fq\u0001\u0019AAp\u0003E\u0001(o\\2fgNLEmV5uQ:\u000bW.\u001a\u0005\b\u0005'q\u0001\u0019\u0001B\u000b\u00035\u0019\u0018M^3q_&tG\u000fU1uQB!1g B\f!\u0011\u0011IB!\t\u000f\t\tm!Q\u0004\t\u0003+RJ1Aa\b5\u0003\u0019\u0001&/\u001a3fM&!!1\u0005B\u0013\u0005\u0019\u0019FO]5oO*\u0019!q\u0004\u001b\t\u000f\u0005%h\u00021\u0001\u0002l\u0006!b/\u00197jI\u0006$XMQ3g_J,G)\u001a9m_f$bA!\f\u00036\tMCC\u0002B\u0018\u0005c\u0011\u0019\u0004\u0005\u0004\u0002\\\u0005u\u00131\u000f\u0005\b\u0003\u0013|\u00019AAf\u0011\u001d\t9i\u0004a\u0002\u0003\u0013CqAa\u000e\u0010\u0001\u0004\u0011I$\u0001\bqe>\u001cWm]:EKR\f\u0017\u000e\\:\u0011\r\tm\"\u0011\tB$\u001d\u0011\tIJ!\u0010\n\t\t}\u0012QV\u0001\u000faJ|7-Z:tI\u0016$\u0018-\u001b7t\u0013\u0011\u0011\u0019E!\u0012\u0003%\t\u000b7/\u001a)s_\u000e,7o\u001d#fi\u0006LGn\u001d\u0006\u0005\u0005\u007f\ti\u000b\u0005\u0003\u0003J\t=SB\u0001B&\u0015\u0011\u0011i%! \u0002\u001d\r\fgn\u001c8jG\u0006dwM]1qQ&!!\u0011\u000bB&\u0005A\u0019\u0015M\\8oS\u000e\fG\u000e\u0015:pG\u0016\u001c8\u000fC\u0004\u0003V=\u0001\rAa\u0016\u0002\u0011\u0005\u001cG/[8o\u0013\u0012\u0004BA!\u0017\u0003b5\u0011!1\f\u0006\u0005\u0005;\u0012y&\u0001\u0004f]RLG/\u001f\u0006\u00033\"JAAa\u0019\u0003\\\ty\u0001K]8dKN\u001c\u0018i\u0019;j_:LE-A\bwC2LG-\u0019;f!J|7-Z:t)\u0011\t\tM!\u001b\t\u000f\t]\u0002\u00031\u0001\u0003:\u0005Y3\r[3dW\u000e\u000bg\u000eU3sM>\u0014X.Q2uS>t\u0017I\u001c3BI\u0012Le\u000e\u0015:pOJ,7o]!di&|g.\u0006\u0003\u0003p\t\u0005EC\u0003B9\u0005_\u00139L!6\u0003`RA!1\u000fBQ\u0005W\u0013i\u000b\u0005\u0004\u0002\\\u0005u#Q\u000f\t\fg\t]$1\u0010B,\u0005'\u0013y*C\u0002\u0003zQ\u0012a\u0001V;qY\u0016$\u0004C\u0002B\u001e\u0005\u0003\u0012i\b\u0005\u0003\u0003\u0000\t\u0005E\u0002\u0001\u0003\b\u0005\u0007\u000b\"\u0019\u0001BC\u0005\t\u00016+\u0005\u0003\u0003\b\n5\u0005cA\u001a\u0003\n&\u0019!1\u0012\u001b\u0003\u000f9{G\u000f[5oOB\u00191Ga$\n\u0007\tEEGA\u0002B]f\u0004BaM@\u0003\u0016B!!q\u0013BN\u001b\t\u0011IJC\u0002(\u0003sJAA!(\u0003\u001a\nIa+\u001a:tS>t\u0017\n\u001a\t\u0005g}\f\u0019\nC\u0005\u0003$F\t\t\u0011q\u0001\u0003&\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\r\tm\"q\u0015B?\u0013\u0011\u0011IK!\u0012\u00033A\u0013xnY3tgNC\u0017\r]3GKR\u001c\u0007n\u0015;sCR,w-\u001f\u0005\b\u0003\u0013\f\u00029AAf\u0011\u001d\t9)\u0005a\u0002\u0003\u0013Cq!!8\u0012\u0001\u0004\u0011\t\f\u0005\u0003\u0003\u0018\nM\u0016\u0002\u0002B[\u00053\u0013\u0011\u0002\u0015:pG\u0016\u001c8/\u00133\t\u000f\te\u0016\u00031\u0001\u0003<\u0006Q\u0011m\u0019;j_:$\u0016\u0010]3\u0011\t\tu&q\u001a\b\u0005\u0005\u007f\u0013YM\u0004\u0003\u0003B\n%g\u0002\u0002Bb\u0005\u000ftA!a'\u0003F&\u0019\u0011q\u0010\u0016\n\t\u0005m\u0014QP\u0005\u0004K\u0005e\u0014\u0002\u0002Bg\u0003o\n\u0011\u0003\u0015:pG\u0016\u001c8/Q2uS>tG+\u001f9f\u0013\u0011\u0011\tNa5\u0003#A\u0013xnY3tg\u0006\u001bG/[8o)f\u0004XM\u0003\u0003\u0003N\u0006]\u0004b\u0002Bl#\u0001\u0007!\u0011\\\u0001\u001eO\u0016$h+\u001a:tS>twJ\\,iS\u000eD\u0017i\u0019;j_:L5\u000fR8oKB91Ga7\u0003|\tM\u0015b\u0001Boi\tIa)\u001e8di&|g.\r\u0005\b\u0005C\f\u0002\u0019\u0001Br\u0003i9W\r\u001e\"vS2$\u0017J\u001c4p!J|7-Z:tS:<G+\u001f9f!\u001d\u0019$1\u001cB>\u0005?\u000b!d\u00195fG.Le\u000e\u0015:pOJ,7o],ji\"dunY6j]\u001e,BA!;\u0003xRQ!1\u001eB\u007f\u0007\u0003\u0019\u0019aa\u0002\u0015\u0011\t5(q\u001eB}\u0005w\u0004b!a\u0017\u0002^\t]\u0003\"\u0003By%\u0005\u0005\t9\u0001Bz\u0003))g/\u001b3f]\u000e,GE\r\t\u0007\u0005w\u00119K!>\u0011\t\t}$q\u001f\u0003\b\u0005\u0007\u0013\"\u0019\u0001BC\u0011\u001d\tIM\u0005a\u0002\u0003\u0017Dq!a\"\u0013\u0001\b\tI\tC\u0004\u00038I\u0001\rAa@\u0011\r\tm\"\u0011\tB{\u0011\u001d\u0011IL\u0005a\u0001\u0005wCqa!\u0002\u0013\u0001\u0004\u0011\u0019*\u0001\u000ewKJ\u001c\u0018n\u001c8P]^C\u0017n\u00195BGRLwN\\%t\t>tW\rC\u0004\u0004\nI\u0001\rAa(\u0002/\t,\u0018\u000e\u001c3J]\u001a|\u0007K]8dKN\u001c\u0018J\\4UsB,\u0017\u0001I2iK\u000e\\\u0017JZ\"b]B+'OZ8s[\u0006\u001bG/[8o\u001f:\u0004&o\\2fgN,Baa\u0004\u0004\u001cQ11\u0011CB\u000f\u0007?!B!!1\u0004\u0014!I1QC\n\u0002\u0002\u0003\u000f1qC\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004C\u0002B\u001e\u0005O\u001bI\u0002\u0005\u0003\u0003\u0000\rmAa\u0002BB'\t\u0007!Q\u0011\u0005\b\u0005s\u001b\u0002\u0019\u0001B^\u0011\u001d\u00119d\u0005a\u0001\u0007C\u0001bAa\u000f\u0003B\re\u0011AH2iK\u000e\\\u0017JZ\"b]B+'OZ8s[\u0006\u001bG/[8o\u0013:\u001cF/\u0019;f+\u0011\u00199ca\r\u0015\u0011\r%2QGB\u001c\u0007w!B!!1\u0004,!I1Q\u0006\u000b\u0002\u0002\u0003\u000f1qF\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004C\u0002B\u001e\u0005O\u001b\t\u0004\u0005\u0003\u0003\u0000\rMBa\u0002BB)\t\u0007!Q\u0011\u0005\b\u0005s#\u0002\u0019\u0001B^\u0011\u001d\u00119\u0004\u0006a\u0001\u0007s\u0001bAa\u000f\u0003B\rE\u0002bBB\u001f)\u0001\u00071qH\u0001\u0003aN\u0004B!!\u001e\u0004B%!11IA<\u00051\u0001&o\\2fgN\u001cF/\u0019;f\u0003U\u0001(/\u001a9be\u0016$U\r\u001d7ps6,g\u000e\u001e#bi\u0006$ba!\u0013\u0004P\r]\u0003\u0003\u0002B\u0001\u0007\u0017JAa!\u0014\u0003\u0004\tqA)\u001a9m_flWM\u001c;ECR\f\u0007bBAe+\u0001\u00071\u0011\u000b\t\u0005\u0005\u0003\u0019\u0019&\u0003\u0003\u0004V\t\r!\u0001B+tKJDqa!\u0017\u0016\u0001\u0004\u0019Y&\u0001\u0007eKBdw._7f]RLE\r\u0005\u0003\u0003\u0002\ru\u0013\u0002BB0\u0005\u0007\u0011A\u0002R3qY>LX.\u001a8u\u0013\u0012\fAE];o\t\u0016\u0004Hn\\=nK:$\u0018i\u0019;j_:<\u0016\u000e\u001e5O_RLg-[2bi&|gn]\u000b\u0005\u0007K\u001ay\u0007\u0006\b\u0004h\r\u000551QBC\u0007\u000f\u001bYi!$\u0015\t\r%4q\u000f\u000b\u0007\u0007W\u001a\u0019h!\u001e\u0011\r\u0005m\u0013QLB7!\u0011\u0011yha\u001c\u0005\u000f\rEdC1\u0001\u0003\u0006\n\tA\u000bC\u0004\u0002JZ\u0001\u001d!a3\t\u000f\u0005\u001de\u0003q\u0001\u0002\n\"A1\u0011\u0010\f\u0005\u0002\u0004\u0019Y(A\u0005sk:\f5\r^5p]B)1g! \u0004l%\u00191q\u0010\u001b\u0003\u0011q\u0012\u0017P\\1nKzBqA!/\u0017\u0001\u0004\u0011Y\fC\u0004\u0003VY\u0001\rAa\u0016\t\u000f\t=a\u00031\u0001\u0002`\"91\u0011\u0012\fA\u0002\tM\u0015!\b<feNLwN\\(o/\"L7\r[!di&|g.S:E_:,w\n\u001d;\t\u000f\u0005%h\u00031\u0001\u0002l\"91\u0011\u0002\fA\u0002\t}\u0015aD4fiB\u0013xnY3tgN#\u0018\r^3\u0015\t\rM5Q\u0015\u000b\t\u0007+\u001b9j!'\u0004\u001cB1\u00111LA/\u0007\u007fAq!!3\u0018\u0001\b\tY\rC\u0004\u0002\b^\u0001\u001d!!#\t\u000f\ruu\u0003q\u0001\u0004 \u0006yaM]3tQ:,7o\u001d)pY&\u001c\u0017\u0010\u0005\u0003\u0002v\r\u0005\u0016\u0002BBR\u0003o\u00121\u0003R1uC\u001a\u0013Xm\u001d5oKN\u001c\bk\u001c7jGfDqAa\u0004\u0018\u0001\u0004\ty\u000e\u0006\u0003\u0004*\u000eEF\u0003CBK\u0007W\u001bika,\t\u000f\u0005%\u0007\u0004q\u0001\u0002L\"9\u0011q\u0011\rA\u0004\u0005%\u0005bBBO1\u0001\u000f1q\u0014\u0005\b\u0005oA\u0002\u0019ABZa\u0011\u0019)l!/\u0011\r\tm\"\u0011IB\\!\u0011\u0011yh!/\u0005\u0019\rm6\u0011WA\u0001\u0002\u0003\u0015\tA!\"\u0003\u0007}#\u0013\u0007\u0006\u0004\u0004@\u000e\u001d71\u001b\u000b\u0007\u0007\u0003\u001c\u0019m!2\u0011\tI\u00037q\b\u0005\b\u0003\u000fK\u00029AAE\u0011\u001d\u0019i*\u0007a\u0002\u0007?CqAa\u000e\u001a\u0001\u0004\u0019I\r\r\u0003\u0004L\u000e=\u0007C\u0002B\u001e\u0005\u0003\u001ai\r\u0005\u0003\u0003\u0000\r=G\u0001DBi\u0007\u000f\f\t\u0011!A\u0003\u0002\t\u0015%aA0%e!91Q[\rA\u0002\r]\u0017!F5o!J|wM]3tg\u0006\u001bG/[8o)f\u0004Xm\u001d\t\u0007\u00053\u0019INa/\n\t\rm'Q\u0005\u0002\u0004'\u0016$\u0018!H2iK\u000e\\7\u000b^1uK&sG)\u001a9m_flWM\u001c;NC:\fw-\u001a:\u0015\r\r\u00058q]By)\u0019\u0019\tma9\u0004f\"9\u0011q\u0011\u000eA\u0004\u0005%\u0005bBBO5\u0001\u000f1q\u0014\u0005\b\u0007ST\u0002\u0019ABv\u0003E!W\r\u001d7ps6,g\u000e^'b]\u0006<WM\u001d\t\u0005\u0003k\u001ai/\u0003\u0003\u0004p\u0006]$!\u0005#fa2|\u00170\\3oi6\u000bg.Y4fe\"9!q\u0007\u000eA\u0002\rM\b\u0007BB{\u0007s\u0004bAa\u000f\u0003B\r]\b\u0003\u0002B@\u0007s$Aba?\u0004r\u0006\u0005\t\u0011!B\u0001\u0005\u000b\u00131a\u0018\u00134\u0003Y\u0001(o\\2fgN$\u0015\r^1Fq&\u001cHo\u0014:GC&dW\u0003\u0002C\u0001\t\u000f!b\u0001b\u0001\u0005\n\u0011=\u0001\u0003\u0002*a\t\u000b\u0001BAa \u0005\b\u001191\u0011O\u000eC\u0002\t\u0015\u0005b\u0002C\u00067\u0001\u0007AQB\u0001\r[\u0006L(-\u001a)s_\u000e,7o\u001d\t\u0005g}$)\u0001C\u0004\u0002^n\u0001\rA!-\u0002%\u001d,Go\u0015;bi\u00164%o\\7F]\u001eLg.\u001a\u000b\u0007\t+!)\u0003b\n\u0015\r\u0011]A\u0011\u0005C\u0012!\u0019\tY&!\u0018\u0005\u001aA1\u0011Q\u000fC\u000e\t?IA\u0001\"\b\u0002x\t9r+\u001b;i\t\u0006$\u0018M\u0012:fg\"tWm]:Ti\u0006$Xo\u001d\t\u0005g}\u001cy\u0004C\u0004\u0002\br\u0001\u001d!!#\t\u000f\ruE\u0004q\u0001\u0004 \"91\u0011\u001e\u000fA\u0002\r-\bb\u0002B\b9\u0001\u0007\u0011q\\\u0001\u0016Q\u0006tG\r\\3GS:L7\u000f[3e!J|7-Z:t)\u0019!i\u0003b\u000f\u0005HQ!Aq\u0006C\u001d!\u0011\u0011\u0006\r\"\r\u0011\tMzH1\u0007\t\u0005\u0005w!)$\u0003\u0003\u00058\t\u0015#!\u0004)s_\u000e,7o]!di&|g\u000eC\u0004\u0002\bv\u0001\u001d!!#\t\u000f\t]R\u00041\u0001\u0005>A\"Aq\bC\"!\u0019\u0011YD!\u0011\u0005BA!!q\u0010C\"\t1!)\u0005b\u000f\u0002\u0002\u0003\u0005)\u0011\u0001BC\u0005\ryF\u0005\u000e\u0005\b\t\u0013j\u0002\u0019\u0001C\u0010\u00031\u0001(o\\2fgN\u001cF/\u0019;f\u0003mIgN^1mS\u0012\fG/Z%o!J|wM]3tg\u0006\u001bG/[8ogR\u0011\u0011\u0011Y\u0001\u0016\t\u0016\u0004Hn\\=nK:$8+\u001a:wS\u000e,\u0017*\u001c9m!\tI\u0004e\u0005\u0002!eQ\u0011A\u0011K\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\u0011m#\u0006BA\u000b\t;Z#\u0001b\u0018\u0011\t\u0011\u0005D1N\u0007\u0003\tGRA\u0001\"\u001a\u0005h\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\tS\"\u0014AC1o]>$\u0018\r^5p]&!AQ\u000eC2\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DeploymentServiceImpl
implements DeploymentService,
LazyLogging {
    private final DeploymentManagerDispatcher dispatcher;
    private final FetchingProcessRepository<DBIOAction> processRepository;
    private final DbProcessActionRepository<DBIOAction> actionRepository;
    private final DBIOActionRunner dbioRunner;
    private final ProcessValidation processValidation;
    private final ScenarioResolver scenarioResolver;
    private final ProcessChangeListener processChangeListener;
    private final Option<FiniteDuration> scenarioStateTimeout;
    private final Clock clock;
    private final ActorSystem system;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Clock $lessinit$greater$default$9() {
        return DeploymentServiceImpl$.MODULE$.$lessinit$greater$default$9();
    }

    private Logger logger$lzycompute() {
        DeploymentServiceImpl deploymentServiceImpl = this;
        synchronized (deploymentServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Future<List<DeployedScenarioData>> getDeployedScenarios(String processingType, ExecutionContext ec) {
        NussknackerInternalUser$ userFetchingDataFromRepository = NussknackerInternalUser$.MODULE$;
        Some x$1 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Some x$3 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some x$4 = new Some((Object)new .colon.colon((Object)processingType, (List)Nil$.MODULE$));
        Option<Seq<String>> x$5 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$4();
        Option<Seq<ProcessName>> x$6 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$6();
        return this.dbioRunner.run(this.processRepository.fetchProcessesDetails(new FetchingProcessRepository.FetchProcessesDetailsQuery((Option<Object>)x$1, (Option<Object>)x$2, (Option<Object>)x$3, x$5, (Option<Seq<String>>)x$4, x$6), processdetails.ProcessShapeFetchStrategy$.FetchCanonical$.MODULE$, (LoggedUser)userFetchingDataFromRepository, ec)).flatMap((Function1 & Serializable)deployedProcesses -> Future$.MODULE$.sequence((IterableOnce)deployedProcesses.flatMap((Function1 & Serializable)details -> {
            processdetails.ProcessAction lastDeployAction = (processdetails.ProcessAction)details.lastDeployedAction().get();
            User deployingUser = new User(lastDeployAction.user(), lastDeployAction.user());
            DeploymentData deploymentData = this.prepareDeploymentData(deployingUser, "");
            Try deployedScenarioDataTry = $this.scenarioResolver.resolveScenario((CanonicalProcess)details.json(), details.processCategory()).map((Function1 & Serializable)resolvedScenario -> new DeployedScenarioData(details.toEngineProcessVersion(), deploymentData, resolvedScenario));
            Try try_ = deployedScenarioDataTry;
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Exception during resolving deployed scenario " + details.id(), exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return None$.MODULE$;
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                DeployedScenarioData value = (DeployedScenarioData)success.value();
                return new Some((Object)Future$.MODULE$.successful((Object)value));
            }
            throw new MatchError((Object)try_);
        }), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)dataList -> dataList, ec), ec);
    }

    @Override
    public Future<BoxedUnit> cancelProcess(ProcessIdWithName processId, Option<DeploymentComment> deploymentComment, LoggedUser user, ExecutionContext ec) {
        Enumeration.Value actionType = ProcessActionType$.MODULE$.Cancel();
        return this.checkCanPerformActionAndAddInProgressAction(processId.id(), actionType, (Function1)(Function1 & Serializable)x$1 -> x$1.lastDeployedAction().map((Function1 & Serializable)x$2 -> x$2.processVersionId()), (Function1)(Function1 & Serializable)x$3 -> None$.MODULE$, (processdetails.ProcessShapeFetchStrategy)processdetails.ProcessShapeFetchStrategy$.NotFetch$.MODULE$, user, ec).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                processdetails.BaseProcessDetails processDetails = (processdetails.BaseProcessDetails)tuple4._1();
                ProcessActionId actionId = (ProcessActionId)tuple4._2();
                Option versionOnWhichActionIsDone = (Option)tuple4._3();
                Option buildInfoProcessIngType = (Option)tuple4._4();
                return this.runDeploymentActionWithNotifications(actionType, actionId, processId, (Option<VersionId>)versionOnWhichActionIsDone, deploymentComment, (Option<String>)buildInfoProcessIngType, (Function0 & Serializable)() -> $this.dispatcher.deploymentManagerUnsafe(processDetails.processingType()).cancel(processId.name(), LoggedUserConversions$.MODULE$.LoggedUserOps(user).toManagerUser()), user, ec);
            }
            throw new MatchError((Object)tuple4);
        }, ec);
    }

    @Override
    public Future<Future<Option<ExternalDeploymentId>>> deployProcessAsync(ProcessIdWithName processIdWithName, Option<String> savepointPath, Option<DeploymentComment> deploymentComment, LoggedUser user, ExecutionContext ec) {
        Enumeration.Value actionType = ProcessActionType$.MODULE$.Deploy();
        return this.checkCanPerformActionAndAddInProgressAction(processIdWithName.id(), actionType, (Function1)(Function1 & Serializable)d -> new Some((Object)d.processVersionId()), (Function1)(Function1 & Serializable)d -> new Some((Object)d.processingType()), (processdetails.ProcessShapeFetchStrategy)processdetails.ProcessShapeFetchStrategy$.FetchCanonical$.MODULE$, user, ec).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                processdetails.BaseProcessDetails processDetails = (processdetails.BaseProcessDetails)tuple4._1();
                ProcessActionId actionId = (ProcessActionId)tuple4._2();
                Option versionOnWhichActionIsDone = (Option)tuple4._3();
                Option buildInfoProcessIngType = (Option)tuple4._4();
                return this.validateBeforeDeploy((processdetails.BaseProcessDetails<CanonicalProcess>)processDetails, actionId, user, ec).transformWith((Function1 & Serializable)x0$2 -> {
                    Try try_ = x0$2;
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        return $this.dbioRunner.runInTransaction($this.actionRepository.removeAction(actionId)).transform((Function1 & Serializable)x$4 -> new Failure(ex), ec);
                    }
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        DeployedScenarioData validationResult = (DeployedScenarioData)success.value();
                        Future deploymentFuture = this.runDeploymentActionWithNotifications(actionType, actionId, processIdWithName, (Option<VersionId>)versionOnWhichActionIsDone, deploymentComment, (Option<String>)buildInfoProcessIngType, (Function0 & Serializable)() -> $this.dispatcher.deploymentManagerUnsafe(processDetails.processingType()).deploy(validationResult.processVersion(), validationResult.deploymentData(), validationResult.resolvedScenario(), savepointPath), user, ec);
                        return Future$.MODULE$.successful(deploymentFuture);
                    }
                    throw new MatchError((Object)try_);
                }, ec);
            }
            throw new MatchError((Object)tuple4);
        }, ec);
    }

    public Future<DeployedScenarioData> validateBeforeDeploy(processdetails.BaseProcessDetails<CanonicalProcess> processDetails, ProcessActionId actionId, LoggedUser user, ExecutionContext ec) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateProcess(processDetails))).map((Function1 & Serializable)x$5 -> {
            DeploymentManager deploymentManager = $this.dispatcher.deploymentManagerUnsafe(processDetails.processingType());
            return new Tuple2(x$5, (Object)deploymentManager);
        }, ec).flatMap((Function1 & Serializable)x$8 -> {
            Tuple2 tuple2 = x$8;
            if (tuple2 != null) {
                DeploymentManager deploymentManager = (DeploymentManager)tuple2._2();
                return Future$.MODULE$.fromTry($this.scenarioResolver.resolveScenario((CanonicalProcess)processDetails.json(), processDetails.processCategory())).map((Function1 & Serializable)resolvedCanonicalProcess -> {
                    DeploymentData deploymentData = this.prepareDeploymentData(LoggedUserConversions$.MODULE$.LoggedUserOps(user).toManagerUser(), actionId.value().toString());
                    return new Tuple2(resolvedCanonicalProcess, (Object)deploymentData);
                }, ec).flatMap((Function1 & Serializable)x$7 -> {
                    Tuple2 tuple2 = x$7;
                    if (tuple2 != null) {
                        CanonicalProcess resolvedCanonicalProcess = (CanonicalProcess)tuple2._1();
                        DeploymentData deploymentData = (DeploymentData)tuple2._2();
                        return deploymentManager.validate(processDetails.toEngineProcessVersion(), deploymentData, resolvedCanonicalProcess).map((Function1 & Serializable)x$6 -> {
                            BoxedUnit boxedUnit = x$6;
                            return new DeployedScenarioData(processDetails.toEngineProcessVersion(), deploymentData, resolvedCanonicalProcess);
                        }, ec);
                    }
                    throw new MatchError((Object)tuple2);
                }, ec);
            }
            throw new MatchError((Object)tuple2);
        }, ec);
    }

    private void validateProcess(processdetails.BaseProcessDetails<CanonicalProcess> processDetails) {
        ValidationResults.ValidationResult validationResult = this.processValidation.processingTypeValidationWithTypingInfo((CanonicalProcess)processDetails.json(), processDetails.processingType(), processDetails.processCategory());
        if (validationResult.hasErrors()) {
            throw DeployingInvalidScenarioError$.MODULE$;
        }
    }

    private <PS> Future<Tuple4<processdetails.BaseProcessDetails<PS>, ProcessActionId, Option<VersionId>, Option<String>>> checkCanPerformActionAndAddInProgressAction(ProcessId processId, Enumeration.Value actionType, Function1<processdetails.BaseProcessDetails<PS>, Option<VersionId>> getVersionOnWhichActionIsDone, Function1<processdetails.BaseProcessDetails<PS>, Option<String>> getBuildInfoProcessingType, processdetails.ProcessShapeFetchStrategy<PS> evidence$1, LoggedUser user, ExecutionContext ec) {
        return this.dbioRunner.run(this.processRepository.fetchLatestProcessDetailsForProcessId(processId, evidence$1, user, ec)).flatMap((Function1 & Serializable)processDetailsOpt -> $this.dbioRunner.run(this.processDataExistOrFail((Option)processDetailsOpt, processId)).map((Function1 & Serializable)processDetails -> {
            this.checkIfCanPerformActionOnProcess(actionType, (processdetails.BaseProcessDetails)processDetails, evidence$1);
            BoxedUnit x$9 = BoxedUnit.UNIT;
            Option versionOnWhichActionIsDone = (Option)getVersionOnWhichActionIsDone.apply(processDetails);
            Option buildInfoProcessIngType = (Option)getBuildInfoProcessingType.apply(processDetails);
            return new Tuple4(processDetails, (Object)x$9, (Object)versionOnWhichActionIsDone, (Object)buildInfoProcessIngType);
        }, ec).flatMap((Function1 & Serializable)x$10 -> {
            Tuple4 tuple4 = x$10;
            if (tuple4 != null) {
                processdetails.BaseProcessDetails processDetails = (processdetails.BaseProcessDetails)tuple4._1();
                Option versionOnWhichActionIsDone = (Option)tuple4._3();
                Option buildInfoProcessIngType = (Option)tuple4._4();
                return this.checkInProgressWithLocking(processDetails, actionType, (Option<VersionId>)versionOnWhichActionIsDone, (Option<String>)buildInfoProcessIngType, evidence$1, user, ec).map((Function1 & Serializable)actionId -> new Tuple4((Object)processDetails, actionId, (Object)versionOnWhichActionIsDone, (Object)buildInfoProcessIngType), ec);
            }
            throw new MatchError((Object)tuple4);
        }, ec), ec);
    }

    private <PS> Future<ProcessActionId> checkInProgressWithLocking(processdetails.BaseProcessDetails<PS> processDetails, Enumeration.Value actionType, Option<VersionId> versionOnWhichActionIsDone, Option<String> buildInfoProcessIngType, processdetails.ProcessShapeFetchStrategy<PS> evidence$2, LoggedUser user, ExecutionContext ec) {
        return this.dbioRunner.runInTransaction(this.actionRepository.lockActionsTable().flatMap((Function1 & Serializable)x$13 -> {
            BoxedUnit boxedUnit = x$13;
            return $this.actionRepository.getInProgressActionTypes(processDetails.processId()).flatMap((Function1 & Serializable)inProgressActionTypes -> {
                DataFreshnessPolicy.Fresh$ freshnessPolicy = DataFreshnessPolicy.Fresh$.MODULE$;
                return this.getProcessState(processDetails, (Set<Enumeration.Value>)inProgressActionTypes, ec, (DataFreshnessPolicy)freshnessPolicy).map((Function1 & Serializable)processState -> {
                    this.checkIfCanPerformActionInState(actionType, processDetails, (ProcessState)processState, evidence$2);
                    BoxedUnit x$11 = BoxedUnit.UNIT;
                    return new Tuple2(processState, (Object)x$11);
                }, ec).flatMap((Function1 & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 != null) {
                        return $this.actionRepository.addInProgressAction(processDetails.processId(), actionType, versionOnWhichActionIsDone, buildInfoProcessIngType, user).map((Function1 & Serializable)actionId -> actionId, ec);
                    }
                    throw new MatchError((Object)tuple2);
                }, ec);
            }, ec);
        }, ec));
    }

    private <PS> void checkIfCanPerformActionOnProcess(Enumeration.Value actionType, processdetails.BaseProcessDetails<PS> processDetails, processdetails.ProcessShapeFetchStrategy<PS> evidence$3) {
        if (processDetails.isArchived()) {
            throw ProcessIllegalAction$.MODULE$.archived(actionType, processDetails.idWithName());
        }
        if (processDetails.isSubprocess()) {
            throw ProcessIllegalAction$.MODULE$.subprocess(actionType, processDetails.idWithName());
        }
    }

    private <PS> void checkIfCanPerformActionInState(Enumeration.Value actionType, processdetails.BaseProcessDetails<PS> processDetails, ProcessState ps, processdetails.ProcessShapeFetchStrategy<PS> evidence$4) {
        if (!ps.allowedActions().contains((Object)actionType)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Action: {} on process: {} not allowed in {} state", new Object[]{actionType, processDetails.name(), ps.status()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw ProcessIllegalAction$.MODULE$.apply(actionType, processDetails.idWithName(), ps);
        }
    }

    public DeploymentData prepareDeploymentData(User user, String deploymentId) {
        return new DeploymentData(deploymentId, user, Predef$.MODULE$.Map().empty());
    }

    private <T> Future<T> runDeploymentActionWithNotifications(Enumeration.Value actionType, ProcessActionId actionId, ProcessIdWithName processIdWithName, Option<VersionId> versionOnWhichActionIsDoneOpt, Option<DeploymentComment> deploymentComment, Option<String> buildInfoProcessIngType, Function0<Future<T>> runAction, LoggedUser user, ExecutionContext ec) {
        pl.touk.nussknacker.ui.listener.User listenerUser = ListenerApiUser$.MODULE$.apply(user);
        Future actionFuture = (Future)runAction.apply();
        String actionString = actionType.toString().toLowerCase() + " (id: " + actionId.value() + ") of " + processIdWithName.name();
        return actionFuture.transformWith((Function1 & Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable failure2 = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Action: " + actionString + " finished with failure", failure2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Instant performedAt = $this.clock.instant();
                $this.processChangeListener.handle((ProcessChangeEvent)new ProcessChangeEvent.OnDeployActionFailed(processIdWithName.id(), failure2), ec, listenerUser);
                return $this.dbioRunner.runInTransaction($this.actionRepository.markActionAsFailed(actionId, processIdWithName.id(), actionType, versionOnWhichActionIsDoneOpt, performedAt, failure2.getMessage(), buildInfoProcessIngType, user)).transform((Function1 & Serializable)x$14 -> new Failure(failure2), ec);
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return ((Future)versionOnWhichActionIsDoneOpt.map((Function1 & Serializable)versionOnWhichActionIsDone -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Finishing {}", (Object)actionString);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Instant performedAt = $this.clock.instant();
                    Option comment = deploymentComment.map((Function1 & Serializable)x$15 -> x$15.toComment(actionType));
                    $this.processChangeListener.handle((ProcessChangeEvent)new ProcessChangeEvent.OnDeployActionSuccess(processIdWithName.id(), versionOnWhichActionIsDone, comment, performedAt, actionType), ec, listenerUser);
                    return $this.dbioRunner.runInTransaction($this.actionRepository.markActionAsFinished(actionId, processIdWithName.id(), actionType, (VersionId)versionOnWhichActionIsDone, performedAt, (Option<Comment>)comment, buildInfoProcessIngType, user));
                }).getOrElse((Function0 & Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Action {} finished for action without version id - skipping listener notification", (Object)actionString);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return $this.dbioRunner.runInTransaction($this.actionRepository.removeAction(actionId));
                })).map((Function1 & Serializable)x$16 -> result, ec);
            }
            throw new MatchError((Object)try_);
        }, ec);
    }

    @Override
    public Future<ProcessState> getProcessState(ProcessIdWithName processIdWithName, LoggedUser user, ExecutionContext ec, DataFreshnessPolicy freshnessPolicy) {
        return this.dbioRunner.run(this.processRepository.fetchLatestProcessDetailsForProcessId(processIdWithName.id(), processdetails.ProcessShapeFetchStrategy$.NotFetch$.MODULE$, user, ec).flatMap((Function1 & Serializable)processDetailsOpt -> this.processDataExistOrFail((Option)processDetailsOpt, processIdWithName.id()).flatMap((Function1 & Serializable)processDetails -> $this.actionRepository.getInProgressActionTypes(processDetails.processId()).flatMap((Function1 & Serializable)inProgressActionTypes -> this.getProcessState((processdetails.BaseProcessDetails<?>)processDetails, (Set<Enumeration.Value>)inProgressActionTypes, ec, freshnessPolicy).map((Function1 & Serializable)result -> result, ec), ec), ec), ec));
    }

    @Override
    public Future<ProcessState> getProcessState(processdetails.BaseProcessDetails<?> processDetails, LoggedUser user, ExecutionContext ec, DataFreshnessPolicy freshnessPolicy) {
        return this.dbioRunner.run(this.actionRepository.getInProgressActionTypes(processDetails.processId()).flatMap((Function1 & Serializable)inProgressActionTypes -> this.getProcessState(processDetails, (Set<Enumeration.Value>)inProgressActionTypes, ec, freshnessPolicy).map((Function1 & Serializable)result -> result, ec), ec));
    }

    private DBIOAction<ProcessState, NoStream, Effect.All> getProcessState(processdetails.BaseProcessDetails<?> processDetails, Set<Enumeration.Value> inProgressActionTypes, ExecutionContext ec, DataFreshnessPolicy freshnessPolicy) {
        return (DBIOAction)this.dispatcher.deploymentManager(processDetails.processingType()).map((Function1 & Serializable)manager -> {
            if (inProgressActionTypes.contains((Object)ProcessActionType$.MODULE$.Deploy())) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Status for: '{}' is: {}", new Object[]{processDetails.name(), SimpleStateStatus$.MODULE$.DuringCancel()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ProcessStateDefinitionManager qual$1 = manager.processStateDefinitionManager();
                StateStatus x$1 = SimpleStateStatus$.MODULE$.DuringDeploy();
                Option x$2 = qual$1.processState$default$2();
                Option x$3 = qual$1.processState$default$3();
                Option x$4 = qual$1.processState$default$4();
                Option x$5 = qual$1.processState$default$5();
                List x$6 = qual$1.processState$default$6();
                return DBIOAction$.MODULE$.successful((Object)qual$1.processState(x$1, x$2, x$3, x$4, x$5, x$6));
            }
            if (inProgressActionTypes.contains((Object)ProcessActionType$.MODULE$.Cancel())) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Status for: '{}' is: {}", new Object[]{processDetails.name(), SimpleStateStatus$.MODULE$.DuringCancel()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ProcessStateDefinitionManager qual$2 = manager.processStateDefinitionManager();
                StateStatus x$7 = SimpleStateStatus$.MODULE$.DuringCancel();
                Option x$8 = qual$2.processState$default$2();
                Option x$9 = qual$2.processState$default$3();
                Option x$10 = qual$2.processState$default$4();
                Option x$11 = qual$2.processState$default$5();
                List x$12 = qual$2.processState$default$6();
                return DBIOAction$.MODULE$.successful((Object)qual$2.processState(x$7, x$8, x$9, x$10, x$11, x$12));
            }
            return this.checkStateInDeploymentManager((DeploymentManager)manager, processDetails, ec, freshnessPolicy);
        }).getOrElse((Function0 & Serializable)() -> DBIOAction$.MODULE$.successful((Object)SimpleProcessStateDefinitionManager$.MODULE$.errorFailedToGet()));
    }

    private DBIOAction<ProcessState, NoStream, Effect.All> checkStateInDeploymentManager(DeploymentManager deploymentManager, processdetails.BaseProcessDetails<?> processDetails, ExecutionContext ec, DataFreshnessPolicy freshnessPolicy) {
        return DBIOAction$.MODULE$.from(this.getStateFromEngine(deploymentManager, processDetails.idWithName(), ec, freshnessPolicy)).flatMap((Function1 & Serializable)state -> this.handleFinishedProcess(processDetails, (Option<ProcessState>)((Option)state.value()), ec).map((Function1 & Serializable)cancelActionOpt -> {
            BoxedUnit boxedUnit;
            Option lastAction = cancelActionOpt.orElse((Function0 & Serializable)() -> processDetails.lastAction());
            ProcessState finalState = ObsoleteStateDetector$.MODULE$.handleObsoleteStatus((Option<ProcessState>)((Option)state.value()), (Option<processdetails.ProcessAction>)lastAction);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Status for: '{}' is: {} (from engine: {}, cached: {}, last action: {})", new Object[]{processDetails.name(), finalState.status(), ((Option)state.value()).map((Function1 & Serializable)x$17 -> x$17.status()), BoxesRunTime.boxToBoolean((boolean)state.cached()), lastAction.map((Function1 & Serializable)x$18 -> x$18.action())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return finalState;
        }, ec), ec);
    }

    private <T> DBIOAction<T, NoStream, Effect.All> processDataExistOrFail(Option<T> maybeProcess, ProcessId processId) {
        Option<T> option = maybeProcess;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object processData = some.value();
            return DBIOAction$.MODULE$.successful(processData);
        }
        if (None$.MODULE$.equals(option)) {
            return DBIOAction$.MODULE$.failed((Throwable)new ProcessDBQueryRepository.ProcessNotFoundError(Long.toString(processId.value())));
        }
        throw new MatchError(option);
    }

    private Future<WithDataFreshnessStatus<Option<ProcessState>>> getStateFromEngine(DeploymentManager deploymentManager, ProcessIdWithName processIdWithName, ExecutionContext ec, DataFreshnessPolicy freshnessPolicy) {
        LazyRef failedToGetResult$lzy = new LazyRef();
        Future stateFromEngineFuture = deploymentManager.getProcessState(processIdWithName.name(), freshnessPolicy).recover((PartialFunction)new Serializable(this, processIdWithName, failedToGetResult$lzy){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ DeploymentServiceImpl $outer;
            private final ProcessIdWithName processIdWithName$4;
            private final LazyRef failedToGetResult$lzy$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Failed to get status of " + this.processIdWithName$4.name() + ": " + e.getMessage(), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (B1)DeploymentServiceImpl.pl$touk$nussknacker$ui$process$deployment$DeploymentServiceImpl$$failedToGetResult$1(this.failedToGetResult$lzy$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                return throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.processIdWithName$4 = processIdWithName$4;
                this.failedToGetResult$lzy$1 = failedToGetResult$lzy$1;
            }
        }, ec);
        return (Future)this.scenarioStateTimeout.map((Function1 & Serializable)timeout -> FutureUtils$.MODULE$.FutureOps(stateFromEngineFuture).withTimeout((FiniteDuration)timeout, (Function0 & Serializable)() -> DeploymentServiceImpl.pl$touk$nussknacker$ui$process$deployment$DeploymentServiceImpl$$failedToGetResult$1(failedToGetResult$lzy), $this.system).map((Function1 & Serializable)x0$1 -> {
            FutureUtils.LimitedByTimeoutResult limitedByTimeoutResult = x0$1;
            if (limitedByTimeoutResult instanceof FutureUtils.CompletedNormally) {
                FutureUtils.CompletedNormally completedNormally = (FutureUtils.CompletedNormally)limitedByTimeoutResult;
                WithDataFreshnessStatus value = (WithDataFreshnessStatus)completedNormally.value();
                return value;
            }
            if (limitedByTimeoutResult instanceof FutureUtils.CompletedByTimeout) {
                BoxedUnit boxedUnit;
                FutureUtils.CompletedByTimeout completedByTimeout = (FutureUtils.CompletedByTimeout)limitedByTimeoutResult;
                WithDataFreshnessStatus value = (WithDataFreshnessStatus)completedByTimeout.value();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Timeout: {} occurred during waiting for response from engine for {}", new Object[]{timeout, processIdWithName.name()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return value;
            }
            throw new MatchError((Object)limitedByTimeoutResult);
        }, ec)).getOrElse((Function0 & Serializable)() -> stateFromEngineFuture);
    }

    private DBIOAction<Option<processdetails.ProcessAction>, NoStream, Effect.All> handleFinishedProcess(processdetails.BaseProcessDetails<?> processDetails, Option<ProcessState> processState, ExecutionContext ec) {
        NussknackerInternalUser$ user = NussknackerInternalUser$.MODULE$;
        pl.touk.nussknacker.ui.listener.User listenerUser = ListenerApiUser$.MODULE$.apply((LoggedUser)user);
        return (DBIOAction)processState.filter((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DeploymentServiceImpl.$anonfun$handleFinishedProcess$1(x$19))).flatMap((Function1 & Serializable)x$20 -> processDetails.lastDeployedAction().map((Function1 & Serializable)lastDeployedAction -> {
            Comment finishedComment = DeploymentComment$.MODULE$.unsafe("Scenario finished").toComment(ProcessActionType$.MODULE$.Cancel());
            $this.processChangeListener.handle((ProcessChangeEvent)new ProcessChangeEvent.OnFinished(processDetails.processId(), lastDeployedAction.processVersionId()), ec, listenerUser);
            return $this.actionRepository.addInstantAction(processDetails.processId(), lastDeployedAction.processVersionId(), ProcessActionType$.MODULE$.Cancel(), (Option<Comment>)new Some((Object)finishedComment), (Option<String>)None$.MODULE$, (LoggedUser)user).map((Function1 & Serializable)a -> new Some((Object)ProcessDBQueryRepository$.MODULE$.toProcessAction((Tuple2<ProcessActionEntityData, Option<CommentEntityData>>)new Tuple2(a, (Object)None$.MODULE$))), ec);
        })).getOrElse((Function0 & Serializable)() -> DBIOAction$.MODULE$.successful((Object)None$.MODULE$));
    }

    @Override
    public void invalidateInProgressActions() {
        Await$.MODULE$.result(this.dbioRunner.run(this.actionRepository.deleteInProgressActions()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
    }

    private static final /* synthetic */ WithDataFreshnessStatus failedToGetResult$lzycompute$1(LazyRef failedToGetResult$lzy$1) {
        WithDataFreshnessStatus withDataFreshnessStatus;
        LazyRef lazyRef = failedToGetResult$lzy$1;
        synchronized (lazyRef) {
            withDataFreshnessStatus = failedToGetResult$lzy$1.initialized() ? (WithDataFreshnessStatus)failedToGetResult$lzy$1.value() : (WithDataFreshnessStatus)failedToGetResult$lzy$1.initialize((Object)new WithDataFreshnessStatus((Object)Option$.MODULE$.apply((Object)SimpleProcessStateDefinitionManager$.MODULE$.errorFailedToGet()), false));
        }
        return withDataFreshnessStatus;
    }

    public static final WithDataFreshnessStatus pl$touk$nussknacker$ui$process$deployment$DeploymentServiceImpl$$failedToGetResult$1(LazyRef failedToGetResult$lzy$1) {
        if (failedToGetResult$lzy$1.initialized()) {
            return (WithDataFreshnessStatus)failedToGetResult$lzy$1.value();
        }
        return DeploymentServiceImpl.failedToGetResult$lzycompute$1(failedToGetResult$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$handleFinishedProcess$1(ProcessState x$19) {
        return x$19.status().isFinished();
    }

    public DeploymentServiceImpl(DeploymentManagerDispatcher dispatcher, FetchingProcessRepository<DBIOAction> processRepository, DbProcessActionRepository<DBIOAction> actionRepository, DBIOActionRunner dbioRunner, ProcessValidation processValidation, ScenarioResolver scenarioResolver, ProcessChangeListener processChangeListener, Option<FiniteDuration> scenarioStateTimeout, Clock clock, ActorSystem system) {
        this.dispatcher = dispatcher;
        this.processRepository = processRepository;
        this.actionRepository = actionRepository;
        this.dbioRunner = dbioRunner;
        this.processValidation = processValidation;
        this.scenarioResolver = scenarioResolver;
        this.processChangeListener = processChangeListener;
        this.scenarioStateTimeout = scenarioStateTimeout;
        this.clock = clock;
        this.system = system;
        LazyLogging.$init$((LazyLogging)this);
    }
}

