/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.component;

import cats.data.Validated;
import com.typesafe.config.Config;
import java.io.Serializable;
import pl.touk.nussknacker.engine.ProcessingTypeData;
import pl.touk.nussknacker.engine.api.component.ComponentId;
import pl.touk.nussknacker.engine.api.component.SingleComponentConfig;
import pl.touk.nussknacker.restmodel.definition.package;
import pl.touk.nussknacker.ui.component.Component;
import pl.touk.nussknacker.ui.component.ComponentConfigurationException;
import pl.touk.nussknacker.ui.component.ComponentIdProvider;
import pl.touk.nussknacker.ui.component.ComponentWrongConfiguration;
import pl.touk.nussknacker.ui.component.DefaultComponentIdProvider;
import pl.touk.nussknacker.ui.component.DefaultComponentService;
import pl.touk.nussknacker.ui.component.DefaultsComponentIcon$;
import pl.touk.nussknacker.ui.component.WrongConfigurationAttribute$;
import pl.touk.nussknacker.ui.definition.UIProcessObjectsFactory$;
import pl.touk.nussknacker.ui.process.ProcessCategoryService;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.processingtypedata.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.process.subprocess.SubprocessDetails;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.security.api.NussknackerInternalUser$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.runtime.ScalaRunTime$;

public final class DefaultComponentService$ {
    public static final DefaultComponentService$ MODULE$ = new DefaultComponentService$();

    public DefaultComponentService apply(Config config, ProcessingTypeDataProvider<ProcessingTypeData> processingTypeDataProvider, ProcessService processService, ProcessCategoryService categoryService, ExecutionContext ec) {
        Validated<List<ComponentWrongConfiguration<?>>, ComponentIdProvider> componentIdProvider = this.prepareComponentProvider(processingTypeDataProvider, categoryService, ec);
        return (DefaultComponentService)componentIdProvider.map((Function1 & Serializable)x$1 -> new DefaultComponentService(config, processingTypeDataProvider, processService, categoryService, (ComponentIdProvider)x$1, ec)).valueOr((Function1 & Serializable)wrongConfigurations -> {
            throw new ComponentConfigurationException("Wrong configured components were found.", (List<ComponentWrongConfiguration<?>>)wrongConfigurations);
        });
    }

    private Validated<List<ComponentWrongConfiguration<?>>, ComponentIdProvider> prepareComponentProvider(ProcessingTypeDataProvider<ProcessingTypeData> processingTypeDataProvider, ProcessCategoryService categoryService, ExecutionContext ec) {
        List data = processingTypeDataProvider.all().toList().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String processingType = (String)tuple2._1();
                ProcessingTypeData processingTypeData = (ProcessingTypeData)tuple2._2();
                return MODULE$.extractFromProcessingType(processingTypeData, processingType, categoryService, ec);
            }
            throw new MatchError((Object)tuple2);
        });
        List wrongComponents = ((IterableOnceOps)data.flatMap((Function1 & Serializable)x$2 -> x$2.components()).groupBy((Function1 & Serializable)x$3 -> new ComponentId(x$3.id())).flatMap((Function1 & Serializable)x0$2 -> {
            .colon.colon colon2;
            List list;
            List list2;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null && (list2 = (List)tuple2._2()) instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).next$access$1())) {
                return Nil$.MODULE$;
            }
            if (tuple2 != null) {
                String componentId = ((ComponentId)tuple2._1()).value();
                List components = (List)tuple2._2();
                return MODULE$.computeWrongConfigurations(componentId, (Iterable<Component>)components);
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        if (wrongComponents.nonEmpty()) {
            return new Validated.Invalid((Object)wrongComponents);
        }
        return new Validated.Valid((Object)new DefaultComponentIdProvider((Map<String, Map<String, SingleComponentConfig>>)data.map((Function1 & Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.processingType()), d.componentsUiConfig())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    private DefaultComponentService.ExtractedData extractFromProcessingType(ProcessingTypeData processingTypeData, String processingType, ProcessCategoryService categoryService, ExecutionContext ec) {
        package.UIProcessObjects uiProcessObjects = UIProcessObjectsFactory$.MODULE$.prepareUIProcessObjects(processingTypeData.modelData(), processingTypeData.deploymentManager(), processingTypeData.typeSpecificInitialData(), (LoggedUser)NussknackerInternalUser$.MODULE$, (Set<SubprocessDetails>)Predef$.MODULE$.Set().empty(), false, categoryService, processingTypeData.additionalPropertiesConfig(), processingType);
        Map componentsUiConfig = uiProcessObjects.componentsConfig();
        DefaultComponentIdProvider componentIdProvider = new DefaultComponentIdProvider((Map<String, Map<String, SingleComponentConfig>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)processingType), (Object)componentsUiConfig)}))));
        List components = uiProcessObjects.componentGroups().flatMap((Function1 & Serializable)group -> group.components().map((Function1 & Serializable)com -> {
            String componentId = componentIdProvider.createComponentId(processingType, com.label(), com.type());
            String icon = MODULE$.pl$touk$nussknacker$ui$component$DefaultComponentService$$getComponentIcon((Map<String, SingleComponentConfig>)componentsUiConfig, (package.ComponentTemplate)com);
            return new Component(componentId, com.label(), icon, com.type(), group.name());
        }));
        return new DefaultComponentService.ExtractedData(processingType, (Map<String, SingleComponentConfig>)componentsUiConfig, (List<Component>)components);
    }

    public String pl$touk$nussknacker$ui$component$DefaultComponentService$$getComponentIcon(Map<String, SingleComponentConfig> componentsUiConfig, package.ComponentTemplate com) {
        return (String)this.componentConfig(componentsUiConfig, com).flatMap((Function1 & Serializable)x$4 -> x$4.icon()).getOrElse((Function0 & Serializable)() -> DefaultsComponentIcon$.MODULE$.fromComponentType(com.type()));
    }

    public Option<String> pl$touk$nussknacker$ui$component$DefaultComponentService$$getComponentDoc(Map<String, SingleComponentConfig> componentsUiConfig, package.ComponentTemplate com) {
        return this.componentConfig(componentsUiConfig, com).flatMap((Function1 & Serializable)x$5 -> x$5.docsUrl());
    }

    private Option<SingleComponentConfig> componentConfig(Map<String, SingleComponentConfig> componentsUiConfig, package.ComponentTemplate com) {
        return componentsUiConfig.get((Object)com.label());
    }

    private List<ComponentWrongConfiguration<?>> computeWrongConfigurations(String componentId, Iterable<Component> components) {
        Option wrongConfiguredNames = DefaultComponentService$.discoverWrongConfiguration$1(WrongConfigurationAttribute$.MODULE$.NameAttribute(), (Iterable)components.map((Function1 & Serializable)x$6 -> x$6.name()), componentId);
        Option wrongConfiguredIcons = DefaultComponentService$.discoverWrongConfiguration$1(WrongConfigurationAttribute$.MODULE$.IconAttribute(), (Iterable)components.map((Function1 & Serializable)x$7 -> x$7.icon()), componentId);
        Option wrongConfiguredGroups = DefaultComponentService$.discoverWrongConfiguration$1(WrongConfigurationAttribute$.MODULE$.ComponentGroupNameAttribute(), (Iterable)components.map((Function1 & Serializable)x$8 -> x$8.componentGroupName()), componentId);
        Option wrongConfiguredTypes = DefaultComponentService$.discoverWrongConfiguration$1(WrongConfigurationAttribute$.MODULE$.ComponentTypeAttribute(), (Iterable)components.map((Function1 & Serializable)x$9 -> x$9.componentType()), componentId);
        Iterable wrongConfigurations = (Iterable)((IterableOps)((IterableOps)Option$.MODULE$.option2Iterable(wrongConfiguredNames).$plus$plus((IterableOnce)wrongConfiguredTypes)).$plus$plus((IterableOnce)wrongConfiguredGroups)).$plus$plus((IterableOnce)wrongConfiguredIcons);
        return wrongConfigurations.toList();
    }

    private static final Option discoverWrongConfiguration$1(Enumeration.Value attribute, Iterable elements, String componentId$1) {
        .colon.colon colon2;
        List list;
        List list2 = (List)elements.toList().distinct();
        if (list2 instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).next$access$1())) {
            return None$.MODULE$;
        }
        return new Some(new ComponentWrongConfiguration(componentId$1, attribute, list2));
    }

    private DefaultComponentService$() {
    }
}

