/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBState;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.state.internal.InternalAppendingState;
import org.apache.flink.util.FlinkRuntimeException;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

abstract class AbstractRocksDBAppendingState<K, N, IN, SV, OUT, S extends State>
extends AbstractRocksDBState<K, N, SV, S>
implements InternalAppendingState<K, N, IN, SV, OUT> {
    protected AbstractRocksDBAppendingState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<SV> valueSerializer, SV defaultValue, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
    }

    public SV getInternal() {
        return this.getInternal(this.getKeyBytes());
    }

    SV getInternal(byte[] key) {
        try {
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            if (valueBytes == null) {
                return null;
            }
            return (SV)this.valueSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStreamWithPos(valueBytes)));
        }
        catch (IOException | RocksDBException e) {
            throw new FlinkRuntimeException("Error while retrieving data from RocksDB", (Throwable)e);
        }
    }

    public void updateInternal(SV valueToStore) {
        this.updateInternal(this.getKeyBytes(), valueToStore);
    }

    void updateInternal(byte[] key, SV valueToStore) {
        try {
            this.backend.db.put(this.columnFamily, this.writeOptions, key, this.getValueBytes(valueToStore));
        }
        catch (RocksDBException e) {
            throw new FlinkRuntimeException("Error while adding value to RocksDB", (Throwable)e);
        }
    }
}

