/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.InputStream;
import java.util.Collection;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBAppendingState;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.util.FlinkRuntimeException;
import org.rocksdb.ColumnFamilyHandle;

class RocksDBAggregatingState<K, N, T, ACC, R>
extends AbstractRocksDBAppendingState<K, N, T, ACC, R, AggregatingState<T, R>>
implements InternalAggregatingState<K, N, T, ACC, R> {
    private final AggregateFunction<T, ACC, R> aggFunction;

    private RocksDBAggregatingState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<ACC> valueSerializer, ACC defaultValue, AggregateFunction<T, ACC, R> aggFunction, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
        this.aggFunction = aggFunction;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.backend.getKeySerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<ACC> getValueSerializer() {
        return this.valueSerializer;
    }

    public R get() {
        Object accumulator = this.getInternal();
        if (accumulator == null) {
            return null;
        }
        return (R)this.aggFunction.getResult(accumulator);
    }

    public void add(T value2) {
        byte[] key = this.getKeyBytes();
        Object accumulator = this.getInternal(key);
        accumulator = accumulator == null ? this.aggFunction.createAccumulator() : accumulator;
        this.updateInternal(key, this.aggFunction.add(value2, accumulator));
    }

    public void mergeNamespaces(N target, Collection<N> sources2) {
        if (sources2 == null || sources2.isEmpty()) {
            return;
        }
        Object key = this.backend.getCurrentKey();
        int keyGroup = this.backend.getCurrentKeyGroupIndex();
        try {
            Object current = null;
            for (N source2 : sources2) {
                if (source2 == null) continue;
                this.writeKeyWithGroupAndNamespace(keyGroup, key, source2, this.keySerializationStream, this.keySerializationDataOutputView);
                byte[] sourceKey = this.keySerializationStream.toByteArray();
                byte[] valueBytes = this.backend.db.get(this.columnFamily, sourceKey);
                this.backend.db.delete(this.columnFamily, this.writeOptions, sourceKey);
                if (valueBytes == null) continue;
                Object value2 = this.valueSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStreamWithPos(valueBytes)));
                if (current != null) {
                    current = this.aggFunction.merge(current, value2);
                    continue;
                }
                current = value2;
            }
            if (current != null) {
                this.writeKeyWithGroupAndNamespace(keyGroup, key, target, this.keySerializationStream, this.keySerializationDataOutputView);
                byte[] targetKey = this.keySerializationStream.toByteArray();
                byte[] targetValueBytes = this.backend.db.get(this.columnFamily, targetKey);
                if (targetValueBytes != null) {
                    Object value3 = this.valueSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStreamWithPos(targetValueBytes)));
                    current = this.aggFunction.merge(current, value3);
                }
                this.keySerializationStream.reset();
                this.valueSerializer.serialize(current, this.keySerializationDataOutputView);
                this.backend.db.put(this.columnFamily, this.writeOptions, targetKey, this.keySerializationStream.toByteArray());
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Error while merging state in RocksDB", (Throwable)e);
        }
    }

    static <K, N, SV, S extends State, IS extends S> IS create(StateDescriptor<S, SV> stateDesc, Tuple2<ColumnFamilyHandle, RegisteredKeyValueStateBackendMetaInfo<N, SV>> registerResult, RocksDBKeyedStateBackend<K> backend) {
        return (IS)new RocksDBAggregatingState((ColumnFamilyHandle)registerResult.f0, ((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getNamespaceSerializer(), ((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getStateSerializer(), stateDesc.getDefaultValue(), ((AggregatingStateDescriptor)stateDesc).getAggregateFunction(), backend);
    }
}

