/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

class RocksDBKeySerializationUtils {
    RocksDBKeySerializationUtils() {
    }

    static int readKeyGroup(int keyGroupPrefixBytes, DataInputView inputView) throws IOException {
        int keyGroup = 0;
        for (int i = 0; i < keyGroupPrefixBytes; ++i) {
            keyGroup <<= 8;
            keyGroup |= inputView.readByte() & 0xFF;
        }
        return keyGroup;
    }

    public static <K> K readKey(TypeSerializer<K> keySerializer, ByteArrayInputStreamWithPos inputStream, DataInputView inputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeRead = inputStream.getPosition();
        Object key = keySerializer.deserialize(inputView);
        if (ambiguousKeyPossible) {
            int length = inputStream.getPosition() - beforeRead;
            RocksDBKeySerializationUtils.readVariableIntBytes(inputView, length);
        }
        return (K)key;
    }

    public static <N> N readNamespace(TypeSerializer<N> namespaceSerializer, ByteArrayInputStreamWithPos inputStream, DataInputView inputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeRead = inputStream.getPosition();
        Object namespace = namespaceSerializer.deserialize(inputView);
        if (ambiguousKeyPossible) {
            int length = inputStream.getPosition() - beforeRead;
            RocksDBKeySerializationUtils.readVariableIntBytes(inputView, length);
        }
        return (N)namespace;
    }

    public static <N> void writeNameSpace(N namespace, TypeSerializer<N> namespaceSerializer, ByteArrayOutputStreamWithPos keySerializationStream, DataOutputView keySerializationDataOutputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeWrite = keySerializationStream.getPosition();
        namespaceSerializer.serialize(namespace, keySerializationDataOutputView);
        if (ambiguousKeyPossible) {
            RocksDBKeySerializationUtils.writeLengthFrom(beforeWrite, keySerializationStream, keySerializationDataOutputView);
        }
    }

    public static boolean isAmbiguousKeyPossible(TypeSerializer keySerializer, TypeSerializer namespaceSerializer) {
        return keySerializer.getLength() < 0 && namespaceSerializer.getLength() < 0;
    }

    public static void writeKeyGroup(int keyGroup, int keyGroupPrefixBytes, DataOutputView keySerializationDateDataOutputView) throws IOException {
        int i = keyGroupPrefixBytes;
        while (--i >= 0) {
            keySerializationDateDataOutputView.writeByte((int)RocksDBKeySerializationUtils.extractByteAtPosition(keyGroup, i));
        }
    }

    public static <K> void writeKey(K key, TypeSerializer<K> keySerializer, ByteArrayOutputStreamWithPos keySerializationStream, DataOutputView keySerializationDataOutputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeWrite = keySerializationStream.getPosition();
        keySerializer.serialize(key, keySerializationDataOutputView);
        if (ambiguousKeyPossible) {
            RocksDBKeySerializationUtils.writeLengthFrom(beforeWrite, keySerializationStream, keySerializationDataOutputView);
        }
    }

    private static void readVariableIntBytes(DataInputView inputView, int value2) throws IOException {
        do {
            inputView.readByte();
        } while ((value2 >>>= 8) != 0);
    }

    private static void writeLengthFrom(int fromPosition, ByteArrayOutputStreamWithPos keySerializationStream, DataOutputView keySerializationDateDataOutputView) throws IOException {
        int length = keySerializationStream.getPosition() - fromPosition;
        RocksDBKeySerializationUtils.writeVariableIntBytes(length, keySerializationDateDataOutputView);
    }

    private static void writeVariableIntBytes(int value2, DataOutputView keySerializationDateDataOutputView) throws IOException {
        do {
            keySerializationDateDataOutputView.writeByte(value2);
        } while ((value2 >>>= 8) != 0);
    }

    public static void serializeKeyGroup(int keyGroup, byte[] startKeyGroupPrefixBytes) {
        int keyGroupPrefixBytes = startKeyGroupPrefixBytes.length;
        for (int j = 0; j < keyGroupPrefixBytes; ++j) {
            startKeyGroupPrefixBytes[j] = RocksDBKeySerializationUtils.extractByteAtPosition(keyGroup, keyGroupPrefixBytes - j - 1);
        }
    }

    private static byte extractByteAtPosition(int value2, int byteIdx) {
        return (byte)(value2 >>> (byteIdx << 3));
    }

    public static int computeRequiredBytesInKeyGroupPrefix(int totalKeyGroupsInJob) {
        return totalKeyGroupsInJob > 128 ? 2 : 1;
    }
}

