/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDBWriteBatchWrapper
implements AutoCloseable {
    private static final int MIN_CAPACITY = 100;
    private static final int MAX_CAPACITY = 1000;
    private static final int PER_RECORD_BYTES = 100;
    private final RocksDB db;
    private final WriteBatch batch;
    private final WriteOptions options;
    private final int capacity;

    public RocksDBWriteBatchWrapper(@Nonnull RocksDB rocksDB) {
        this(rocksDB, null, 500);
    }

    public RocksDBWriteBatchWrapper(@Nonnull RocksDB rocksDB, @Nullable WriteOptions options) {
        this(rocksDB, options, 500);
    }

    public RocksDBWriteBatchWrapper(@Nonnull RocksDB rocksDB, @Nullable WriteOptions options, int capacity) {
        Preconditions.checkArgument((capacity >= 100 && capacity <= 1000 ? 1 : 0) != 0, (Object)"capacity should be between 100 and 1000");
        this.db = rocksDB;
        this.options = options;
        this.capacity = capacity;
        this.batch = new WriteBatch(this.capacity * 100);
    }

    public void put(@Nonnull ColumnFamilyHandle handle2, @Nonnull byte[] key, @Nonnull byte[] value2) throws RocksDBException {
        this.batch.put(handle2, key, value2);
        if (this.batch.count() == this.capacity) {
            this.flush();
        }
    }

    public void remove(@Nonnull ColumnFamilyHandle handle2, @Nonnull byte[] key) throws RocksDBException {
        this.batch.remove(handle2, key);
        if (this.batch.count() == this.capacity) {
            this.flush();
        }
    }

    public void flush() throws RocksDBException {
        if (this.options != null) {
            this.db.write(this.options, this.batch);
        } else {
            try (WriteOptions writeOptions = new WriteOptions();){
                this.db.write(writeOptions, this.batch);
            }
        }
        this.batch.clear();
    }

    public WriteOptions getOptions() {
        return this.options;
    }

    @Override
    public void close() throws RocksDBException {
        if (this.batch.count() != 0) {
            this.flush();
        }
        IOUtils.closeQuietly((AutoCloseable)this.batch);
    }
}

