/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internals;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionAssigner;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicsDescriptor;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractPartitionDiscoverer {
    private final KafkaTopicsDescriptor topicsDescriptor;
    private final int indexOfThisSubtask;
    private final int numParallelSubtasks;
    private volatile boolean closed = true;
    private volatile boolean wakeup;
    private Set<KafkaTopicPartition> discoveredPartitions;

    public AbstractPartitionDiscoverer(KafkaTopicsDescriptor topicsDescriptor, int indexOfThisSubtask, int numParallelSubtasks) {
        this.topicsDescriptor = (KafkaTopicsDescriptor)Preconditions.checkNotNull((Object)topicsDescriptor);
        this.indexOfThisSubtask = indexOfThisSubtask;
        this.numParallelSubtasks = numParallelSubtasks;
        this.discoveredPartitions = new HashSet<KafkaTopicPartition>();
    }

    public void open() throws Exception {
        this.closed = false;
        this.initializeConnections();
    }

    public void close() throws Exception {
        this.closed = true;
        this.closeConnections();
    }

    public void wakeup() {
        this.wakeup = true;
        this.wakeupConnections();
    }

    public List<KafkaTopicPartition> discoverPartitions() throws WakeupException, ClosedException {
        if (!this.closed && !this.wakeup) {
            try {
                List<KafkaTopicPartition> newDiscoveredPartitions;
                if (this.topicsDescriptor.isFixedTopics()) {
                    newDiscoveredPartitions = this.getAllPartitionsForTopics(this.topicsDescriptor.getFixedTopics());
                } else {
                    List<String> matchedTopics = this.getAllTopics();
                    Iterator<String> iter2 = matchedTopics.iterator();
                    while (iter2.hasNext()) {
                        if (this.topicsDescriptor.getTopicPattern().matcher(iter2.next()).matches()) continue;
                        iter2.remove();
                    }
                    newDiscoveredPartitions = matchedTopics.size() != 0 ? this.getAllPartitionsForTopics(matchedTopics) : null;
                }
                if (newDiscoveredPartitions == null || newDiscoveredPartitions.isEmpty()) {
                    throw new RuntimeException("Unable to retrieve any partitions with KafkaTopicsDescriptor: " + this.topicsDescriptor);
                }
                Iterator<KafkaTopicPartition> iter3 = newDiscoveredPartitions.iterator();
                while (iter3.hasNext()) {
                    KafkaTopicPartition nextPartition = iter3.next();
                    if (this.setAndCheckDiscoveredPartition(nextPartition)) continue;
                    iter3.remove();
                }
                return newDiscoveredPartitions;
            }
            catch (WakeupException e) {
                this.wakeup = false;
                throw e;
            }
        }
        if (!this.closed && this.wakeup) {
            this.wakeup = false;
            throw new WakeupException();
        }
        throw new ClosedException();
    }

    public boolean setAndCheckDiscoveredPartition(KafkaTopicPartition partition2) {
        if (this.isUndiscoveredPartition(partition2)) {
            this.discoveredPartitions.add(partition2);
            return KafkaTopicPartitionAssigner.assign(partition2, this.numParallelSubtasks) == this.indexOfThisSubtask;
        }
        return false;
    }

    protected abstract void initializeConnections() throws Exception;

    protected abstract void wakeupConnections();

    protected abstract void closeConnections() throws Exception;

    protected abstract List<String> getAllTopics() throws WakeupException;

    protected abstract List<KafkaTopicPartition> getAllPartitionsForTopics(List<String> var1) throws WakeupException;

    private boolean isUndiscoveredPartition(KafkaTopicPartition partition2) {
        return !this.discoveredPartitions.contains(partition2);
    }

    public static final class ClosedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static final class WakeupException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

