/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.streaming.util.serialization.KeyedDeserializationSchema;

@PublicEvolving
public class JSONKeyValueDeserializationSchema
implements KeyedDeserializationSchema<ObjectNode> {
    private static final long serialVersionUID = 1509391548173891955L;
    private final boolean includeMetadata;
    private ObjectMapper mapper;

    public JSONKeyValueDeserializationSchema(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    @Override
    public ObjectNode deserialize(byte[] messageKey, byte[] message2, String topic, int partition2, long offset) throws IOException {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        ObjectNode node2 = this.mapper.createObjectNode();
        if (messageKey != null) {
            node2.set("key", (JsonNode)this.mapper.readValue(messageKey, JsonNode.class));
        }
        if (message2 != null) {
            node2.set("value", (JsonNode)this.mapper.readValue(message2, JsonNode.class));
        }
        if (this.includeMetadata) {
            node2.putObject("metadata").put("offset", offset).put("topic", topic).put("partition", partition2);
        }
        return node2;
    }

    @Override
    public boolean isEndOfStream(ObjectNode nextElement) {
        return false;
    }

    public TypeInformation<ObjectNode> getProducedType() {
        return TypeExtractor.getForClass(ObjectNode.class);
    }
}

