/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;

public class MockConsumer<K, V>
implements Consumer<K, V> {
    private final Map<String, List<PartitionInfo>> partitions;
    private final SubscriptionState subscriptions;
    private Map<TopicPartition, List<ConsumerRecord<K, V>>> records;
    private Set<TopicPartition> paused;
    private boolean closed;
    private final Map<TopicPartition, Long> beginningOffsets;
    private final Map<TopicPartition, Long> endOffsets;
    private Queue<Runnable> pollTasks;
    private KafkaException exception;
    private AtomicBoolean wakeup;

    public MockConsumer(OffsetResetStrategy offsetResetStrategy) {
        this.subscriptions = new SubscriptionState(offsetResetStrategy);
        this.partitions = new HashMap<String, List<PartitionInfo>>();
        this.records = new HashMap<TopicPartition, List<ConsumerRecord<K, V>>>();
        this.paused = new HashSet<TopicPartition>();
        this.closed = false;
        this.beginningOffsets = new HashMap<TopicPartition, Long>();
        this.endOffsets = new HashMap<TopicPartition, Long>();
        this.pollTasks = new LinkedList<Runnable>();
        this.exception = null;
        this.wakeup = new AtomicBoolean(false);
    }

    @Override
    public synchronized Set<TopicPartition> assignment() {
        return this.subscriptions.assignedPartitions();
    }

    public synchronized void rebalance(Collection<TopicPartition> newAssignment) {
        this.records.clear();
        this.subscriptions.assignFromSubscribed(newAssignment);
    }

    @Override
    public synchronized Set<String> subscription() {
        return this.subscriptions.subscription();
    }

    @Override
    public synchronized void subscribe(Collection<String> topics) {
        this.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    @Override
    public synchronized void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        this.ensureNotClosed();
        this.subscriptions.subscribe(pattern, listener);
        HashSet<String> topicsToSubscribe = new HashSet<String>();
        for (String topic : this.partitions.keySet()) {
            if (!pattern.matcher(topic).matches() || this.subscriptions.subscription().contains(topic)) continue;
            topicsToSubscribe.add(topic);
        }
        this.ensureNotClosed();
        this.subscriptions.subscribeFromPattern(topicsToSubscribe);
    }

    @Override
    public synchronized void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        this.ensureNotClosed();
        this.subscriptions.subscribe(new HashSet<String>(topics), listener);
    }

    @Override
    public synchronized void assign(Collection<TopicPartition> partitions) {
        this.ensureNotClosed();
        this.subscriptions.assignFromUser(new HashSet<TopicPartition>(partitions));
    }

    @Override
    public synchronized void unsubscribe() {
        this.ensureNotClosed();
        this.subscriptions.unsubscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ConsumerRecords<K, V> poll(long timeout) {
        this.ensureNotClosed();
        Queue<Runnable> queue = this.pollTasks;
        synchronized (queue) {
            Runnable task = this.pollTasks.poll();
            if (task != null) {
                task.run();
            }
        }
        if (this.wakeup.get()) {
            this.wakeup.set(false);
            throw new WakeupException();
        }
        if (this.exception != null) {
            KafkaException exception = this.exception;
            this.exception = null;
            throw exception;
        }
        for (TopicPartition tp : this.subscriptions.missingFetchPositions()) {
            this.updateFetchPosition(tp);
        }
        HashMap results = new HashMap();
        for (TopicPartition topicPartition : this.records.keySet()) {
            results.put(topicPartition, new ArrayList());
        }
        for (Map.Entry entry : this.records.entrySet()) {
            if (this.subscriptions.isPaused((TopicPartition)entry.getKey())) continue;
            List recs = (List)entry.getValue();
            for (ConsumerRecord rec : recs) {
                if (!this.assignment().contains(entry.getKey()) || rec.offset() < this.subscriptions.position((TopicPartition)entry.getKey())) continue;
                ((List)results.get(entry.getKey())).add(rec);
                this.subscriptions.position((TopicPartition)entry.getKey(), rec.offset() + 1L);
            }
        }
        this.records.clear();
        return new ConsumerRecords(results);
    }

    public synchronized void addRecord(ConsumerRecord<K, V> record2) {
        this.ensureNotClosed();
        TopicPartition tp = new TopicPartition(record2.topic(), record2.partition());
        HashSet<TopicPartition> currentAssigned = new HashSet<TopicPartition>(this.subscriptions.assignedPartitions());
        if (!currentAssigned.contains(tp)) {
            throw new IllegalStateException("Cannot add records for a partition that is not assigned to the consumer");
        }
        List<ConsumerRecord<K, V>> recs = this.records.get(tp);
        if (recs == null) {
            recs = new ArrayList<ConsumerRecord<K, V>>();
            this.records.put(tp, recs);
        }
        recs.add(record2);
    }

    public synchronized void setException(KafkaException exception) {
        this.exception = exception;
    }

    @Override
    public synchronized void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.ensureNotClosed();
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            this.subscriptions.committed(entry.getKey(), entry.getValue());
        }
        if (callback != null) {
            callback.onComplete(offsets, null);
        }
    }

    @Override
    public synchronized void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.commitAsync(offsets, null);
    }

    @Override
    public synchronized void commitAsync() {
        this.commitAsync(null);
    }

    @Override
    public synchronized void commitAsync(OffsetCommitCallback callback) {
        this.ensureNotClosed();
        this.commitAsync(this.subscriptions.allConsumed(), callback);
    }

    @Override
    public synchronized void commitSync() {
        this.commitSync(this.subscriptions.allConsumed());
    }

    @Override
    public synchronized void seek(TopicPartition partition2, long offset) {
        this.ensureNotClosed();
        this.subscriptions.seek(partition2, offset);
    }

    @Override
    public synchronized OffsetAndMetadata committed(TopicPartition partition2) {
        this.ensureNotClosed();
        if (this.subscriptions.isAssigned(partition2)) {
            return this.subscriptions.committed(partition2);
        }
        return new OffsetAndMetadata(0L);
    }

    @Override
    public synchronized long position(TopicPartition partition2) {
        this.ensureNotClosed();
        if (!this.subscriptions.isAssigned(partition2)) {
            throw new IllegalArgumentException("You can only check the position for partitions assigned to this consumer.");
        }
        Long offset = this.subscriptions.position(partition2);
        if (offset == null) {
            this.updateFetchPosition(partition2);
            offset = this.subscriptions.position(partition2);
        }
        return offset;
    }

    @Override
    public synchronized void seekToBeginning(Collection<TopicPartition> partitions) {
        this.ensureNotClosed();
        for (TopicPartition tp : partitions) {
            this.subscriptions.needOffsetReset(tp, OffsetResetStrategy.EARLIEST);
        }
    }

    public synchronized void updateBeginningOffsets(Map<TopicPartition, Long> newOffsets) {
        this.beginningOffsets.putAll(newOffsets);
    }

    @Override
    public synchronized void seekToEnd(Collection<TopicPartition> partitions) {
        this.ensureNotClosed();
        for (TopicPartition tp : partitions) {
            this.subscriptions.needOffsetReset(tp, OffsetResetStrategy.LATEST);
        }
    }

    public synchronized void updateEndOffsets(Map<TopicPartition, Long> newOffsets) {
        this.endOffsets.putAll(newOffsets);
    }

    @Override
    public synchronized Map<MetricName, ? extends Metric> metrics() {
        this.ensureNotClosed();
        return Collections.emptyMap();
    }

    @Override
    public synchronized List<PartitionInfo> partitionsFor(String topic) {
        this.ensureNotClosed();
        return this.partitions.get(topic);
    }

    @Override
    public synchronized Map<String, List<PartitionInfo>> listTopics() {
        this.ensureNotClosed();
        return this.partitions;
    }

    public synchronized void updatePartitions(String topic, List<PartitionInfo> partitions) {
        this.ensureNotClosed();
        this.partitions.put(topic, partitions);
    }

    @Override
    public synchronized void pause(Collection<TopicPartition> partitions) {
        for (TopicPartition partition2 : partitions) {
            this.subscriptions.pause(partition2);
            this.paused.add(partition2);
        }
    }

    @Override
    public synchronized void resume(Collection<TopicPartition> partitions) {
        for (TopicPartition partition2 : partitions) {
            this.subscriptions.resume(partition2);
            this.paused.remove(partition2);
        }
    }

    @Override
    public synchronized Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public synchronized Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        HashMap<TopicPartition, Long> result2 = new HashMap<TopicPartition, Long>();
        for (TopicPartition tp : partitions) {
            Long beginningOffset = this.beginningOffsets.get(tp);
            if (beginningOffset == null) {
                throw new IllegalStateException("The partition " + tp + " does not have a beginning offset.");
            }
            result2.put(tp, beginningOffset);
        }
        return result2;
    }

    @Override
    public synchronized Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        HashMap<TopicPartition, Long> result2 = new HashMap<TopicPartition, Long>();
        for (TopicPartition tp : partitions) {
            Long endOffset = this.endOffsets.get(tp);
            if (endOffset == null) {
                throw new IllegalStateException("The partition " + tp + " does not have an end offset.");
            }
            result2.put(tp, endOffset);
        }
        return result2;
    }

    @Override
    public synchronized void close() {
        this.close(30000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void close(long timeout, TimeUnit unit2) {
        this.ensureNotClosed();
        this.closed = true;
    }

    public synchronized boolean closed() {
        return this.closed;
    }

    @Override
    public synchronized void wakeup() {
        this.wakeup.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void schedulePollTask(Runnable task) {
        Queue<Runnable> queue = this.pollTasks;
        synchronized (queue) {
            this.pollTasks.add(task);
        }
    }

    public synchronized void scheduleNopPollTask() {
        this.schedulePollTask(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public synchronized Set<TopicPartition> paused() {
        return Collections.unmodifiableSet(new HashSet<TopicPartition>(this.paused));
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("This consumer has already been closed.");
        }
    }

    private void updateFetchPosition(TopicPartition tp) {
        if (this.subscriptions.isOffsetResetNeeded(tp)) {
            this.resetOffsetPosition(tp);
        } else if (this.subscriptions.committed(tp) == null) {
            this.subscriptions.needOffsetReset(tp);
            this.resetOffsetPosition(tp);
        } else {
            this.subscriptions.seek(tp, this.subscriptions.committed(tp).offset());
        }
    }

    private void resetOffsetPosition(TopicPartition tp) {
        Long offset;
        OffsetResetStrategy strategy = this.subscriptions.resetStrategy(tp);
        if (strategy == OffsetResetStrategy.EARLIEST) {
            offset = this.beginningOffsets.get(tp);
            if (offset == null) {
                throw new IllegalStateException("MockConsumer didn't have beginning offset specified, but tried to seek to beginning");
            }
        } else if (strategy == OffsetResetStrategy.LATEST) {
            offset = this.endOffsets.get(tp);
            if (offset == null) {
                throw new IllegalStateException("MockConsumer didn't have end offset specified, but tried to seek to end");
            }
        } else {
            throw new NoOffsetForPartitionException(tp);
        }
        this.seek(tp, offset);
    }
}

