/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.serialization.ExtendedSerializer;
import org.apache.kafka.common.serialization.Serializer;

public class MockProducer<K, V>
implements Producer<K, V> {
    private final Cluster cluster;
    private final Partitioner partitioner;
    private final List<ProducerRecord<K, V>> sent;
    private final List<ProducerRecord<K, V>> uncommittedSends;
    private final Deque<Completion> completions;
    private final Map<TopicPartition, Long> offsets;
    private final List<Map<String, Map<TopicPartition, OffsetAndMetadata>>> consumerGroupOffsets;
    private Map<String, Map<TopicPartition, OffsetAndMetadata>> uncommittedConsumerGroupOffsets;
    private final ExtendedSerializer<K> keySerializer;
    private final ExtendedSerializer<V> valueSerializer;
    private boolean autoComplete;
    private boolean closed;
    private boolean transactionInitialized;
    private boolean transactionInFlight;
    private boolean transactionCommitted;
    private boolean transactionAborted;
    private boolean producerFenced;
    private boolean sentOffsets;
    private long commitCount = 0L;

    public MockProducer(Cluster cluster, boolean autoComplete, Partitioner partitioner, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.cluster = cluster;
        this.autoComplete = autoComplete;
        this.partitioner = partitioner;
        this.keySerializer = ExtendedSerializer.Wrapper.ensureExtended(keySerializer);
        this.valueSerializer = ExtendedSerializer.Wrapper.ensureExtended(valueSerializer);
        this.offsets = new HashMap<TopicPartition, Long>();
        this.sent = new ArrayList<ProducerRecord<K, V>>();
        this.uncommittedSends = new ArrayList<ProducerRecord<K, V>>();
        this.consumerGroupOffsets = new ArrayList<Map<String, Map<TopicPartition, OffsetAndMetadata>>>();
        this.uncommittedConsumerGroupOffsets = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
        this.completions = new ArrayDeque<Completion>();
    }

    public MockProducer(boolean autoComplete, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(Cluster.empty(), autoComplete, new DefaultPartitioner(), keySerializer, valueSerializer);
    }

    public MockProducer(boolean autoComplete, Partitioner partitioner, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(Cluster.empty(), autoComplete, partitioner, keySerializer, valueSerializer);
    }

    public MockProducer() {
        this(Cluster.empty(), false, null, null, null);
    }

    @Override
    public void initTransactions() {
        this.verifyProducerState();
        if (this.transactionInitialized) {
            throw new IllegalStateException("MockProducer has already been initialized for transactions.");
        }
        this.transactionInitialized = true;
    }

    @Override
    public void beginTransaction() throws ProducerFencedException {
        this.verifyProducerState();
        this.verifyTransactionsInitialized();
        this.transactionInFlight = true;
        this.transactionCommitted = false;
        this.transactionAborted = false;
        this.sentOffsets = false;
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
        this.verifyProducerState();
        this.verifyTransactionsInitialized();
        this.verifyNoTransactionInFlight();
        Objects.requireNonNull(consumerGroupId);
        if (offsets.size() == 0) {
            return;
        }
        Map<TopicPartition, OffsetAndMetadata> uncommittedOffsets = this.uncommittedConsumerGroupOffsets.get(consumerGroupId);
        if (uncommittedOffsets == null) {
            uncommittedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            this.uncommittedConsumerGroupOffsets.put(consumerGroupId, uncommittedOffsets);
        }
        uncommittedOffsets.putAll(offsets);
        this.sentOffsets = true;
    }

    @Override
    public void commitTransaction() throws ProducerFencedException {
        this.verifyProducerState();
        this.verifyTransactionsInitialized();
        this.verifyNoTransactionInFlight();
        this.flush();
        this.sent.addAll(this.uncommittedSends);
        if (!this.uncommittedConsumerGroupOffsets.isEmpty()) {
            this.consumerGroupOffsets.add(this.uncommittedConsumerGroupOffsets);
        }
        this.uncommittedSends.clear();
        this.uncommittedConsumerGroupOffsets = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
        this.transactionCommitted = true;
        this.transactionAborted = false;
        this.transactionInFlight = false;
        ++this.commitCount;
    }

    @Override
    public void abortTransaction() throws ProducerFencedException {
        this.verifyProducerState();
        this.verifyTransactionsInitialized();
        this.verifyNoTransactionInFlight();
        this.flush();
        this.uncommittedSends.clear();
        this.uncommittedConsumerGroupOffsets.clear();
        this.transactionCommitted = false;
        this.transactionAborted = true;
        this.transactionInFlight = false;
    }

    private void verifyProducerState() {
        if (this.closed) {
            throw new IllegalStateException("MockProducer is already closed.");
        }
        if (this.producerFenced) {
            throw new ProducerFencedException("MockProducer is fenced.");
        }
    }

    private void verifyTransactionsInitialized() {
        if (!this.transactionInitialized) {
            throw new IllegalStateException("MockProducer hasn't been initialized for transactions.");
        }
    }

    private void verifyNoTransactionInFlight() {
        if (!this.transactionInFlight) {
            throw new IllegalStateException("There is no open transaction.");
        }
    }

    @Override
    public synchronized Future<RecordMetadata> send(ProducerRecord<K, V> record2) {
        return this.send(record2, null);
    }

    @Override
    public synchronized Future<RecordMetadata> send(ProducerRecord<K, V> record2, Callback callback) {
        this.verifyProducerState();
        int partition2 = 0;
        if (!this.cluster.partitionsForTopic(record2.topic()).isEmpty()) {
            partition2 = this.partition(record2, this.cluster);
        }
        TopicPartition topicPartition = new TopicPartition(record2.topic(), partition2);
        ProduceRequestResult result2 = new ProduceRequestResult(topicPartition);
        FutureRecordMetadata future = new FutureRecordMetadata(result2, 0L, -1L, 0L, 0, 0);
        long offset = this.nextOffset(topicPartition);
        Completion completion = new Completion(offset, new RecordMetadata(topicPartition, 0L, offset, -1L, (Long)0L, 0, 0), result2, callback);
        if (!this.transactionInFlight) {
            this.sent.add(record2);
        } else {
            this.uncommittedSends.add(record2);
        }
        if (this.autoComplete) {
            completion.complete(null);
        } else {
            this.completions.addLast(completion);
        }
        return future;
    }

    private long nextOffset(TopicPartition tp) {
        Long offset = this.offsets.get(tp);
        if (offset == null) {
            this.offsets.put(tp, 1L);
            return 0L;
        }
        Long next2 = offset + 1L;
        this.offsets.put(tp, next2);
        return offset;
    }

    @Override
    public synchronized void flush() {
        this.verifyProducerState();
        while (!this.completions.isEmpty()) {
            this.completeNext();
        }
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        return this.cluster.partitionsForTopic(topic);
    }

    @Override
    public Map<MetricName, Metric> metrics() {
        return Collections.emptyMap();
    }

    @Override
    public void close() {
        this.close(0L, null);
    }

    @Override
    public void close(long timeout, TimeUnit timeUnit) {
        if (this.closed) {
            throw new IllegalStateException("MockProducer is already closed.");
        }
        this.closed = true;
    }

    public boolean closed() {
        return this.closed;
    }

    public void fenceProducer() {
        this.verifyProducerState();
        this.verifyTransactionsInitialized();
        this.producerFenced = true;
    }

    public boolean transactionInitialized() {
        return this.transactionInitialized;
    }

    public boolean transactionInFlight() {
        return this.transactionInFlight;
    }

    public boolean transactionCommitted() {
        return this.transactionCommitted;
    }

    public boolean transactionAborted() {
        return this.transactionAborted;
    }

    public boolean flushed() {
        return this.completions.isEmpty();
    }

    public boolean sentOffsets() {
        return this.sentOffsets;
    }

    public long commitCount() {
        return this.commitCount;
    }

    public synchronized List<ProducerRecord<K, V>> history() {
        return new ArrayList<ProducerRecord<K, V>>(this.sent);
    }

    public synchronized List<Map<String, Map<TopicPartition, OffsetAndMetadata>>> consumerGroupOffsetsHistory() {
        return new ArrayList<Map<String, Map<TopicPartition, OffsetAndMetadata>>>(this.consumerGroupOffsets);
    }

    public synchronized void clear() {
        this.sent.clear();
        this.uncommittedSends.clear();
        this.completions.clear();
        this.consumerGroupOffsets.clear();
        this.uncommittedConsumerGroupOffsets.clear();
        this.transactionInitialized = false;
        this.transactionInFlight = false;
        this.transactionCommitted = false;
        this.transactionAborted = false;
        this.producerFenced = false;
    }

    public synchronized boolean completeNext() {
        return this.errorNext(null);
    }

    public synchronized boolean errorNext(RuntimeException e) {
        Completion completion = this.completions.pollFirst();
        if (completion != null) {
            completion.complete(e);
            return true;
        }
        return false;
    }

    private int partition(ProducerRecord<K, V> record2, Cluster cluster) {
        Integer partition2 = record2.partition();
        String topic = record2.topic();
        if (partition2 != null) {
            List<PartitionInfo> partitions = cluster.partitionsForTopic(topic);
            int numPartitions = partitions.size();
            if (partition2 < 0 || partition2 >= numPartitions) {
                throw new IllegalArgumentException("Invalid partition given with record: " + partition2 + " is not in the range [0..." + numPartitions + "].");
            }
            return partition2;
        }
        byte[] keyBytes = this.keySerializer.serialize(topic, record2.headers(), record2.key());
        byte[] valueBytes = this.valueSerializer.serialize(topic, record2.headers(), record2.value());
        return this.partitioner.partition(topic, record2.key(), keyBytes, record2.value(), valueBytes, cluster);
    }

    private static class Completion {
        private final long offset;
        private final RecordMetadata metadata;
        private final ProduceRequestResult result;
        private final Callback callback;

        public Completion(long offset, RecordMetadata metadata, ProduceRequestResult result2, Callback callback) {
            this.metadata = metadata;
            this.offset = offset;
            this.result = result2;
            this.callback = callback;
        }

        public void complete(RuntimeException e) {
            this.result.set(e == null ? this.offset : -1L, -1L, e);
            if (this.callback != null) {
                if (e == null) {
                    this.callback.onCompletion(this.metadata, null);
                } else {
                    this.callback.onCompletion(null, e);
                }
            }
            this.result.done();
        }
    }
}

