/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class TransactionalRequestResult {
    static final TransactionalRequestResult COMPLETE = new TransactionalRequestResult(new CountDownLatch(0));
    private final CountDownLatch latch;
    private volatile RuntimeException error = null;

    public TransactionalRequestResult() {
        this(new CountDownLatch(1));
    }

    private TransactionalRequestResult(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setError(RuntimeException error) {
        this.error = error;
    }

    public void done() {
        this.latch.countDown();
    }

    public void await() {
        boolean completed = false;
        while (!completed) {
            try {
                this.latch.await();
                completed = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.isSuccessful()) {
            throw this.error();
        }
    }

    public boolean await(long timeout, TimeUnit unit2) throws InterruptedException {
        return this.latch.await(timeout, unit2);
    }

    public RuntimeException error() {
        return this.error;
    }

    public boolean isSuccessful() {
        return this.error == null;
    }

    public boolean isCompleted() {
        return this.latch.getCount() == 0L;
    }
}

