/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

public class Node {
    private static final Node NO_NODE = new Node(-1, "", -1);
    private final int id;
    private final String idString;
    private final String host;
    private final int port;
    private final String rack;

    public Node(int id2, String host, int port) {
        this(id2, host, port, null);
    }

    public Node(int id2, String host, int port, String rack) {
        this.id = id2;
        this.idString = Integer.toString(id2);
        this.host = host;
        this.port = port;
        this.rack = rack;
    }

    public static Node noNode() {
        return NO_NODE;
    }

    public boolean isEmpty() {
        return this.host == null || this.host.isEmpty() || this.port < 0;
    }

    public int id() {
        return this.id;
    }

    public String idString() {
        return this.idString;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean hasRack() {
        return this.rack != null;
    }

    public String rack() {
        return this.rack;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.host == null ? 0 : this.host.hashCode());
        result2 = 31 * result2 + this.id;
        result2 = 31 * result2 + this.port;
        result2 = 31 * result2 + (this.rack == null ? 0 : this.rack.hashCode());
        return result2;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        Node other = (Node)obj2;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.rack == null ? other.rack != null : !this.rack.equals(other.rack));
    }

    public String toString() {
        return this.host + ":" + this.port + " (id: " + this.idString + " rack: " + this.rack + ")";
    }
}

