/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ConcurrentTransactionsException;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.DuplicateSequenceNumberException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.IllegalSaslStateException;
import org.apache.kafka.common.errors.InconsistentGroupProtocolException;
import org.apache.kafka.common.errors.InvalidCommitOffsetSizeException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidFetchSizeException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidRequiredAcksException;
import org.apache.kafka.common.errors.InvalidSessionTimeoutException;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.InvalidTxnTimeoutException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.OffsetMetadataTooLarge;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.TransactionalIdAuthorizationException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.errors.UnsupportedSaslMechanismException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Errors {
    UNKNOWN(-1, "The server experienced an unexpected error when processing the request", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new UnknownServerException(message2);
        }
    }),
    NONE(0, null, new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return null;
        }
    }),
    OFFSET_OUT_OF_RANGE(1, "The requested offset is not within the range of offsets maintained by the server.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new OffsetOutOfRangeException(message2);
        }
    }),
    CORRUPT_MESSAGE(2, "This message has failed its CRC checksum, exceeds the valid size, or is otherwise corrupt.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new CorruptRecordException(message2);
        }
    }),
    UNKNOWN_TOPIC_OR_PARTITION(3, "This server does not host this topic-partition.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new UnknownTopicOrPartitionException(message2);
        }
    }),
    INVALID_FETCH_SIZE(4, "The requested fetch size is invalid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidFetchSizeException(message2);
        }
    }),
    LEADER_NOT_AVAILABLE(5, "There is no leader for this topic-partition as we are in the middle of a leadership election.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new LeaderNotAvailableException(message2);
        }
    }),
    NOT_LEADER_FOR_PARTITION(6, "This server is not the leader for that topic-partition.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new NotLeaderForPartitionException(message2);
        }
    }),
    REQUEST_TIMED_OUT(7, "The request timed out.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new TimeoutException(message2);
        }
    }),
    BROKER_NOT_AVAILABLE(8, "The broker is not available.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new BrokerNotAvailableException(message2);
        }
    }),
    REPLICA_NOT_AVAILABLE(9, "The replica is not available for the requested topic-partition", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new ReplicaNotAvailableException(message2);
        }
    }),
    MESSAGE_TOO_LARGE(10, "The request included a message larger than the max message size the server will accept.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new RecordTooLargeException(message2);
        }
    }),
    STALE_CONTROLLER_EPOCH(11, "The controller moved to another broker.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new ControllerMovedException(message2);
        }
    }),
    OFFSET_METADATA_TOO_LARGE(12, "The metadata field of the offset request was too large.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new OffsetMetadataTooLarge(message2);
        }
    }),
    NETWORK_EXCEPTION(13, "The server disconnected before a response was received.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new NetworkException(message2);
        }
    }),
    COORDINATOR_LOAD_IN_PROGRESS(14, "The coordinator is loading and hence can't process requests.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new CoordinatorLoadInProgressException(message2);
        }
    }),
    COORDINATOR_NOT_AVAILABLE(15, "The coordinator is not available.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new CoordinatorNotAvailableException(message2);
        }
    }),
    NOT_COORDINATOR(16, "This is not the correct coordinator.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new NotCoordinatorException(message2);
        }
    }),
    INVALID_TOPIC_EXCEPTION(17, "The request attempted to perform an operation on an invalid topic.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidTopicException(message2);
        }
    }),
    RECORD_LIST_TOO_LARGE(18, "The request included message batch larger than the configured segment size on the server.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new RecordBatchTooLargeException(message2);
        }
    }),
    NOT_ENOUGH_REPLICAS(19, "Messages are rejected since there are fewer in-sync replicas than required.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new NotEnoughReplicasException(message2);
        }
    }),
    NOT_ENOUGH_REPLICAS_AFTER_APPEND(20, "Messages are written to the log, but to fewer in-sync replicas than required.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new NotEnoughReplicasAfterAppendException(message2);
        }
    }),
    INVALID_REQUIRED_ACKS(21, "Produce request specified an invalid value for required acks.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidRequiredAcksException(message2);
        }
    }),
    ILLEGAL_GENERATION(22, "Specified group generation id is not valid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new IllegalGenerationException(message2);
        }
    }),
    INCONSISTENT_GROUP_PROTOCOL(23, "The group member's supported protocols are incompatible with those of existing members.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InconsistentGroupProtocolException(message2);
        }
    }),
    INVALID_GROUP_ID(24, "The configured groupId is invalid", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidGroupIdException(message2);
        }
    }),
    UNKNOWN_MEMBER_ID(25, "The coordinator is not aware of this member.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new UnknownMemberIdException(message2);
        }
    }),
    INVALID_SESSION_TIMEOUT(26, "The session timeout is not within the range allowed by the broker (as configured by group.min.session.timeout.ms and group.max.session.timeout.ms).", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidSessionTimeoutException(message2);
        }
    }),
    REBALANCE_IN_PROGRESS(27, "The group is rebalancing, so a rejoin is needed.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new RebalanceInProgressException(message2);
        }
    }),
    INVALID_COMMIT_OFFSET_SIZE(28, "The committing offset data size is not valid", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidCommitOffsetSizeException(message2);
        }
    }),
    TOPIC_AUTHORIZATION_FAILED(29, "Topic authorization failed.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new TopicAuthorizationException(message2);
        }
    }),
    GROUP_AUTHORIZATION_FAILED(30, "Group authorization failed.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new GroupAuthorizationException(message2);
        }
    }),
    CLUSTER_AUTHORIZATION_FAILED(31, "Cluster authorization failed.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new ClusterAuthorizationException(message2);
        }
    }),
    INVALID_TIMESTAMP(32, "The timestamp of the message is out of acceptable range.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidTimestampException(message2);
        }
    }),
    UNSUPPORTED_SASL_MECHANISM(33, "The broker does not support the requested SASL mechanism.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new UnsupportedSaslMechanismException(message2);
        }
    }),
    ILLEGAL_SASL_STATE(34, "Request is not valid given the current SASL state.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new IllegalSaslStateException(message2);
        }
    }),
    UNSUPPORTED_VERSION(35, "The version of API is not supported.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new UnsupportedVersionException(message2);
        }
    }),
    TOPIC_ALREADY_EXISTS(36, "Topic with this name already exists.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new TopicExistsException(message2);
        }
    }),
    INVALID_PARTITIONS(37, "Number of partitions is invalid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidPartitionsException(message2);
        }
    }),
    INVALID_REPLICATION_FACTOR(38, "Replication-factor is invalid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidReplicationFactorException(message2);
        }
    }),
    INVALID_REPLICA_ASSIGNMENT(39, "Replica assignment is invalid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidReplicaAssignmentException(message2);
        }
    }),
    INVALID_CONFIG(40, "Configuration is invalid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidConfigurationException(message2);
        }
    }),
    NOT_CONTROLLER(41, "This is not the correct controller for this cluster.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new NotControllerException(message2);
        }
    }),
    INVALID_REQUEST(42, "This most likely occurs because of a request being malformed by the client library or the message was sent to an incompatible broker. See the broker logs for more details.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidRequestException(message2);
        }
    }),
    UNSUPPORTED_FOR_MESSAGE_FORMAT(43, "The message format version on the broker does not support the request.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new UnsupportedForMessageFormatException(message2);
        }
    }),
    POLICY_VIOLATION(44, "Request parameters do not satisfy the configured policy.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new PolicyViolationException(message2);
        }
    }),
    OUT_OF_ORDER_SEQUENCE_NUMBER(45, "The broker received an out of order sequence number", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new OutOfOrderSequenceException(message2);
        }
    }),
    DUPLICATE_SEQUENCE_NUMBER(46, "The broker received a duplicate sequence number", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new DuplicateSequenceNumberException(message2);
        }
    }),
    INVALID_PRODUCER_EPOCH(47, "Producer attempted an operation with an old epoch. Either there is a newer producer with the same transactionalId, or the producer's transaction has been expired by the broker.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new ProducerFencedException(message2);
        }
    }),
    INVALID_TXN_STATE(48, "The producer attempted a transactional operation in an invalid state", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidTxnStateException(message2);
        }
    }),
    INVALID_PRODUCER_ID_MAPPING(49, "The producer attempted to use a producer id which is not currently assigned to its transactional id", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidPidMappingException(message2);
        }
    }),
    INVALID_TRANSACTION_TIMEOUT(50, "The transaction timeout is larger than the maximum value allowed by the broker (as configured by max.transaction.timeout.ms).", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new InvalidTxnTimeoutException(message2);
        }
    }),
    CONCURRENT_TRANSACTIONS(51, "The producer attempted to update a transaction while another concurrent operation on the same transaction was ongoing", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new ConcurrentTransactionsException(message2);
        }
    }),
    TRANSACTION_COORDINATOR_FENCED(52, "Indicates that the transaction coordinator sending a WriteTxnMarker is no longer the current coordinator for a given producer", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new TransactionCoordinatorFencedException(message2);
        }
    }),
    TRANSACTIONAL_ID_AUTHORIZATION_FAILED(53, "Transactional Id authorization failed", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new TransactionalIdAuthorizationException(message2);
        }
    }),
    SECURITY_DISABLED(54, "Security features are disabled.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new SecurityDisabledException(message2);
        }
    }),
    OPERATION_NOT_ATTEMPTED(55, "The broker did not attempt to execute this operation. This may happen for batched RPCs where some operations in the batch failed, causing the broker to respond without trying the rest.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message2) {
            return new OperationNotAttemptedException(message2);
        }
    });

    private static final Logger log;
    private static Map<Class<?>, Errors> classToError;
    private static Map<Short, Errors> codeToError;
    private final short code;
    private final ApiExceptionBuilder builder;
    private final ApiException exception;

    private Errors(int code, String defaultExceptionString, ApiExceptionBuilder builder) {
        this.code = (short)code;
        this.builder = builder;
        this.exception = builder.build(defaultExceptionString);
    }

    public ApiException exception() {
        return this.exception;
    }

    public ApiException exception(String message2) {
        if (message2 == null) {
            return this.exception;
        }
        return this.builder.build(message2);
    }

    public String exceptionName() {
        return this.exception == null ? null : this.exception.getClass().getName();
    }

    public short code() {
        return this.code;
    }

    public void maybeThrow() {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public String message() {
        if (this.exception != null) {
            return this.exception.getMessage();
        }
        return this.toString();
    }

    public static Errors forCode(short code) {
        Errors error = codeToError.get(code);
        if (error != null) {
            return error;
        }
        log.warn("Unexpected error code: {}.", (Object)code);
        return UNKNOWN;
    }

    public static Errors forException(Throwable t) {
        for (Class<?> clazz = t.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Errors error = classToError.get(clazz);
            if (error == null) continue;
            return error;
        }
        return UNKNOWN;
    }

    private static String toHtml() {
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>");
        b.append("<th>Error</th>\n");
        b.append("<th>Code</th>\n");
        b.append("<th>Retriable</th>\n");
        b.append("<th>Description</th>\n");
        b.append("</tr>\n");
        for (Errors error : Errors.values()) {
            b.append("<tr>");
            b.append("<td>");
            b.append(error.name());
            b.append("</td>");
            b.append("<td>");
            b.append(error.code());
            b.append("</td>");
            b.append("<td>");
            b.append(error.exception() != null && error.exception() instanceof RetriableException ? "True" : "False");
            b.append("</td>");
            b.append("<td>");
            b.append(error.exception() != null ? error.exception().getMessage() : "");
            b.append("</td>");
            b.append("</tr>\n");
        }
        b.append("</table>\n");
        return b.toString();
    }

    public static void main(String[] args) {
        System.out.println(Errors.toHtml());
    }

    static {
        log = LoggerFactory.getLogger(Errors.class);
        classToError = new HashMap();
        codeToError = new HashMap<Short, Errors>();
        for (Errors error : Errors.values()) {
            codeToError.put(error.code(), error);
            if (error.exception == null) continue;
            classToError.put(error.exception.getClass(), error);
        }
    }

    private static interface ApiExceptionBuilder {
        public ApiException build(String var1);
    }
}

