/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class Schema
extends Type {
    private final Field[] fields;
    private final Map<String, Field> fieldsByName;

    public Schema(Field ... fs) {
        this.fields = new Field[fs.length];
        this.fieldsByName = new HashMap<String, Field>();
        for (int i = 0; i < this.fields.length; ++i) {
            Field field2 = fs[i];
            if (this.fieldsByName.containsKey(field2.name)) {
                throw new SchemaException("Schema contains a duplicate field: " + field2.name);
            }
            this.fields[i] = new Field(i, field2.name, field2.type, field2.doc, field2.defaultValue, this);
            this.fieldsByName.put(fs[i].name, this.fields[i]);
        }
    }

    @Override
    public void write(ByteBuffer buffer, Object o) {
        Struct r2 = (Struct)o;
        for (Field field2 : this.fields) {
            try {
                Object value2 = field2.type().validate(r2.get(field2));
                field2.type.write(buffer, value2);
            }
            catch (Exception e) {
                throw new SchemaException("Error writing field '" + field2.name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
    }

    @Override
    public Struct read(ByteBuffer buffer) {
        Object[] objects = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            try {
                objects[i] = this.fields[i].type.read(buffer);
                continue;
            }
            catch (Exception e) {
                throw new SchemaException("Error reading field '" + this.fields[i].name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
        return new Struct(this, objects);
    }

    @Override
    public int sizeOf(Object o) {
        int size2 = 0;
        Struct r2 = (Struct)o;
        for (Field field2 : this.fields) {
            try {
                size2 += field2.type.sizeOf(r2.get(field2));
            }
            catch (Exception e) {
                throw new SchemaException("Error computing size for field '" + field2.name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
        return size2;
    }

    public int numFields() {
        return this.fields.length;
    }

    public Field get(int slot) {
        return this.fields[slot];
    }

    public Field get(String name) {
        return this.fieldsByName.get(name);
    }

    public Field[] fields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < this.fields.length; ++i) {
            b.append(this.fields[i].name);
            b.append(':');
            b.append(this.fields[i].type());
            if (i >= this.fields.length - 1) continue;
            b.append(',');
        }
        b.append("}");
        return b.toString();
    }

    @Override
    public Struct validate(Object item) {
        try {
            Struct struct = (Struct)item;
            for (Field field2 : this.fields) {
                try {
                    field2.type.validate(struct.get(field2));
                }
                catch (SchemaException e) {
                    throw new SchemaException("Invalid value for field '" + field2.name + "': " + e.getMessage());
                }
            }
            return struct;
        }
        catch (ClassCastException e) {
            throw new SchemaException("Not a Struct.");
        }
    }
}

