/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class AddPartitionsToTxnResponse
extends AbstractResponse {
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String ERRORS_KEY_NAME = "errors";
    private static final String TOPIC_NAME = "topic";
    private static final String PARTITION = "partition";
    private static final String PARTITION_ERRORS = "partition_errors";
    private final int throttleTimeMs;
    private final Map<TopicPartition, Errors> errors;

    public AddPartitionsToTxnResponse(int throttleTimeMs, Map<TopicPartition, Errors> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public AddPartitionsToTxnResponse(Struct struct) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errors = new HashMap<TopicPartition, Errors>();
        for (Object topic : struct.getArray(ERRORS_KEY_NAME)) {
            Struct topicStruct = (Struct)topic;
            String topicName = topicStruct.getString(TOPIC_NAME);
            for (Object partition2 : topicStruct.getArray(PARTITION_ERRORS)) {
                Struct partitionStruct = (Struct)partition2;
                TopicPartition topicPartition = new TopicPartition(topicName, partitionStruct.getInt(PARTITION));
                this.errors.put(topicPartition, Errors.forCode(partitionStruct.getShort(ERROR_CODE_KEY_NAME)));
            }
        }
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, Errors> errors() {
        return this.errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.ADD_PARTITIONS_TO_TXN.responseSchema(version));
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Map<String, Map<Integer, Errors>> errorsByTopic = CollectionUtils.groupDataByTopic(this.errors);
        ArrayList<Struct> topics = new ArrayList<Struct>(errorsByTopic.size());
        for (Map.Entry<String, Map<Integer, Errors>> entry : errorsByTopic.entrySet()) {
            Struct topicErrorCodes = struct.instance(ERRORS_KEY_NAME);
            topicErrorCodes.set(TOPIC_NAME, (Object)entry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, Errors> partitionErrors : entry.getValue().entrySet()) {
                Struct partitionData = topicErrorCodes.instance(PARTITION_ERRORS).set(PARTITION, (Object)partitionErrors.getKey()).set(ERROR_CODE_KEY_NAME, (Object)partitionErrors.getValue().code());
                partitionArray.add(partitionData);
            }
            topicErrorCodes.set(PARTITION_ERRORS, (Object)partitionArray.toArray());
            topics.add(topicErrorCodes);
        }
        struct.set(ERRORS_KEY_NAME, (Object)topics.toArray());
        return struct;
    }

    public static AddPartitionsToTxnResponse parse(ByteBuffer buffer, short version) {
        return new AddPartitionsToTxnResponse(ApiKeys.ADD_PARTITIONS_TO_TXN.parseResponse(version, buffer));
    }

    public String toString() {
        return "AddPartitionsToTxnResponse(errors=" + this.errors + ", throttleTimeMs=" + this.throttleTimeMs + ')';
    }
}

