/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.utils.Utils;

public class DeleteAclsRequest
extends AbstractRequest {
    private static final String FILTERS = "filters";
    private final List<AclBindingFilter> filters;

    DeleteAclsRequest(short version, List<AclBindingFilter> filters) {
        super(version);
        this.filters = filters;
    }

    public DeleteAclsRequest(Struct struct, short version) {
        super(version);
        this.filters = new ArrayList<AclBindingFilter>();
        for (Object filterStructObj : struct.getArray(FILTERS)) {
            Struct filterStruct = (Struct)filterStructObj;
            ResourceFilter resourceFilter = RequestUtils.resourceFilterFromStructFields(filterStruct);
            AccessControlEntryFilter aceFilter = RequestUtils.aceFilterFromStructFields(filterStruct);
            this.filters.add(new AclBindingFilter(resourceFilter, aceFilter));
        }
    }

    public List<AclBindingFilter> filters() {
        return this.filters;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DELETE_ACLS.requestSchema(this.version()));
        ArrayList<Struct> filterStructs = new ArrayList<Struct>();
        for (AclBindingFilter filter2 : this.filters) {
            Struct filterStruct = struct.instance(FILTERS);
            RequestUtils.resourceFilterSetStructFields(filter2.resourceFilter(), filterStruct);
            RequestUtils.aceFilterSetStructFields(filter2.entryFilter(), filterStruct);
            filterStructs.add(filterStruct);
        }
        struct.set(FILTERS, (Object)filterStructs.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                ArrayList<DeleteAclsResponse.AclFilterResponse> responses = new ArrayList<DeleteAclsResponse.AclFilterResponse>();
                for (int i = 0; i < this.filters.size(); ++i) {
                    responses.add(new DeleteAclsResponse.AclFilterResponse(ApiError.fromThrowable(throwable), Collections.emptySet()));
                }
                return new DeleteAclsResponse(throttleTimeMs, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.DELETE_ACLS.latestVersion()));
    }

    public static DeleteAclsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteAclsRequest(ApiKeys.DELETE_ACLS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteAclsRequest> {
        private final List<AclBindingFilter> filters;

        public Builder(List<AclBindingFilter> filters) {
            super(ApiKeys.DELETE_ACLS);
            this.filters = filters;
        }

        @Override
        public DeleteAclsRequest build(short version) {
            return new DeleteAclsRequest(version, this.filters);
        }

        public String toString() {
            return "(type=DeleteAclsRequest, filters=" + Utils.join(this.filters, ", ") + ")";
        }
    }
}

