/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class DeleteRecordsRequest
extends AbstractRequest {
    public static final long HIGH_WATERMARK = -1L;
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String OFFSET_KEY_NAME = "offset";
    private final int timeout;
    private final Map<TopicPartition, Long> partitionOffsets;

    public DeleteRecordsRequest(Struct struct, short version) {
        super(version);
        this.partitionOffsets = new HashMap<TopicPartition, Long>();
        for (Object topicStructObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicStruct = (Struct)topicStructObj;
            String topic = topicStruct.getString(TOPIC_KEY_NAME);
            for (Object partitionStructObj : topicStruct.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionStruct = (Struct)partitionStructObj;
                int partition2 = partitionStruct.getInt(PARTITION_KEY_NAME);
                long offset = partitionStruct.getLong(OFFSET_KEY_NAME);
                this.partitionOffsets.put(new TopicPartition(topic, partition2), offset);
            }
        }
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
    }

    public DeleteRecordsRequest(int timeout, Map<TopicPartition, Long> partitionOffsets, short version) {
        super(version);
        this.timeout = timeout;
        this.partitionOffsets = partitionOffsets;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DELETE_RECORDS.requestSchema(this.version()));
        Map<String, Map<Integer, Long>> offsetsByTopic = CollectionUtils.groupDataByTopic(this.partitionOffsets);
        struct.set(TIMEOUT_KEY_NAME, (Object)this.timeout);
        ArrayList<Struct> topicStructArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, Long>> offsetsByTopicEntry : offsetsByTopic.entrySet()) {
            Struct topicStruct = struct.instance(TOPICS_KEY_NAME);
            topicStruct.set(TOPIC_KEY_NAME, (Object)offsetsByTopicEntry.getKey());
            ArrayList<Struct> partitionStructArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, Long> offsetsByPartitionEntry : offsetsByTopicEntry.getValue().entrySet()) {
                Struct partitionStruct = topicStruct.instance(PARTITIONS_KEY_NAME);
                partitionStruct.set(PARTITION_KEY_NAME, (Object)offsetsByPartitionEntry.getKey());
                partitionStruct.set(OFFSET_KEY_NAME, (Object)offsetsByPartitionEntry.getValue());
                partitionStructArray.add(partitionStruct);
            }
            topicStruct.set(PARTITIONS_KEY_NAME, (Object)partitionStructArray.toArray());
            topicStructArray.add(topicStruct);
        }
        struct.set(TOPICS_KEY_NAME, (Object)topicStructArray.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, DeleteRecordsResponse.PartitionResponse> responseMap = new HashMap<TopicPartition, DeleteRecordsResponse.PartitionResponse>();
        for (Map.Entry<TopicPartition, Long> entry : this.partitionOffsets.entrySet()) {
            responseMap.put(entry.getKey(), new DeleteRecordsResponse.PartitionResponse(-1L, Errors.forException(e)));
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new DeleteRecordsResponse(throttleTimeMs, responseMap);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.DELETE_RECORDS.latestVersion()));
    }

    public int timeout() {
        return this.timeout;
    }

    public Map<TopicPartition, Long> partitionOffsets() {
        return this.partitionOffsets;
    }

    public static DeleteRecordsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteRecordsRequest(ApiKeys.DELETE_RECORDS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteRecordsRequest> {
        private final int timeout;
        private final Map<TopicPartition, Long> partitionOffsets;

        public Builder(int timeout, Map<TopicPartition, Long> partitionOffsets) {
            super(ApiKeys.DELETE_RECORDS);
            this.timeout = timeout;
            this.partitionOffsets = partitionOffsets;
        }

        @Override
        public DeleteRecordsRequest build(short version) {
            return new DeleteRecordsRequest(this.timeout, this.partitionOffsets, version);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(type=DeleteRecordsRequest").append(", timeout=").append(this.timeout).append(", partitionOffsets=(").append(this.partitionOffsets).append("))");
            return builder.toString();
        }
    }
}

