/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.resource.Resource;

public class DescribeAclsResponse
extends AbstractResponse {
    private static final String RESOURCES = "resources";
    private static final String ACLS = "acls";
    private final int throttleTimeMs;
    private final ApiError error;
    private final Collection<AclBinding> acls;

    public DescribeAclsResponse(int throttleTimeMs, ApiError error, Collection<AclBinding> acls) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.acls = acls;
    }

    public DescribeAclsResponse(Struct struct) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.error = new ApiError(struct);
        this.acls = new ArrayList<AclBinding>();
        for (Object resourceStructObj : struct.getArray(RESOURCES)) {
            Struct resourceStruct = (Struct)resourceStructObj;
            Resource resource = RequestUtils.resourceFromStructFields(resourceStruct);
            for (Object aclDataStructObj : resourceStruct.getArray(ACLS)) {
                Struct aclDataStruct = (Struct)aclDataStructObj;
                AccessControlEntry entry = RequestUtils.aceFromStructFields(aclDataStruct);
                this.acls.add(new AclBinding(resource, entry));
            }
        }
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DESCRIBE_ACLS.responseSchema(version));
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        this.error.write(struct);
        HashMap<Resource, ArrayList<AccessControlEntry>> resourceToData = new HashMap<Resource, ArrayList<AccessControlEntry>>();
        for (AclBinding acl : this.acls) {
            ArrayList<AccessControlEntry> entry = (ArrayList<AccessControlEntry>)resourceToData.get(acl.resource());
            if (entry == null) {
                entry = new ArrayList<AccessControlEntry>();
                resourceToData.put(acl.resource(), entry);
            }
            entry.add(acl.entry());
        }
        ArrayList<Struct> resourceStructs = new ArrayList<Struct>();
        for (Map.Entry tuple23 : resourceToData.entrySet()) {
            Resource resource = (Resource)tuple23.getKey();
            Struct resourceStruct = struct.instance(RESOURCES);
            RequestUtils.resourceSetStructFields(resource, resourceStruct);
            ArrayList<Struct> dataStructs = new ArrayList<Struct>();
            for (AccessControlEntry entry : (List)tuple23.getValue()) {
                Struct dataStruct = resourceStruct.instance(ACLS);
                RequestUtils.aceSetStructFields(entry, dataStruct);
                dataStructs.add(dataStruct);
            }
            resourceStruct.set(ACLS, (Object)dataStructs.toArray());
            resourceStructs.add(resourceStruct);
        }
        struct.set(RESOURCES, (Object)resourceStructs.toArray());
        return struct;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public ApiError error() {
        return this.error;
    }

    public Collection<AclBinding> acls() {
        return this.acls;
    }

    public static DescribeAclsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeAclsResponse(ApiKeys.DESCRIBE_ACLS.responseSchema(version).read(buffer));
    }
}

