/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class FindCoordinatorResponse
extends AbstractResponse {
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String ERROR_MESSAGE_KEY_NAME = "error_message";
    private static final String COORDINATOR_KEY_NAME = "coordinator";
    private static final String NODE_ID_KEY_NAME = "node_id";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private final int throttleTimeMs;
    private final String errorMessage;
    private final Errors error;
    private final Node node;

    public FindCoordinatorResponse(Errors error, Node node2) {
        this(0, error, node2);
    }

    public FindCoordinatorResponse(int throttleTimeMs, Errors error, Node node2) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.node = node2;
        this.errorMessage = null;
    }

    public FindCoordinatorResponse(Struct struct) {
        this.throttleTimeMs = struct.hasField("throttle_time_ms") ? struct.getInt("throttle_time_ms") : 0;
        this.error = Errors.forCode(struct.getShort(ERROR_CODE_KEY_NAME));
        this.errorMessage = struct.hasField(ERROR_MESSAGE_KEY_NAME) ? struct.getString(ERROR_MESSAGE_KEY_NAME) : null;
        Struct broker = (Struct)struct.get(COORDINATOR_KEY_NAME);
        int nodeId = broker.getInt(NODE_ID_KEY_NAME);
        String host = broker.getString(HOST_KEY_NAME);
        int port = broker.getInt(PORT_KEY_NAME);
        this.node = new Node(nodeId, host, port);
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Errors error() {
        return this.error;
    }

    public Node node() {
        return this.node;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.FIND_COORDINATOR.responseSchema(version));
        if (struct.hasField("throttle_time_ms")) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set(ERROR_CODE_KEY_NAME, (Object)this.error.code());
        if (struct.hasField(ERROR_MESSAGE_KEY_NAME)) {
            struct.set(ERROR_MESSAGE_KEY_NAME, (Object)this.errorMessage);
        }
        Struct coordinator = struct.instance(COORDINATOR_KEY_NAME);
        coordinator.set(NODE_ID_KEY_NAME, (Object)this.node.id());
        coordinator.set(HOST_KEY_NAME, (Object)this.node.host());
        coordinator.set(PORT_KEY_NAME, (Object)this.node.port());
        struct.set(COORDINATOR_KEY_NAME, (Object)coordinator);
        return struct;
    }

    public static FindCoordinatorResponse parse(ByteBuffer buffer, short version) {
        return new FindCoordinatorResponse(ApiKeys.FIND_COORDINATOR.responseSchema(version).read(buffer));
    }

    public String toString() {
        return "FindCoordinatorResponse(throttleTimeMs=" + this.throttleTimeMs + ", errorMessage='" + this.errorMessage + '\'' + ", error=" + (Object)((Object)this.error) + ", node=" + this.node + ')';
    }
}

