/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class OffsetFetchResponse
extends AbstractResponse {
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String COMMIT_OFFSET_KEY_NAME = "offset";
    private static final String METADATA_KEY_NAME = "metadata";
    public static final long INVALID_OFFSET = -1L;
    public static final String NO_METADATA = "";
    public static final PartitionData UNKNOWN_PARTITION = new PartitionData(-1L, "", Errors.UNKNOWN_TOPIC_OR_PARTITION);
    private static final List<Errors> PARTITION_ERRORS = Arrays.asList(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    private final Map<TopicPartition, PartitionData> responseData;
    private final Errors error;
    private final int throttleTimeMs;

    public OffsetFetchResponse(Errors error, Map<TopicPartition, PartitionData> responseData) {
        this(0, error, responseData);
    }

    public OffsetFetchResponse(int throttleTimeMs, Errors error, Map<TopicPartition, PartitionData> responseData) {
        this.throttleTimeMs = throttleTimeMs;
        this.responseData = responseData;
        this.error = error;
    }

    public OffsetFetchResponse(Struct struct) {
        this.throttleTimeMs = struct.hasField("throttle_time_ms") ? struct.getInt("throttle_time_ms") : 0;
        Errors topLevelError = Errors.NONE;
        this.responseData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition2 = partitionResponse.getInt(PARTITION_KEY_NAME);
                long offset = partitionResponse.getLong(COMMIT_OFFSET_KEY_NAME);
                String metadata = partitionResponse.getString(METADATA_KEY_NAME);
                Errors error = Errors.forCode(partitionResponse.getShort(ERROR_CODE_KEY_NAME));
                if (error != Errors.NONE && !PARTITION_ERRORS.contains((Object)error)) {
                    topLevelError = error;
                }
                PartitionData partitionData = new PartitionData(offset, metadata, error);
                this.responseData.put(new TopicPartition(topic, partition2), partitionData);
            }
        }
        this.error = struct.hasField(ERROR_CODE_KEY_NAME) ? Errors.forCode(struct.getShort(ERROR_CODE_KEY_NAME)) : topLevelError;
    }

    public void maybeThrowFirstPartitionError() {
        Collection<PartitionData> partitionsData = this.responseData.values();
        for (PartitionData data : partitionsData) {
            if (!data.hasError()) continue;
            throw data.error.exception();
        }
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public boolean hasError() {
        return this.error != Errors.NONE;
    }

    public Errors error() {
        return this.error;
    }

    public Map<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    public static OffsetFetchResponse parse(ByteBuffer buffer, short version) {
        return new OffsetFetchResponse(ApiKeys.OFFSET_FETCH.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.OFFSET_FETCH.responseSchema(version));
        if (struct.hasField("throttle_time_ms")) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(this.responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> entries : topicsData.entrySet()) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entries.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : entries.getValue().entrySet()) {
                PartitionData fetchPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(COMMIT_OFFSET_KEY_NAME, (Object)fetchPartitionData.offset);
                partitionData.set(METADATA_KEY_NAME, (Object)fetchPartitionData.metadata);
                partitionData.set(ERROR_CODE_KEY_NAME, (Object)fetchPartitionData.error.code());
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        if (version > 1) {
            struct.set(ERROR_CODE_KEY_NAME, (Object)this.error.code());
        }
        return struct;
    }

    public static final class PartitionData {
        public final long offset;
        public final String metadata;
        public final Errors error;

        public PartitionData(long offset, String metadata, Errors error) {
            this.offset = offset;
            this.metadata = metadata;
            this.error = error;
        }

        public boolean hasError() {
            return this.error != Errors.NONE;
        }
    }
}

