/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class ProduceResponse
extends AbstractResponse {
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_RESPONSES_KEY_NAME = "partition_responses";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    public static final long INVALID_OFFSET = -1L;
    private static final String BASE_OFFSET_KEY_NAME = "base_offset";
    private static final String LOG_APPEND_TIME_KEY_NAME = "log_append_time";
    private final Map<TopicPartition, PartitionResponse> responses;
    private final int throttleTime;

    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses) {
        this(responses, 0);
    }

    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses, int throttleTime) {
        this.responses = responses;
        this.throttleTime = throttleTime;
    }

    public ProduceResponse(Struct struct) {
        this.responses = new HashMap<TopicPartition, PartitionResponse>();
        for (Object topicResponse : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicRespStruct = (Struct)topicResponse;
            String topic = topicRespStruct.getString(TOPIC_KEY_NAME);
            for (Object partResponse : topicRespStruct.getArray(PARTITION_RESPONSES_KEY_NAME)) {
                Struct partRespStruct = (Struct)partResponse;
                int partition2 = partRespStruct.getInt(PARTITION_KEY_NAME);
                Errors error = Errors.forCode(partRespStruct.getShort(ERROR_CODE_KEY_NAME));
                long offset = partRespStruct.getLong(BASE_OFFSET_KEY_NAME);
                long logAppendTime = partRespStruct.getLong(LOG_APPEND_TIME_KEY_NAME);
                TopicPartition tp = new TopicPartition(topic, partition2);
                this.responses.put(tp, new PartitionResponse(error, offset, logAppendTime));
            }
        }
        this.throttleTime = struct.getInt("throttle_time_ms");
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.PRODUCE.responseSchema(version));
        Map<String, Map<Integer, PartitionResponse>> responseByTopic = CollectionUtils.groupDataByTopic(this.responses);
        ArrayList<Struct> topicDatas = new ArrayList<Struct>(responseByTopic.size());
        for (Map.Entry<String, Map<Integer, PartitionResponse>> entry : responseByTopic.entrySet()) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionResponse> partitionEntry : entry.getValue().entrySet()) {
                PartitionResponse part2 = partitionEntry.getValue();
                Struct partStruct = topicData.instance(PARTITION_RESPONSES_KEY_NAME).set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey()).set(ERROR_CODE_KEY_NAME, (Object)part2.error.code()).set(BASE_OFFSET_KEY_NAME, (Object)part2.baseOffset);
                if (partStruct.hasField(LOG_APPEND_TIME_KEY_NAME)) {
                    partStruct.set(LOG_APPEND_TIME_KEY_NAME, (Object)part2.logAppendTime);
                }
                partitionArray.add(partStruct);
            }
            topicData.set(PARTITION_RESPONSES_KEY_NAME, (Object)partitionArray.toArray());
            topicDatas.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicDatas.toArray());
        if (struct.hasField("throttle_time_ms")) {
            struct.set("throttle_time_ms", (Object)this.throttleTime);
        }
        return struct;
    }

    public Map<TopicPartition, PartitionResponse> responses() {
        return this.responses;
    }

    public int getThrottleTime() {
        return this.throttleTime;
    }

    public static ProduceResponse parse(ByteBuffer buffer, short version) {
        return new ProduceResponse(ApiKeys.PRODUCE.responseSchema(version).read(buffer));
    }

    public static final class PartitionResponse {
        public Errors error;
        public long baseOffset;
        public long logAppendTime;

        public PartitionResponse(Errors error) {
            this(error, -1L, -1L);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime) {
            this.error = error;
            this.baseOffset = baseOffset;
            this.logAppendTime = logAppendTime;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('{');
            b.append("error: ");
            b.append((Object)this.error);
            b.append(",offset: ");
            b.append(this.baseOffset);
            b.append(",logAppendTime: ");
            b.append(this.logAppendTime);
            b.append('}');
            return b.toString();
        }
    }
}

