/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransportLayers;
import org.apache.kafka.common.record.Records;

public class RecordsSend
implements Send {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private final String destination;
    private final Records records;
    private int remaining;
    private boolean pending = false;

    public RecordsSend(String destination, Records records) {
        this.destination = destination;
        this.records = records;
        this.remaining = records.sizeInBytes();
    }

    @Override
    public String destination() {
        return this.destination;
    }

    @Override
    public boolean completed() {
        return this.remaining <= 0 && !this.pending;
    }

    @Override
    public long writeTo(GatheringByteChannel channel) throws IOException {
        long written2 = 0L;
        if (this.remaining > 0) {
            written2 = this.records.writeTo(channel, this.size() - (long)this.remaining, this.remaining);
            if (written2 < 0L) {
                throw new EOFException("Wrote negative bytes to channel. This shouldn't happen.");
            }
            this.remaining = (int)((long)this.remaining - written2);
        }
        this.pending = TransportLayers.hasPendingWrites(channel);
        if (this.remaining <= 0 && this.pending) {
            channel.write(EMPTY_BYTE_BUFFER);
        }
        return written2;
    }

    @Override
    public long size() {
        return this.records.sizeInBytes();
    }
}

