/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class StopReplicaResponse
extends AbstractResponse {
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String PARTITIONS_TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_PARTITION_KEY_NAME = "partition";
    private static final String PARTITIONS_ERROR_CODE_KEY_NAME = "error_code";
    private final Map<TopicPartition, Errors> responses;
    private final Errors error;

    public StopReplicaResponse(Errors error, Map<TopicPartition, Errors> responses) {
        this.responses = responses;
        this.error = error;
    }

    public StopReplicaResponse(Struct struct) {
        this.responses = new HashMap<TopicPartition, Errors>();
        for (Object responseDataObj : struct.getArray(PARTITIONS_KEY_NAME)) {
            Struct responseData = (Struct)responseDataObj;
            String topic = responseData.getString(PARTITIONS_TOPIC_KEY_NAME);
            int partition2 = responseData.getInt(PARTITIONS_PARTITION_KEY_NAME);
            Errors error = Errors.forCode(responseData.getShort("error_code"));
            this.responses.put(new TopicPartition(topic, partition2), error);
        }
        this.error = Errors.forCode(struct.getShort("error_code"));
    }

    public Map<TopicPartition, Errors> responses() {
        return this.responses;
    }

    public Errors error() {
        return this.error;
    }

    public static StopReplicaResponse parse(ByteBuffer buffer, short version) {
        return new StopReplicaResponse(ApiKeys.STOP_REPLICA.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.STOP_REPLICA.responseSchema(version));
        ArrayList<Struct> responseDatas = new ArrayList<Struct>(this.responses.size());
        for (Map.Entry<TopicPartition, Errors> response : this.responses.entrySet()) {
            Struct partitionData = struct.instance(PARTITIONS_KEY_NAME);
            TopicPartition partition2 = response.getKey();
            partitionData.set(PARTITIONS_TOPIC_KEY_NAME, (Object)partition2.topic());
            partitionData.set(PARTITIONS_PARTITION_KEY_NAME, (Object)partition2.partition());
            partitionData.set("error_code", (Object)response.getValue().code());
            responseDatas.add(partitionData);
        }
        struct.set(PARTITIONS_KEY_NAME, (Object)responseDatas.toArray());
        struct.set("error_code", (Object)this.error.code());
        return struct;
    }
}

