/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.utils.Utils;

public class UpdateMetadataRequest
extends AbstractRequest {
    private static final String CONTROLLER_ID_KEY_NAME = "controller_id";
    private static final String CONTROLLER_EPOCH_KEY_NAME = "controller_epoch";
    private static final String PARTITION_STATES_KEY_NAME = "partition_states";
    private static final String LIVE_BROKERS_KEY_NAME = "live_brokers";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String LEADER_KEY_NAME = "leader";
    private static final String LEADER_EPOCH_KEY_NAME = "leader_epoch";
    private static final String ISR_KEY_NAME = "isr";
    private static final String ZK_VERSION_KEY_NAME = "zk_version";
    private static final String REPLICAS_KEY_NAME = "replicas";
    private static final String BROKER_ID_KEY_NAME = "id";
    private static final String ENDPOINTS_KEY_NAME = "end_points";
    private static final String RACK_KEY_NAME = "rack";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private static final String LISTENER_NAME_KEY_NAME = "listener_name";
    private static final String SECURITY_PROTOCOL_TYPE_KEY_NAME = "security_protocol_type";
    private final int controllerId;
    private final int controllerEpoch;
    private final Map<TopicPartition, PartitionState> partitionStates;
    private final Set<Broker> liveBrokers;

    private UpdateMetadataRequest(short version, int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Broker> liveBrokers) {
        super(version);
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.partitionStates = partitionStates;
        this.liveBrokers = liveBrokers;
    }

    public UpdateMetadataRequest(Struct struct, short versionId) {
        super(versionId);
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        for (Object partitionStateDataObj : struct.getArray(PARTITION_STATES_KEY_NAME)) {
            Struct partitionStateData = (Struct)partitionStateDataObj;
            String topic = partitionStateData.getString(TOPIC_KEY_NAME);
            int partition2 = partitionStateData.getInt(PARTITION_KEY_NAME);
            int controllerEpoch = partitionStateData.getInt(CONTROLLER_EPOCH_KEY_NAME);
            int leader = partitionStateData.getInt(LEADER_KEY_NAME);
            int leaderEpoch = partitionStateData.getInt(LEADER_EPOCH_KEY_NAME);
            Object[] isrArray = partitionStateData.getArray(ISR_KEY_NAME);
            ArrayList<Integer> isr = new ArrayList<Integer>(isrArray.length);
            for (Object r2 : isrArray) {
                isr.add((Integer)r2);
            }
            int zkVersion = partitionStateData.getInt(ZK_VERSION_KEY_NAME);
            Object[] replicasArray = partitionStateData.getArray(REPLICAS_KEY_NAME);
            ArrayList<Integer> replicas = new ArrayList<Integer>(replicasArray.length);
            for (Object r3 : replicasArray) {
                replicas.add((Integer)r3);
            }
            PartitionState partitionState = new PartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas);
            partitionStates.put(new TopicPartition(topic, partition2), partitionState);
        }
        HashSet<Broker> liveBrokers = new HashSet<Broker>();
        for (Object brokerDataObj : struct.getArray(LIVE_BROKERS_KEY_NAME)) {
            Struct brokerData = (Struct)brokerDataObj;
            int brokerId = brokerData.getInt(BROKER_ID_KEY_NAME);
            if (brokerData.hasField(HOST_KEY_NAME)) {
                String host = brokerData.getString(HOST_KEY_NAME);
                int port = brokerData.getInt(PORT_KEY_NAME);
                ArrayList<EndPoint> endPoints = new ArrayList<EndPoint>(1);
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                endPoints.add(new EndPoint(host, port, securityProtocol, ListenerName.forSecurityProtocol(securityProtocol)));
                liveBrokers.add(new Broker(brokerId, endPoints, null));
                continue;
            }
            ArrayList<EndPoint> endPoints = new ArrayList<EndPoint>();
            for (Object endPointDataObj : brokerData.getArray(ENDPOINTS_KEY_NAME)) {
                Struct endPointData = (Struct)endPointDataObj;
                int port = endPointData.getInt(PORT_KEY_NAME);
                String host = endPointData.getString(HOST_KEY_NAME);
                short protocolTypeId = endPointData.getShort(SECURITY_PROTOCOL_TYPE_KEY_NAME);
                SecurityProtocol securityProtocol = SecurityProtocol.forId(protocolTypeId);
                String listenerName = endPointData.hasField(LISTENER_NAME_KEY_NAME) ? endPointData.getString(LISTENER_NAME_KEY_NAME) : securityProtocol.name;
                endPoints.add(new EndPoint(host, port, securityProtocol, new ListenerName(listenerName)));
            }
            String rack = null;
            if (brokerData.hasField(RACK_KEY_NAME)) {
                rack = brokerData.getString(RACK_KEY_NAME);
            }
            liveBrokers.add(new Broker(brokerId, endPoints, rack));
        }
        this.controllerId = struct.getInt(CONTROLLER_ID_KEY_NAME);
        this.controllerEpoch = struct.getInt(CONTROLLER_EPOCH_KEY_NAME);
        this.partitionStates = partitionStates;
        this.liveBrokers = liveBrokers;
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.UPDATE_METADATA_KEY.requestSchema(version));
        struct.set(CONTROLLER_ID_KEY_NAME, (Object)this.controllerId);
        struct.set(CONTROLLER_EPOCH_KEY_NAME, (Object)this.controllerEpoch);
        ArrayList<Struct> partitionStatesData = new ArrayList<Struct>(this.partitionStates.size());
        for (Map.Entry<TopicPartition, PartitionState> entry : this.partitionStates.entrySet()) {
            Struct partitionStateData = struct.instance(PARTITION_STATES_KEY_NAME);
            TopicPartition topicPartition = entry.getKey();
            partitionStateData.set(TOPIC_KEY_NAME, (Object)topicPartition.topic());
            partitionStateData.set(PARTITION_KEY_NAME, (Object)topicPartition.partition());
            PartitionState partitionState = entry.getValue();
            partitionStateData.set(CONTROLLER_EPOCH_KEY_NAME, (Object)partitionState.controllerEpoch);
            partitionStateData.set(LEADER_KEY_NAME, (Object)partitionState.leader);
            partitionStateData.set(LEADER_EPOCH_KEY_NAME, (Object)partitionState.leaderEpoch);
            partitionStateData.set(ISR_KEY_NAME, (Object)partitionState.isr.toArray());
            partitionStateData.set(ZK_VERSION_KEY_NAME, (Object)partitionState.zkVersion);
            partitionStateData.set(REPLICAS_KEY_NAME, (Object)partitionState.replicas.toArray());
            partitionStatesData.add(partitionStateData);
        }
        struct.set(PARTITION_STATES_KEY_NAME, (Object)partitionStatesData.toArray());
        ArrayList<Struct> brokersData = new ArrayList<Struct>(this.liveBrokers.size());
        for (Broker broker : this.liveBrokers) {
            Struct brokerData = struct.instance(LIVE_BROKERS_KEY_NAME);
            brokerData.set(BROKER_ID_KEY_NAME, (Object)broker.id);
            if (version == 0) {
                EndPoint endPoint = broker.endPoints.get(0);
                brokerData.set(HOST_KEY_NAME, (Object)endPoint.host);
                brokerData.set(PORT_KEY_NAME, (Object)endPoint.port);
            } else {
                ArrayList<Struct> endPointsData = new ArrayList<Struct>(broker.endPoints.size());
                for (EndPoint endPoint : broker.endPoints) {
                    Struct endPointData = brokerData.instance(ENDPOINTS_KEY_NAME);
                    endPointData.set(PORT_KEY_NAME, (Object)endPoint.port);
                    endPointData.set(HOST_KEY_NAME, (Object)endPoint.host);
                    endPointData.set(SECURITY_PROTOCOL_TYPE_KEY_NAME, (Object)endPoint.securityProtocol.id);
                    if (version >= 3) {
                        endPointData.set(LISTENER_NAME_KEY_NAME, (Object)endPoint.listenerName.value());
                    }
                    endPointsData.add(endPointData);
                }
                brokerData.set(ENDPOINTS_KEY_NAME, (Object)endPointsData.toArray());
                if (version >= 2) {
                    brokerData.set(RACK_KEY_NAME, (Object)broker.rack);
                }
            }
            brokersData.add(brokerData);
        }
        struct.set(LIVE_BROKERS_KEY_NAME, (Object)brokersData.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        if (versionId <= 3) {
            return new UpdateMetadataResponse(Errors.forException(e));
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.UPDATE_METADATA_KEY.latestVersion()));
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public Map<TopicPartition, PartitionState> partitionStates() {
        return this.partitionStates;
    }

    public Set<Broker> liveBrokers() {
        return this.liveBrokers;
    }

    public static UpdateMetadataRequest parse(ByteBuffer buffer, short version) {
        return new UpdateMetadataRequest(ApiKeys.UPDATE_METADATA_KEY.parseRequest(version, buffer), version);
    }

    public static final class EndPoint {
        public final String host;
        public final int port;
        public final SecurityProtocol securityProtocol;
        public final ListenerName listenerName;

        public EndPoint(String host, int port, SecurityProtocol securityProtocol, ListenerName listenerName) {
            this.host = host;
            this.port = port;
            this.securityProtocol = securityProtocol;
            this.listenerName = listenerName;
        }

        public String toString() {
            return "(host=" + this.host + ", port=" + this.port + ", listenerName=" + this.listenerName + ", securityProtocol=" + (Object)((Object)this.securityProtocol) + ")";
        }
    }

    public static final class Broker {
        public final int id;
        public final List<EndPoint> endPoints;
        public final String rack;

        public Broker(int id2, List<EndPoint> endPoints, String rack) {
            this.id = id2;
            this.endPoints = endPoints;
            this.rack = rack;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(id=").append(this.id);
            bld.append(", endPoints=").append(Utils.join(this.endPoints, ","));
            bld.append(", rack=").append(this.rack);
            bld.append(")");
            return bld.toString();
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<UpdateMetadataRequest> {
        private final int controllerId;
        private final int controllerEpoch;
        private final Map<TopicPartition, PartitionState> partitionStates;
        private final Set<Broker> liveBrokers;

        public Builder(short version, int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Broker> liveBrokers) {
            super(ApiKeys.UPDATE_METADATA_KEY, version);
            this.controllerId = controllerId;
            this.controllerEpoch = controllerEpoch;
            this.partitionStates = partitionStates;
            this.liveBrokers = liveBrokers;
        }

        @Override
        public UpdateMetadataRequest build(short version) {
            if (version == 0) {
                for (Broker broker : this.liveBrokers) {
                    if (broker.endPoints.size() == 1 && broker.endPoints.get((int)0).securityProtocol == SecurityProtocol.PLAINTEXT) continue;
                    throw new UnsupportedVersionException("UpdateMetadataRequest v0 only handles PLAINTEXT endpoints");
                }
            }
            return new UpdateMetadataRequest(version, this.controllerId, this.controllerEpoch, this.partitionStates, this.liveBrokers);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: UpdateMetadataRequest=").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", partitionStates=").append(this.partitionStates).append(", liveBrokers=").append(Utils.join(this.liveBrokers, ", ")).append(")");
            return bld.toString();
        }
    }
}

