/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.Login;
import org.apache.kafka.common.security.authenticator.DefaultLogin;
import org.apache.kafka.common.security.kerberos.KerberosLogin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginManager.class);
    private static final Map<String, LoginManager> STATIC_INSTANCES = new HashMap<String, LoginManager>();
    private static final Map<Password, LoginManager> DYNAMIC_INSTANCES = new HashMap<Password, LoginManager>();
    private final Login login;
    private final Object cacheKey;
    private int refCount;

    private LoginManager(JaasContext jaasContext, boolean hasKerberos, Map<String, ?> configs, Password jaasConfigValue) throws IOException, LoginException {
        this.cacheKey = jaasConfigValue != null ? jaasConfigValue : jaasContext.name();
        this.login = hasKerberos ? new KerberosLogin() : new DefaultLogin();
        this.login.configure(configs, jaasContext);
        this.login.login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginManager acquireLoginManager(JaasContext jaasContext, boolean hasKerberos, Map<String, ?> configs) throws IOException, LoginException {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            LoginManager loginManager;
            Password jaasConfigValue = (Password)configs.get("sasl.jaas.config");
            if (jaasContext.type() == JaasContext.Type.CLIENT && jaasConfigValue != null) {
                loginManager = DYNAMIC_INSTANCES.get(jaasConfigValue);
                if (loginManager == null) {
                    loginManager = new LoginManager(jaasContext, hasKerberos, configs, jaasConfigValue);
                    DYNAMIC_INSTANCES.put(jaasConfigValue, loginManager);
                }
            } else {
                loginManager = STATIC_INSTANCES.get(jaasContext.name());
                if (loginManager == null) {
                    loginManager = new LoginManager(jaasContext, hasKerberos, configs, jaasConfigValue);
                    STATIC_INSTANCES.put(jaasContext.name(), loginManager);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return loginManager.acquire();
        }
    }

    public Subject subject() {
        return this.login.subject();
    }

    public String serviceName() {
        return this.login.serviceName();
    }

    private LoginManager acquire() {
        ++this.refCount;
        LOGGER.trace("{} acquired", (Object)this);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            if (this.refCount == 0) {
                throw new IllegalStateException("release() called on disposed " + this);
            }
            if (this.refCount == 1) {
                if (this.cacheKey instanceof Password) {
                    DYNAMIC_INSTANCES.remove(this.cacheKey);
                } else {
                    STATIC_INSTANCES.remove(this.cacheKey);
                }
                this.login.close();
            }
            --this.refCount;
            LOGGER.trace("{} released", (Object)this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return "LoginManager(serviceName=" + this.serviceName() + ", publicCredentials=" + this.subject().getPublicCredentials() + ", refCount=" + this.refCount + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            for (String string2 : new ArrayList<String>(STATIC_INSTANCES.keySet())) {
                LoginManager.STATIC_INSTANCES.remove((Object)string2).login.close();
            }
            for (Password password : new ArrayList<Password>(DYNAMIC_INSTANCES.keySet())) {
                LoginManager.DYNAMIC_INSTANCES.remove((Object)password).login.close();
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }
}

