/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class DoubleDeserializer
implements Deserializer<Double> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Double deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 8) {
            throw new SerializationException("Size of data received by Deserializer is not 8");
        }
        long value2 = 0L;
        for (byte b : data) {
            value2 <<= 8;
            value2 |= (long)(b & 0xFF);
        }
        return Double.longBitsToDouble(value2);
    }

    @Override
    public void close() {
    }
}

