/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class FloatDeserializer
implements Deserializer<Float> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Float deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 4) {
            throw new SerializationException("Size of data received by Deserializer is not 4");
        }
        int value2 = 0;
        for (byte b : data) {
            value2 <<= 8;
            value2 |= b & 0xFF;
        }
        return Float.valueOf(Float.intBitsToFloat(value2));
    }

    @Override
    public void close() {
    }
}

