/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static long readUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public static long readUnsignedInt(ByteBuffer buffer, int index) {
        return (long)buffer.getInt(index) & 0xFFFFFFFFL;
    }

    public static int readUnsignedIntLE(InputStream in) throws IOException {
        return in.read() | in.read() << 8 | in.read() << 16 | in.read() << 24;
    }

    public static int readUnsignedIntLE(byte[] buffer, int offset) {
        return buffer[offset] << 0 & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }

    public static void writeUnsignedInt(ByteBuffer buffer, int index, long value2) {
        buffer.putInt(index, (int)(value2 & 0xFFFFFFFFL));
    }

    public static void writeUnsignedInt(ByteBuffer buffer, long value2) {
        buffer.putInt((int)(value2 & 0xFFFFFFFFL));
    }

    public static void writeUnsignedIntLE(OutputStream out, int value2) throws IOException {
        out.write(value2);
        out.write(value2 >>> 8);
        out.write(value2 >>> 16);
        out.write(value2 >>> 24);
    }

    public static void writeUnsignedIntLE(byte[] buffer, int offset, int value2) {
        buffer[offset] = (byte)value2;
        buffer[offset + 1] = (byte)(value2 >>> 8);
        buffer[offset + 2] = (byte)(value2 >>> 16);
        buffer[offset + 3] = (byte)(value2 >>> 24);
    }

    public static int readVarint(ByteBuffer buffer) {
        byte b;
        int value2 = 0;
        int i = 0;
        while (((b = buffer.get()) & 0x80) != 0) {
            value2 |= (b & 0x7F) << i;
            if ((i += 7) <= 28) continue;
            throw ByteUtils.illegalVarintException(value2);
        }
        return (value2 |= b << i) >>> 1 ^ -(value2 & 1);
    }

    public static int readVarint(DataInput in) throws IOException {
        byte b;
        int value2 = 0;
        int i = 0;
        while (((b = in.readByte()) & 0x80) != 0) {
            value2 |= (b & 0x7F) << i;
            if ((i += 7) <= 28) continue;
            throw ByteUtils.illegalVarintException(value2);
        }
        return (value2 |= b << i) >>> 1 ^ -(value2 & 1);
    }

    public static long readVarlong(DataInput in) throws IOException {
        long b;
        long value2 = 0L;
        int i = 0;
        while (((b = (long)in.readByte()) & 0x80L) != 0L) {
            value2 |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw ByteUtils.illegalVarlongException(value2);
        }
        return (value2 |= b << i) >>> 1 ^ -(value2 & 1L);
    }

    public static long readVarlong(ByteBuffer buffer) {
        long b;
        long value2 = 0L;
        int i = 0;
        while (((b = (long)buffer.get()) & 0x80L) != 0L) {
            value2 |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw ByteUtils.illegalVarlongException(value2);
        }
        return (value2 |= b << i) >>> 1 ^ -(value2 & 1L);
    }

    public static void writeVarint(int value2, DataOutput out) throws IOException {
        int v = value2 << 1 ^ value2 >> 31;
        while ((long)(v & 0xFFFFFF80) != 0L) {
            out.writeByte(v & 0x7F | 0x80);
            v >>>= 7;
        }
        out.writeByte((byte)v);
    }

    public static void writeVarint(int value2, ByteBuffer buffer) {
        int v = value2 << 1 ^ value2 >> 31;
        while ((long)(v & 0xFFFFFF80) != 0L) {
            byte b = (byte)(v & 0x7F | 0x80);
            buffer.put(b);
            v >>>= 7;
        }
        buffer.put((byte)v);
    }

    public static void writeVarlong(long value2, DataOutput out) throws IOException {
        long v = value2 << 1 ^ value2 >> 63;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)v & 0x7F | 0x80);
            v >>>= 7;
        }
        out.writeByte((byte)v);
    }

    public static void writeVarlong(long value2, ByteBuffer buffer) {
        long v = value2 << 1 ^ value2 >> 63;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(v & 0x7FL | 0x80L);
            buffer.put(b);
            v >>>= 7;
        }
        buffer.put((byte)v);
    }

    public static int sizeOfVarint(int value2) {
        int v = value2 << 1 ^ value2 >> 31;
        int bytes2 = 1;
        while ((long)(v & 0xFFFFFF80) != 0L) {
            ++bytes2;
            v >>>= 7;
        }
        return bytes2;
    }

    public static int sizeOfVarlong(long value2) {
        long v = value2 << 1 ^ value2 >> 63;
        int bytes2 = 1;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            ++bytes2;
            v >>>= 7;
        }
        return bytes2;
    }

    private static IllegalArgumentException illegalVarintException(int value2) {
        throw new IllegalArgumentException("Varint is too long, the most significant bit in the 5th byte is set, converted value: " + Integer.toHexString(value2));
    }

    private static IllegalArgumentException illegalVarlongException(long value2) {
        throw new IllegalArgumentException("Varlong is too long, most significant bit in the 10th byte is set, converted value: " + Long.toHexString(value2));
    }
}

