/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class Bytes
implements Comparable<Bytes> {
    private static final char[] HEX_CHARS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] bytes;
    private int hashCode;
    public static final ByteArrayComparator BYTES_LEXICO_COMPARATOR = new LexicographicByteArrayComparator();

    public static Bytes wrap(byte[] bytes2) {
        return new Bytes(bytes2);
    }

    public Bytes(byte[] bytes2) {
        this.bytes = bytes2;
        this.hashCode = 0;
    }

    public byte[] get() {
        return this.bytes;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.bytes);
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (other instanceof Bytes) {
            return Arrays.equals(this.bytes, ((Bytes)other).get());
        }
        return false;
    }

    @Override
    public int compareTo(Bytes that) {
        return BYTES_LEXICO_COMPARATOR.compare(this.bytes, that.bytes);
    }

    public String toString() {
        return Bytes.toString(this.bytes, 0, this.bytes.length);
    }

    private static String toString(byte[] b, int off, int len) {
        StringBuilder result2 = new StringBuilder();
        if (b == null) {
            return result2.toString();
        }
        if (off >= b.length) {
            return result2.toString();
        }
        if (off + len > b.length) {
            len = b.length - off;
        }
        for (int i = off; i < off + len; ++i) {
            int ch = b[i] & 0xFF;
            if (ch >= 32 && ch <= 126 && ch != 92) {
                result2.append((char)ch);
                continue;
            }
            result2.append("\\x");
            result2.append(HEX_CHARS_UPPER[ch / 16]);
            result2.append(HEX_CHARS_UPPER[ch % 16]);
        }
        return result2.toString();
    }

    private static class LexicographicByteArrayComparator
    implements ByteArrayComparator {
        private LexicographicByteArrayComparator() {
        }

        @Override
        public int compare(byte[] buffer1, byte[] buffer2) {
            return this.compare(buffer1, 0, buffer1.length, buffer2, 0, buffer2.length);
        }

        @Override
        public int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
            if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                return 0;
            }
            int end1 = offset1 + length1;
            int end2 = offset2 + length2;
            int i = offset1;
            for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                int a = buffer1[i] & 0xFF;
                int b = buffer2[j] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return length1 - length2;
        }
    }

    public static interface ByteArrayComparator
    extends Comparator<byte[]>,
    Serializable {
        public int compare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);
    }
}

