/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.hsqldb.ClientConnection;
import org.hsqldb.HsqlException;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.result.Result;

public class ClientConnectionHTTP
extends ClientConnection {
    static final String ENCODING = "ISO-8859-1";
    static final int IDLENGTH = 12;
    private HttpURLConnection httpConnection = null;

    public ClientConnectionHTTP(String string2, int n, String string3, String string4, boolean bl, boolean bl2, String string5, String string6, int n2) {
        super(string2, n, string3, string4, bl, bl2, string5, string6, n2);
    }

    public ClientConnectionHTTP(ClientConnectionHTTP clientConnectionHTTP) {
        super(clientConnectionHTTP);
    }

    @Override
    protected void initConnection(String string2, int n, boolean bl) {
    }

    @Override
    protected void openConnection(String string2, int n, boolean bl) {
        try {
            URL uRL = null;
            String string3 = "";
            if (!this.path.endsWith("/")) {
                string3 = "/";
            }
            string3 = "http://" + string2 + ":" + n + this.path + string3 + this.database;
            uRL = bl ? new URL("https://" + string2 + ":" + n + this.path + string3 + this.database) : new URL(string3);
            this.httpConnection = (HttpURLConnection)uRL.openConnection();
            this.httpConnection.setDefaultUseCaches(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    @Override
    protected void closeConnection() {
    }

    @Override
    public synchronized Result execute(Result result2) {
        this.openConnection(this.host, this.port, this.isTLS);
        Result result3 = super.execute(result2);
        this.closeConnection();
        return result3;
    }

    @Override
    public Result cancel(Result result2) {
        ClientConnectionHTTP clientConnectionHTTP = new ClientConnectionHTTP(this);
        result2.setSessionRandomID(this.randomID);
        return clientConnectionHTTP.execute(result2);
    }

    @Override
    protected void write(Result result2) throws IOException, HsqlException {
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(hsqlByteArrayOutputStream);
        result2.write(this, dataOutputStream, this.rowOut);
        this.httpConnection.setRequestMethod("POST");
        this.httpConnection.setDoOutput(true);
        this.httpConnection.setUseCaches(false);
        this.httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
        this.httpConnection.setRequestProperty("Content-Length", String.valueOf(12 + hsqlByteArrayOutputStream.size()));
        this.dataOutput = new DataOutputStream(this.httpConnection.getOutputStream());
        this.dataOutput.writeInt(result2.getDatabaseId());
        this.dataOutput.writeLong(result2.getSessionId());
        hsqlByteArrayOutputStream.writeTo(this.dataOutput);
        this.dataOutput.flush();
    }

    @Override
    protected Result read() throws IOException, HsqlException {
        this.dataInput = new DataInputStream(new BufferedInputStream(this.httpConnection.getInputStream()));
        this.rowOut.reset();
        Result result2 = Result.newResult(this.dataInput, this.rowIn);
        result2.readAdditionalResults(this, this.dataInput, this.rowIn);
        this.dataInput.close();
        return result2;
    }

    @Override
    protected void handshake() throws IOException {
    }
}

