/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.types.Type;

public class ColumnBase {
    private String name;
    private String table;
    private String schema;
    private String catalog;
    boolean isWriteable;
    private boolean isSearchable;
    protected byte parameterMode;
    protected boolean isIdentity;
    protected byte nullability = 1;
    protected Type dataType;

    ColumnBase() {
    }

    public ColumnBase(String string2, String string3, String string4, String string5) {
        this.catalog = string2;
        this.schema = string3;
        this.table = string4;
        this.name = string5;
    }

    public ColumnBase(String string2, ColumnSchema columnSchema) {
        this.catalog = string2;
        this.schema = columnSchema.getSchemaNameString();
        this.table = columnSchema.getTableNameString();
        this.name = columnSchema.getNameString();
        this.nullability = columnSchema.getNullability();
        this.isIdentity = columnSchema.isIdentity();
        this.isSearchable = columnSchema.isSearchable();
        this.isWriteable = columnSchema.isWriteable();
    }

    public String getNameString() {
        return this.name;
    }

    public String getTableNameString() {
        return this.table;
    }

    public String getSchemaNameString() {
        return this.schema;
    }

    public String getCatalogNameString() {
        return this.catalog;
    }

    public void setIdentity(boolean bl) {
        this.isIdentity = bl;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    protected void setType(ColumnBase columnBase) {
        this.nullability = columnBase.nullability;
        this.dataType = columnBase.dataType;
    }

    public void setType(Type type) {
        this.dataType = type;
    }

    public boolean isNullable() {
        return !this.isIdentity && this.nullability == 1;
    }

    protected void setNullable(boolean bl) {
        this.nullability = bl ? (byte)1 : 0;
    }

    public byte getNullability() {
        return this.isIdentity ? (byte)0 : this.nullability;
    }

    public void setNullability(byte by2) {
        this.nullability = by2;
    }

    public boolean isWriteable() {
        return this.isWriteable;
    }

    public void setWriteable(boolean bl) {
        this.isWriteable = bl;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public void setSearchable(boolean bl) {
        this.isSearchable = bl;
    }

    public Type getDataType() {
        return this.dataType;
    }

    public byte getParameterMode() {
        return this.parameterMode;
    }

    public void setParameterMode(byte by2) {
        this.parameterMode = by2;
    }
}

