/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Vector;
import org.hsqldb.Database;
import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Notified;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.HsqlProperties;

public class DatabaseManager {
    private static int dbIDCounter;
    static final HashMap memDatabaseMap;
    static final HashMap fileDatabaseMap;
    static final HashMap resDatabaseMap;
    static final IntKeyHashMap databaseIDMap;
    static final HashMap serverMap;
    private static final HsqlTimer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getDatabaseURIs() {
        Vector<String> vector = new Vector<String>();
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator iterator2 = databaseIDMap.values().iterator();
            while (iterator2.hasNext()) {
                Database database = (Database)iterator2.next();
                vector.addElement(database.getURI());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDatabases(int n) {
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator iterator2 = databaseIDMap.values().iterator();
            while (iterator2.hasNext()) {
                Database database = (Database)iterator2.next();
                try {
                    database.close(n);
                }
                catch (HsqlException hsqlException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session newSession(int n, String string2, String string3, String string4, int n2) {
        Database database = null;
        Object object = databaseIDMap;
        synchronized (object) {
            database = (Database)databaseIDMap.get(n);
        }
        if (database == null) {
            return null;
        }
        object = database.connect(string2, string3, string4, n2);
        ((Session)object).isNetwork = true;
        return object;
    }

    public static Session newSession(String string2, String string3, String string4, String string5, HsqlProperties hsqlProperties, String string6, int n) {
        Database database = DatabaseManager.getDatabase(string2, string3, hsqlProperties);
        return database.connect(string4, string5, string6, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(int n, long l) {
        Database database = null;
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            database = (Database)databaseIDMap.get(n);
        }
        return database == null ? null : database.sessionManager.getSession(l);
    }

    public static int getDatabase(String string2, String string3, Notified notified, HsqlProperties hsqlProperties) {
        Database database = DatabaseManager.getDatabase(string2, string3, hsqlProperties);
        DatabaseManager.registerServer(notified, database);
        return database.databaseID;
    }

    public static Database getDatabase(int n) {
        return (Database)databaseIDMap.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownDatabases(Notified notified, int n) {
        Object[] objectArray;
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)serverMap.get(notified);
            if (hashSet == null) {
                objectArray = new Database[]{};
            } else {
                objectArray = new Database[hashSet.size()];
                hashSet.toArray(objectArray);
            }
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((Database)objectArray[i]).close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String string2, String string3, HsqlProperties hsqlProperties) {
        Database database;
        DatabaseType databaseType = DatabaseType.get(string2);
        Database database2 = database = DatabaseManager.getDatabaseObject(databaseType, string3, hsqlProperties);
        synchronized (database2) {
            switch (database.getState()) {
                case 1: {
                    break;
                }
                case 4: {
                    if (DatabaseManager.lookupDatabaseObject(databaseType, string3) == null) {
                        DatabaseManager.addDatabaseObject(databaseType, string3, database);
                    }
                    database.open();
                    break;
                }
                case 2: 
                case 3: {
                    throw Error.error(451, 23);
                }
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Database getDatabaseObject(DatabaseType databaseType, String string2, HsqlProperties hsqlProperties) {
        Object object;
        Database database;
        HashMap hashMap;
        String string3 = string2;
        block2 : switch (databaseType) {
            case DB_FILE: {
                hashMap = fileDatabaseMap;
                string3 = DatabaseManager.filePathToKey(string2);
                database = (Database)hashMap.get(string3);
                if (database != null || hashMap.size() <= 0) break;
                object = hashMap.keySet().iterator();
                while (object.hasNext()) {
                    String string4 = (String)object.next();
                    if (!string3.equalsIgnoreCase(string4)) continue;
                    string3 = string4;
                    break block2;
                }
                break;
            }
            case DB_RES: {
                hashMap = resDatabaseMap;
                break;
            }
            case DB_MEM: {
                hashMap = memDatabaseMap;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DatabaseManager");
            }
        }
        if ((database = (Database)hashMap.get(string3)) == null) {
            database = new Database(databaseType, string2, string3, hsqlProperties);
            database.databaseID = dbIDCounter;
            object = databaseIDMap;
            synchronized (object) {
                databaseIDMap.put(dbIDCounter, database);
                ++dbIDCounter;
            }
            hashMap.put(string3, database);
        }
        return database;
    }

    public static synchronized Database lookupDatabaseObject(DatabaseType databaseType, String string2) {
        HashMap hashMap;
        String string3 = string2;
        if (databaseType == DatabaseType.DB_FILE) {
            hashMap = fileDatabaseMap;
            string3 = DatabaseManager.filePathToKey(string2);
        } else if (databaseType == DatabaseType.DB_RES) {
            hashMap = resDatabaseMap;
        } else if (databaseType == DatabaseType.DB_MEM) {
            hashMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(201, "DatabaseManager");
        }
        return (Database)hashMap.get(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addDatabaseObject(DatabaseType databaseType, String string2, Database database) {
        HashMap hashMap;
        String string3 = string2;
        if (databaseType == DatabaseType.DB_FILE) {
            hashMap = fileDatabaseMap;
            string3 = DatabaseManager.filePathToKey(string2);
        } else if (databaseType == DatabaseType.DB_RES) {
            hashMap = resDatabaseMap;
        } else if (databaseType == DatabaseType.DB_MEM) {
            hashMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(201, "DatabaseManager");
        }
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            databaseIDMap.put(database.databaseID, database);
        }
        hashMap.put(string3, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDatabase(Database database) {
        HashMap hashMap;
        String string2;
        int n = database.databaseID;
        DatabaseType databaseType = database.getType();
        String string3 = string2 = database.getPath();
        DatabaseManager.notifyServers(database);
        if (databaseType == DatabaseType.DB_FILE) {
            hashMap = fileDatabaseMap;
            string3 = DatabaseManager.filePathToKey(string2);
        } else if (databaseType == DatabaseType.DB_RES) {
            hashMap = resDatabaseMap;
        } else if (databaseType == DatabaseType.DB_MEM) {
            hashMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(201, "DatabaseManager");
        }
        boolean bl = false;
        BaseHashMap baseHashMap = databaseIDMap;
        synchronized (baseHashMap) {
            databaseIDMap.remove(n);
            bl = databaseIDMap.isEmpty();
        }
        baseHashMap = hashMap;
        synchronized (baseHashMap) {
            hashMap.remove(string3);
        }
        if (bl) {
            ValuePool.resetPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deRegisterServer(Notified notified) {
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            serverMap.remove(notified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerServer(Notified notified, Database database) {
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            if (!serverMap.containsKey(notified)) {
                serverMap.put(notified, new HashSet());
            }
            HashSet hashSet = (HashSet)serverMap.get(notified);
            hashSet.add(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServers(Database database) {
        Object[] objectArray;
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            objectArray = new Notified[serverMap.size()];
            serverMap.keysToArray(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            HashSet hashSet;
            Object object = objectArray[i];
            boolean bl = false;
            BaseHashMap baseHashMap = serverMap;
            synchronized (baseHashMap) {
                hashSet = (HashSet)serverMap.get(object);
            }
            if (hashSet != null) {
                baseHashMap = hashSet;
                synchronized (baseHashMap) {
                    bl = hashSet.remove(database);
                }
            }
            if (!bl) continue;
            object.notify(database.databaseID);
        }
    }

    static boolean isServerDB(Database database) {
        Iterator iterator2 = serverMap.keySet().iterator();
        while (iterator2.hasNext()) {
            Notified notified = (Notified)iterator2.next();
            HashSet hashSet = (HashSet)serverMap.get(notified);
            if (!hashSet.contains(database)) continue;
            return true;
        }
        return false;
    }

    public static HsqlTimer getTimer() {
        return timer;
    }

    private static String filePathToKey(String string2) {
        try {
            return FileUtil.getFileUtil().canonicalPath(string2);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    static {
        memDatabaseMap = new HashMap();
        fileDatabaseMap = new HashMap();
        resDatabaseMap = new HashMap();
        databaseIDMap = new IntKeyHashMap();
        serverMap = new HashMap();
        timer = new HsqlTimer();
    }
}

