/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.error.Error;
import org.hsqldb.result.Result;

public class HsqlException
extends RuntimeException {
    public static final HsqlException[] emptyArray = new HsqlException[0];
    public static final HsqlException noDataCondition = Error.error(1100);
    private String message;
    private String state;
    private int code;
    private int level;
    private int statementGroup;
    private int statementCode;
    public Object info;

    public HsqlException(Throwable throwable, String string2, String string3, int n) {
        super(throwable);
        this.message = string2;
        this.state = string3;
        this.code = n;
    }

    public HsqlException(Result result2) {
        this.message = result2.getMainString();
        this.state = result2.getSubString();
        this.code = result2.getErrorCode();
    }

    public HsqlException(Throwable throwable, String string2, int n) {
        super(throwable);
        this.message = throwable.toString();
        this.state = string2;
        this.code = n;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string2) {
        this.message = string2;
    }

    public String getSQLState() {
        return this.state;
    }

    public int getErrorCode() {
        return this.code;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public int getStatementCode() {
        return this.statementCode;
    }

    public void setStatementType(int n, int n2) {
        this.statementGroup = n;
        this.statementCode = n2;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object object) {
        if (object instanceof HsqlException) {
            HsqlException hsqlException = (HsqlException)object;
            return this.code == hsqlException.code && HsqlException.equals(this.state, hsqlException.state) && HsqlException.equals(this.message, hsqlException.message);
        }
        return false;
    }

    private static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static class HsqlRuntimeMemoryError
    extends OutOfMemoryError {
        HsqlRuntimeMemoryError() {
        }
    }
}

