/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Token;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class ParserBase {
    protected Scanner scanner;
    protected Token token;
    private final Token dummyToken = new Token();
    protected int parsePosition;
    protected HsqlException lastError;
    protected HsqlNameManager.HsqlName lastSynonym;
    protected boolean isCheckOrTriggerCondition;
    protected boolean isSchemaDefinition;
    protected boolean isViewDefinition;
    protected boolean isRecording;
    protected HsqlArrayList recordedStatement;
    static final BigDecimal LONG_MAX_VALUE_INCREMENT = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L));
    private static final IntKeyIntValueHashMap expressionTypeMap = new IntKeyIntValueHashMap(37);

    ParserBase(Scanner scanner) {
        this.scanner = scanner;
        this.token = scanner.token;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public int getParsePosition() {
        return this.parsePosition;
    }

    public void setParsePosition(int n) {
        this.parsePosition = n;
    }

    void reset(Session session, String string2) {
        this.scanner.reset(session, string2);
        this.parsePosition = 0;
        this.lastError = null;
        this.lastSynonym = null;
        this.isCheckOrTriggerCondition = false;
        this.isSchemaDefinition = false;
        this.isViewDefinition = false;
        this.isRecording = false;
        this.recordedStatement = null;
    }

    int getPosition() {
        return this.scanner.getTokenPosition();
    }

    void rewind(int n) {
        if (n == this.scanner.getTokenPosition()) {
            return;
        }
        this.scanner.position(n);
        if (this.isRecording) {
            int n2;
            for (n2 = this.recordedStatement.size() - 1; n2 >= 0; --n2) {
                Token token = (Token)this.recordedStatement.get(n2);
                if (token.position < n) break;
            }
            this.recordedStatement.setSize(n2 + 1);
        }
        this.read();
    }

    String getLastPart() {
        return this.scanner.getPart(this.parsePosition, this.scanner.getTokenPosition());
    }

    String getLastPart(int n) {
        return this.scanner.getPart(n, this.scanner.getTokenPosition());
    }

    String getLastPartAndCurrent(int n) {
        return this.scanner.getPart(n, this.scanner.getPosition());
    }

    String getStatement(int n, short[] sArray) {
        while (this.token.tokenType != 841 && this.token.tokenType != 914 && ArrayUtil.find(sArray, this.token.tokenType) == -1) {
            this.read();
        }
        String string2 = this.scanner.getPart(n, this.scanner.getTokenPosition());
        return string2;
    }

    String getStatementForRoutine(int n, short[] sArray) {
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        while (true) {
            if (this.token.tokenType == 841) {
                n4 = this.scanner.getTokenPosition();
                n3 = n2;
            } else {
                if (this.token.tokenType == 914) {
                    if (n3 <= 0 || n3 != n2 - 1) break;
                    this.rewind(n4);
                    break;
                }
                if (ArrayUtil.find(sArray, this.token.tokenType) != -1) break;
            }
            this.read();
            ++n2;
        }
        String string2 = this.scanner.getPart(n, this.scanner.getTokenPosition());
        return string2;
    }

    void startRecording() {
        this.recordedStatement = new HsqlArrayList();
        this.recordedStatement.add(this.token.duplicate());
        this.isRecording = true;
    }

    Token getRecordedToken() {
        if (this.isRecording) {
            return (Token)this.recordedStatement.get(this.recordedStatement.size() - 1);
        }
        return this.token.duplicate();
    }

    Token[] getRecordedStatement() {
        this.isRecording = false;
        this.recordedStatement.remove(this.recordedStatement.size() - 1);
        Token[] tokenArray = new Token[this.recordedStatement.size()];
        this.recordedStatement.toArray(tokenArray);
        this.recordedStatement = null;
        return tokenArray;
    }

    void read() {
        this.scanner.scanNext();
        if (this.token.isMalformed) {
            int n = -1;
            switch (this.token.tokenType) {
                case 922: {
                    n = 5587;
                    break;
                }
                case 921: {
                    n = 5588;
                    break;
                }
                case 923: {
                    n = 5586;
                    break;
                }
                case 919: {
                    n = 5584;
                    break;
                }
                case -1: {
                    n = 5582;
                    break;
                }
                case 920: {
                    n = 5585;
                    break;
                }
                case 924: {
                    n = 5589;
                    break;
                }
                case 925: {
                    n = 5583;
                    break;
                }
            }
            throw Error.error(n, this.token.getFullString());
        }
        if (this.isRecording) {
            Token token = this.token.duplicate();
            token.position = this.scanner.getTokenPosition();
            this.recordedStatement.add(token);
        }
    }

    boolean isReservedKey() {
        return this.token.isReservedIdentifier;
    }

    boolean isCoreReservedKey() {
        return this.token.isCoreReservedIdentifier;
    }

    boolean isNonReservedIdentifier() {
        return !this.token.isReservedIdentifier && (this.token.isUndelimitedIdentifier || this.token.isDelimitedIdentifier);
    }

    void checkIsNonReservedIdentifier() {
        if (!this.isNonReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isNonCoreReservedIdentifier() {
        return !this.token.isCoreReservedIdentifier && (this.token.isUndelimitedIdentifier || this.token.isDelimitedIdentifier);
    }

    void checkIsNonCoreReservedIdentifier() {
        if (!this.isNonCoreReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    void checkIsIrregularCharInIdentifier() {
        if (this.token.hasIrregularChar) {
            throw this.unexpectedToken();
        }
    }

    boolean isIdentifier() {
        return this.token.isUndelimitedIdentifier || this.token.isDelimitedIdentifier;
    }

    void checkIsIdentifier() {
        if (!this.isIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isDelimitedIdentifier() {
        return this.token.isDelimitedIdentifier;
    }

    void checkIsDelimitedIdentifier() {
        if (!this.token.isDelimitedIdentifier) {
            throw Error.error(5569);
        }
    }

    void checkIsUndelimitedIdentifier() {
        if (!this.token.isUndelimitedIdentifier) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue() {
        if (this.token.tokenType != 911) {
            throw this.unexpectedToken();
        }
    }

    void checkIsQuotedString() {
        if (this.token.tokenType != 911 || !this.token.dataType.isCharacterType()) {
            throw this.unexpectedToken();
        }
    }

    void checkIsThis(int n) {
        if (this.token.tokenType != n) {
            String string2 = Tokens.getKeyword(n);
            throw this.unexpectedTokenRequire(string2);
        }
    }

    boolean isUndelimitedSimpleName() {
        return this.token.isUndelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isDelimitedSimpleName() {
        return this.token.isDelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isSimpleName() {
        return this.isNonCoreReservedIdentifier() && this.token.namePrefix == null;
    }

    void checkIsSimpleName() {
        if (!this.isSimpleName()) {
            throw this.unexpectedToken();
        }
    }

    void readUnquotedIdentifier(String string2) {
        this.checkIsSimpleName();
        if (!this.token.tokenString.equals(string2)) {
            throw this.unexpectedToken();
        }
        this.read();
    }

    String readQuotedString() {
        this.checkIsValue();
        if (!this.token.dataType.isCharacterType()) {
            throw Error.error(5563);
        }
        String string2 = this.token.tokenString;
        this.read();
        return string2;
    }

    void readThis(int n) {
        if (this.token.tokenType != n) {
            String string2 = Tokens.getKeyword(n);
            throw this.unexpectedTokenRequire(string2);
        }
        this.read();
    }

    boolean readIfThis(int n) {
        if (this.token.tokenType == n) {
            this.read();
            return true;
        }
        return false;
    }

    void readThis(String string2) {
        if (!string2.equals(this.token.tokenString)) {
            String string3 = string2;
            throw this.unexpectedTokenRequire(string3);
        }
        this.read();
    }

    boolean readIfThis(String string2) {
        if (string2.equals(this.token.tokenString)) {
            this.read();
            return true;
        }
        return false;
    }

    Integer readIntegerObject() {
        int n = this.readInteger();
        return ValuePool.getInt(n);
    }

    int readInteger() {
        boolean bl = false;
        if (this.token.tokenType == 834) {
            bl = true;
            this.read();
        }
        this.checkIsValue();
        if (bl && this.token.dataType.typeCode == 25 && ((Number)this.token.tokenValue).longValue() == 0x80000000L) {
            this.read();
            return Integer.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4) {
            throw Error.error(5563);
        }
        int n = ((Number)this.token.tokenValue).intValue();
        if (bl) {
            n = -n;
        }
        this.read();
        return n;
    }

    long readBigint() {
        boolean bl = false;
        if (this.token.tokenType == 834) {
            bl = true;
            this.read();
        }
        this.checkIsValue();
        if (bl && this.token.dataType.typeCode == 2 && LONG_MAX_VALUE_INCREMENT.equals(this.token.tokenValue)) {
            this.read();
            return Long.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4 && this.token.dataType.typeCode != 25) {
            throw Error.error(5563);
        }
        long l = ((Number)this.token.tokenValue).longValue();
        if (bl) {
            l = -l;
        }
        this.read();
        return l;
    }

    Expression readDateTimeIntervalLiteral(Session session) {
        int n = this.getPosition();
        switch (this.token.tokenType) {
            case 77: {
                this.read();
                if (this.token.tokenType != 911 || !this.token.dataType.isCharacterType()) break;
                String string2 = this.token.tokenString;
                this.read();
                TimestampData timestampData = this.scanner.newDate(string2);
                return new ExpressionValue(timestampData, Type.SQL_DATE);
            }
            case 297: {
                this.read();
                if (this.token.tokenType != 911 || !this.token.dataType.isCharacterType()) break;
                String string3 = this.token.tokenString;
                this.read();
                TimeData timeData = this.scanner.newTime(string3);
                Type type = this.scanner.dateTimeType;
                return new ExpressionValue(timeData, type);
            }
            case 298: {
                this.read();
                if (this.token.tokenType != 911 || !this.token.dataType.isCharacterType()) break;
                String string4 = this.token.tokenString;
                this.read();
                TimestampData timestampData = this.scanner.newTimestamp(string4);
                Type type = this.scanner.dateTimeType;
                return new ExpressionValue(timestampData, type);
            }
            case 150: {
                boolean bl = false;
                this.read();
                if (this.token.tokenType == 834) {
                    this.read();
                    bl = true;
                } else if (this.token.tokenType == 837) {
                    this.read();
                }
                if (this.token.tokenType != 911) break;
                String string5 = this.token.tokenString;
                if (!this.token.dataType.isIntegralType() && !this.token.dataType.isCharacterType()) break;
                this.read();
                IntervalType intervalType = this.readIntervalType(false);
                Object object = this.scanner.newInterval(string5, intervalType);
                intervalType = (IntervalType)this.scanner.dateTimeType;
                if (bl) {
                    object = intervalType.negate(object);
                }
                return new ExpressionValue(object, intervalType);
            }
            default: {
                throw Error.runtimeError(201, "ParserBase");
            }
        }
        this.rewind(n);
        return null;
    }

    IntervalType readIntervalType(boolean bl) {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = n = this.token.tokenType;
        this.read();
        if (this.token.tokenType == 836) {
            this.read();
            n2 = this.readInteger();
            if (n2 <= 0) {
                throw Error.error(5592);
            }
            if (this.token.tokenType == 824) {
                if (n4 != 264) {
                    throw this.unexpectedToken();
                }
                this.read();
                n3 = this.readInteger();
                if (n3 < 0) {
                    throw Error.error(5592);
                }
            }
            this.readThis(822);
        }
        if (this.token.tokenType == 301) {
            this.read();
            n = this.token.tokenType;
            this.read();
        }
        if (this.token.tokenType == 836) {
            if (n != 264 || n == n4) {
                throw this.unexpectedToken();
            }
            this.read();
            n3 = this.readInteger();
            if (n3 < 0) {
                throw Error.error(5592);
            }
            this.readThis(822);
        }
        int n5 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, n4);
        int n6 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, n);
        if (n2 == -1 && bl) {
            n2 = n5 == 5 ? 12 : 9;
        }
        return IntervalType.getIntervalType(n5, n6, n2, n3);
    }

    static int getExpressionType(int n) {
        int n2 = expressionTypeMap.get(n, -1);
        if (n2 == -1) {
            throw Error.runtimeError(201, "ParserBase");
        }
        return n2;
    }

    HsqlException unexpectedToken(String string2) {
        return Error.parseError(5581, string2, this.scanner.getLineNumber());
    }

    HsqlException unexpectedTokenRequire(String string2) {
        if (this.token.tokenType == 914) {
            return Error.parseError(5590, 1, this.scanner.getLineNumber(), new Object[]{"", string2});
        }
        String string3 = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.parseError(5581, 1, this.scanner.getLineNumber(), new Object[]{string3, string2});
    }

    HsqlException unexpectedToken() {
        if (this.token.tokenType == 914) {
            return Error.parseError(5590, null, this.scanner.getLineNumber());
        }
        String string2 = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.parseError(5581, string2, this.scanner.getLineNumber());
    }

    HsqlException tooManyIdentifiers() {
        String string2 = this.token.namePrePrePrefix != null ? this.token.namePrePrePrefix : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString));
        return Error.parseError(5551, string2, this.scanner.getLineNumber());
    }

    HsqlException unsupportedFeature() {
        return Error.error(1551, this.token.tokenString);
    }

    HsqlException unsupportedFeature(String string2) {
        return Error.error(1551, string2);
    }

    public Number convertToNumber(String string2, NumberType numberType) {
        return this.scanner.convertToNumber(string2, numberType);
    }

    static {
        expressionTypeMap.put(417, 40);
        expressionTypeMap.put(829, 43);
        expressionTypeMap.put(832, 44);
        expressionTypeMap.put(830, 41);
        expressionTypeMap.put(833, 45);
        expressionTypeMap.put(835, 46);
        expressionTypeMap.put(56, 71);
        expressionTypeMap.put(173, 74);
        expressionTypeMap.put(178, 73);
        expressionTypeMap.put(289, 72);
        expressionTypeMap.put(17, 75);
        expressionTypeMap.put(105, 76);
        expressionTypeMap.put(6, 77);
        expressionTypeMap.put(272, 77);
        expressionTypeMap.put(283, 78);
        expressionTypeMap.put(284, 79);
        expressionTypeMap.put(325, 80);
        expressionTypeMap.put(326, 81);
        expressionTypeMap.put(9, 82);
        expressionTypeMap.put(719, 83);
        expressionTypeMap.put(634, 85);
    }
}

