/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.constant.Constable;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.RangeGroup;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;

public class ParserCommand
extends ParserDDL {
    ParserCommand(Session session, Scanner scanner) {
        super(session, scanner);
    }

    Statement compileStatement(int n) {
        Statement statement = this.compilePart(n);
        if (this.token.tokenType == 914) {
            if (statement.getSchemaName() == null) {
                statement.setSchemaHsqlName(this.session.getCurrentSchemaHsqlName());
            }
            return statement;
        }
        throw this.unexpectedToken();
    }

    HsqlArrayList compileStatements(String string2, Result result2) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Statement statement = null;
        this.reset(this.session, string2);
        while (this.token.tokenType != 914) {
            try {
                this.lastError = null;
                statement = this.compilePart(result2.getExecuteProperties());
            }
            catch (HsqlException hsqlException) {
                if (this.lastError != null && this.lastError.getLevel() > hsqlException.getLevel()) {
                    throw this.lastError;
                }
                throw hsqlException;
            }
            if (!statement.isExplain && statement.getParametersMetaData().getColumnCount() > 0) {
                throw Error.error(5575);
            }
            statement.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
            hsqlArrayList.add(statement);
        }
        int n = result2.getStatementType();
        if (n != 0) {
            int n2 = statement.getGroup();
            if (n2 == 2003) {
                if (n == 1) {
                    throw Error.error(1253);
                }
            } else if (n == 2) {
                // empty if block
            }
        }
        return hsqlArrayList;
    }

    private Statement compilePart(int n) {
        Statement statement;
        this.compileContext.reset();
        this.setParsePosition(this.getPosition());
        if (this.token.tokenType == 915) {
            this.read();
        }
        switch (this.token.tokenType) {
            case 265: 
            case 294: 
            case 336: 
            case 836: {
                statement = this.compileCursorSpecification(RangeGroup.emptyArray, n, false);
                break;
            }
            case 324: {
                RangeGroup[] rangeGroupArray = this.session.sessionContext.sessionVariableRangeGroups;
                this.compileContext.setOuterRanges(rangeGroupArray);
                statement = this.compileShortCursorSpecification(n);
                break;
            }
            case 145: {
                statement = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 319: {
                statement = this.compileUpdateStatement(RangeGroup.emptyArray);
                break;
            }
            case 176: {
                statement = this.compileMergeStatement(RangeGroup.emptyArray);
                break;
            }
            case 84: {
                statement = this.compileDeleteStatement(RangeGroup.emptyArray);
                break;
            }
            case 311: {
                statement = this.compileTruncateStatement();
                break;
            }
            case 761: {
                statement = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 28: {
                statement = this.compileCallStatement(this.session.sessionContext.sessionVariableRangeGroups, false);
                break;
            }
            case 268: {
                statement = this.compileSet();
                break;
            }
            case 128: {
                statement = this.compileGetStatement(this.session.sessionContext.sessionVariableRangeGroups);
                break;
            }
            case 281: {
                statement = this.compileStartTransaction();
                break;
            }
            case 47: {
                statement = this.compileCommit();
                break;
            }
            case 255: {
                statement = this.compileRollback();
                break;
            }
            case 260: {
                statement = this.compileSavepoint();
                break;
            }
            case 247: {
                statement = this.compileReleaseSavepoint();
                break;
            }
            case 59: {
                statement = this.compileCreate();
                break;
            }
            case 4: {
                statement = this.compileAlter();
                break;
            }
            case 93: {
                statement = this.compileDrop();
                break;
            }
            case 130: 
            case 253: {
                statement = this.compileGrantOrRevoke();
                break;
            }
            case 599: {
                statement = this.compileComment();
                break;
            }
            case 629: {
                statement = this.compileLock();
                break;
            }
            case 50: {
                statement = this.compileConnect();
                break;
            }
            case 89: {
                statement = this.compileDisconnect();
                break;
            }
            case 655: {
                statement = this.compileScript();
                break;
            }
            case 657: {
                statement = this.compileShutdown();
                break;
            }
            case 585: {
                statement = this.compileBackup();
                break;
            }
            case 595: {
                statement = this.compileCheckpoint();
                break;
            }
            case 611: {
                int n2 = this.getPosition();
                statement = this.compileExplainPlan();
                statement.setSQL(this.getLastPart(n2));
                break;
            }
            case 82: {
                statement = this.compileDeclare();
                break;
            }
            case 644: {
                statement = this.compilePerform();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (statement.type) {
            case 14: 
            case 66: 
            case 1093: 
            case 1151: {
                break;
            }
            default: {
                statement.setSQL(this.getLastPart());
            }
        }
        if (this.token.tokenType == 841) {
            this.read();
        } else if (this.token.tokenType == 914) {
            // empty if block
        }
        return statement;
    }

    private Statement compileDeclare() {
        Statement statement = this.compileDeclareLocalTableOrNull();
        if (statement != null) {
            return statement;
        }
        ColumnSchema[] columnSchemaArray = this.readLocalVariableDeclarationOrNull();
        if (columnSchemaArray != null) {
            Object[] objectArray = new Object[]{columnSchemaArray};
            statement = new StatementSession(1127, objectArray);
            return statement;
        }
        statement = this.compileDeclareCursorOrNull(RangeGroup.emptyArray, false);
        if (statement == null) {
            throw this.lastError == null ? this.unexpectedToken() : this.lastError;
        }
        return statement;
    }

    private Statement compileScript() {
        String string2 = null;
        this.read();
        if (this.token.tokenType == 911) {
            string2 = this.readQuotedString();
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{string2};
        return new StatementCommand(1004, objectArray, null, hsqlNameArray);
    }

    private Statement compileConnect() {
        String string2 = null;
        this.read();
        this.readThis(321);
        this.checkIsSimpleName();
        String string3 = this.token.tokenString;
        this.read();
        if (!this.session.isProcessingLog()) {
            this.readThis(643);
            string2 = this.readPassword();
        }
        Expression[] expressionArray = new Expression[]{new ExpressionValue(string3, Type.SQL_VARCHAR), new ExpressionValue(string2, Type.SQL_VARCHAR)};
        StatementSession statementSession = new StatementSession(81, expressionArray);
        return statementSession;
    }

    private StatementCommand compileSetDefault() {
        this.read();
        switch (this.token.tokenType) {
            case 623: {
                this.read();
                this.readThis(519);
                HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{hsqlName};
                return new StatementCommand(1034, objectArray);
            }
            case 250: {
                this.read();
                this.readThis(635);
                this.readThis(259);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1046, objectArray);
            }
            case 294: {
                int n;
                this.read();
                this.readThis(557);
                switch (this.token.tokenType) {
                    case 635: {
                        n = 4;
                        break;
                    }
                    case 593: {
                        n = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                return new StatementCommand(1035, objectArray);
            }
            case 446: {
                int n;
                this.read();
                this.readThis(454);
                switch (this.token.tokenType) {
                    case 502: {
                        this.read();
                        this.readThis(386);
                        n = 2;
                        break;
                    }
                    case 528: {
                        this.read();
                        n = 8;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                return new StatementCommand(1053, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    private StatementCommand compileSetProperty() {
        Object object;
        this.read();
        this.checkIsSimpleName();
        this.checkIsDelimitedIdentifier();
        String string2 = this.token.tokenString;
        this.read();
        if (this.token.tokenType == 310) {
            object = Boolean.TRUE;
        } else if (this.token.tokenType == 114) {
            object = Boolean.FALSE;
        } else {
            this.checkIsValue();
            object = this.token.tokenValue;
        }
        this.read();
        Object[] objectArray = new Object[]{string2, object};
        return new StatementCommand(1039, objectArray);
    }

    private Statement compileSet() {
        this.read();
        switch (this.token.tokenType) {
            case 369: {
                this.read();
                Expression expression2 = this.XreadValueSpecificationOrNull();
                if (expression2 == null) {
                    HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                    Object[] objectArray = new Object[]{hsqlName};
                    return new StatementSession(72, objectArray);
                }
                if (!expression2.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(expression2.getType() == 1 || expression2.getType() == 28 && ((FunctionSQL)expression2).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] expressionArray = new Expression[]{expression2};
                return new StatementSession(72, expressionArray);
            }
            case 519: {
                this.read();
                Expression expression3 = this.XreadValueSpecificationOrNull();
                if (expression3 == null) {
                    HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                    Object[] objectArray = new Object[]{hsqlName};
                    return new StatementSession(80, objectArray);
                }
                if (!expression3.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(expression3.getType() == 1 || expression3.getType() == 28 && ((FunctionSQL)expression3).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] expressionArray = new Expression[]{expression3};
                return new StatementSession(80, expressionArray);
            }
            case 190: {
                Object[] objectArray;
                this.read();
                this.readThis(379);
                HsqlArrayList hsqlArrayList = null;
                if (this.readIfThis(120)) {
                    hsqlArrayList = new HsqlArrayList();
                    while (true) {
                        objectArray = this.readSchemaObjectName(14);
                        hsqlArrayList.add(objectArray);
                        if (this.token.tokenType != 824) break;
                        this.read();
                    }
                }
                objectArray = new Object[]{null, Boolean.FALSE, hsqlArrayList};
                return new StatementSession(83, objectArray);
            }
            case 379: {
                Object[] objectArray;
                this.read();
                Expression expression4 = this.XreadValueSpecificationOrNull();
                if (expression4 == null || !expression4.getDataType().isCharacterType()) {
                    throw Error.error(4650);
                }
                HsqlArrayList hsqlArrayList = null;
                if (this.readIfThis(120)) {
                    hsqlArrayList = new HsqlArrayList();
                    while (true) {
                        objectArray = this.readSchemaObjectName(14);
                        hsqlArrayList.add(objectArray);
                        if (this.token.tokenType != 824) break;
                        this.read();
                    }
                }
                objectArray = new Object[]{expression4, Boolean.TRUE, hsqlArrayList};
                return new StatementSession(83, objectArray);
            }
            case 297: {
                this.read();
                return this.compileSetTimeZone();
            }
            case 512: {
                this.read();
                return this.compileSetRole();
            }
            case 530: {
                this.read();
                return this.compileSessionSettings();
            }
            case 548: {
                this.read();
                Object[] objectArray = this.processTransactionCharacteristics();
                if (objectArray[0] == null && objectArray[1] == null) {
                    throw this.unexpectedToken();
                }
                return new StatementSession(85, objectArray);
            }
            case 583: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(1114, objectArray);
            }
            case 649: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(82, objectArray);
            }
            case 618: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(1048, objectArray);
            }
            case 633: {
                this.read();
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementSession(1116, objectArray);
            }
            case 83: {
                int n;
                this.read();
                this.readThis(294);
                this.readThis(557);
                switch (this.token.tokenType) {
                    case 635: {
                        n = 4;
                        break;
                    }
                    case 593: {
                        n = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                return new StatementCommand(1035, objectArray);
            }
            case 294: {
                return this.compileSetTable();
            }
            case 668: {
                this.read();
                int n = 0;
                if (this.token.tokenType == 310) {
                    n = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 114) {
                    n = 0;
                    this.read();
                } else {
                    n = this.readInteger();
                    if (n < 0) {
                        n = 0;
                    }
                    if (this.token.tokenType == 636) {
                        this.read();
                    } else {
                        n *= 1000;
                    }
                }
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1033, objectArray, null, null);
            }
            case 643: {
                Boolean bl = Boolean.FALSE;
                this.read();
                if (this.readIfThis(609)) {
                    bl = Boolean.TRUE;
                }
                String string2 = this.readPassword();
                Object[] objectArray = new Object[]{null, string2, bl};
                StatementCommand statementCommand = new StatementCommand(1093, objectArray);
                String string3 = User.getSetCurrentPasswordDigestSQL(this.database.granteeManager, string2, bl);
                statementCommand.setSQL(string3);
                return statementCommand;
            }
            case 623: {
                this.read();
                this.readThis(519);
                HsqlNameManager.HsqlName hsqlName = this.token.tokenType == 83 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{null, hsqlName};
                return new StatementCommand(1092, objectArray);
            }
            case 614: {
                return this.compileSetFilesProperty();
            }
            case 605: {
                return this.compileSetDatabaseProperty();
            }
            case 647: {
                return this.compileSetProperty();
            }
        }
        return this.compileSetStatement(this.session.sessionContext.sessionVariableRangeGroups, this.session.sessionContext.sessionVariablesRange);
    }

    StatementCommand compileSetTable() {
        this.read();
        Table table = this.readTableName();
        Object[] objectArray = new Object[]{table.getName(), null, null};
        switch (this.token.tokenType) {
            default: {
                throw this.unexpectedToken();
            }
            case 535: {
                this.read();
                return this.compileTableSource(table);
            }
            case 502: {
                this.read();
                boolean bl = false;
                if (this.token.tokenType == 569) {
                    this.read();
                } else {
                    this.readThis(205);
                    bl = true;
                }
                objectArray[1] = bl;
                return new StatementCommand(1154, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 649: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                objectArray[1] = bl;
                return new StatementCommand(1154, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 621: {
                this.read();
                this.checkIsValue();
                String string2 = this.token.tokenString;
                this.read();
                objectArray[1] = string2;
                objectArray[2] = 5;
                return new StatementCommand(1153, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 557: {
                int n;
                this.read();
                switch (this.token.tokenType) {
                    case 635: {
                        n = 4;
                        break;
                    }
                    case 593: {
                        n = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                switch (table.getTableType()) {
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                objectArray[1] = n;
                return new StatementCommand(1157, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 598: {
                this.read();
                this.readThis(204);
                OrderedHashSet orderedHashSet = new OrderedHashSet();
                this.readThis(836);
                this.readSimpleColumnNames(orderedHashSet, table, false);
                this.readThis(822);
                int[] nArray = table.getColumnIndexes(orderedHashSet);
                objectArray[1] = nArray;
                return new StatementCommand(1158, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 189: {
                this.read();
                this.readThis(536);
                objectArray = new Object[]{table.getName()};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
                return new StatementCommand(1159, objectArray, null, hsqlNameArray);
            }
            case 536: 
        }
        this.read();
        Integer n = this.readIntegerObject();
        objectArray = new Object[]{table.getName(), n};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementCommand(1160, objectArray, null, hsqlNameArray);
    }

    StatementCommand compileSetDatabaseProperty() {
        this.read();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 584: {
                this.read();
                this.readThis(126);
                Routine routine = this.readCreateDatabaseAuthenticationFunction();
                Object[] objectArray = new Object[]{routine};
                return new StatementCommand(1036, objectArray, null, null);
            }
            case 379: {
                Boolean bl = null;
                this.read();
                this.checkIsSimpleName();
                String string2 = this.token.tokenString;
                this.read();
                if (this.readIfThis(190)) {
                    this.readThis(485);
                    bl = Boolean.FALSE;
                } else if (this.readIfThis(485)) {
                    this.readThis(536);
                    bl = Boolean.TRUE;
                }
                if (bl == null) {
                    bl = this.session.isProcessingScript() && this.database.getProperties().isVersion18() ? Boolean.FALSE : Boolean.TRUE;
                }
                Object[] objectArray = new Object[]{string2, bl};
                return new StatementCommand(1047, objectArray, null, null);
            }
            case 83: {
                return this.compileSetDefault();
            }
            case 610: {
                this.read();
                this.readThis(734);
                boolean bl = this.readIfThis(275);
                this.readThis(454);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n, bl};
                return new StatementCommand(1016, objectArray, null, null);
            }
            case 616: {
                this.read();
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1037, objectArray, null, null);
            }
            case 643: {
                this.read();
                switch (this.token.tokenType) {
                    case 40: {
                        this.read();
                        this.readThis(126);
                        Routine routine = this.readCreatePasswordCheckFunction();
                        Object[] objectArray = new Object[]{routine};
                        return new StatementCommand(1040, objectArray, null, null);
                    }
                    case 609: {
                        this.read();
                        String string3 = this.readQuotedString();
                        Object[] objectArray = new Object[]{string3};
                        return new StatementCommand(1056, objectArray, null, null);
                    }
                }
                throw this.unexpectedToken();
            }
            case 650: {
                this.read();
                this.readThis(620);
                boolean bl = this.processTrueOrFalse();
                Object[] objectArray = new Object[]{bl};
                return new StatementCommand(1049, objectArray, null, null);
            }
            case 275: {
                Object[] objectArray;
                this.read();
                int n = 1050;
                Boolean bl = Boolean.TRUE;
                Integer n2 = 0;
                String string4 = null;
                switch (this.token.tokenType) {
                    case 627: {
                        this.read();
                        this.readThis(475);
                        string4 = "sql.live_object";
                        bl = this.processTrueOrFalseObject();
                        objectArray = new Object[]{string4, bl, n2};
                        break;
                    }
                    case 468: {
                        this.read();
                        string4 = "sql.enforce_names";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 651: {
                        this.read();
                        this.readThis(468);
                        string4 = "sql.regular_names";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 236: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string4 = "sql.enforce_refs";
                        break;
                    }
                    case 534: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string4 = "sql.enforce_size";
                        break;
                    }
                    case 665: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string4 = "sql.enforce_types";
                        break;
                    }
                    case 660: {
                        this.read();
                        if (this.readIfThis(84)) {
                            string4 = "sql.enforce_tdc_delete";
                        } else {
                            this.readThis(319);
                            string4 = "sql.enforce_tdc_update";
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 303: {
                        this.read();
                        this.readThis(664);
                        this.readThis(665);
                        bl = this.processTrueOrFalseObject();
                        string4 = "jdbc.translate_tti_types";
                        break;
                    }
                    case 38: {
                        this.read();
                        this.readThis(626);
                        bl = this.processTrueOrFalseObject();
                        string4 = "sql.char_literal";
                        break;
                    }
                    case 687: {
                        this.read();
                        this.readThis(473);
                        bl = this.processTrueOrFalseObject();
                        string4 = "sql.concat_nulls";
                        break;
                    }
                    case 473: {
                        this.read();
                        if (this.readIfThis(423)) {
                            string4 = "sql.nulls_first";
                        } else {
                            this.readThis(208);
                            string4 = "sql.nulls_order";
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 315: {
                        this.read();
                        this.readThis(473);
                        bl = this.processTrueOrFalseObject();
                        string4 = "sql.unique_nulls";
                        break;
                    }
                    case 53: {
                        this.read();
                        this.readThis(311);
                        bl = this.processTrueOrFalseObject();
                        string4 = "sql.convert_trunc";
                        break;
                    }
                    case 17: {
                        this.read();
                        this.readThis(518);
                        n2 = this.readIntegerObject();
                        string4 = "sql.avg_scale";
                        break;
                    }
                    case 92: {
                        this.read();
                        this.readThis(638);
                        bl = this.processTrueOrFalseObject();
                        string4 = "sql.double_nan";
                        break;
                    }
                    case 632: {
                        this.read();
                        this.readThis(152);
                        this.readThis(733);
                        bl = this.processTrueOrFalseObject();
                        string4 = "sql.longvar_is_lob";
                        break;
                    }
                    case 618: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string4 = "sql.ignore_case";
                        break;
                    }
                    case 659: {
                        this.read();
                        if (this.token.tokenString.equals("DB2")) {
                            this.read();
                            string4 = "sql.syntax_db2";
                        } else if (this.token.tokenString.equals("MSS")) {
                            this.read();
                            string4 = "sql.syntax_mss";
                        } else if (this.token.tokenString.equals("MYS")) {
                            this.read();
                            string4 = "sql.syntax_mys";
                        } else if (this.token.tokenString.equals("ORA")) {
                            this.read();
                            string4 = "sql.syntax_ora";
                        } else if (this.token.tokenString.equals("PGS")) {
                            this.read();
                            string4 = "sql.syntax_pgs";
                        } else {
                            throw this.unexpectedToken();
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                objectArray = new Object[]{string4, bl, n2};
                return new StatementCommand(n, objectArray, null, null);
            }
            case 662: {
                this.read();
                this.readThis(294);
                this.readThis(402);
                String string5 = this.readQuotedString();
                Object[] objectArray = new Object[]{string5};
                return new StatementCommand(1051, objectArray, null, null);
            }
            case 548: {
                this.read();
                if (this.readIfThis(255)) {
                    this.readThis(204);
                    if (!this.readIfThis(606)) {
                        this.readThis(602);
                    }
                    Boolean bl = this.processTrueOrFalseObject();
                    StatementCommand statementCommand = new StatementCommand(1054, new Object[]{bl}, null, null);
                    return statementCommand;
                }
                this.readThis(603);
                int n = 0;
                switch (this.token.tokenType) {
                    case 742: {
                        this.read();
                        n = 2;
                        break;
                    }
                    case 743: {
                        this.read();
                        n = 1;
                        break;
                    }
                    case 630: {
                        this.read();
                        n = 0;
                        break;
                    }
                }
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                StatementCommand statementCommand = new StatementCommand(1052, objectArray, null, hsqlNameArray);
                return statementCommand;
            }
            case 315: {
                this.read();
                this.readThis(467);
                if (!this.isUndelimitedSimpleName()) {
                    throw this.unexpectedToken();
                }
                String string6 = this.token.tokenString;
                this.read();
                if (string6.length() != 16) {
                    throw Error.error(5555);
                }
                if (!Charset.isInSet(string6, Charset.unquotedIdentifier) || !Charset.startsWith(string6, Charset.uppercaseLetters)) {
                    throw Error.error(5501);
                }
                Object[] objectArray = new Object[]{string6};
                return new StatementCommand(1055, objectArray, null, null);
            }
        }
        throw this.unexpectedToken();
    }

    StatementCommand compileSetFilesProperty() {
        this.read();
        int n = 0;
        Boolean bl = null;
        Integer n2 = null;
        Boolean bl2 = null;
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 40: {
                this.read();
                long l = this.readBigint();
                long l2 = -1L;
                n = 1014;
                hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
                if (this.readIfThis(824)) {
                    l2 = this.readBigint();
                }
                Object[] objectArray = new Object[]{l, l2};
                return new StatementCommand(n, objectArray, null, hsqlNameArray);
            }
            case 592: {
                this.read();
                if (this.readIfThis(534)) {
                    n2 = this.readIntegerObject();
                    n = 1013;
                } else {
                    this.readThis(259);
                    n2 = this.readIntegerObject();
                    n = 1012;
                }
                if (!this.readIfThis(190)) break;
                this.readThis(40);
                bl2 = Boolean.TRUE;
                break;
            }
            case 518: {
                this.read();
                n2 = this.readIntegerObject();
                n = 1025;
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 536: {
                this.read();
                if (this.token.tokenType == 310) {
                    bl = Boolean.TRUE;
                    this.read();
                } else if (this.token.tokenType == 114) {
                    bl = Boolean.FALSE;
                    this.read();
                } else {
                    n2 = this.readIntegerObject();
                }
                n = 1031;
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 733: {
                this.read();
                if (this.readIfThis(518)) {
                    n2 = this.readIntegerObject();
                    n = 1017;
                } else {
                    this.readThis(601);
                    n = 1018;
                    bl = this.processTrueOrFalseObject();
                }
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 607: {
                this.read();
                n = 1015;
                n2 = this.readIntegerObject();
                break;
            }
            case 746: {
                this.read();
                if (this.readIfThis(534)) {
                    n2 = this.readIntegerObject();
                } else {
                    bl = this.processTrueOrFalseObject();
                }
                n = 1022;
                break;
            }
            case 585: {
                this.read();
                n = 1011;
                this.readThis(439);
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 734: {
                this.read();
                if (this.readIfThis(534)) {
                    n = 1021;
                    n2 = this.readIntegerObject();
                    break;
                }
                n = 1020;
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 661: {
                this.read();
                this.readThis(494);
                n = 1032;
                n2 = this.readIntegerObject();
                break;
            }
            case 569: {
                this.read();
                this.readThis(608);
                n = 1033;
                int n3 = 0;
                if (this.token.tokenType == 310) {
                    n3 = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 114) {
                    n3 = 0;
                    this.read();
                } else {
                    n3 = this.readInteger();
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (this.token.tokenType == 636) {
                        this.read();
                    } else {
                        n3 *= 1000;
                    }
                }
                n2 = n3;
                break;
            }
            case 655: {
                this.read();
                this.readThis(615);
                if (this.token.tokenType == 662) {
                    this.read();
                    n2 = 0;
                } else {
                    this.readThis(601);
                    n2 = 3;
                }
                n = 1026;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] objectArray = new Object[]{bl == null ? (Constable)n2 : (Constable)bl, bl2};
        return new StatementCommand(n, objectArray, null, hsqlNameArray);
    }

    Object[] processTransactionCharacteristics() {
        int n = 0;
        boolean bl = false;
        Object[] objectArray = new Object[2];
        block10: while (true) {
            switch (this.token.tokenType) {
                case 502: {
                    if (objectArray[0] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 205) {
                        this.read();
                        bl = true;
                    } else {
                        this.readThis(569);
                        bl = false;
                    }
                    objectArray[0] = bl;
                    continue block10;
                }
                case 446: {
                    if (objectArray[1] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(454);
                    switch (this.token.tokenType) {
                        case 528: {
                            this.read();
                            n = 8;
                            break;
                        }
                        case 502: {
                            this.read();
                            if (this.token.tokenType == 386) {
                                this.read();
                                n = 2;
                                break;
                            }
                            if (this.token.tokenType == 559) {
                                this.read();
                                n = 1;
                                break;
                            }
                            throw this.unexpectedToken();
                        }
                        case 504: {
                            this.read();
                            this.readThis(502);
                            n = 4;
                            break;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                    objectArray[1] = n;
                    continue block10;
                }
                case 824: {
                    if (objectArray[0] == null && objectArray[1] == null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block10;
                }
            }
            break;
        }
        if (!bl && n == 1) {
            throw this.unexpectedToken("WRITE");
        }
        return objectArray;
    }

    private Statement compileCommit() {
        boolean bl = false;
        this.read();
        this.readIfThis(568);
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 190) {
                this.read();
            } else {
                bl = true;
            }
            this.readThis(371);
        }
        String string2 = bl ? StatementSession.commitAndChainStatement.sql : StatementSession.commitNoChainStatement.sql;
        StatementSession statementSession = new StatementSession(14, new Object[]{bl});
        statementSession.setSQL(string2);
        return statementSession;
    }

    private Statement compileStartTransaction() {
        this.read();
        this.readThis(548);
        Object[] objectArray = this.processTransactionCharacteristics();
        StatementSession statementSession = new StatementSession(86, objectArray);
        return statementSession;
    }

    private Statement compileLock() {
        this.read();
        if (this.readIfThis(369)) {
            return this.compileLockCatalog();
        }
        this.readThis(294);
        return this.compileLockTable();
    }

    private Statement compileLockCatalog() {
        boolean bl = this.processTrueOrFalse();
        int n = bl ? 1111 : 1112;
        HsqlNameManager.HsqlName[] hsqlNameArray = bl ? this.database.schemaManager.getCatalogAndBaseTableNames() : null;
        StatementSession statementSession = new StatementSession(n, null, hsqlNameArray);
        return statementSession;
    }

    private Statement compileLockTable() {
        Object[] objectArray;
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        while (true) {
            objectArray = this.readTableName(true);
            switch (this.token.tokenType) {
                case 502: {
                    this.read();
                    orderedHashSet.add(objectArray.getName());
                    break;
                }
                case 569: {
                    this.read();
                    orderedHashSet2.add(objectArray.getName());
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (this.token.tokenType != 824) break;
            this.read();
        }
        objectArray = new HsqlNameManager.HsqlName[orderedHashSet2.size()];
        orderedHashSet2.toArray(objectArray);
        orderedHashSet.removeAll(objectArray);
        Object[] objectArray2 = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray2);
        StatementSession statementSession = new StatementSession(1113, (HsqlNameManager.HsqlName[])objectArray2, (HsqlNameManager.HsqlName[])objectArray);
        return statementSession;
    }

    private Statement compileRollback() {
        boolean bl = false;
        String string2 = null;
        this.read();
        if (this.token.tokenType == 568) {
            this.read();
        }
        if (this.token.tokenType == 301) {
            this.read();
            this.readThis(260);
            this.checkIsSimpleName();
            string2 = this.token.tokenString;
            this.read();
            Object[] objectArray = new Object[]{string2};
            StatementSession statementSession = new StatementSession(1118, objectArray);
            return statementSession;
        }
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 190) {
                this.read();
            } else {
                bl = true;
            }
            this.readThis(371);
        }
        String string3 = bl ? StatementSession.rollbackAndChainStatement.sql : StatementSession.rollbackNoChainStatement.sql;
        StatementSession statementSession = new StatementSession(66, new Object[]{bl});
        statementSession.setSQL(string3);
        return statementSession;
    }

    private Statement compileSavepoint() {
        this.read();
        this.checkIsSimpleName();
        String string2 = this.token.tokenString;
        this.read();
        Object[] objectArray = new Object[]{string2};
        return new StatementSession(67, objectArray);
    }

    private Statement compileReleaseSavepoint() {
        this.read();
        this.readThis(260);
        String string2 = this.token.tokenString;
        this.read();
        Object[] objectArray = new Object[]{string2};
        return new StatementSession(61, objectArray);
    }

    private Statement compileSessionSettings() {
        switch (this.token.tokenType) {
            case 375: {
                this.read();
                this.readThis(11);
                this.readThis(548);
                Object[] objectArray = this.processTransactionCharacteristics();
                return new StatementSession(82, objectArray);
            }
            case 16: {
                this.read();
                Expression expression2 = this.XreadValueSpecificationOrNull();
                if (expression2 == null) {
                    throw Error.error(5584);
                }
                expression2.resolveTypes(this.session, null);
                if (expression2.isUnresolvedParam()) {
                    expression2.dataType = Type.SQL_VARCHAR;
                }
                if (expression2.dataType == null || !expression2.dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                Expression[] expressionArray = new Expression[]{expression2, null};
                return new StatementSession(81, expressionArray);
            }
            case 250: {
                this.read();
                this.readThis(635);
                this.readThis(259);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementSession(1117, objectArray);
            }
            case 612: {
                this.read();
                String string2 = this.parseSQLFeatureValue();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{string2, bl};
                return new StatementSession(1115, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileSetRole() {
        Expression expression2;
        if (this.token.tokenType == 191) {
            this.read();
            expression2 = new ExpressionValue(null, Type.SQL_VARCHAR);
        } else {
            expression2 = this.XreadValueSpecificationOrNull();
            if (expression2 == null) {
                throw Error.error(4100);
            }
            if (!expression2.getDataType().isCharacterType()) {
                throw Error.error(2200);
            }
            if (!(expression2.getType() == 1 || expression2.getType() == 28 && ((FunctionSQL)expression2).isValueFunction())) {
                throw Error.error(2200);
            }
        }
        return new StatementSession(79, new Expression[]{expression2});
    }

    private Statement compileSetTimeZone() {
        Expression expression2;
        this.readThis(571);
        if (this.token.tokenType == 167) {
            this.read();
            expression2 = new ExpressionValue(null, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
        } else {
            expression2 = this.XreadIntervalValueExpression();
            HsqlList hsqlList = expression2.resolveColumnReferences(this.session, RangeGroup.emptyGroup, RangeGroup.emptyArray, null);
            ExpressionColumn.checkColumnsResolved(hsqlList);
            expression2.resolveTypes(this.session, null);
            if (expression2.dataType == null) {
                throw Error.error(5563);
            }
            if (expression2.dataType.typeCode != 111) {
                throw Error.error(5563);
            }
        }
        return new StatementSession(76, new Expression[]{expression2});
    }

    private Statement compileShutdown() {
        this.session.checkAdmin();
        int n = 2;
        this.read();
        switch (this.token.tokenType) {
            case 619: {
                n = 1;
                this.read();
                break;
            }
            case 600: {
                n = 3;
                this.read();
                break;
            }
            case 655: {
                n = 4;
                this.read();
                break;
            }
        }
        if (this.token.tokenType == 841) {
            this.read();
        }
        if (this.token.tokenType != 914) {
            throw this.unexpectedToken();
        }
        Object[] objectArray = new Object[]{n};
        StatementCommand statementCommand = new StatementCommand(1003, objectArray, null, null);
        return statementCommand;
    }

    private Statement compileBackup() {
        Boolean bl = null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        Boolean bl4 = null;
        this.read();
        this.readThis(605);
        this.readThis(301);
        String string2 = this.readQuotedString();
        string2 = string2.trim();
        if (string2.length() == 0) {
            throw this.unexpectedToken(string2);
        }
        block7: while (true) {
            switch (this.token.tokenType) {
                case 589: {
                    if (bl != null) {
                        throw this.unexpectedToken();
                    }
                    bl = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 655: {
                    if (bl2 != null) {
                        throw this.unexpectedToken();
                    }
                    bl2 = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 601: {
                    if (bl3 != null) {
                        throw this.unexpectedToken();
                    }
                    bl3 = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 193: {
                    this.read();
                    if (this.token.tokenType == 601) {
                        if (bl3 != null) {
                            throw this.unexpectedToken();
                        }
                        bl3 = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    if (this.token.tokenType == 589) {
                        if (bl != null) {
                            throw this.unexpectedToken();
                        }
                        bl = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    throw this.unexpectedToken();
                }
                case 11: {
                    if (bl4 != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(614);
                    bl4 = Boolean.TRUE;
                    continue block7;
                }
            }
            break;
        }
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        if (bl == null) {
            bl = Boolean.TRUE;
        }
        if (bl3 == null) {
            bl3 = Boolean.TRUE;
        }
        if (bl4 == null) {
            bl4 = Boolean.FALSE;
        }
        if (bl2.booleanValue() && !bl.booleanValue()) {
            throw this.unexpectedToken("NOT");
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = bl != false ? this.database.schemaManager.getCatalogAndBaseTableNames() : HsqlNameManager.HsqlName.emptyArray;
        Object[] objectArray = new Object[]{string2, bl, bl2, bl3, bl4};
        StatementCommand statementCommand = new StatementCommand(1001, objectArray, null, hsqlNameArray);
        return statementCommand;
    }

    private Statement compilePerform() {
        this.read();
        switch (this.token.tokenType) {
            case 40: {
                this.read();
                this.readThis(294);
                Table table = this.readTableName();
                this.readThis(621);
                Object[] objectArray = new Object[]{table.getName(), 1, null};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
                return new StatementCommand(1006, objectArray, null, hsqlNameArray);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileCheckpoint() {
        boolean bl = false;
        this.read();
        if (this.token.tokenType == 607) {
            bl = true;
            this.read();
        } else if (this.token.tokenType == 841) {
            this.read();
        }
        if (this.token.tokenType != 914) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{bl};
        StatementCommand statementCommand = new StatementCommand(1002, objectArray, null, hsqlNameArray);
        return statementCommand;
    }

    public static Statement getAutoCheckpointStatement(Database database) {
        HsqlNameManager.HsqlName[] hsqlNameArray = database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{Boolean.FALSE};
        StatementCommand statementCommand = new StatementCommand(1002, objectArray, null, hsqlNameArray);
        statementCommand.setCompileTimestamp(database.txManager.getGlobalChangeTimestamp());
        statementCommand.setSQL("CHECKPOINT");
        return statementCommand;
    }

    private Statement compileDisconnect() {
        this.read();
        String string2 = "DISCONNECT";
        StatementSession statementSession = new StatementSession(22, (Object[])null);
        return statementSession;
    }

    private Statement compileExplainPlan() {
        this.read();
        this.readThis(645);
        this.readThis(120);
        Statement statement = this.compilePart(0);
        statement.setDescribe();
        return new StatementCommand(1151, new Object[]{statement});
    }

    private StatementCommand compileTableSource(Table table) {
        String string2;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = new Object[5];
        objectArray[0] = table.getName();
        if (!table.isText()) {
            object = Error.error(321);
        }
        if (this.token.tokenType == 204) {
            this.read();
            object = this.getLastPart();
            objectArray[1] = Boolean.TRUE;
            return new StatementCommand(1155, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
        }
        if (this.token.tokenType == 642) {
            this.read();
            object = this.getLastPart();
            objectArray[1] = Boolean.FALSE;
            return new StatementCommand(1155, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
        }
        if (this.token.tokenType == 617) {
            this.read();
            bl = true;
        }
        if (this.token.tokenType == 913) {
            string2 = this.token.tokenString;
            this.read();
        } else {
            string2 = this.readQuotedString();
        }
        if (!bl && this.token.tokenType == 410) {
            bl2 = true;
            this.read();
        }
        object = this.getLastPart();
        objectArray[2] = string2;
        objectArray[3] = bl2;
        objectArray[4] = bl;
        int n = bl ? 1156 : 1155;
        return new StatementCommand(n, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
    }
}

