/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class QuerySpecification
extends QueryExpression {
    public int resultRangePosition;
    public boolean isDistinctSelect;
    public boolean isAggregated;
    public boolean isGrouped;
    public boolean isOrderSensitive;
    public boolean isSimpleDistinct;
    RangeVariable[] rangeVariables;
    private HsqlArrayList rangeVariableList;
    int startInnerRange = -1;
    int endInnerRange = -1;
    Expression queryCondition;
    Expression checkQueryCondition;
    private Expression havingCondition;
    Expression rowExpression;
    Expression[] exprColumns;
    HsqlArrayList exprColumnList;
    public int indexLimitVisible;
    private int indexLimitRowId;
    private int groupByColumnCount;
    private int havingColumnCount;
    private int indexStartHaving;
    public int indexStartOrderBy;
    public int indexStartAggregates;
    private int indexLimitExpressions;
    public int indexLimitData;
    private boolean hasRowID;
    private boolean isSimpleCount;
    private boolean isSingleMemoryTable;
    public boolean isUniqueResultRows;
    Type[] resultColumnTypes;
    private ArrayListIdentity aggregateSet;
    private ArrayListIdentity resolvedSubqueryExpressions = null;
    private boolean[] aggregateCheck;
    private OrderedHashSet tempSet = new OrderedHashSet();
    int[] columnMap;
    private Table baseTable;
    private OrderedHashSet conditionTables;
    public Index groupIndex;
    private RangeGroup[] outerRanges;

    QuerySpecification(Session session, Table table, ParserDQL.CompileContext compileContext, boolean bl) {
        this(compileContext);
        this.isValueList = bl;
        RangeVariable rangeVariable = new RangeVariable(table, null, null, null, compileContext);
        rangeVariable.addTableColumns(this.exprColumnList, 0, null);
        this.indexLimitVisible = this.exprColumnList.size();
        this.addRangeVariable(session, rangeVariable);
        this.sortAndSlice = SortAndSlice.noSort;
        this.isBaseMergeable = true;
        this.isMergeable = true;
        this.isTable = true;
    }

    QuerySpecification(ParserDQL.CompileContext compileContext) {
        super(compileContext);
        this.resultRangePosition = compileContext.getNextRangeVarIndex();
        this.rangeVariableList = new HsqlArrayList();
        this.exprColumnList = new HsqlArrayList();
        this.sortAndSlice = SortAndSlice.noSort;
        this.isBaseMergeable = true;
        this.isMergeable = true;
    }

    void addRangeVariable(Session session, RangeVariable rangeVariable) {
        this.rangeVariableList.add(rangeVariable);
    }

    public TableDerived getValueListTable() {
        if (this.isValueList) {
            RangeVariable rangeVariable = null;
            if (this.rangeVariables == null) {
                if (this.rangeVariableList.size() == 1) {
                    rangeVariable = (RangeVariable)this.rangeVariableList.get(0);
                }
            } else if (this.rangeVariables.length == 1) {
                rangeVariable = this.rangeVariables[0];
            }
            if (rangeVariable != null) {
                return (TableDerived)rangeVariable.getTable();
            }
        }
        return null;
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }

    public int getCurrentRangeVariableCount() {
        return this.rangeVariableList.size();
    }

    private void resolveRangeVariables(Session session, RangeGroup[] rangeGroupArray) {
        if (this.rangeVariables == null || this.rangeVariables.length < this.rangeVariableList.size()) {
            this.rangeVariables = new RangeVariable[this.rangeVariableList.size()];
            this.rangeVariableList.toArray(this.rangeVariables);
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            RangeGroup rangeGroup;
            if (this.rangeVariables[i].isLateral) {
                RangeVariable[] rangeVariableArray = (RangeVariable[])ArrayUtil.resizeArray(this.rangeVariables, i);
                rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariableArray, this);
            } else {
                rangeGroup = rangeGroupArray == RangeGroup.emptyArray ? RangeGroup.emptyGroup : new RangeGroup.RangeGroupSimple(RangeVariable.emptyArray, this);
            }
            this.rangeVariables[i].resolveRangeTable(session, rangeGroup, rangeGroupArray);
        }
    }

    void addSelectColumnExpression(Expression expression2) {
        if (expression2.getType() == 25) {
            throw Error.error(5564);
        }
        if (this.indexLimitVisible > 0) {
            if (expression2.opType == 93 && ((ExpressionColumn)expression2).getTableName() == null) {
                throw Error.error(5578);
            }
            Expression expression3 = (Expression)this.exprColumnList.get(0);
            if (expression3.opType == 93 && ((ExpressionColumn)expression3).getTableName() == null) {
                throw Error.error(5578);
            }
        }
        this.exprColumnList.add(expression2);
        ++this.indexLimitVisible;
    }

    void addQueryCondition(Expression expression2) {
        this.queryCondition = expression2;
    }

    void addGroupByColumnExpression(Expression expression2) {
        if (expression2.getType() == 25) {
            throw Error.error(5564);
        }
        this.exprColumnList.add(expression2);
        this.isGrouped = true;
        ++this.groupByColumnCount;
    }

    void addHavingExpression(Expression expression2) {
        this.exprColumnList.add(expression2);
        this.havingCondition = expression2;
        this.havingColumnCount = 1;
    }

    @Override
    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
    }

    @Override
    public void resolveReferences(Session session, RangeGroup[] rangeGroupArray) {
        if (this.isReferencesResolved) {
            return;
        }
        this.outerRanges = rangeGroupArray;
        this.resolveRangeVariables(session, rangeGroupArray);
        this.resolveColumnReferencesForAsterisk();
        this.finaliseColumns();
        this.resolveColumnReferences(session, rangeGroupArray);
        this.setReferenceableColumns();
        Expression.resolveColumnSet(session, RangeVariable.emptyArray, rangeGroupArray, this.unresolvedExpressions);
        this.unionColumnTypes = new Type[this.indexLimitVisible];
        this.isReferencesResolved = true;
    }

    @Override
    public boolean hasReference(RangeVariable rangeVariable) {
        if (this.unresolvedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.unresolvedExpressions.size(); ++i) {
            if (!((Expression)this.unresolvedExpressions.get(i)).hasReference(rangeVariable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areColumnsResolved() {
        return super.areColumnsResolved();
    }

    @Override
    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        this.resolveTypesPartThree(session);
        ArrayUtil.copyArray(this.resultTable.colTypes, this.unionColumnTypes, this.unionColumnTypes.length);
    }

    @Override
    void resolveTypesPartOne(Session session) {
        if (this.isPartOneResolved) {
            return;
        }
        this.resolveExpressionTypes(session);
        this.resolveAggregates();
        for (int i = 0; i < this.unionColumnTypes.length; ++i) {
            this.unionColumnTypes[i] = Type.getAggregateType(this.unionColumnTypes[i], this.exprColumns[i].getDataType());
        }
        this.isPartOneResolved = true;
    }

    @Override
    void resolveTypesPartTwoRecursive(Session session) {
        for (int i = 0; i < this.unionColumnTypes.length; ++i) {
            Type type = this.unionColumnTypes[i];
            this.exprColumns[i].setDataType(session, type);
        }
        this.setResultColumnTypes();
        this.createResultMetaData(session);
        this.createTable(session);
    }

    @Override
    void resolveTypesPartTwo(Session session) {
        int n;
        if (this.isPartTwoResolved) {
            return;
        }
        this.resolveGroups();
        for (n = 0; n < this.unionColumnTypes.length; ++n) {
            Type type = this.unionColumnTypes[n];
            if (type == null) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5567);
                }
                this.unionColumnTypes[n] = type = Type.SQL_VARCHAR_DEFAULT;
            }
            this.exprColumns[n].setDataType(session, type);
            if (!this.exprColumns[n].dataType.isArrayType() || this.exprColumns[n].dataType.collectionBaseType() != null) continue;
            throw Error.error(5567);
        }
        for (n = this.indexLimitVisible; n < this.indexStartHaving; ++n) {
            if (this.exprColumns[n].dataType != null) continue;
            throw Error.error(5567);
        }
        this.checkLobUsage();
        this.setMergeability();
        this.setUpdatability();
        this.setResultColumnTypes();
        this.createResultMetaData(session);
        this.createTable(session);
        this.mergeQuery();
        this.isPartTwoResolved = true;
    }

    @Override
    void resolveTypesPartThree(Session session) {
        if (this.isResolved) {
            return;
        }
        this.sortAndSlice.setSortIndex(this);
        this.setRangeVariableConditions(session);
        this.setDistinctConditions(session);
        this.setAggregateConditions(session);
        this.sortAndSlice.setSortRange(this);
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].resolveRangeTableTypes(session, this.rangeVariables);
        }
        this.setResultNullability();
        this.rangeVariableList = null;
        this.tempSet = null;
        this.compileContext = null;
        this.outerRanges = null;
        this.isResolved = true;
    }

    @Override
    public void addExtraConditions(Expression expression2) {
        if (this.isAggregated || this.isGrouped) {
            return;
        }
        this.queryCondition = ExpressionLogical.andExpressions(this.queryCondition, expression2);
    }

    private void resolveColumnReferences(Session session, RangeGroup[] rangeGroupArray) {
        Object object;
        int n;
        if (this.isDistinctSelect || this.isGrouped) {
            this.acceptsSequences = false;
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            object = this.rangeVariables[n].getJoinCondition();
            if (object == null) continue;
            this.resolveColumnReferencesAndAllocate(session, (Expression)object, n + 1, rangeGroupArray, false);
        }
        this.resolveColumnReferencesAndAllocate(session, this.queryCondition, this.rangeVariables.length, rangeGroupArray, false);
        if (this.resolvedSubqueryExpressions != null) {
            this.resolvedSubqueryExpressions.setSize(0);
        }
        for (n = 0; n < this.indexLimitVisible; ++n) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[n], this.rangeVariables.length, rangeGroupArray, this.acceptsSequences);
            if (this.isGrouped || this.isDistinctSelect) continue;
            object = this.exprColumns[n].collectAllSubqueries(null);
            if (object != null) {
                this.isMergeable = false;
            }
            if ((object = this.exprColumns[n].collectAllExpressions(null, Expression.sequenceExpressionSet, Expression.subqueryAggregateExpressionSet)) == null) continue;
            this.isOrderSensitive = true;
            this.isMergeable = false;
            this.isBaseMergeable = false;
        }
        for (n = this.indexLimitVisible; n < this.indexStartHaving; ++n) {
            this.exprColumns[n] = this.resolveColumnReferencesInGroupBy(session, this.exprColumns[n]);
        }
        for (n = this.indexStartHaving; n < this.indexStartOrderBy; ++n) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[n], this.rangeVariables.length, rangeGroupArray, false);
        }
        this.resolveColumnReferencesInOrderBy(session, rangeGroupArray, this.sortAndSlice);
    }

    void resolveColumnReferencesInOrderBy(Session session, RangeGroup[] rangeGroupArray, SortAndSlice sortAndSlice) {
        int n = sortAndSlice.getOrderLength();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)sortAndSlice.exprList.get(i);
            this.replaceColumnIndexInOrderBy(expressionOrderBy);
            if (expressionOrderBy.getLeftNode().queryTableColumnIndex != -1) continue;
            if (sortAndSlice.sortUnion && expressionOrderBy.getLeftNode().getType() != 2) {
                throw Error.error(5576);
            }
            expressionOrderBy.replaceAliasInOrderBy(session, this.exprColumns, this.indexLimitVisible);
            this.resolveColumnReferencesAndAllocate(session, expressionOrderBy, this.rangeVariables.length, RangeGroup.emptyArray, false);
            if (!this.isAggregated && !this.isGrouped || (bl = expressionOrderBy.getLeftNode().isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, Expression.aggregateFunctionSet))) continue;
            throw Error.error(5576);
        }
        if (sortAndSlice.limitCondition != null) {
            this.unresolvedExpressions = sortAndSlice.limitCondition.resolveColumnReferences(session, this, rangeGroupArray, this.unresolvedExpressions);
        }
        sortAndSlice.prepare(this);
    }

    private boolean resolveColumnReferences(Session session, Expression expression2, int n, boolean bl) {
        if (expression2 == null) {
            return true;
        }
        int n2 = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        this.unresolvedExpressions = expression2.resolveColumnReferences(session, this, n, RangeGroup.emptyArray, this.unresolvedExpressions, bl);
        int n3 = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        return n2 == n3;
    }

    private void resolveColumnReferencesForAsterisk() {
        int n = 0;
        while (n < this.indexLimitVisible) {
            Expression expression2 = (Expression)this.exprColumnList.get(n);
            if (expression2.getType() == 93) {
                int n2;
                this.exprColumnList.remove(n);
                String string2 = ((ExpressionColumn)expression2).getTableName();
                if (string2 == null) {
                    this.addAllJoinedColumns(expression2);
                } else {
                    n2 = 0;
                    for (int i = 0; i < this.rangeVariables.length; ++i) {
                        RangeVariable rangeVariable = this.rangeVariables[i].getRangeForTableName(string2);
                        if (rangeVariable == null) continue;
                        HashSet hashSet = this.getAllNamedJoinColumns();
                        this.rangeVariables[i].addTableColumns(rangeVariable, expression2, hashSet);
                        n2 = 1;
                        break;
                    }
                    if (n2 == 0) {
                        throw Error.error(5501, string2);
                    }
                }
                for (n2 = 0; n2 < expression2.nodes.length; ++n2) {
                    this.exprColumnList.add(n, expression2.nodes[n2]);
                    ++n;
                }
                this.indexLimitVisible += expression2.nodes.length - 1;
                continue;
            }
            ++n;
        }
    }

    private void resolveColumnReferencesAndAllocate(Session session, Expression expression2, int n, RangeGroup[] rangeGroupArray, boolean bl) {
        if (expression2 == null) {
            return;
        }
        HsqlList hsqlList = expression2.resolveColumnReferences(session, this, n, rangeGroupArray, null, bl);
        if (hsqlList != null) {
            for (int i = 0; i < hsqlList.size(); ++i) {
                Expression expression3 = (Expression)hsqlList.get(i);
                boolean bl2 = true;
                if (expression3.isSelfAggregate()) {
                    for (int j = 0; j < expression3.nodes.length; ++j) {
                        HsqlList hsqlList2 = expression3.nodes[j].resolveColumnReferences(session, this, n, RangeGroup.emptyArray, null, false);
                        for (int k = 0; k < rangeGroupArray.length; ++k) {
                            if (!rangeGroupArray[k].isVariable()) continue;
                            hsqlList2 = Expression.resolveColumnSet(session, rangeGroupArray[k].getRangeVariables(), RangeGroup.emptyArray, hsqlList2);
                        }
                        bl2 &= hsqlList2 == null;
                    }
                } else {
                    bl2 = this.resolveColumnReferences(session, expression3, n, bl);
                }
                if (bl2) {
                    if (expression3.isSelfAggregate()) {
                        if (this.aggregateSet == null) {
                            this.aggregateSet = new ArrayListIdentity();
                        }
                        this.aggregateSet.add(expression3);
                        this.isAggregated = true;
                        expression2.setAggregate();
                        expression3.setCorrelatedReferences(this);
                    }
                    if (this.resolvedSubqueryExpressions == null) {
                        this.resolvedSubqueryExpressions = new ArrayListIdentity();
                    }
                    this.resolvedSubqueryExpressions.add(expression3);
                    continue;
                }
                if (this.unresolvedExpressions == null) {
                    this.unresolvedExpressions = new ArrayListIdentity();
                }
                this.unresolvedExpressions.add(expression3);
            }
        }
    }

    private Expression resolveColumnReferencesInGroupBy(Session session, Expression expression2) {
        if (expression2 == null) {
            return null;
        }
        HsqlList hsqlList = expression2.resolveColumnReferences(session, this, this.rangeVariables.length, RangeGroup.emptyArray, null, false);
        if (hsqlList != null) {
            Expression expression3;
            if (expression2.getType() == 2 && (expression3 = expression2.replaceAliasInOrderBy(session, this.exprColumns, this.indexLimitVisible)) != expression2) {
                return expression3;
            }
            this.resolveColumnReferencesAndAllocate(session, expression2, this.rangeVariables.length, RangeGroup.emptyArray, false);
        }
        return expression2;
    }

    private HashSet getAllNamedJoinColumns() {
        HashSet hashSet = null;
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable rangeVariable = (RangeVariable)this.rangeVariableList.get(i);
            if (rangeVariable.namedJoinColumns == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.addAll(rangeVariable.namedJoinColumns);
        }
        return hashSet;
    }

    public Expression getEquiJoinExpressions(OrderedHashSet orderedHashSet, RangeVariable rangeVariable, boolean bl) {
        HashSet hashSet = new HashSet();
        Expression expression2 = null;
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        for (int i = this.rangeVariableList.size() - 1; i >= 0; --i) {
            RangeVariable rangeVariable2 = (RangeVariable)this.rangeVariableList.get(i);
            HashMappedList hashMappedList = rangeVariable2.rangeTable.columnList;
            for (int j = 0; j < hashMappedList.size(); ++j) {
                boolean bl2;
                ColumnSchema columnSchema = (ColumnSchema)hashMappedList.get(j);
                String string2 = rangeVariable2.getColumnAlias((int)j).name;
                boolean bl3 = orderedHashSet.contains(string2);
                boolean bl4 = rangeVariable2.namedJoinColumns != null && rangeVariable2.namedJoinColumns.contains(string2);
                boolean bl5 = bl2 = !bl4 && !hashSet.add(string2);
                if (bl2 && (!bl || bl3)) {
                    throw Error.error(5578, string2);
                }
                if (!bl3) continue;
                orderedHashSet2.add(string2);
                int n = rangeVariable2.rangeTable.getColumnIndex(columnSchema.getNameString());
                int n2 = rangeVariable.rangeTable.getColumnIndex(string2);
                ExpressionLogical expressionLogical = new ExpressionLogical(rangeVariable2, n, rangeVariable, n2);
                ExpressionColumn expressionColumn = rangeVariable2.getColumnExpression(string2);
                if (expressionColumn == null) {
                    expressionColumn = new ExpressionColumn(new Expression[]{expressionLogical.getLeftNode(), expressionLogical.getRightNode()}, string2);
                    rangeVariable2.addNamedJoinColumnExpression(string2, expressionColumn, n);
                    expression2 = ExpressionLogical.andExpressions(expression2, expressionLogical);
                    rangeVariable.addNamedJoinColumnExpression(string2, expressionColumn, n2);
                    continue;
                }
                if (rangeVariable.getColumnExpression(string2) != null || rangeVariable2.isLeftJoin && !rangeVariable2.isRightJoin) continue;
                if (rangeVariable2.isLeftJoin && rangeVariable2.isRightJoin) {
                    expressionLogical = new ExpressionLogical(expressionColumn, expressionLogical.getRightNode());
                }
                expressionColumn.nodes = (Expression[])ArrayUtil.resizeArray(expressionColumn.nodes, expressionColumn.nodes.length + 1);
                expressionColumn.nodes[expressionColumn.nodes.length - 1] = expressionLogical.getRightNode();
                expression2 = ExpressionLogical.andExpressions(expression2, expressionLogical);
                rangeVariable.addNamedJoinColumnExpression(string2, expressionColumn, n2);
            }
            if (!rangeVariable2.isJoin) break;
        }
        if (bl && !orderedHashSet2.containsAll(orderedHashSet)) {
            throw Error.error(5501);
        }
        rangeVariable.addNamedJoinColumns(orderedHashSet2);
        return expression2;
    }

    private void addAllJoinedColumns(Expression expression2) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].addTableColumns(hsqlArrayList);
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        expression2.nodes = expressionArray;
    }

    private void finaliseColumns() {
        int n;
        this.indexLimitRowId = this.indexLimitVisible;
        this.indexStartHaving = this.indexLimitRowId + this.groupByColumnCount;
        this.indexStartOrderBy = this.indexStartHaving + this.havingColumnCount;
        this.indexLimitData = this.indexLimitExpressions = (this.indexStartAggregates = this.indexStartOrderBy + this.sortAndSlice.getOrderLength());
        this.exprColumns = new Expression[this.indexLimitExpressions];
        this.exprColumnList.toArray(this.exprColumns);
        this.exprColumnList = null;
        for (n = 0; n < this.indexLimitVisible; ++n) {
            this.exprColumns[n].queryTableColumnIndex = n;
        }
        if (this.sortAndSlice.hasOrder()) {
            for (n = 0; n < this.sortAndSlice.getOrderLength(); ++n) {
                this.exprColumns[this.indexStartOrderBy + n] = (Expression)this.sortAndSlice.exprList.get(n);
            }
        }
        this.rowExpression = new Expression(25, this.exprColumns);
    }

    private void replaceColumnIndexInOrderBy(Expression expression2) {
        int n;
        Expression expression3 = expression2.getLeftNode();
        if (expression3.getType() != 1) {
            return;
        }
        Type type = expression3.getDataType();
        if (type != null && type.typeCode == 4 && 0 < (n = ((Integer)expression3.getValue(null)).intValue()) && n <= this.indexLimitVisible) {
            expression2.setLeftNode(this.exprColumns[n - 1]);
            return;
        }
        throw Error.error(5576);
    }

    @Override
    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            orderedHashSet = this.exprColumns[i].collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        if (this.havingCondition != null) {
            orderedHashSet = this.havingCondition.collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        return orderedHashSet;
    }

    @Override
    OrderedHashSet collectRangeVariables(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            orderedHashSet = this.exprColumns[i].collectRangeVariables(orderedHashSet);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectRangeVariables(orderedHashSet);
        }
        if (this.havingCondition != null) {
            orderedHashSet = this.havingCondition.collectRangeVariables(orderedHashSet);
        }
        return orderedHashSet;
    }

    public void resolveExpressionTypes(Session session) {
        Expression expression2;
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            expression2 = this.exprColumns[n];
            expression2.resolveTypes(session, this.rowExpression);
            if (expression2.getType() == 25) {
                throw Error.error(5565);
            }
            if (expression2.getType() == 22 && expression2.getDegree() > 1) {
                throw Error.error(5565);
            }
            if (expression2.getDataType() == null || expression2.getDataType().typeCode != 19) continue;
            throw Error.error(5565);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            expression2 = this.rangeVariables[n].getJoinCondition();
            if (expression2 == null) continue;
            expression2.resolveTypes(session, null);
            if (expression2.getDataType() == Type.SQL_BOOLEAN) continue;
            throw Error.error(5568);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session, null);
            if (this.queryCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.havingCondition != null) {
            this.havingCondition.resolveTypes(session, null);
            if (this.havingCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.sortAndSlice.limitCondition != null) {
            this.sortAndSlice.limitCondition.resolveTypes(session, null);
        }
    }

    private void resolveAggregates() {
        this.tempSet.clear();
        if (this.isAggregated) {
            this.aggregateCheck = new boolean[this.indexStartAggregates];
            this.tempSet.addAll(this.aggregateSet);
            this.indexLimitData = this.indexLimitExpressions = this.exprColumns.length + this.tempSet.size();
            this.exprColumns = (Expression[])ArrayUtil.resizeArray(this.exprColumns, this.indexLimitExpressions);
            int n = this.indexStartAggregates;
            int n2 = 0;
            while (n < this.indexLimitExpressions) {
                Expression expression2 = (Expression)this.tempSet.get(n2);
                this.exprColumns[n] = expression2.duplicate();
                this.exprColumns[n].nodes = expression2.nodes;
                this.exprColumns[n].dataType = expression2.dataType;
                ++n;
                ++n2;
            }
            this.tempSet.clear();
        }
    }

    private void setRangeVariableConditions(Session session) {
        RangeVariableResolver rangeVariableResolver = new RangeVariableResolver(session, this);
        rangeVariableResolver.processConditions();
        this.rangeVariables = rangeVariableResolver.rangeVariables;
    }

    private void setDistinctConditions(Session session) {
        Index index;
        int n;
        int[] nArray;
        if (!this.isDistinctSelect && !this.isGrouped) {
            return;
        }
        if (this.isAggregated) {
            return;
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (!this.rangeVariables[i].isRightJoin) continue;
            return;
        }
        RangeVariable rangeVariable = null;
        if (this.isGrouped) {
            nArray = new int[this.groupByColumnCount];
            for (n = 0; n < this.groupByColumnCount; ++n) {
                if (this.exprColumns[this.indexLimitRowId + n].getType() != 2) {
                    return;
                }
                if (rangeVariable == null) {
                    rangeVariable = this.exprColumns[this.indexLimitRowId + n].getRangeVariable();
                } else if (rangeVariable != this.exprColumns[this.indexLimitRowId + n].getRangeVariable()) {
                    return;
                }
                nArray[n] = this.exprColumns[n].columnIndex;
            }
        } else {
            nArray = new int[this.indexLimitVisible];
        }
        for (n = 0; n < this.indexLimitVisible; ++n) {
            if (this.exprColumns[n].getType() != 2) {
                return;
            }
            if (rangeVariable == null) {
                rangeVariable = this.exprColumns[n].getRangeVariable();
            } else if (rangeVariable != this.exprColumns[n].getRangeVariable()) {
                return;
            }
            if (this.isGrouped) continue;
            nArray[n] = this.exprColumns[n].columnIndex;
        }
        if (rangeVariable != this.rangeVariables[0]) {
            return;
        }
        n = ArrayUtil.areAllIntIndexesAsBooleanArray(nArray, rangeVariable.usedColumns) ? 1 : 0;
        if (n == 0) {
            return;
        }
        if (!rangeVariable.hasAnyIndexCondition() && (index = rangeVariable.rangeTable.getIndexForColumns(nArray)) != null) {
            rangeVariable.setSortIndex(index, false);
        }
        this.isSimpleDistinct = rangeVariable.setDistinctColumnsOnIndex(nArray);
    }

    private void setAggregateConditions(Session session) {
        if (!this.isAggregated) {
            return;
        }
        if (this.isGrouped) {
            this.setGroupedAggregateConditions(session);
        } else if (!this.sortAndSlice.hasOrder() && !this.sortAndSlice.hasLimit() && this.aggregateSet.size() == 1 && this.indexLimitVisible == 1) {
            Expression expression2 = this.exprColumns[this.indexStartAggregates];
            int n = expression2.getType();
            Expression expression3 = expression2.getLeftNode();
            switch (n) {
                case 73: 
                case 74: {
                    if (expression2.hasCondition()) break;
                    SortAndSlice sortAndSlice = new SortAndSlice();
                    sortAndSlice.isGenerated = true;
                    sortAndSlice.addLimitCondition(ExpressionOp.limitOneExpression);
                    if (!sortAndSlice.prepareSpecial(session, this)) break;
                    this.sortAndSlice = sortAndSlice;
                    break;
                }
                case 71: {
                    if (expression2.hasCondition() || this.rangeVariables.length != 1 || this.queryCondition != null) break;
                    if (expression3.getType() == 11) {
                        this.isSimpleCount = true;
                        break;
                    }
                    if (expression3.getNullability() != 0) break;
                    if (expression2.isDistinctAggregate) {
                        Table table;
                        if (expression3.opType != 2 || (table = expression3.getRangeVariable().getTable()).getPrimaryKey().length != 1 || table.getColumn(table.getPrimaryKey()[0]) != expression3.getColumn()) break;
                        this.isSimpleCount = true;
                        break;
                    }
                    this.isSimpleCount = true;
                    break;
                }
            }
        }
    }

    private void setGroupedAggregateConditions(Session session) {
    }

    void checkLobUsage() {
    }

    private void resolveGroups() {
        int n;
        Expression expression2;
        int n2;
        Expression expression3;
        int n3;
        int n4;
        OrderedHashSet orderedHashSet = null;
        this.tempSet.clear();
        if (this.isGrouped) {
            for (n4 = this.indexLimitVisible; n4 < this.indexLimitVisible + this.groupByColumnCount; ++n4) {
                this.exprColumns[n4].collectAllExpressions(this.tempSet, Expression.aggregateFunctionSet, Expression.subqueryExpressionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5572, ((Expression)this.tempSet.get(0)).getSQL());
            }
            for (n4 = 0; n4 < this.indexLimitVisible; ++n4) {
                if (this.exprColumns[n4].isComposedOf(this.exprColumns, this.indexLimitVisible, this.indexLimitVisible + this.groupByColumnCount, Expression.aggregateFunctionSet)) continue;
                this.tempSet.add(this.exprColumns[n4]);
            }
            if (!this.tempSet.isEmpty()) {
                if (!this.resolveForGroupBy(this.tempSet)) {
                    throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
                }
                orderedHashSet = new OrderedHashSet();
                orderedHashSet.addAll(this.tempSet);
            }
        } else if (this.isAggregated) {
            for (n4 = 0; n4 < this.indexLimitVisible; ++n4) {
                this.exprColumns[n4].collectAllExpressions(this.tempSet, Expression.columnExpressionSet, Expression.aggregateFunctionSet);
                for (n3 = 0; n3 < this.tempSet.size(); ++n3) {
                    expression3 = (Expression)this.tempSet.get(n3);
                    for (int i = 0; i < this.rangeVariables.length; ++i) {
                        if (this.rangeVariables[i] != expression3.getRangeVariable()) continue;
                        throw Error.error(5574, expression3.getSQL());
                    }
                }
                this.tempSet.clear();
            }
        }
        this.tempSet.clear();
        if (this.havingCondition != null) {
            if (this.unresolvedExpressions != null) {
                this.tempSet.addAll(this.unresolvedExpressions);
            }
            for (n4 = this.indexLimitVisible; n4 < this.indexLimitVisible + this.groupByColumnCount; ++n4) {
                this.tempSet.add(this.exprColumns[n4]);
            }
            if (orderedHashSet != null) {
                this.tempSet.addAll(orderedHashSet);
            }
            if (!this.havingCondition.isComposedOf(this.tempSet, this.outerRanges, Expression.subqueryAggregateExpressionSet)) {
                throw Error.error(5573);
            }
            this.tempSet.clear();
        }
        if (this.isDistinctSelect) {
            n4 = this.sortAndSlice.getOrderLength();
            for (n3 = 0; n3 < n4; ++n3) {
                expression3 = (Expression)this.sortAndSlice.exprList.get(n3);
                if (expression3.queryTableColumnIndex != -1 || expression3.isComposedOf(this.exprColumns, 0, this.indexLimitVisible, Expression.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (this.isGrouped) {
            n4 = this.sortAndSlice.getOrderLength();
            for (n3 = 0; n3 < n4; ++n3) {
                expression3 = (Expression)this.sortAndSlice.exprList.get(n3);
                if (expression3.queryTableColumnIndex != -1 || expression3.isAggregate() || expression3.isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, Expression.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (!this.isAggregated) {
            return;
        }
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        OrderedHashSet orderedHashSet3 = new OrderedHashSet();
        for (n2 = this.indexStartAggregates; n2 < this.indexLimitExpressions; ++n2) {
            Expression expression4 = this.exprColumns[n2];
            expression2 = new ExpressionColumn(expression4, n2, this.resultRangePosition);
            orderedHashSet2.add(expression4);
            orderedHashSet3.add(expression2);
        }
        for (n2 = 0; n2 < this.indexStartHaving; ++n2) {
            Expression expression5;
            if (this.exprColumns[n2].isAggregate() || !orderedHashSet2.add(expression5 = this.exprColumns[n2])) continue;
            expression2 = new ExpressionColumn(expression5, n2, this.resultRangePosition);
            orderedHashSet3.add(expression2);
        }
        n2 = this.sortAndSlice.getOrderLength();
        for (n = 0; n < n2; ++n) {
            expression2 = (Expression)this.sortAndSlice.exprList.get(n);
            if (!expression2.getLeftNode().isAggregate()) continue;
            expression2.setAggregate();
        }
        for (n = this.indexStartOrderBy; n < this.indexStartAggregates; ++n) {
            if (!this.exprColumns[n].getLeftNode().isAggregate()) continue;
            this.exprColumns[n].setAggregate();
        }
        for (n = 0; n < this.indexStartAggregates; ++n) {
            expression2 = this.exprColumns[n];
            if (!expression2.isAggregate()) continue;
            this.aggregateCheck[n] = true;
            if (!expression2.isAggregate()) continue;
            expression2.convertToSimpleColumn(orderedHashSet2, orderedHashSet3);
        }
        for (n = 0; n < this.aggregateSet.size(); ++n) {
            expression2 = (Expression)this.aggregateSet.get(n);
            expression2.convertToSimpleColumn(orderedHashSet2, orderedHashSet3);
        }
        if (this.resolvedSubqueryExpressions != null) {
            for (n = 0; n < this.resolvedSubqueryExpressions.size(); ++n) {
                expression2 = (Expression)this.resolvedSubqueryExpressions.get(n);
                expression2.convertToSimpleColumn(orderedHashSet2, orderedHashSet3);
            }
        }
    }

    boolean resolveForGroupBy(HsqlList hsqlList) {
        Object object;
        Object object2;
        int n;
        for (n = this.indexLimitVisible; n < this.indexLimitVisible + this.groupByColumnCount; ++n) {
            object2 = this.exprColumns[n];
            if (((Expression)object2).getType() != 2) continue;
            object = ((Expression)object2).getRangeVariable();
            int n2 = ((Expression)object2).getColumnIndex();
            ((RangeVariable)object).columnsInGroupBy[n2] = true;
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            object2 = this.rangeVariables[n];
            ((RangeVariable)object2).hasKeyedColumnInGroupBy = ((RangeVariable)object2).rangeTable.getUniqueNotNullColumnGroup(((RangeVariable)object2).columnsInGroupBy) != null;
        }
        OrderedHashSet orderedHashSet = null;
        for (int i = 0; i < hsqlList.size(); ++i) {
            object = (Expression)hsqlList.get(i);
            orderedHashSet = ((Expression)object).getUnkeyedColumns(orderedHashSet);
        }
        return orderedHashSet == null;
    }

    @Override
    Result getResult(Session session, int n) {
        Result result2 = this.getSingleResult(session, n);
        result2.getNavigator().reset();
        return result2;
    }

    private Result getSingleResult(Session session, int n) {
        int[] nArray = this.sortAndSlice.getLimits(session, this, n);
        Result result2 = this.buildResult(session, nArray);
        RowSetNavigatorData rowSetNavigatorData = (RowSetNavigatorData)result2.getNavigator();
        if (this.isDistinctSelect) {
            rowSetNavigatorData.removeDuplicates(session);
        }
        if (this.sortAndSlice.hasOrder()) {
            rowSetNavigatorData.sortOrder(session);
        }
        if (nArray != SortAndSlice.defaultLimits && !this.sortAndSlice.skipFullResult) {
            rowSetNavigatorData.trim(nArray[0], nArray[1]);
        }
        return result2;
    }

    private Result buildResult(Session session, int[] nArray) {
        int n;
        RowSetNavigatorData rowSetNavigatorData = new RowSetNavigatorData(session, this);
        Result result2 = Result.newResult(rowSetNavigatorData);
        boolean bl = this.isGrouped && !this.isSimpleDistinct;
        result2.metaData = this.resultMetaData;
        if (this.isUpdatable) {
            result2.rsProperties = 8;
        }
        int n2 = 0;
        int n3 = nArray[2];
        if (this.sortAndSlice.skipFullResult) {
            n2 = nArray[0];
            n3 = nArray[1];
        }
        if (this.isSimpleCount) {
            Object[] objectArray = new Object[this.indexLimitData];
            Table table = this.rangeVariables[0].getTable();
            table.materialise(session);
            PersistentStore persistentStore = table.getRowStore(session);
            long l = persistentStore.elementCount(session);
            objectArray[this.indexStartAggregates] = ValuePool.getLong(l);
            rowSetNavigatorData.add(objectArray);
            rowSetNavigatorData.reset();
            session.sessionContext.setRangeIterator(rowSetNavigatorData);
            if (rowSetNavigatorData.next()) {
                objectArray = rowSetNavigatorData.getCurrent();
                for (int i = 0; i < this.indexStartAggregates; ++i) {
                    objectArray[i] = this.exprColumns[i].getValue(session);
                }
            }
            session.sessionContext.unsetRangeIterator(rowSetNavigatorData);
            return result2;
        }
        int n4 = 0;
        RangeIterator[] rangeIteratorArray = new RangeIterator[this.rangeVariables.length];
        for (n = 0; n < this.rangeVariables.length; ++n) {
            rangeIteratorArray[n] = this.rangeVariables[n].getIterator(session);
        }
        session.sessionContext.rownum = 1;
        n = 0;
        while (true) {
            int n5;
            int n6;
            RangeIterator rangeIterator;
            if (n < n4) {
                boolean bl2 = true;
                for (int i = n4 + 1; i < this.rangeVariables.length; ++i) {
                    if (!this.rangeVariables[i].isRightJoin) continue;
                    n4 = i;
                    n = i;
                    bl2 = false;
                    ((RangeVariable.RangeIteratorRight)rangeIteratorArray[i]).setOnOuterRows();
                    break;
                }
                if (bl2) break;
            }
            if ((rangeIterator = rangeIteratorArray[n]).next()) {
                if (n < this.rangeVariables.length - 1) {
                    ++n;
                    continue;
                }
            } else {
                rangeIterator.reset();
                --n;
                continue;
            }
            if (n3 == 0) break;
            session.sessionData.startRowProcessing();
            Object[] objectArray = new Object[this.indexLimitData];
            for (n6 = 0; n6 < this.indexStartAggregates; ++n6) {
                if (this.isAggregated && this.aggregateCheck[n6]) continue;
                objectArray[n6] = this.exprColumns[n6].getValue(session);
            }
            for (n6 = this.indexLimitVisible; n6 < this.indexLimitRowId; ++n6) {
                objectArray[n6] = n6 == this.indexLimitVisible ? rangeIterator.getRowidObject() : rangeIterator.getCurrentRow();
            }
            ++session.sessionContext.rownum;
            if (n2 > 0) {
                --n2;
                continue;
            }
            Object[] objectArray2 = null;
            if ((this.isAggregated || bl) && (objectArray2 = rowSetNavigatorData.getGroupData(objectArray)) != null) {
                objectArray = objectArray2;
            }
            for (n5 = this.indexStartAggregates; n5 < this.indexLimitExpressions; ++n5) {
                objectArray[n5] = this.exprColumns[n5].updateAggregatingValue(session, objectArray[n5]);
            }
            if (objectArray2 == null) {
                rowSetNavigatorData.add(objectArray);
                if (this.isSimpleDistinct) {
                    for (n5 = 1; n5 < this.rangeVariables.length; ++n5) {
                        rangeIteratorArray[n5].reset();
                    }
                    n = 0;
                }
            } else if (this.isAggregated) {
                rowSetNavigatorData.update(objectArray2, objectArray);
            }
            if ((n5 = rowSetNavigatorData.getSize()) == session.resultMaxMemoryRows && !this.isAggregated && !this.isSingleMemoryTable) {
                rowSetNavigatorData = new RowSetNavigatorDataTable(session, this, rowSetNavigatorData);
                result2.setNavigator(rowSetNavigatorData);
            }
            if ((!this.isAggregated && !bl || this.sortAndSlice.isGenerated) && n5 >= n3) break;
        }
        rowSetNavigatorData.reset();
        for (n = 0; n < this.rangeVariables.length; ++n) {
            rangeIteratorArray[n].reset();
        }
        if (!bl && !this.isAggregated) {
            return result2;
        }
        if (this.isAggregated) {
            if (!bl && rowSetNavigatorData.getSize() == 0) {
                Object[] objectArray = new Object[this.exprColumns.length];
                for (int i = 0; i < this.indexStartAggregates; ++i) {
                    if (this.aggregateCheck[i]) continue;
                    objectArray[i] = this.exprColumns[i].getValue(session);
                }
                rowSetNavigatorData.add(objectArray);
            }
            rowSetNavigatorData.reset();
            session.sessionContext.setRangeIterator(rowSetNavigatorData);
            while (rowSetNavigatorData.next()) {
                int n7;
                Object[] objectArray = rowSetNavigatorData.getCurrent();
                for (n7 = this.indexStartAggregates; n7 < this.indexLimitExpressions; ++n7) {
                    objectArray[n7] = this.exprColumns[n7].getAggregatedValue(session, objectArray[n7]);
                }
                for (n7 = 0; n7 < this.indexStartAggregates; ++n7) {
                    if (!this.aggregateCheck[n7]) continue;
                    objectArray[n7] = this.exprColumns[n7].getValue(session);
                }
            }
            session.sessionContext.unsetRangeIterator(rowSetNavigatorData);
        }
        rowSetNavigatorData.reset();
        if (this.havingCondition != null) {
            while (rowSetNavigatorData.hasNext()) {
                Object[] objectArray = rowSetNavigatorData.getNext();
                if (Boolean.TRUE.equals(objectArray[this.indexLimitVisible + this.groupByColumnCount])) continue;
                rowSetNavigatorData.removeCurrent();
            }
            rowSetNavigatorData.reset();
        }
        return result2;
    }

    void setReferenceableColumns() {
        this.accessibleColumns = new boolean[this.indexLimitVisible];
        IntValueHashMap intValueHashMap = new IntValueHashMap();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression2 = this.exprColumns[i];
            String string2 = expression2.getAlias();
            if (string2.length() == 0) {
                HsqlNameManager.HsqlName hsqlName = HsqlNameManager.getAutoColumnName(i);
                expression2.setAlias(hsqlName);
                continue;
            }
            int n = intValueHashMap.get((Object)string2, -1);
            if (n == -1) {
                intValueHashMap.put(string2, i);
                this.accessibleColumns[i] = true;
                continue;
            }
            this.accessibleColumns[n] = false;
        }
    }

    void setColumnAliases(HsqlNameManager.SimpleName[] simpleNameArray) {
        if (simpleNameArray.length != this.indexLimitVisible) {
            throw Error.error(5593);
        }
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            this.exprColumns[i].setAlias(simpleNameArray[i]);
        }
    }

    private void createResultMetaData(Session session) {
        this.resultMetaData = ResultMetaData.newResultMetaData(this.resultColumnTypes, this.columnMap, this.indexLimitVisible, this.indexLimitRowId);
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression2 = this.exprColumns[i];
            ColumnSchema columnSchema = null;
            columnSchema = expression2.getColumn();
            this.resultMetaData.columnTypes[i] = expression2.getDataType();
            ColumnBase columnBase = columnSchema == null ? new ColumnBase() : new ColumnBase(session.database.getCatalogName().name, columnSchema);
            columnBase.setType(expression2.getDataType());
            this.resultMetaData.columns[i] = columnBase;
            this.resultMetaData.columnLabels[i] = expression2.getAlias();
        }
    }

    private void setResultNullability() {
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            RangeVariable rangeVariable;
            Expression expression2 = this.exprColumns[i];
            byte by2 = expression2.getNullability();
            if (expression2.opType == 2 && (rangeVariable = expression2.getRangeVariable()) != null && (rangeVariable.rangePositionInJoin < this.startInnerRange || rangeVariable.rangePositionInJoin >= this.endInnerRange)) {
                by2 = 1;
            }
            this.resultMetaData.columns[i].setNullability(by2);
        }
    }

    @Override
    void createTable(Session session) {
        int[] nArray;
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipSort) {
            this.orderIndex = this.sortAndSlice.getNewIndex(session, this.resultTable);
        }
        if (this.isDistinctSelect || this.isFullOrder) {
            this.createFullIndex(session);
        }
        if (this.isGrouped) {
            nArray = new int[this.groupByColumnCount];
            for (int i = 0; i < this.groupByColumnCount; ++i) {
                nArray[i] = this.indexLimitRowId + i;
            }
            this.groupIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
        } else if (this.isAggregated) {
            this.groupIndex = this.mainIndex;
        }
        if (this.isUpdatable && this.view == null) {
            nArray = new int[]{this.indexLimitVisible};
            this.idIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
        }
    }

    private void createFullIndex(Session session) {
        int[] nArray = new int[this.indexLimitVisible];
        ArrayUtil.fillSequence(nArray);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
    }

    private void setResultColumnTypes() {
        Expression expression2;
        int n;
        this.resultColumnTypes = new Type[this.indexLimitData];
        for (n = 0; n < this.indexLimitVisible; ++n) {
            expression2 = this.exprColumns[n];
            this.resultColumnTypes[n] = expression2.getDataType();
        }
        for (n = this.indexLimitVisible; n < this.indexLimitRowId; ++n) {
            this.resultColumnTypes[n] = n == this.indexLimitVisible ? Type.SQL_BIGINT : Type.SQL_ALL_TYPES;
        }
        for (n = this.indexLimitRowId; n < this.indexLimitData; ++n) {
            expression2 = this.exprColumns[n];
            Type type = expression2.getDataType();
            if (type.getCollation() != expression2.collation && expression2.collation != null) {
                type = Type.getType(type, expression2.collation);
            }
            this.resultColumnTypes[n] = type;
        }
    }

    @Override
    void createResultTable(Session session) {
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.getSubqueryTableName();
        int n = this.persistenceScope == 21 ? 2 : 9;
        HashMappedList hashMappedList = new HashMappedList();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression2 = this.exprColumns[i];
            HsqlNameManager.SimpleName simpleName = expression2.getSimpleName();
            String string2 = simpleName.name;
            HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newColumnSchemaHsqlName(hsqlName, simpleName);
            if (!this.accessibleColumns[i]) {
                string2 = HsqlNameManager.getAutoNoNameColumnString(i);
            }
            ColumnSchema columnSchema = new ColumnSchema(hsqlName2, expression2.dataType, true, false, null);
            hashMappedList.add(string2, columnSchema);
        }
        this.resultTable = new TableDerived(session.database, hsqlName, n, this.resultColumnTypes, hashMappedList, ValuePool.emptyIntArray);
    }

    public String getSQL() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        int n2 = this.indexLimitVisible;
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.exprColumns[n].getSQL());
        }
        stringBuffer.append("FROM");
        n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            RangeVariable rangeVariable = this.rangeVariables[n];
            if (n > 0) {
                if (rangeVariable.isLeftJoin && rangeVariable.isRightJoin) {
                    stringBuffer.append("FULL").append(' ');
                } else if (rangeVariable.isLeftJoin) {
                    stringBuffer.append("LEFT").append(' ');
                } else if (rangeVariable.isRightJoin) {
                    stringBuffer.append("RIGHT").append(' ');
                }
                stringBuffer.append("JOIN").append(' ');
            }
            stringBuffer.append(rangeVariable.getTable().getName().statementName);
        }
        if (this.isGrouped) {
            stringBuffer.append(' ').append("GROUP").append(' ').append("BY");
            n2 = this.indexLimitVisible + this.groupByColumnCount;
            for (n = this.indexLimitVisible; n < n2; ++n) {
                stringBuffer.append(this.exprColumns[n].getSQL());
                if (n >= n2 - 1) continue;
                stringBuffer.append(',');
            }
        }
        if (this.havingCondition != null) {
            stringBuffer.append(' ').append("HAVING").append(' ');
            stringBuffer.append(this.havingCondition.getSQL());
        }
        if (this.sortAndSlice.hasOrder()) {
            n2 = this.indexStartOrderBy + this.sortAndSlice.getOrderLength();
            stringBuffer.append(' ').append("ORDER").append("BY").append(' ');
            for (n = this.indexStartOrderBy; n < n2; ++n) {
                stringBuffer.append(this.exprColumns[n].getSQL());
                if (n >= n2 - 1) continue;
                stringBuffer.append(',');
            }
        }
        if (this.sortAndSlice.hasLimit()) {
            stringBuffer.append(this.sortAndSlice.limitCondition.getLeftNode().getSQL());
        }
        return stringBuffer.toString();
    }

    @Override
    public ResultMetaData getMetaData() {
        return this.resultMetaData;
    }

    @Override
    public String describe(Session session, int n) {
        String string2;
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer(n);
        for (n3 = 0; n3 < n; ++n3) {
            stringBuffer.append(' ');
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer).append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        stringBuffer2.append(stringBuffer).append("isGrouped=[").append(this.isGrouped).append("]\n");
        stringBuffer2.append(stringBuffer).append("isAggregated=[").append(this.isAggregated).append("]\n");
        stringBuffer2.append(stringBuffer).append("columns=[");
        for (n3 = 0; n3 < this.indexLimitVisible; ++n3) {
            n2 = n3;
            if (this.exprColumns[n3].getType() == 5) {
                n2 = this.exprColumns[n3].columnIndex;
            }
            stringBuffer2.append(stringBuffer);
            string2 = this.exprColumns[n2].describe(session, 2);
            stringBuffer2.append(string2.substring(0, string2.length() - 1));
            if (this.resultMetaData.columns[n3].getNullability() == 0) {
                stringBuffer2.append(" not nullable\n");
                continue;
            }
            stringBuffer2.append(" nullable\n");
        }
        stringBuffer2.append("\n");
        stringBuffer2.append(stringBuffer).append("]\n");
        for (n3 = 0; n3 < this.rangeVariables.length; ++n3) {
            stringBuffer2.append(stringBuffer).append("[");
            stringBuffer2.append("range variable ").append(n3 + 1).append("\n");
            stringBuffer2.append(this.rangeVariables[n3].describe(session, n + 2));
            stringBuffer2.append(stringBuffer).append("]");
        }
        stringBuffer2.append(stringBuffer).append("]\n");
        String string3 = string2 = this.queryCondition == null ? "null" : this.queryCondition.describe(session, n);
        if (this.isGrouped) {
            stringBuffer2.append(stringBuffer).append("groupColumns=[");
            for (n3 = this.indexLimitRowId; n3 < this.indexLimitRowId + this.groupByColumnCount; ++n3) {
                n2 = n3;
                if (this.exprColumns[n3].getType() == 5) {
                    n2 = this.exprColumns[n3].columnIndex;
                }
                stringBuffer2.append(this.exprColumns[n2].describe(session, n));
            }
            stringBuffer2.append(stringBuffer).append("]\n");
        }
        if (this.havingCondition != null) {
            string2 = this.havingCondition.describe(session, n);
            stringBuffer2.append(stringBuffer).append("havingCondition=[").append(string2).append("]\n");
        }
        if (this.sortAndSlice.hasOrder()) {
            stringBuffer2.append(stringBuffer).append("order by=[\n");
            for (n3 = 0; n3 < this.sortAndSlice.exprList.size(); ++n3) {
                stringBuffer2.append(stringBuffer).append(((Expression)this.sortAndSlice.exprList.get(n3)).describe(session, n));
            }
            if (this.sortAndSlice.primaryTableIndex != null) {
                stringBuffer2.append(stringBuffer).append("uses index");
            }
            stringBuffer2.append(stringBuffer).append("]\n");
        }
        if (this.sortAndSlice.hasLimit()) {
            if (this.sortAndSlice.limitCondition.getLeftNode() != null) {
                stringBuffer2.append(stringBuffer).append("offset=[").append(this.sortAndSlice.limitCondition.getLeftNode().describe(session, stringBuffer.length())).append("]\n");
            }
            if (this.sortAndSlice.limitCondition.getRightNode() != null) {
                stringBuffer2.append(stringBuffer).append("limit=[").append(this.sortAndSlice.limitCondition.getRightNode().describe(session, stringBuffer.length())).append("]\n");
            }
        }
        return stringBuffer2.toString();
    }

    void setMergeability() {
        this.isOrderSensitive |= this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder();
        if (this.isOrderSensitive) {
            this.isMergeable = false;
        }
        if (this.isAggregated) {
            this.isMergeable = false;
        }
        if (this.isGrouped || this.isDistinctSelect) {
            this.isMergeable = false;
        }
        if (this.rangeVariables.length != 1) {
            this.isBaseMergeable = false;
            this.isMergeable = false;
        }
    }

    void setUpdatability() {
        String string2;
        Object object;
        int n;
        if (!this.isUpdatable) {
            return;
        }
        this.isUpdatable = false;
        if (this.isGrouped || this.isDistinctSelect || this.isAggregated) {
            return;
        }
        if (!this.isBaseMergeable) {
            return;
        }
        if (!this.isTopLevel) {
            return;
        }
        if (this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) {
            return;
        }
        RangeVariable rangeVariable = this.rangeVariables[0];
        Table table = rangeVariable.getTable();
        Table table2 = table.getBaseTable();
        if (table2 == null) {
            return;
        }
        this.isInsertable = table.isInsertable();
        this.isUpdatable = table.isUpdatable();
        if (!this.isInsertable && !this.isUpdatable) {
            return;
        }
        IntValueHashMap intValueHashMap = new IntValueHashMap();
        int[] nArray = table.getBaseTableColumnMap();
        int[] nArray2 = new int[this.indexLimitVisible];
        if (this.queryCondition != null) {
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, this.queryCondition);
            if (this.tempSet.contains(table.getName()) || this.tempSet.contains(table2.getName())) {
                this.isUpdatable = false;
                this.isInsertable = false;
                return;
            }
        }
        for (n = 0; n < this.indexLimitVisible; ++n) {
            object = this.exprColumns[n];
            if (((Expression)object).getType() == 2) {
                string2 = ((Expression)object).getColumn().getName().name;
                if (intValueHashMap.containsKey(string2)) {
                    intValueHashMap.put(string2, 1);
                    continue;
                }
                intValueHashMap.put(string2, 0);
                continue;
            }
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, (Expression)object);
            if (!this.tempSet.contains(table.getName())) continue;
            this.isUpdatable = false;
            this.isInsertable = false;
            return;
        }
        this.isUpdatable = false;
        for (n = 0; n < this.indexLimitVisible; ++n) {
            if (this.accessibleColumns[n] && ((Expression)(object = this.exprColumns[n])).getType() == 2 && intValueHashMap.get(string2 = ((Expression)object).getColumn().getName().name) == 0) {
                int n2 = table.findColumn(string2);
                nArray2[n] = nArray[n2];
                if (nArray2[n] == -1) continue;
                this.isUpdatable = true;
                continue;
            }
            nArray2[n] = -1;
            this.isInsertable = false;
        }
        if (this.isInsertable) {
            boolean[] blArray = table2.getColumnCheckList(nArray2);
            for (n = 0; n < blArray.length; ++n) {
                if (blArray[n] || ((ColumnBase)(object = table2.getColumn(n))).isIdentity() || ((ColumnSchema)object).isGenerated() || ((ColumnSchema)object).hasDefault() || ((ColumnSchema)object).isNullable()) continue;
                this.isInsertable = false;
                break;
            }
        }
        if (!this.isUpdatable) {
            this.isInsertable = false;
        }
        if (this.isUpdatable) {
            this.columnMap = nArray2;
            this.baseTable = table2;
            if (this.view != null) {
                return;
            }
            ++this.indexLimitRowId;
            this.hasRowID = true;
            if (!table2.isFileBased()) {
                ++this.indexLimitRowId;
                this.isSingleMemoryTable = true;
            }
            this.indexLimitData = this.indexLimitRowId;
        }
    }

    void mergeQuery() {
        RangeVariable rangeVariable = this.rangeVariables[0];
        Table table = rangeVariable.getTable();
        Expression expression2 = this.queryCondition;
        QueryExpression queryExpression = table.getQueryExpression();
        if (this.isBaseMergeable && queryExpression != null && queryExpression.isMergeable) {
            QuerySpecification querySpecification = queryExpression.getMainSelect();
            this.rangeVariables[0] = querySpecification.rangeVariables[0];
            this.rangeVariables[0].resetConditions();
            for (int i = 0; i < this.indexLimitExpressions; ++i) {
                Expression expression3 = this.exprColumns[i];
                this.exprColumns[i] = expression3.replaceColumnReferences(rangeVariable, querySpecification.exprColumns);
            }
            if (expression2 != null) {
                expression2 = expression2.replaceColumnReferences(rangeVariable, querySpecification.exprColumns);
            }
            Expression expression4 = querySpecification.queryCondition;
            this.checkQueryCondition = querySpecification.checkQueryCondition;
            this.queryCondition = ExpressionLogical.andExpressions(expression4, expression2);
        }
        if (this.view != null) {
            switch (this.view.getCheckOption()) {
                case 1: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = expression2;
                    break;
                }
                case 2: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = this.queryCondition;
                }
            }
        }
    }

    static void collectSubQueriesAndReferences(OrderedHashSet orderedHashSet, Expression expression2) {
        expression2.collectAllExpressions(orderedHashSet, Expression.subqueryExpressionSet, Expression.emptyExpressionSet);
        int n = orderedHashSet.size();
        for (int i = 0; i < n; ++i) {
            Expression expression3 = (Expression)orderedHashSet.get(i);
            expression3.collectObjectNames(orderedHashSet);
        }
    }

    @Override
    public OrderedHashSet getSubqueries() {
        int n;
        OrderedHashSet orderedHashSet = null;
        for (n = 0; n < this.indexLimitExpressions; ++n) {
            orderedHashSet = this.exprColumns[n].collectAllSubqueries(orderedHashSet);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectAllSubqueries(orderedHashSet);
        }
        if (this.havingCondition != null) {
            orderedHashSet = this.havingCondition.collectAllSubqueries(orderedHashSet);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            OrderedHashSet orderedHashSet2 = this.rangeVariables[n].getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
        }
        return orderedHashSet;
    }

    @Override
    public Table getBaseTable() {
        return this.baseTable;
    }

    public OrderedHashSet collectAllSubqueries(OrderedHashSet orderedHashSet) {
        return orderedHashSet;
    }

    public OrderedHashSet collectOuterColumnExpressions(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        if ((orderedHashSet = this.collectAllExpressions(orderedHashSet, Expression.columnExpressionSet, Expression.subqueryAggregateExpressionSet)) == null) {
            return null;
        }
        for (int i = orderedHashSet.size() - 1; i >= 0; --i) {
            Expression expression2 = (Expression)orderedHashSet.get(i);
            if (ArrayUtil.find(this.rangeVariables, expression2.getRangeVariable()) >= 0) {
                orderedHashSet.remove(i);
            }
            if (!orderedHashSet2.contains(expression2)) continue;
            orderedHashSet.remove(i);
        }
        if (orderedHashSet.isEmpty()) {
            orderedHashSet = null;
        }
        return orderedHashSet;
    }

    @Override
    public OrderedHashSet collectAllExpressions(OrderedHashSet orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            orderedHashSet = this.exprColumns[n].collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        if (this.havingCondition != null) {
            orderedHashSet = this.havingCondition.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            this.rangeVariables[n].collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    @Override
    public void collectObjectNames(Set set2) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            this.exprColumns[n].collectObjectNames(set2);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectObjectNames(set2);
        }
        if (this.havingCondition != null) {
            this.havingCondition.collectObjectNames(set2);
        }
        int n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            HsqlNameManager.HsqlName hsqlName = this.rangeVariables[n].getTable().getName();
            set2.add(hsqlName);
        }
    }

    @Override
    public void replaceColumnReferences(RangeVariable rangeVariable, Expression[] expressionArray) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            this.exprColumns[n] = this.exprColumns[n].replaceColumnReferences(rangeVariable, expressionArray);
        }
        if (this.queryCondition != null) {
            this.queryCondition = this.queryCondition.replaceColumnReferences(rangeVariable, expressionArray);
        }
        if (this.havingCondition != null) {
            this.havingCondition = this.havingCondition.replaceColumnReferences(rangeVariable, expressionArray);
        }
        int n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            this.rangeVariables[n].replaceColumnReferences(rangeVariable, expressionArray);
        }
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            this.exprColumns[n].replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        if (this.havingCondition != null) {
            this.havingCondition.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        int n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            this.rangeVariables[n].getSubqueries();
        }
    }

    @Override
    public void setReturningResult() {
        this.setReturningResultSet();
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    @Override
    void setReturningResultSet() {
        this.persistenceScope = 23;
    }

    @Override
    public boolean isSingleColumn() {
        return this.indexLimitVisible == 1;
    }

    @Override
    public String[] getColumnNames() {
        String[] stringArray = new String[this.indexLimitVisible];
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            stringArray[i] = this.exprColumns[i].getAlias();
        }
        return stringArray;
    }

    @Override
    public Type[] getColumnTypes() {
        if (this.resultColumnTypes.length == this.indexLimitVisible) {
            return this.resultColumnTypes;
        }
        Type[] typeArray = new Type[this.indexLimitVisible];
        ArrayUtil.copyArray(this.resultColumnTypes, typeArray, typeArray.length);
        return typeArray;
    }

    @Override
    public int getColumnCount() {
        return this.indexLimitVisible;
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return this.columnMap;
    }

    @Override
    public Expression getCheckCondition() {
        return this.queryCondition;
    }

    @Override
    void getBaseTableNames(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            Table table = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName hsqlName = table.getName();
            if (table.isView() || table.isDataReadOnly() || table.isTemp() || hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            orderedHashSet.add(hsqlName);
        }
    }

    @Override
    boolean isEquivalent(QueryExpression queryExpression) {
        if (!(queryExpression instanceof QuerySpecification)) {
            return false;
        }
        QuerySpecification querySpecification = (QuerySpecification)queryExpression;
        if (!Expression.equals(this.exprColumns, querySpecification.exprColumns)) {
            return false;
        }
        if (!Expression.equals(this.queryCondition, querySpecification.queryCondition)) {
            return false;
        }
        if (this.rangeVariables.length != querySpecification.rangeVariables.length) {
            return false;
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].getTable() == querySpecification.rangeVariables[i].getTable()) continue;
            return false;
        }
        return true;
    }
}

