/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAccessor;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class StatementDML
extends StatementDMQL {
    Expression[] targets;
    boolean isTruncate;
    boolean isMergeDeleteFirst;
    Expression mergeInsertCondition;
    Expression mergeUpdateCondition;
    Expression mergeDeleteCondition;
    boolean isSimpleInsert;
    int generatedType;
    ResultMetaData generatedInputMetaData;
    int limit = Integer.MAX_VALUE;
    int[] generatedIndexes;
    ResultMetaData generatedResultMetaData;

    public StatementDML(int n, int n2, HsqlNameManager.HsqlName hsqlName) {
        super(n, n2, hsqlName);
    }

    StatementDML(Session session, Table table, RangeVariable rangeVariable, RangeVariable[] rangeVariableArray, ParserDQL.CompileContext compileContext, boolean bl, int n, SortAndSlice sortAndSlice) {
        super(19, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = table;
        this.baseTable = table.isTriggerDeletable() ? table : table.getBaseTable();
        this.targetRangeVariables = rangeVariableArray;
        this.restartIdentity = bl;
        if (sortAndSlice != null) {
            int[] nArray = sortAndSlice.getLimits(session, null, Integer.MAX_VALUE);
            this.limit = nArray[1];
        }
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        if (n == 1215) {
            this.isTruncate = true;
        }
        rangeVariable.addAllColumns();
    }

    StatementDML(Session session, Expression[] expressionArray, Table table, RangeVariable rangeVariable, RangeVariable[] rangeVariableArray, int[] nArray, Expression[] expressionArray2, boolean[] blArray, ParserDQL.CompileContext compileContext, SortAndSlice sortAndSlice) {
        super(92, 2004, session.getCurrentSchemaHsqlName());
        this.targets = expressionArray;
        this.targetTable = table;
        this.baseTable = table.isTriggerUpdatable() ? table : table.getBaseTable();
        this.updateColumnMap = nArray;
        this.updateExpressions = expressionArray2;
        this.updateCheckColumns = blArray;
        this.targetRangeVariables = rangeVariableArray;
        if (sortAndSlice != null) {
            int[] nArray2 = sortAndSlice.getLimits(session, null, Integer.MAX_VALUE);
            this.limit = nArray2[1];
        }
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        rangeVariable.addAllColumns();
    }

    StatementDML(Session session, Expression[] expressionArray, RangeVariable rangeVariable, RangeVariable rangeVariable2, RangeVariable[] rangeVariableArray, int[] nArray, int[] nArray2, boolean[] blArray, Expression expression2, Expression expression3, Expression[] expressionArray2, boolean bl, Expression expression4, Expression expression5, Expression expression6, ParserDQL.CompileContext compileContext) {
        super(56, 2004, session.getCurrentSchemaHsqlName());
        this.targets = expressionArray;
        this.sourceTable = rangeVariable.rangeTable;
        this.targetTable = rangeVariable2.rangeTable;
        this.baseTable = this.targetTable.isTriggerUpdatable() ? this.targetTable : this.targetTable.getBaseTable();
        this.insertCheckColumns = blArray;
        this.insertColumnMap = nArray;
        this.updateColumnMap = nArray2;
        this.insertExpression = expression3;
        this.updateExpressions = expressionArray2;
        this.targetRangeVariables = rangeVariableArray;
        this.condition = expression2;
        this.mergeInsertCondition = expression4;
        this.mergeUpdateCondition = expression5;
        this.mergeDeleteCondition = expression6;
        this.isMergeDeleteFirst = bl;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    StatementDML() {
        super(91, 2004, null);
    }

    void setupChecks() {
        if (this.targetTable != this.baseTable) {
            QuerySpecification querySpecification = ((TableDerived)this.targetTable).getQueryExpression().getMainSelect();
            this.updatableTableCheck = querySpecification.checkQueryCondition;
            this.checkRangeVariable = querySpecification.rangeVariables[querySpecification.rangeVariables.length - 1];
        }
    }

    @Override
    Result getResult(Session session) {
        Result result2 = null;
        switch (this.type) {
            case 92: {
                result2 = this.executeUpdateStatement(session);
                break;
            }
            case 56: {
                result2 = this.executeMergeStatement(session);
                break;
            }
            case 19: {
                if (this.isTruncate) {
                    result2 = this.executeDeleteTruncateStatement(session);
                    break;
                }
                result2 = this.executeDeleteStatement(session);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementDML");
            }
        }
        session.sessionContext.diagnosticsVariables[2] = result2.getUpdateCount();
        return result2;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        SchemaObject schemaObject;
        int n;
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(orderedHashSet, false);
        } else if (!this.baseTable.isTemp()) {
            block5: for (n = 0; n < this.baseTable.fkConstraints.length; ++n) {
                schemaObject = this.baseTable.fkConstraints[n];
                switch (this.type) {
                    case 92: {
                        if (!ArrayUtil.haveCommonElement(((Constraint)schemaObject).getRefColumns(), this.updateColumnMap)) continue block5;
                        orderedHashSet.add(this.baseTable.fkConstraints[n].getMain().getName());
                        continue block5;
                    }
                    case 55: {
                        orderedHashSet.add(this.baseTable.fkConstraints[n].getMain().getName());
                        continue block5;
                    }
                    case 56: {
                        if (this.updateColumnMap != null && ArrayUtil.haveCommonElement(((Constraint)schemaObject).getRefColumns(), this.updateColumnMap)) {
                            orderedHashSet.add(this.baseTable.fkConstraints[n].getMain().getName());
                        }
                        if (this.insertExpression == null) continue block5;
                        orderedHashSet.add(this.baseTable.fkConstraints[n].getMain().getName());
                    }
                }
            }
            if (this.type == 92 || this.type == 56) {
                this.baseTable.collectFKReadLocks(this.updateColumnMap, orderedHashSet);
            } else if (this.type == 19) {
                this.baseTable.collectFKReadLocks(null, orderedHashSet);
            }
            this.getTriggerTableNames(orderedHashSet, false);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            schemaObject = this.rangeVariables[n].rangeTable;
            HsqlNameManager.HsqlName hsqlName = ((Table)schemaObject).getName();
            if (((Table)schemaObject).isDataReadOnly() || ((Table)schemaObject).isTemp() || hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            orderedHashSet.add(hsqlName);
        }
        for (n = 0; n < this.subqueries.length; ++n) {
            if (this.subqueries[n].queryExpression == null) continue;
            this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.routines.length; ++n) {
            orderedHashSet.addAll(this.routines[n].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(orderedHashSet, true);
        } else if (!this.baseTable.isTemp()) {
            orderedHashSet.add(this.baseTable.getName());
            if (this.type == 92 || this.type == 56) {
                if (this.updateExpressions.length != 0) {
                    this.baseTable.collectFKWriteLocks(this.updateColumnMap, orderedHashSet);
                }
            } else if (this.type == 19) {
                this.baseTable.collectFKWriteLocks(null, orderedHashSet);
            }
            this.getTriggerTableNames(orderedHashSet, true);
        }
    }

    @Override
    public void setGeneratedColumnInfo(int n, ResultMetaData resultMetaData) {
        if (this.type != 55) {
            return;
        }
        int n2 = this.baseTable.getIdentityColumnIndex();
        this.generatedType = n;
        this.generatedInputMetaData = resultMetaData;
        switch (n) {
            case 2: {
                return;
            }
            case 21: {
                this.generatedIndexes = resultMetaData.getGeneratedColumnIndexes();
                for (int i = 0; i < this.generatedIndexes.length; ++i) {
                    if (this.generatedIndexes[i] >= 0 && this.generatedIndexes[i] < this.baseTable.getColumnCount()) continue;
                    throw Error.error(5501);
                }
                break;
            }
            case 1: {
                int n3;
                if (this.baseTable.hasGeneratedColumn()) {
                    if (n2 >= 0) {
                        int n4 = ArrayUtil.countTrueElements(this.baseTable.colGenerated) + 1;
                        this.generatedIndexes = new int[n4];
                        int n5 = 0;
                        for (n3 = 0; n3 < this.baseTable.colGenerated.length; ++n3) {
                            if (!this.baseTable.colGenerated[n3] && n3 != n2) continue;
                            this.generatedIndexes[n5++] = n3;
                        }
                        break;
                    }
                    this.generatedIndexes = ArrayUtil.booleanArrayToIntIndexes(this.baseTable.colGenerated);
                    break;
                }
                if (n2 >= 0) {
                    this.generatedIndexes = new int[]{n2};
                    break;
                }
                return;
            }
            case 11: {
                int n3;
                String[] stringArray = resultMetaData.getGeneratedColumnNames();
                this.generatedIndexes = this.baseTable.getColumnIndexes(stringArray);
                for (n3 = 0; n3 < this.generatedIndexes.length; ++n3) {
                    if (this.generatedIndexes[n3] >= 0) continue;
                    throw Error.error(5501, stringArray[0]);
                }
                break;
            }
        }
        this.generatedResultMetaData = ResultMetaData.newResultMetaData(this.generatedIndexes.length);
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            ColumnSchema columnSchema = this.baseTable.getColumn(this.generatedIndexes[i]);
            this.generatedResultMetaData.columns[i] = columnSchema;
        }
        this.generatedResultMetaData.prepareData();
        this.isSimpleInsert = false;
    }

    Object[] getGeneratedColumns(Object[] objectArray) {
        if (this.generatedIndexes == null) {
            return null;
        }
        Object[] objectArray2 = new Object[this.generatedIndexes.length];
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            objectArray2[i] = objectArray[this.generatedIndexes[i]];
        }
        return objectArray2;
    }

    @Override
    public boolean hasGeneratedColumns() {
        return this.generatedIndexes != null;
    }

    @Override
    public ResultMetaData generatedResultMetaData() {
        return this.generatedResultMetaData;
    }

    void getTriggerTableNames(OrderedHashSet orderedHashSet, boolean bl) {
        block6: for (int i = 0; i < this.baseTable.triggerList.length; ++i) {
            TriggerDef triggerDef = this.baseTable.triggerList[i];
            switch (this.type) {
                case 55: {
                    if (triggerDef.getStatementType() != 55) continue block6;
                    break;
                }
                case 92: {
                    if (triggerDef.getStatementType() != 92) continue block6;
                    break;
                }
                case 19: {
                    if (triggerDef.getStatementType() != 19) continue block6;
                    break;
                }
                case 56: {
                    if (triggerDef.getStatementType() != 55 && triggerDef.getStatementType() != 92) continue block6;
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "StatementDML");
                }
            }
            if (triggerDef.routine == null) continue;
            if (bl) {
                orderedHashSet.addAll(triggerDef.routine.getTableNamesForWrite());
                continue;
            }
            orderedHashSet.addAll(triggerDef.routine.getTableNamesForRead());
        }
    }

    Result executeUpdateStatement(Session session) {
        int n = 0;
        RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
        Type[] typeArray = this.baseTable.getColumnTypes();
        RangeIterator rangeIterator = RangeVariable.getIterator(session, this.targetRangeVariables);
        Result result2 = null;
        RowSetNavigator rowSetNavigator = null;
        if (this.generatedIndexes != null) {
            result2 = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            rowSetNavigator = result2.getChainedResult().getNavigator();
        }
        session.sessionContext.rownum = 1;
        int n2 = 0;
        while (rangeIterator.next()) {
            session.sessionData.startRowProcessing();
            Row row = rangeIterator.getCurrentRow();
            Object[] objectArray = row.getData();
            Object[] objectArray2 = StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, typeArray, objectArray);
            if (this.updatableTableCheck != null) {
                rangeIterator.setCurrent(objectArray2);
                boolean bl = this.updatableTableCheck.testCondition(session);
                if (!bl) {
                    rangeIterator.release();
                    throw Error.error(5700);
                }
            }
            rowSetNavigatorDataChange.addRow(session, row, objectArray2, typeArray, this.updateColumnMap);
            ++session.sessionContext.rownum;
            if (++n2 != this.limit) continue;
            break;
        }
        rowSetNavigatorDataChange.endMainDataSet();
        rangeIterator.release();
        rowSetNavigatorDataChange.beforeFirst();
        n = this.update(session, this.baseTable, rowSetNavigatorDataChange, rowSetNavigator);
        if (result2 == null) {
            if (n == 1) {
                return Result.updateOneResult;
            }
            if (n == 0) {
                session.addWarning(HsqlException.noDataCondition);
                return Result.updateZeroResult;
            }
            return new Result(1, n);
        }
        result2.setUpdateCount(n);
        if (n == 0) {
            session.addWarning(HsqlException.noDataCondition);
        }
        return result2;
    }

    static Object[] getUpdatedData(Session session, Expression[] expressionArray, Table table, int[] nArray, Expression[] expressionArray2, Type[] typeArray, Object[] objectArray) {
        Object[] objectArray2 = table.getEmptyRowData();
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        int n = 0;
        int n2 = 0;
        while (n < nArray.length) {
            Cloneable cloneable;
            int n3;
            Expression expression2;
            if ((expression2 = expressionArray2[n2++]).getType() == 25) {
                Object[] objectArray3 = expression2.getRowValue(session);
                int n4 = 0;
                while (n4 < objectArray3.length) {
                    n3 = nArray[n];
                    cloneable = expression2.nodes[n4];
                    if (table.identityColumn != n3 || cloneable.getType() != 1 || cloneable.valueData != null) {
                        if (cloneable.getType() == 4) {
                            if (table.identityColumn != n3) {
                                objectArray2[n3] = table.colDefaults[n3] == null ? null : table.colDefaults[n3].getValue(session);
                            }
                        } else {
                            objectArray2[n3] = typeArray[n3].convertToType(session, objectArray3[n4], cloneable.dataType);
                        }
                    }
                    ++n4;
                    ++n;
                }
                continue;
            }
            if (expression2.getType() == 22) {
                Object[] objectArray4 = expression2.getRowValue(session);
                int n5 = 0;
                while (n5 < objectArray4.length) {
                    n3 = nArray[n];
                    cloneable = expression2.table.queryExpression.getMetaData().columnTypes[n5];
                    objectArray2[n3] = typeArray[n3].convertToType(session, objectArray4[n5], (Type)cloneable);
                    ++n5;
                    ++n;
                }
                continue;
            }
            int n6 = nArray[n];
            if (expression2.getType() == 4) {
                if (table.identityColumn == n6) {
                    ++n;
                    continue;
                }
                objectArray2[n6] = table.colDefaults[n6] == null ? null : table.colDefaults[n6].getValue(session);
                ++n;
                continue;
            }
            Object object = expression2.getValue(session);
            objectArray2[n6] = expressionArray[n].getType() == 95 ? ((ExpressionAccessor)expressionArray[n]).getUpdatedArray(session, (Object[])objectArray2[n6], object, true) : typeArray[n6].convertToType(session, object, expression2.dataType);
            ++n;
        }
        return objectArray2;
    }

    Result executeMergeStatement(Session session) {
        int n;
        boolean bl;
        Type[] typeArray = this.baseTable.getColumnTypes();
        Result result2 = null;
        RowSetNavigator rowSetNavigator = null;
        boolean bl2 = bl = this.mergeDeleteCondition != null || this.updateExpressions.length != 0;
        if (this.generatedIndexes != null) {
            result2 = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            rowSetNavigator = result2.getChainedResult().getNavigator();
        }
        int n2 = 0;
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient(8);
        RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
        RangeVariable[] rangeVariableArray = this.targetRangeVariables;
        RangeIterator[] rangeIteratorArray = new RangeIterator[rangeVariableArray.length];
        for (n = 0; n < rangeVariableArray.length; ++n) {
            rangeIteratorArray[n] = rangeVariableArray[n].getIterator(session);
        }
        n = 0;
        while (n >= 0) {
            Object[] objectArray;
            RangeIterator rangeIterator = rangeIteratorArray[n];
            boolean bl3 = rangeIterator.isBeforeFirst();
            if (rangeIterator.next()) {
                if (n < rangeVariableArray.length - 1) {
                    ++n;
                    continue;
                }
            } else {
                if (n == 1 && bl3 && this.insertExpression != null && (objectArray = this.getInsertData(session, typeArray, this.insertExpression.nodes[0].nodes)) != null && this.mergeInsertCondition.testCondition(session)) {
                    rowSetNavigatorClient.add(objectArray);
                }
                rangeIterator.reset();
                --n;
                continue;
            }
            if (!bl) continue;
            objectArray = rangeIterator.getCurrentRow();
            session.sessionData.startRowProcessing();
            try {
                boolean bl4 = false;
                if (this.isMergeDeleteFirst && this.mergeDeleteCondition != null && (bl4 = this.mergeDeleteCondition.testCondition(session))) {
                    rowSetNavigatorDataChange.addRow((Row)objectArray);
                }
                if (!bl4 && this.mergeUpdateCondition != null && (bl4 = this.mergeUpdateCondition.testCondition(session))) {
                    Object[] objectArray2 = StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, typeArray, objectArray.getData());
                    rowSetNavigatorDataChange.addRow(session, (Row)objectArray, objectArray2, typeArray, this.updateColumnMap);
                }
                if (bl4 || this.isMergeDeleteFirst || this.mergeDeleteCondition == null || !(bl4 = this.mergeDeleteCondition.testCondition(session))) continue;
                rowSetNavigatorDataChange.addRow((Row)objectArray);
            }
            catch (HsqlException hsqlException) {
                for (int i = 0; i < rangeVariableArray.length; ++i) {
                    rangeIteratorArray[i].reset();
                }
                throw Error.error(3201);
            }
        }
        rowSetNavigatorDataChange.endMainDataSet();
        for (n = 0; n < rangeVariableArray.length; ++n) {
            rangeIteratorArray[n].reset();
        }
        if (bl) {
            n2 = this.update(session, this.baseTable, rowSetNavigatorDataChange, rowSetNavigator);
        }
        if (rowSetNavigatorClient.getSize() > 0) {
            this.insertRowSet(session, rowSetNavigator, rowSetNavigatorClient);
            n2 += rowSetNavigatorClient.getSize();
        }
        if (this.insertExpression != null && this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, rowSetNavigatorClient);
        }
        if (result2 == null) {
            if (n2 == 1) {
                return Result.updateOneResult;
            }
            if (n2 == 0) {
                session.addWarning(HsqlException.noDataCondition);
                return Result.updateZeroResult;
            }
            return new Result(1, n2);
        }
        result2.setUpdateCount(n2);
        if (n2 == 0) {
            session.addWarning(HsqlException.noDataCondition);
        }
        return result2;
    }

    void insertRowSet(Session session, RowSetNavigator rowSetNavigator, RowSetNavigator rowSetNavigator2) {
        Object[] objectArray;
        PersistentStore persistentStore = this.baseTable.getRowStore(session);
        RangeVariable.RangeIteratorMain rangeIteratorMain = null;
        if (this.updatableTableCheck != null) {
            rangeIteratorMain = this.checkRangeVariable.getIterator(session);
        }
        rowSetNavigator2.beforeFirst();
        if (this.baseTable.identityColumn != -1) {
            while (rowSetNavigator2.hasNext()) {
                objectArray = rowSetNavigator2.getNext();
                session.sessionData.startRowProcessing();
                this.baseTable.setIdentityColumn(session, objectArray);
            }
            rowSetNavigator2.beforeFirst();
        }
        if (this.baseTable.triggerLists[6].length > 0) {
            while (rowSetNavigator2.hasNext()) {
                objectArray = rowSetNavigator2.getNext();
                session.sessionData.startRowProcessing();
                this.baseTable.fireTriggers(session, 6, null, objectArray, null);
            }
            rowSetNavigator2.beforeFirst();
        }
        while (rowSetNavigator2.hasNext()) {
            objectArray = rowSetNavigator2.getNext();
            session.sessionData.startRowProcessing();
            this.baseTable.insertSingleRow(session, persistentStore, objectArray, null);
            if (rangeIteratorMain != null) {
                rangeIteratorMain.setCurrent(objectArray);
                boolean bl = this.updatableTableCheck.testCondition(session);
                if (!bl) {
                    throw Error.error(5700);
                }
            }
            if (rowSetNavigator == null) continue;
            Object[] objectArray2 = this.getGeneratedColumns(objectArray);
            rowSetNavigator.add(objectArray2);
        }
        rowSetNavigator2.beforeFirst();
        while (rowSetNavigator2.hasNext()) {
            objectArray = rowSetNavigator2.getNext();
            StatementDML.performIntegrityChecks(session, this.baseTable, null, objectArray, null);
        }
        rowSetNavigator2.beforeFirst();
        if (this.baseTable.triggerLists[3].length > 0) {
            while (rowSetNavigator2.hasNext()) {
                objectArray = rowSetNavigator2.getNext();
                this.baseTable.fireTriggers(session, 3, null, objectArray, null);
            }
            rowSetNavigator2.beforeFirst();
        }
    }

    Result insertSingleRow(Session session, PersistentStore persistentStore, Object[] objectArray) {
        session.sessionData.startRowProcessing();
        this.baseTable.setIdentityColumn(session, objectArray);
        if (this.baseTable.triggerLists[6].length > 0) {
            this.baseTable.fireTriggers(session, 6, null, objectArray, null);
        }
        this.baseTable.insertSingleRow(session, persistentStore, objectArray, null);
        StatementDML.performIntegrityChecks(session, this.baseTable, null, objectArray, null);
        if (session.database.isReferentialIntegrity()) {
            int n = this.baseTable.fkConstraints.length;
            for (int i = 0; i < n; ++i) {
                this.baseTable.fkConstraints[i].checkInsert(session, this.baseTable, objectArray, true);
            }
        }
        if (this.baseTable.triggerLists[3].length > 0) {
            this.baseTable.fireTriggers(session, 3, null, objectArray, null);
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, (RowSetNavigator)null);
        }
        session.sessionContext.diagnosticsVariables[2] = 1;
        return Result.updateOneResult;
    }

    Object[] getInsertData(Session session, Type[] typeArray, Expression[] expressionArray) {
        Object[] objectArray = this.baseTable.getNewRowData(session);
        session.sessionData.startRowProcessing();
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression2 = expressionArray[i];
            int n = this.insertColumnMap[i];
            if (expression2.opType == 4) {
                if (this.baseTable.identityColumn == n || this.baseTable.colDefaults[n] == null) continue;
                objectArray[n] = this.baseTable.colDefaults[n].getValue(session);
                continue;
            }
            Object object = expression2.getValue(session);
            Type type = typeArray[n];
            if (session.database.sqlSyntaxMys || session.database.sqlSyntaxPgs) {
                try {
                    object = type.convertToType(session, object, expression2.dataType);
                }
                catch (HsqlException hsqlException) {
                    if (type.typeCode == 91) {
                        object = Type.SQL_TIMESTAMP.convertToType(session, object, expression2.dataType);
                        object = type.convertToType(session, object, Type.SQL_TIMESTAMP);
                    }
                    if (type.typeCode == 93) {
                        object = Type.SQL_DATE.convertToType(session, object, expression2.dataType);
                        object = type.convertToType(session, object, Type.SQL_DATE);
                    }
                    throw hsqlException;
                }
            } else if (expression2.dataType == null || type.typeDataGroup != expression2.dataType.typeDataGroup || type.isArrayType()) {
                object = type.convertToType(session, object, expression2.dataType);
            }
            objectArray[n] = object;
        }
        return objectArray;
    }

    int update(Session session, Table table, RowSetNavigatorDataChange rowSetNavigatorDataChange, RowSetNavigator rowSetNavigator) {
        boolean bl;
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        int n = rowSetNavigatorDataChange.getSize();
        boolean bl2 = table.hasUpdatedColumn(this.updateColumnMap);
        for (int i = 0; i < n; ++i) {
            rowSetNavigatorDataChange.next();
            Object[] objectArray2 = rowSetNavigatorDataChange.getCurrentChangedData();
            session.sessionData.startRowProcessing();
            table.setIdentityColumn(session, objectArray2);
            table.setGeneratedColumns(session, objectArray2);
            if (!bl2) continue;
            table.setUpdatedColumns(session, objectArray2);
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            HashSet hashSet = session.sessionContext.getConstraintPath();
            for (int i = 0; i < n; ++i) {
                rowSetNavigatorDataChange.next();
                object3 = rowSetNavigatorDataChange.getCurrentRow();
                object2 = rowSetNavigatorDataChange.getCurrentChangedData();
                StatementDML.performReferentialActions(session, rowSetNavigatorDataChange, (Row)object3, (Object[])object2, this.updateColumnMap, hashSet, false);
                hashSet.clear();
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        while (rowSetNavigatorDataChange.next()) {
            Row row = rowSetNavigatorDataChange.getCurrentRow();
            Object[] objectArray3 = rowSetNavigatorDataChange.getCurrentChangedData();
            object3 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            object2 = (Object[])row.getTable();
            if (object2 instanceof TableDerived) {
                object2 = ((TableDerived)object2).view;
            }
            if (((Table)object2).triggerLists[8].length <= 0) continue;
            session.sessionData.startRowProcessing();
            ((Table)object2).fireTriggers(session, 8, row.getData(), objectArray3, (int[])object3);
            ((Table)object2).enforceRowConstraints(session, objectArray3);
        }
        if (table.isView) {
            return n;
        }
        rowSetNavigatorDataChange.beforeFirst();
        while (rowSetNavigatorDataChange.next()) {
            Row row = rowSetNavigatorDataChange.getCurrentRow();
            Table table2 = (Table)row.getTable();
            object3 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            object2 = table2.getRowStore(session);
            session.addDeleteAction(table2, (PersistentStore)object2, row, (int[])object3);
        }
        rowSetNavigatorDataChange.beforeFirst();
        while (rowSetNavigatorDataChange.next()) {
            Row row = rowSetNavigatorDataChange.getCurrentRow();
            Object[] objectArray4 = rowSetNavigatorDataChange.getCurrentChangedData();
            object3 = (Table)row.getTable();
            object2 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            objectArray = ((Table)object3).getRowStore(session);
            if (objectArray4 == null) continue;
            object = ((Table)object3).insertSingleRow(session, (PersistentStore)objectArray, objectArray4, (int[])object2);
            if (rowSetNavigator == null) continue;
            Object[] objectArray5 = this.getGeneratedColumns(objectArray4);
            rowSetNavigator.add(objectArray5);
        }
        rowSetNavigatorDataChange.beforeFirst();
        BaseHashMap baseHashMap = null;
        boolean bl3 = bl = table.triggerLists[5].length > 0;
        while (rowSetNavigatorDataChange.next()) {
            object3 = rowSetNavigatorDataChange.getCurrentRow();
            object2 = (Table)((Row)object3).getTable();
            objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
            object = rowSetNavigatorDataChange.getCurrentChangedColumns();
            StatementDML.performIntegrityChecks(session, (Table)object2, ((Row)object3).getData(), objectArray, (int[])object);
            if (object2 == table) continue;
            if (baseHashMap == null) {
                baseHashMap = new OrderedHashSet();
            }
            ((HashSet)baseHashMap).add(object2);
            if (((Table)object2).triggerLists[5].length <= 0) continue;
            bl = true;
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (bl) {
            while (rowSetNavigatorDataChange.next()) {
                object3 = rowSetNavigatorDataChange.getCurrentRow();
                object2 = rowSetNavigatorDataChange.getCurrentChangedData();
                objectArray = rowSetNavigatorDataChange.getCurrentChangedColumns();
                object = (Table)((Row)object3).getTable();
                ((Table)object).fireTriggers(session, 5, ((Row)object3).getData(), (Object[])object2, (int[])objectArray);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        this.baseTable.fireTriggers(session, 2, rowSetNavigatorDataChange);
        if (baseHashMap != null) {
            for (int i = 0; i < baseHashMap.size(); ++i) {
                object2 = (Table)((OrderedHashSet)baseHashMap).get(i);
                ((Table)object2).fireTriggers(session, 2, rowSetNavigatorDataChange);
            }
        }
        return n;
    }

    Result executeDeleteStatement(Session session) {
        int n = 0;
        RangeIterator rangeIterator = RangeVariable.getIterator(session, this.targetRangeVariables);
        RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
        session.sessionContext.rownum = 1;
        int n2 = 0;
        while (rangeIterator.next()) {
            Row row = rangeIterator.getCurrentRow();
            rowSetNavigatorDataChange.addRow(row);
            ++session.sessionContext.rownum;
            if (++n2 != this.limit) continue;
            break;
        }
        rangeIterator.release();
        rowSetNavigatorDataChange.endMainDataSet();
        if (rowSetNavigatorDataChange.getSize() <= 0) {
            session.addWarning(HsqlException.noDataCondition);
            return Result.updateZeroResult;
        }
        n = this.delete(session, this.baseTable, rowSetNavigatorDataChange);
        if (n == 1) {
            return Result.updateOneResult;
        }
        return new Result(1, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result executeDeleteTruncateStatement(Session session) {
        PersistentStore persistentStore = this.targetTable.getRowStore(session);
        RowIterator rowIterator = this.targetTable.getPrimaryIndex().firstRow(persistentStore);
        boolean bl = rowIterator.hasNext();
        for (int i = 0; i < this.targetTable.fkMainConstraints.length; ++i) {
            HsqlNameManager.HsqlName hsqlName;
            Table table;
            if (this.targetTable.fkMainConstraints[i].getRef() == this.targetTable || (table = session.database.schemaManager.getUserTable(hsqlName = this.targetTable.fkMainConstraints[i].getRef().getName())).isEmpty(session)) continue;
            throw Error.error(8, table.getName().name);
        }
        try {
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                session.addDeleteAction((Table)row.getTable(), persistentStore, row, null);
            }
            if (this.restartIdentity && this.targetTable.identitySequence != null) {
                this.targetTable.identitySequence.reset();
            }
        }
        finally {
            rowIterator.release();
        }
        if (!bl) {
            session.addWarning(HsqlException.noDataCondition);
        }
        return Result.updateOneResult;
    }

    int delete(Session session, Table table, RowSetNavigatorDataChange rowSetNavigatorDataChange) {
        boolean bl;
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        Object object4;
        int n = rowSetNavigatorDataChange.getSize();
        rowSetNavigatorDataChange.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            int n2;
            object4 = session.sessionContext.getConstraintPath();
            if (table.cascadingDeletes > 0) {
                for (n2 = 0; n2 < n; ++n2) {
                    rowSetNavigatorDataChange.next();
                    Row row = rowSetNavigatorDataChange.getCurrentRow();
                    StatementDML.performReferentialActions(session, rowSetNavigatorDataChange, row, null, null, (HashSet)object4, true);
                    ((BaseHashMap)object4).clear();
                }
                rowSetNavigatorDataChange.beforeFirst();
            }
            n2 = rowSetNavigatorDataChange.getSize();
            for (int i = 0; i < n2; ++i) {
                rowSetNavigatorDataChange.next();
                object3 = rowSetNavigatorDataChange.getCurrentRow();
                StatementDML.performReferentialActions(session, rowSetNavigatorDataChange, (Row)object3, null, null, (HashSet)object4, false);
                ((BaseHashMap)object4).clear();
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        while (rowSetNavigatorDataChange.next()) {
            object4 = rowSetNavigatorDataChange.getCurrentRow();
            Object[] objectArray2 = rowSetNavigatorDataChange.getCurrentChangedData();
            int[] nArray = rowSetNavigatorDataChange.getCurrentChangedColumns();
            object3 = (Table)((Row)object4).getTable();
            if (object3 instanceof TableDerived) {
                object3 = ((TableDerived)object3).view;
            }
            if (objectArray2 == null) {
                ((Table)object3).fireTriggers(session, 7, ((Row)object4).getData(), null, null);
                continue;
            }
            ((Table)object3).fireTriggers(session, 8, ((Row)object4).getData(), objectArray2, nArray);
        }
        if (table.isView) {
            return n;
        }
        rowSetNavigatorDataChange.beforeFirst();
        boolean bl2 = false;
        while (rowSetNavigatorDataChange.next()) {
            Row row = rowSetNavigatorDataChange.getCurrentRow();
            Object[] objectArray3 = rowSetNavigatorDataChange.getCurrentChangedData();
            object3 = (Table)row.getTable();
            object2 = ((Table)object3).getRowStore(session);
            session.addDeleteAction((Table)object3, (PersistentStore)object2, row, null);
            if (objectArray3 == null) continue;
            bl2 = true;
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (bl2) {
            while (rowSetNavigatorDataChange.next()) {
                Row row = rowSetNavigatorDataChange.getCurrentRow();
                Object[] objectArray4 = rowSetNavigatorDataChange.getCurrentChangedData();
                object3 = (Table)row.getTable();
                object2 = rowSetNavigatorDataChange.getCurrentChangedColumns();
                objectArray = ((Table)object3).getRowStore(session);
                if (objectArray4 == null) continue;
                object = ((Table)object3).insertSingleRow(session, (PersistentStore)objectArray, objectArray4, (int[])object2);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        BaseHashMap baseHashMap = null;
        BaseHashMap baseHashMap2 = null;
        boolean bl3 = bl = table.triggerLists[4].length > 0;
        if (n != rowSetNavigatorDataChange.getSize()) {
            while (rowSetNavigatorDataChange.next()) {
                object2 = rowSetNavigatorDataChange.getCurrentRow();
                objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
                object = rowSetNavigatorDataChange.getCurrentChangedColumns();
                Table table2 = (Table)((Row)object2).getTable();
                if (objectArray != null) {
                    StatementDML.performIntegrityChecks(session, table2, ((Row)object2).getData(), objectArray, (int[])object);
                }
                if (table2 == table) continue;
                if (objectArray == null) {
                    if (table2.triggerLists[4].length > 0) {
                        bl = true;
                    }
                    if (baseHashMap2 == null) {
                        baseHashMap2 = new OrderedHashSet();
                    }
                    ((HashSet)baseHashMap2).add(table2);
                    continue;
                }
                if (table2.triggerLists[5].length > 0) {
                    bl = true;
                }
                if (baseHashMap == null) {
                    baseHashMap = new OrderedHashSet();
                }
                ((HashSet)baseHashMap).add(table2);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        if (bl) {
            while (rowSetNavigatorDataChange.next()) {
                object2 = rowSetNavigatorDataChange.getCurrentRow();
                objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
                object = (Table)((Row)object2).getTable();
                if (objectArray == null) {
                    ((Table)object).fireTriggers(session, 4, ((Row)object2).getData(), null, null);
                    continue;
                }
                ((Table)object).fireTriggers(session, 5, ((Row)object2).getData(), objectArray, null);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        table.fireTriggers(session, 1, rowSetNavigatorDataChange);
        if (baseHashMap != null) {
            for (int i = 0; i < baseHashMap.size(); ++i) {
                objectArray = (Table)((OrderedHashSet)baseHashMap).get(i);
                objectArray.fireTriggers(session, 2, rowSetNavigatorDataChange);
            }
        }
        if (baseHashMap2 != null) {
            for (int i = 0; i < baseHashMap2.size(); ++i) {
                objectArray = (Table)((OrderedHashSet)baseHashMap2).get(i);
                objectArray.fireTriggers(session, 1, rowSetNavigatorDataChange);
            }
        }
        return n;
    }

    static void performIntegrityChecks(Session session, Table table, Object[] objectArray, Object[] objectArray2, int[] nArray) {
        int n;
        if (objectArray2 == null) {
            return;
        }
        int n2 = table.checkConstraints.length;
        for (n = 0; n < n2; ++n) {
            table.checkConstraints[n].checkInsert(session, table, objectArray2, objectArray == null);
        }
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        n2 = table.fkConstraints.length;
        for (n = 0; n < n2; ++n) {
            boolean bl = objectArray == null;
            Constraint constraint = table.fkConstraints[n];
            if (!bl) {
                bl = ArrayUtil.haveCommonElement(constraint.getRefColumns(), nArray);
            }
            if (!bl) continue;
            constraint.checkInsert(session, table, objectArray2, objectArray == null);
        }
    }

    static void performReferentialActions(Session session, RowSetNavigatorDataChange rowSetNavigatorDataChange, Row row, Object[] objectArray, int[] nArray, HashSet hashSet, boolean bl) {
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        boolean bl2 = objectArray == null;
        Table table = (Table)row.getTable();
        for (Constraint constraint : table.fkMainConstraints) {
            int n = bl2 ? constraint.getDeleteAction() : constraint.getUpdateAction();
            if (bl ^ (bl2 && n == 0) || !bl2 && (!ArrayUtil.haveCommonElement(nArray, constraint.core.mainCols) || constraint.core.mainIndex.compareRowNonUnique(session, row.getData(), objectArray, constraint.core.mainCols) == 0)) continue;
            RowIterator rowIterator = constraint.findFkRef(session, row.getData());
            if (!rowIterator.hasNext()) {
                rowIterator.release();
                continue;
            }
            block12: while (rowIterator.hasNext()) {
                Object[] objectArray2;
                Row row2 = rowIterator.getNextRow();
                Object[] objectArray3 = null;
                if (constraint.core.refIndex.compareRowNonUnique(session, row2.getData(), row.getData(), constraint.core.mainCols) != 0) break;
                if (bl2 && row2.getId() == row.getId()) continue;
                switch (n) {
                    case 0: {
                        int n2;
                        if (bl2) {
                            try {
                                n2 = rowSetNavigatorDataChange.addRow(row2) ? 1 : 0;
                            }
                            catch (HsqlException hsqlException) {
                                Object[] objectArray4 = StatementDML.getConstraintInfo(constraint);
                                rowIterator.release();
                                throw Error.error(null, 3900, 2, objectArray4);
                            }
                            if (n2 == 0) continue block12;
                            StatementDML.performReferentialActions(session, rowSetNavigatorDataChange, row2, null, null, hashSet, bl);
                            continue block12;
                        }
                        objectArray3 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray3, 0, objectArray3.length);
                        for (n2 = 0; n2 < constraint.core.refCols.length; ++n2) {
                            objectArray3[constraint.core.refCols[n2]] = objectArray[constraint.core.mainCols[n2]];
                        }
                        break;
                    }
                    case 2: {
                        int n2;
                        objectArray3 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray3, 0, objectArray3.length);
                        for (n2 = 0; n2 < constraint.core.refCols.length; ++n2) {
                            objectArray3[constraint.core.refCols[n2]] = null;
                        }
                        break;
                    }
                    case 4: {
                        int n2;
                        objectArray3 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray3, 0, objectArray3.length);
                        for (n2 = 0; n2 < constraint.core.refCols.length; ++n2) {
                            objectArray2 = constraint.core.refTable.getColumn(constraint.core.refCols[n2]);
                            objectArray3[constraint.core.refCols[n2]] = objectArray2.getDefaultValue(session);
                        }
                        break;
                    }
                    case 3: {
                        if (bl2 ? rowSetNavigatorDataChange.containsDeletedRow(row2) : rowSetNavigatorDataChange.containsUpdatedRow(row, row2, constraint.core.mainCols)) continue block12;
                    }
                    case 1: {
                        int n2 = constraint.getDeleteAction() == 3 ? 8 : 3501;
                        objectArray2 = StatementDML.getConstraintInfo(constraint);
                        rowIterator.release();
                        throw Error.error(null, n2, 2, objectArray2);
                    }
                    default: {
                        continue block12;
                    }
                }
                try {
                    objectArray3 = rowSetNavigatorDataChange.addRow(session, row2, objectArray3, constraint.core.refTable.getColumnTypes(), constraint.core.refCols);
                }
                catch (HsqlException hsqlException) {
                    objectArray2 = StatementDML.getConstraintInfo(constraint);
                    rowIterator.release();
                    throw Error.error(null, 3900, 2, objectArray2);
                }
                if (objectArray3 == null || !hashSet.add(constraint)) continue;
                StatementDML.performReferentialActions(session, rowSetNavigatorDataChange, row2, objectArray3, constraint.core.refCols, hashSet, bl);
                hashSet.remove(constraint);
            }
            rowIterator.release();
        }
    }

    static String[] getConstraintInfo(Constraint constraint) {
        return new String[]{constraint.core.refName.name, constraint.core.refTable.getName().name};
    }

    @Override
    public void clearStructures(Session session) {
        session.sessionContext.clearStructures(this);
    }
}

