/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.Session;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.result.Result;

public class StatementSchemaDefinition
extends StatementSchema {
    StatementSchema[] statements;

    StatementSchemaDefinition(StatementSchema[] statementSchemaArray) {
        super(68, 2001);
        this.statements = statementSchemaArray;
    }

    @Override
    public Result execute(Session session) {
        Result result2;
        try {
            result2 = this.getResult(session);
        }
        catch (Throwable throwable) {
            result2 = Result.newErrorResult(throwable);
        }
        if (result2.isError()) {
            result2.getException().setStatementType(this.group, this.type);
        }
        return result2;
    }

    @Override
    Result getResult(Session session) {
        Table table;
        Object object;
        int n;
        HsqlNameManager.HsqlName hsqlName = this.statements[0].getSchemaName();
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        Result result2 = this.statements[0].execute(session);
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        StatementSchema statementSchema = new StatementSchema(null, 1161);
        if (this.statements.length == 1 || result2.isError()) {
            return result2;
        }
        HsqlNameManager.HsqlName hsqlName2 = session.getCurrentSchemaHsqlName();
        for (n = 1; n < this.statements.length; ++n) {
            try {
                session.setSchema(hsqlName.name);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            this.statements[n].setSchemaHsqlName(hsqlName);
            session.parser.reset(session, this.statements[n].getSQL());
            try {
                session.parser.read();
                switch (this.statements[n].getType()) {
                    case 53: 
                    case 54: {
                        result2 = this.statements[n].execute(session);
                        break;
                    }
                    case 87: {
                        StatementSchema statementSchema2 = session.parser.compileCreate();
                        statementSchema2.isSchemaDefinition = true;
                        statementSchema2.setSchemaHsqlName(hsqlName);
                        if (session.parser.token.tokenType != 914) {
                            throw session.parser.unexpectedToken();
                        }
                        statementSchema2.isLogged = false;
                        result2 = statementSchema2.execute(session);
                        object = ((Table)statementSchema2.arguments[0]).getName();
                        table = (Table)session.database.schemaManager.getSchemaObject((HsqlNameManager.HsqlName)object);
                        hsqlArrayList.addAll((HsqlArrayList)statementSchema2.arguments[1]);
                        ((HsqlArrayList)statementSchema2.arguments[1]).clear();
                        statementSchema.sql = table.getSQL();
                        statementSchema.execute(session);
                        break;
                    }
                    case 11: 
                    case 13: 
                    case 65: 
                    case 71: 
                    case 94: {
                        result2 = this.statements[n].execute(session);
                        break;
                    }
                    case 23: 
                    case 69: 
                    case 90: 
                    case 96: 
                    case 1125: {
                        StatementSchema statementSchema2 = session.parser.compileCreate();
                        statementSchema2.isSchemaDefinition = true;
                        statementSchema2.setSchemaHsqlName(hsqlName);
                        if (session.parser.token.tokenType != 914) {
                            throw session.parser.unexpectedToken();
                        }
                        result2 = statementSchema2.execute(session);
                        break;
                    }
                    case 9: 
                    case 88: 
                    case 89: 
                    case 93: 
                    case 95: {
                        throw session.parser.unsupportedFeature();
                    }
                    default: {
                        throw Error.runtimeError(201, "");
                    }
                }
                if (!result2.isError()) continue;
            }
            catch (HsqlException hsqlException) {
                result2 = Result.newErrorResult(hsqlException, this.statements[n].getSQL());
            }
            break;
        }
        if (!result2.isError()) {
            try {
                for (n = 0; n < hsqlArrayList.size(); ++n) {
                    object = (Constraint)hsqlArrayList.get(n);
                    table = session.database.schemaManager.getUserTable(((Constraint)object).core.refTableName);
                    ParserDDL.addForeignKey(session, table, (Constraint)object, null);
                    statementSchema.sql = ((Constraint)object).getSQL();
                    statementSchema.execute(session);
                }
            }
            catch (HsqlException hsqlException) {
                result2 = Result.newErrorResult(hsqlException, this.sql);
            }
        }
        if (result2.isError()) {
            try {
                session.database.schemaManager.dropSchema(session, hsqlName.name, true);
                session.database.logger.writeOtherStatement(session, this.getDropSchemaStatement(hsqlName));
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
        session.setCurrentSchemaHsqlName(hsqlName2);
        return result2;
    }

    String getDropSchemaStatement(HsqlNameManager.HsqlName hsqlName) {
        return "DROP SCHEMA " + hsqlName.statementName + " " + "CASCADE";
    }

    @Override
    public boolean isAutoCommitStatement() {
        return true;
    }
}

