/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.TextCache;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.rowio.RowInputInterface;

public class TextTable
extends Table {
    String dataSource = "";
    boolean isReversed = false;
    boolean isConnected = false;

    TextTable(Database database, HsqlNameManager.HsqlName hsqlName, int n) {
        super(database, hsqlName, n);
        this.isWithDataSource = true;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public void connect(Session session) {
        this.connect(session, this.isReadOnly);
    }

    private void connect(Session session, boolean bl) {
        PersistentStore persistentStore;
        if (this.dataSource.length() == 0 || this.isConnected) {
            return;
        }
        this.store = persistentStore = this.database.persistentStoreCollection.getStore(this);
        TextCache textCache = null;
        TextFileReader textFileReader = null;
        boolean bl2 = this.isReadOnly || this.database.isReadOnly();
        String string2 = this.database.logger.getSecurePath(this.dataSource, false, true);
        if (string2 == null) {
            throw Error.error(457, this.dataSource);
        }
        try {
            RowInputInterface rowInputInterface;
            textCache = (TextCache)this.database.logger.textTableManager.openTextFilePersistence(this, string2, bl2, this.isReversed);
            persistentStore.setCache(textCache);
            textFileReader = textCache.getTextFileReader();
            Row row = null;
            if (textCache.isIgnoreFirstLine()) {
                textFileReader.readHeaderLine();
                textCache.setHeaderInitialise(textFileReader.getHeaderLine());
            }
            while ((rowInputInterface = textFileReader.readObject()) != null && (row = (Row)persistentStore.get(rowInputInterface)) != null) {
                Object[] objectArray = row.getData();
                this.systemUpdateIdentityValue(objectArray);
                this.enforceRowConstraints(session, objectArray);
                persistentStore.indexRow(session, row);
            }
        }
        catch (Throwable throwable) {
            long l = textFileReader == null ? 0L : textFileReader.getLineNumber();
            this.clearAllData(session);
            if (textCache != null) {
                this.database.logger.textTableManager.closeTextCache(this);
                persistentStore.release();
            }
            throw Error.error(throwable, 483, 0, new Object[]{l, throwable.toString()});
        }
        this.isConnected = true;
        this.isReadOnly = bl;
    }

    public void disconnect() {
        this.store = null;
        PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(this);
        persistentStore.release();
        this.isConnected = false;
    }

    private void openCache(Session session, String string2, boolean bl, boolean bl2) {
        String string3 = this.dataSource;
        boolean bl3 = this.isReversed;
        boolean bl4 = this.isReadOnly;
        if (string2 == null) {
            string2 = "";
        }
        this.disconnect();
        this.dataSource = string2;
        this.isReversed = bl && this.dataSource.length() > 0;
        try {
            this.connect(session, bl2 || bl);
        }
        catch (HsqlException hsqlException) {
            this.dataSource = string3;
            this.isReversed = bl3;
            this.connect(session, bl4);
            throw hsqlException;
        }
    }

    void setDataSource(Session session, String string2, boolean bl, boolean bl2) {
        if (this.getTableType() != 6) {
            session.getGrantee().checkSchemaUpdateOrGrantRights(this.getSchemaName().name);
        }
        string2 = string2.trim();
        if (bl || bl != this.isReversed || !this.dataSource.equals(string2) || !this.isConnected) {
            this.openCache(session, string2, bl, this.isReadOnly);
        }
        if (this.isReversed) {
            this.isReadOnly = true;
        }
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public boolean isDescDataSource() {
        return this.isReversed;
    }

    public void setHeader(String string2) {
        PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(this);
        TextCache textCache = (TextCache)persistentStore.getCache();
        if (textCache != null && textCache.isIgnoreFirstLine()) {
            textCache.setHeader(string2);
            return;
        }
        throw Error.error(486);
    }

    private String getHeader() {
        PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(this);
        TextCache textCache = (TextCache)persistentStore.getCache();
        String string2 = textCache == null ? null : textCache.getHeader();
        return string2 == null ? null : StringConverter.toQuotedString(string2, '\'', true);
    }

    @Override
    public void checkDataReadOnly() {
        if (this.dataSource.length() == 0) {
            String string2 = this.getName().getSchemaQualifiedStatementName();
            throw Error.error(481, string2);
        }
        if (this.isDataReadOnly()) {
            throw Error.error(456);
        }
    }

    @Override
    public boolean isDataReadOnly() {
        return !this.isConnected() || super.isDataReadOnly() || this.store.getCache().isDataReadOnly();
    }

    @Override
    public void setDataReadOnly(boolean bl) {
        if (!bl) {
            if (this.isReversed) {
                throw Error.error(456);
            }
            if (this.database.isFilesReadOnly()) {
                throw Error.error(455);
            }
            if (this.isConnected()) {
                this.store.getCache().close();
                this.store.getCache().open(bl);
            }
        }
        this.isReadOnly = bl;
    }

    @Override
    public void insertData(Session session, PersistentStore persistentStore, Object[] objectArray) {
        Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, false);
        persistentStore.indexRow(session, row);
        persistentStore.commitPersistence(row);
    }

    String getDataSourceDDL() {
        String string2 = this.getDataSource();
        if (string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(this.getName().getSchemaQualifiedStatementName());
        stringBuffer.append(' ').append("SOURCE").append(' ').append('\'');
        stringBuffer.append(string2);
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    String getDataSourceHeader() {
        String string2 = this.getHeader();
        if (string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(this.getName().getSchemaQualifiedStatementName());
        stringBuffer.append(' ').append("SOURCE").append(' ');
        stringBuffer.append("HEADER").append(' ');
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

