/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hsqldb.auth.AuthFunctionBean;
import org.hsqldb.jdbc.JDBCArrayBasic;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.types.Type;

public class AuthBeanMultiplexer {
    private static FrameworkLogger logger = FrameworkLogger.getLog(AuthBeanMultiplexer.class);
    private static AuthBeanMultiplexer singleton = new AuthBeanMultiplexer();
    private static Map<String, List<AuthFunctionBean>> beans = new HashMap<String, List<AuthFunctionBean>>();

    private AuthBeanMultiplexer() {
    }

    public static AuthBeanMultiplexer getSingleton() {
        return singleton;
    }

    public void clear() {
        beans.clear();
    }

    public void setAuthFunctionBeans(Map<String, List<AuthFunctionBean>> map23) {
        if (beans.size() > 0) {
            throw new IllegalStateException("Use setAuthFunctionBeans(Map) only when the set is empty");
        }
        beans.putAll(map23);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getUniqueNameFor(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("CALL database_name()");
            if (!resultSet.next()) {
                throw new SQLException("Engine did not reveal unique database name");
            }
            String string2 = resultSet.getString(1);
            return string2;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    logger.error("Failed to close ResultSet for retrieving db name");
                }
            }
            resultSet = null;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                logger.error("Failed to close Statement for retrieving db name");
            }
            statement = null;
        }
    }

    public void setAuthFunctionBeans(Connection connection, List<AuthFunctionBean> list2) throws SQLException {
        this.setAuthFunctionBeans(AuthBeanMultiplexer.getUniqueNameFor(connection), list2);
    }

    public void setAuthFunctionBeans(String string2, List<AuthFunctionBean> list2) {
        if (string2 == null || string2.length() != 16) {
            throw new IllegalArgumentException("Database name not exactly 16 characters long: " + string2);
        }
        List<AuthFunctionBean> list3 = beans.get(string2);
        if (list3 == null) {
            list3 = new ArrayList<AuthFunctionBean>();
            beans.put(string2, list3);
        } else if (list3.size() > 0) {
            throw new IllegalStateException("Use setAuthFunctionBeans(String, List) only when the db's AuthFunctionBean list is empty");
        }
        list3.addAll(list2);
    }

    public void setAuthFunctionBean(Connection connection, AuthFunctionBean authFunctionBean) throws SQLException {
        this.setAuthFunctionBeans(AuthBeanMultiplexer.getUniqueNameFor(connection), Collections.singletonList(authFunctionBean));
    }

    public void setAuthFunctionBean(String string2, AuthFunctionBean authFunctionBean) {
        this.setAuthFunctionBeans(string2, Collections.singletonList(authFunctionBean));
    }

    public static Array authenticate(String string2, String string3, String string4) throws Exception {
        if (string2 == null || string2.length() != 16) {
            throw new IllegalStateException("Internal problem.  Database name not exactly 16 characters long: " + string2);
        }
        List<AuthFunctionBean> list2 = beans.get(string2);
        if (list2 == null) {
            logger.error("Database '" + string2 + "' has not been set up with " + AuthBeanMultiplexer.class.getName());
            throw new IllegalArgumentException("Database '" + string2 + "' has not been set up with " + AuthBeanMultiplexer.class.getName());
        }
        RuntimeException runtimeException = null;
        for (AuthFunctionBean authFunctionBean : list2) {
            try {
                Object[] objectArray = authFunctionBean.authenticate(string3, string4);
                return objectArray == null ? null : new JDBCArrayBasic(objectArray, Type.SQL_VARCHAR);
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException == null) {
                    runtimeException = runtimeException2;
                }
                logger.error("System failure of an AuthFunctionBean: " + (runtimeException2.getMessage() == null ? runtimeException2.toString() : runtimeException2.getMessage()));
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        throw runtimeException;
    }
}

