/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.hsqldb.auth.AuthBeanMultiplexer;
import org.hsqldb.auth.DenyException;
import org.hsqldb.auth.LdapAuthBean;

public class LdapAuthBeanTester {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("SYNTAX:  java " + AuthBeanMultiplexer.class.getName() + " path/to/file.properties <USERNAME> <PASSWORD>");
        }
        File file = new File(stringArray[0]);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + file.getAbsolutePath());
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        String string2 = properties.getProperty("trustStore");
        String string3 = properties.getProperty("startTls");
        String string4 = properties.getProperty("ldapPort");
        String string5 = properties.getProperty("roleSchemaValuePattern");
        String string6 = properties.getProperty("accessValuePattern");
        String string7 = properties.getProperty("securityMechanism");
        String string8 = properties.getProperty("ldapHost");
        String string9 = properties.getProperty("principalTemplate");
        String string10 = properties.getProperty("initialContextFactory");
        String string11 = properties.getProperty("saslRealm");
        String string12 = properties.getProperty("parentDn");
        String string13 = properties.getProperty("rdnAttribute");
        String string14 = properties.getProperty("rolesSchemaAttribute");
        String string15 = properties.getProperty("accessAttribute");
        if (string2 != null) {
            if (!new File(string2).isFile()) {
                throw new IllegalArgumentException("Specified trust store is not a file: " + string2);
            }
            System.setProperty("javax.net.ssl.trustStore", string2);
        }
        LdapAuthBean ldapAuthBean = new LdapAuthBean();
        if (string3 != null) {
            ldapAuthBean.setStartTls(Boolean.parseBoolean(string3));
        }
        if (string4 != null) {
            ldapAuthBean.setLdapPort(Integer.parseInt(string4));
        }
        if (string5 != null) {
            ldapAuthBean.setRoleSchemaValuePatternString(string5);
        }
        if (string6 != null) {
            ldapAuthBean.setAccessValuePatternString(string6);
        }
        if (string7 != null) {
            ldapAuthBean.setSecurityMechanism(string7);
        }
        if (string8 != null) {
            ldapAuthBean.setLdapHost(string8);
        }
        if (string9 != null) {
            ldapAuthBean.setPrincipalTemplate(string9);
        }
        if (string10 != null) {
            ldapAuthBean.setInitialContextFactory(string10);
        }
        if (string11 != null) {
            ldapAuthBean.setSaslRealm(string11);
        }
        if (string12 != null) {
            ldapAuthBean.setParentDn(string12);
        }
        if (string13 != null) {
            ldapAuthBean.setRdnAttribute(string13);
        }
        if (string14 != null) {
            ldapAuthBean.setRolesSchemaAttribute(string14);
        }
        if (string15 != null) {
            ldapAuthBean.setAccessAttribute(string15);
        }
        ldapAuthBean.init();
        Object[] objectArray = null;
        try {
            objectArray = ldapAuthBean.authenticate(stringArray[1], stringArray[2]);
        }
        catch (DenyException denyException) {
            System.out.println("<DENY ACCESS>");
            return;
        }
        if (objectArray == null) {
            System.out.println("<ALLOW ACCESS w/ local Roles+Schema>");
        } else {
            System.out.println(Integer.toString(objectArray.length) + " Roles/Schema: " + Arrays.toString(objectArray));
        }
    }
}

