/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.error;

import java.lang.reflect.Field;
import org.hsqldb.HsqlException;
import org.hsqldb.error.ErrorCode;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.resources.ResourceBundleHandler;
import org.hsqldb.result.Result;

public class Error {
    public static boolean TRACE = false;
    public static boolean TRACESYSTEMOUT = false;
    private static final String defaultMessage = "S1000 General error";
    private static final String errPropsName = "sql-state-messages";
    private static final int bundleHandle = ResourceBundleHandler.getBundleHandle("sql-state-messages", null);
    private static final String MESSAGE_TAG = "$$";
    private static final int SQL_STATE_DIGITS = 5;
    private static final int SQL_CODE_DIGITS = 4;
    private static final int ERROR_CODE_BASE = 11;

    public static RuntimeException runtimeError(int n, String string2) {
        HsqlException hsqlException = Error.error(n, string2);
        return new RuntimeException(hsqlException.getMessage());
    }

    public static HsqlException error(int n, String string2) {
        return Error.error(null, n, string2);
    }

    public static HsqlException error(Throwable throwable, int n, String string2) {
        String string3 = Error.getMessage(n);
        if (string2 != null) {
            string3 = string3 + ": " + string2;
        }
        return new HsqlException(throwable, string3.substring(6), string3.substring(0, 5), -n);
    }

    public static HsqlException parseError(int n, String string2, int n2) {
        String string3 = Error.getMessage(n);
        if (string2 != null) {
            string3 = string3 + ": " + string2;
        }
        if (n2 > 1) {
            string2 = Error.getMessage(24);
            string3 = string3 + " :" + string2 + String.valueOf(n2);
        }
        return new HsqlException(null, string3.substring(6), string3.substring(0, 5), -n);
    }

    public static HsqlException error(int n) {
        return Error.error(null, n, 0, null);
    }

    public static HsqlException error(int n, Throwable throwable) {
        String string2 = Error.getMessage(n, 0, null);
        return new HsqlException(throwable, string2.substring(0, 5), -n);
    }

    public static HsqlException error(Throwable throwable, int n, int n2, Object[] objectArray) {
        String string2 = Error.getMessage(n, n2, objectArray);
        int n3 = n2 < 11 ? n : n2;
        return new HsqlException(throwable, string2.substring(6), string2.substring(0, 5), -n3);
    }

    public static HsqlException parseError(int n, int n2, int n3, Object[] objectArray) {
        String string2 = Error.getMessage(n, n2, objectArray);
        if (n3 > 1) {
            String string3 = Error.getMessage(24);
            string2 = string2 + " :" + string3 + String.valueOf(n3);
        }
        int n4 = n2 < 11 ? n : n2;
        return new HsqlException(null, string2.substring(6), string2.substring(0, 5), -n4);
    }

    public static HsqlException error(int n, int n2) {
        return Error.error(n, Error.getMessage(n2));
    }

    public static HsqlException error(String string2, String string3) {
        int n = Error.getCode(string3);
        if (n < 1000) {
            n = 5800;
        }
        if (string2 == null) {
            string2 = Error.getMessage(n);
        }
        return new HsqlException(null, string2, string3, n);
    }

    private static String insertStrings(String string2, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 32);
        int n = 0;
        int n2 = string2.length();
        for (int i = 0; i < objectArray.length && (n2 = string2.indexOf(MESSAGE_TAG, n)) != -1; ++i) {
            stringBuffer.append(string2.substring(n, n2));
            stringBuffer.append(objectArray[i] == null ? "null exception message" : objectArray[i].toString());
            n = n2 + MESSAGE_TAG.length();
        }
        n2 = string2.length();
        stringBuffer.append(string2.substring(n, n2));
        return stringBuffer.toString();
    }

    public static String getMessage(int n) {
        return Error.getMessage(n, 0, null);
    }

    public static String getStateString(int n) {
        return Error.getMessage(n, 0, null).substring(0, 5);
    }

    public static String getMessage(int n, int n2, Object[] objectArray) {
        String string2 = Error.getResourceString(n);
        if (n2 != 0) {
            string2 = string2 + Error.getResourceString(n2);
        }
        if (objectArray != null) {
            string2 = Error.insertStrings(string2, objectArray);
        }
        return string2;
    }

    private static String getResourceString(int n) {
        String string2 = StringUtil.toZeroPaddedString(n, 4, 4);
        String string3 = ResourceBundleHandler.getString(bundleHandle, string2);
        if (string3 == null) {
            string3 = defaultMessage;
        }
        return string3;
    }

    public static HsqlException error(Result result2) {
        return new HsqlException(result2);
    }

    public static void printSystemOut(String string2) {
        if (TRACESYSTEMOUT) {
            System.out.println(string2);
        }
    }

    public static int getCode(String string2) {
        try {
            Field[] fieldArray = ErrorCode.class.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                String string3 = fieldArray[i].getName();
                if (string3.length() != 7 || !string3.endsWith(string2)) continue;
                return fieldArray[i].getInt(ErrorCode.class);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }
}

