/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class JDBCCallableStatement
extends JDBCPreparedStatement
implements CallableStatement {
    private IntValueHashMap parameterNameMap = new IntValueHashMap();
    private boolean wasNullValue;

    @Override
    public synchronized void registerOutParameter(int n, int n2) throws SQLException {
        this.checkGetParameterIndex(n);
        if (this.parameterModes[--n] == 1) {
            throw JDBCUtil.invalidArgument();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return super.getResultSet();
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.wasNullValue;
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        return (String)this.getColumnInType(n, Type.SQL_VARCHAR);
    }

    @Override
    public synchronized boolean getBoolean(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BOOLEAN);
        return object == null ? false : (Boolean)object;
    }

    @Override
    public synchronized byte getByte(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.TINYINT);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    @Override
    public synchronized short getShort(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_SMALLINT);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    @Override
    public synchronized int getInt(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_INTEGER);
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public synchronized long getLong(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BIGINT);
        return object == null ? 0L : ((Number)object).longValue();
    }

    @Override
    public synchronized float getFloat(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    @Override
    public synchronized double getDouble(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, 1);
        }
        return bigDecimal;
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_VARBINARY);
        if (object == null) {
            return null;
        }
        return ((BinaryData)object).getBytes();
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, timestampData);
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, timeData);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, timestampData);
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterTypes[n - 1];
        switch (type.typeCode) {
            case 50: {
                return this.getArray(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: 
            case 94: {
                return this.getTime(n);
            }
            case 93: 
            case 95: {
                return this.getTimestamp(n);
            }
            case 60: 
            case 61: {
                return this.getBytes(n);
            }
            case 14: {
                boolean bl = this.getBoolean(n);
                return this.wasNull() ? null : (bl ? Boolean.TRUE : Boolean.FALSE);
            }
            case 40: {
                return this.getClob(n);
            }
            case 30: {
                return this.getBlob(n);
            }
            case 1111: 
            case 2000: {
                Object object = this.getColumnInType(n, type);
                if (object == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)object).getObject();
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
        }
        return this.getColumnInType(n, type);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        Type type = this.parameterMetaData.columnTypes[n - 1];
        switch (type.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                type = Type.SQL_DECIMAL;
                break;
            }
            default: {
                type = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(n, type);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map23) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized Blob getBlob(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            return new JDBCBlobClient(this.session, (BlobDataID)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public synchronized Clob getClob(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return new JDBCClobClient(this.session, (ClobDataID)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterMetaData.columnTypes[n - 1];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        Object[] objectArray = (Object[])this.parameterValues[n - 1];
        if (objectArray == null) {
            return null;
        }
        return new JDBCArray(objectArray, type.collectionBaseType(), type, this.connection);
    }

    @Override
    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        long l = timestampData.getSeconds() * 1000L;
        if (calendar != null) {
            l = HsqlDateTime.convertMillisToCalendar(calendar, l);
        }
        return new Date(l);
    }

    @Override
    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        long l = (long)DateTimeType.normaliseTime(timeData.getSeconds()) * 1000L;
        if (!this.parameterMetaData.columnTypes[--n].isDateTimeTypeWithZone()) {
            Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
            l = HsqlDateTime.convertMillisToCalendar(calendar2, l);
            l = HsqlDateTime.getNormalisedTime(l);
        }
        return new Time(l);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Comparable<Calendar> comparable;
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        long l = timestampData.getSeconds() * 1000L;
        if (!this.parameterMetaData.columnTypes[--n].isDateTimeTypeWithZone()) {
            Comparable<Calendar> comparable2 = comparable = calendar == null ? this.session.getCalendar() : calendar;
            if (calendar != null) {
                l = HsqlDateTime.convertMillisToCalendar((Calendar)comparable, l);
            }
        }
        comparable = new Timestamp(l);
        ((Timestamp)comparable).setNanos(timestampData.getNanos());
        return comparable;
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, String string2) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    @Override
    public synchronized void registerOutParameter(String string2, int n) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string2), n);
    }

    @Override
    public synchronized void registerOutParameter(String string2, int n, int n2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string2), n);
    }

    @Override
    public synchronized void registerOutParameter(String string2, int n, String string3) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string2), n);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public void setURL(String string2, URL uRL) throws SQLException {
        this.setURL(this.findParameterIndex(string2), uRL);
    }

    @Override
    public synchronized void setNull(String string2, int n) throws SQLException {
        this.setNull(this.findParameterIndex(string2), n);
    }

    @Override
    public synchronized void setBoolean(String string2, boolean bl) throws SQLException {
        this.setBoolean(this.findParameterIndex(string2), bl);
    }

    @Override
    public synchronized void setByte(String string2, byte by2) throws SQLException {
        this.setByte(this.findParameterIndex(string2), by2);
    }

    @Override
    public synchronized void setShort(String string2, short s2) throws SQLException {
        this.setShort(this.findParameterIndex(string2), s2);
    }

    @Override
    public synchronized void setInt(String string2, int n) throws SQLException {
        this.setInt(this.findParameterIndex(string2), n);
    }

    @Override
    public synchronized void setLong(String string2, long l) throws SQLException {
        this.setLong(this.findParameterIndex(string2), l);
    }

    @Override
    public synchronized void setFloat(String string2, float f) throws SQLException {
        this.setFloat(this.findParameterIndex(string2), f);
    }

    @Override
    public synchronized void setDouble(String string2, double d) throws SQLException {
        this.setDouble(this.findParameterIndex(string2), d);
    }

    @Override
    public synchronized void setBigDecimal(String string2, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParameterIndex(string2), bigDecimal);
    }

    @Override
    public synchronized void setString(String string2, String string3) throws SQLException {
        this.setString(this.findParameterIndex(string2), string3);
    }

    @Override
    public synchronized void setBytes(String string2, byte[] byArray) throws SQLException {
        this.setBytes(this.findParameterIndex(string2), byArray);
    }

    @Override
    public synchronized void setDate(String string2, Date date2) throws SQLException {
        this.setDate(this.findParameterIndex(string2), date2);
    }

    @Override
    public synchronized void setTime(String string2, Time time) throws SQLException {
        this.setTime(this.findParameterIndex(string2), time);
    }

    @Override
    public synchronized void setTimestamp(String string2, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParameterIndex(string2), timestamp);
    }

    @Override
    public synchronized void setAsciiStream(String string2, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.findParameterIndex(string2), inputStream, n);
    }

    @Override
    public synchronized void setBinaryStream(String string2, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.findParameterIndex(string2), inputStream, n);
    }

    @Override
    public synchronized void setObject(String string2, Object object, int n, int n2) throws SQLException {
        this.setObject(this.findParameterIndex(string2), object, n, n2);
    }

    @Override
    public synchronized void setObject(String string2, Object object, int n) throws SQLException {
        this.setObject(this.findParameterIndex(string2), object, n);
    }

    @Override
    public synchronized void setObject(String string2, Object object) throws SQLException {
        this.setObject(this.findParameterIndex(string2), object);
    }

    @Override
    public synchronized void setCharacterStream(String string2, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.findParameterIndex(string2), reader, n);
    }

    @Override
    public synchronized void setDate(String string2, Date date2, Calendar calendar) throws SQLException {
        this.setDate(this.findParameterIndex(string2), date2, calendar);
    }

    @Override
    public synchronized void setTime(String string2, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParameterIndex(string2), time, calendar);
    }

    @Override
    public synchronized void setTimestamp(String string2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParameterIndex(string2), timestamp, calendar);
    }

    @Override
    public synchronized void setNull(String string2, int n, String string3) throws SQLException {
        this.setNull(this.findParameterIndex(string2), n, string3);
    }

    @Override
    public synchronized String getString(String string2) throws SQLException {
        return this.getString(this.findParameterIndex(string2));
    }

    @Override
    public synchronized boolean getBoolean(String string2) throws SQLException {
        return this.getBoolean(this.findParameterIndex(string2));
    }

    @Override
    public synchronized byte getByte(String string2) throws SQLException {
        return this.getByte(this.findParameterIndex(string2));
    }

    @Override
    public synchronized short getShort(String string2) throws SQLException {
        return this.getShort(this.findParameterIndex(string2));
    }

    @Override
    public synchronized int getInt(String string2) throws SQLException {
        return this.getInt(this.findParameterIndex(string2));
    }

    @Override
    public synchronized long getLong(String string2) throws SQLException {
        return this.getLong(this.findParameterIndex(string2));
    }

    @Override
    public synchronized float getFloat(String string2) throws SQLException {
        return this.getFloat(this.findParameterIndex(string2));
    }

    @Override
    public synchronized double getDouble(String string2) throws SQLException {
        return this.getDouble(this.findParameterIndex(string2));
    }

    @Override
    public synchronized byte[] getBytes(String string2) throws SQLException {
        return this.getBytes(this.findParameterIndex(string2));
    }

    @Override
    public synchronized Date getDate(String string2) throws SQLException {
        return this.getDate(this.findParameterIndex(string2));
    }

    @Override
    public synchronized Time getTime(String string2) throws SQLException {
        return this.getTime(this.findParameterIndex(string2));
    }

    @Override
    public synchronized Timestamp getTimestamp(String string2) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string2));
    }

    @Override
    public synchronized Object getObject(String string2) throws SQLException {
        return this.getObject(this.findParameterIndex(string2));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String string2) throws SQLException {
        return this.getBigDecimal(this.findParameterIndex(string2));
    }

    public synchronized Object getObject(String string2, Map map23) throws SQLException {
        return this.getObject(this.findParameterIndex(string2), map23);
    }

    @Override
    public synchronized Ref getRef(String string2) throws SQLException {
        return this.getRef(this.findParameterIndex(string2));
    }

    @Override
    public synchronized Blob getBlob(String string2) throws SQLException {
        return this.getBlob(this.findParameterIndex(string2));
    }

    @Override
    public synchronized Clob getClob(String string2) throws SQLException {
        return this.getClob(this.findParameterIndex(string2));
    }

    @Override
    public synchronized Array getArray(String string2) throws SQLException {
        return this.getArray(this.findParameterIndex(string2));
    }

    @Override
    public synchronized Date getDate(String string2, Calendar calendar) throws SQLException {
        return this.getDate(this.findParameterIndex(string2), calendar);
    }

    @Override
    public synchronized Time getTime(String string2, Calendar calendar) throws SQLException {
        return this.getTime(this.findParameterIndex(string2), calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(String string2, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string2), calendar);
    }

    @Override
    public URL getURL(String string2) throws SQLException {
        return this.getURL(this.findParameterIndex(string2));
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized RowId getRowId(String string2) throws SQLException {
        return this.getRowId(this.findParameterIndex(string2));
    }

    @Override
    public synchronized void setRowId(String string2, RowId rowId) throws SQLException {
        super.setRowId(this.findParameterIndex(string2), rowId);
    }

    @Override
    public synchronized void setNString(String string2, String string3) throws SQLException {
        super.setNString(this.findParameterIndex(string2), string3);
    }

    @Override
    public synchronized void setNCharacterStream(String string2, Reader reader, long l) throws SQLException {
        super.setNCharacterStream(this.findParameterIndex(string2), reader, l);
    }

    @Override
    public synchronized void setNClob(String string2, NClob nClob) throws SQLException {
        super.setNClob(this.findParameterIndex(string2), nClob);
    }

    @Override
    public synchronized void setClob(String string2, Reader reader, long l) throws SQLException {
        super.setClob(this.findParameterIndex(string2), reader, l);
    }

    @Override
    public synchronized void setBlob(String string2, InputStream inputStream, long l) throws SQLException {
        super.setBlob(this.findParameterIndex(string2), inputStream, l);
    }

    @Override
    public synchronized void setNClob(String string2, Reader reader, long l) throws SQLException {
        super.setNClob(this.findParameterIndex(string2), reader, l);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized NClob getNClob(String string2) throws SQLException {
        return this.getNClob(this.findParameterIndex(string2));
    }

    @Override
    public synchronized void setSQLXML(String string2, SQLXML sQLXML) throws SQLException {
        super.setSQLXML(this.findParameterIndex(string2), sQLXML);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized SQLXML getSQLXML(String string2) throws SQLException {
        return this.getSQLXML(this.findParameterIndex(string2));
    }

    @Override
    public String getNString(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized String getNString(String string2) throws SQLException {
        return this.getNString(this.findParameterIndex(string2));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized Reader getNCharacterStream(String string2) throws SQLException {
        return this.getNCharacterStream(this.findParameterIndex(string2));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return ((ClobDataID)object).getCharacterStream(this.session);
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public synchronized Reader getCharacterStream(String string2) throws SQLException {
        return this.getCharacterStream(this.findParameterIndex(string2));
    }

    @Override
    public synchronized void setBlob(String string2, Blob blob) throws SQLException {
        super.setBlob(this.findParameterIndex(string2), blob);
    }

    @Override
    public synchronized void setClob(String string2, Clob clob) throws SQLException {
        super.setClob(this.findParameterIndex(string2), clob);
    }

    @Override
    public synchronized void setAsciiStream(String string2, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            String string3 = "Maximum ASCII input octet length exceeded: " + l;
            throw JDBCUtil.sqlException(422, string3);
        }
        this.setAsciiStream(string2, inputStream, (int)l);
    }

    @Override
    public synchronized void setBinaryStream(String string2, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            String string3 = "Maximum Binary input octet length exceeded: " + l;
            throw JDBCUtil.sqlException(422, string3);
        }
        this.setBinaryStream(string2, inputStream, (int)l);
    }

    @Override
    public synchronized void setCharacterStream(String string2, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            String string3 = "Maximum character input length exceeded: " + l;
            throw JDBCUtil.sqlException(422, string3);
        }
        this.setCharacterStream(string2, reader, (int)l);
    }

    @Override
    public synchronized void setAsciiStream(String string2, InputStream inputStream) throws SQLException {
        super.setAsciiStream(this.findParameterIndex(string2), inputStream);
    }

    @Override
    public synchronized void setBinaryStream(String string2, InputStream inputStream) throws SQLException {
        super.setBinaryStream(this.findParameterIndex(string2), inputStream);
    }

    @Override
    public synchronized void setCharacterStream(String string2, Reader reader) throws SQLException {
        super.setCharacterStream(this.findParameterIndex(string2), reader);
    }

    @Override
    public synchronized void setNCharacterStream(String string2, Reader reader) throws SQLException {
        super.setNCharacterStream(this.findParameterIndex(string2), reader);
    }

    @Override
    public synchronized void setClob(String string2, Reader reader) throws SQLException {
        super.setClob(this.findParameterIndex(string2), reader);
    }

    @Override
    public synchronized void setBlob(String string2, InputStream inputStream) throws SQLException {
        super.setBlob(this.findParameterIndex(string2), inputStream);
    }

    @Override
    public synchronized void setNClob(String string2, Reader reader) throws SQLException {
        super.setNClob(this.findParameterIndex(string2), reader);
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        return (T)this.getObject(n);
    }

    @Override
    public <T> T getObject(String string2, Class<T> clazz) throws SQLException {
        return this.getObject(this.findParameterIndex(string2), clazz);
    }

    public JDBCCallableStatement(JDBCConnection jDBCConnection, String string2, int n, int n2, int n3) throws HsqlException, SQLException {
        super(jDBCConnection, string2, n, n2, n3, 2, null, null);
        if (this.parameterMetaData != null) {
            String[] stringArray = this.parameterMetaData.columnLabels;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3 == null || string3.length() == 0) continue;
                this.parameterNameMap.put(string3, i);
            }
        }
    }

    @Override
    void fetchResult() throws SQLException {
        super.fetchResult();
        if (this.resultIn.getType() == 43) {
            Object[] objectArray = this.resultIn.getParameterData();
            for (int i = 0; i < this.parameterValues.length; ++i) {
                this.parameterValues[i] = objectArray[i];
            }
        }
    }

    int findParameterIndex(String string2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (string2 == null) {
            throw JDBCUtil.nullArgument();
        }
        int n = this.parameterNameMap.get((Object)string2, -1);
        if (n >= 0) {
            return n + 1;
        }
        n = this.parameterNameMap.get((Object)string2.toUpperCase(Locale.ENGLISH), -1);
        if (n >= 0) {
            return n + 1;
        }
        throw JDBCUtil.sqlException(421, string2);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.parameterNameMap = null;
        super.close();
    }

    private Object getColumnInType(int n, Type type) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type2 = this.parameterTypes[--n];
        Object object = this.parameterValues[n];
        if (this.trackNull(object)) {
            return null;
        }
        if (type2.typeCode != type.typeCode) {
            try {
                object = type.convertToTypeJDBC(this.session, object, type2);
            }
            catch (HsqlException hsqlException) {
                String string2 = object instanceof Number || object instanceof String || object instanceof java.util.Date ? object.toString() : "instance of " + object.getClass().getName();
                String string3 = "from SQL type " + type2.getNameString() + " to " + type.getJDBCClassName() + ", value: " + string2;
                HsqlException hsqlException2 = Error.error(5561, string3);
                throw JDBCUtil.sqlException(hsqlException2, hsqlException);
            }
        }
        return object;
    }

    private boolean trackNull(Object object) {
        this.wasNullValue = object == null;
        return this.wasNullValue;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        this.fetchResult();
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet;
        }
        if (this.getMoreResults()) {
            return this.getResultSet();
        }
        throw JDBCUtil.sqlException(1254);
    }
}

