/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.KMPSearchAlgorithm;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCClob
implements Clob {
    private static final long MIN_POS = 1L;
    private static final long MAX_POS = 0x80000000L;
    private boolean m_closed;
    private String m_data;
    private final boolean m_createdByConnection;

    @Override
    public long length() throws SQLException {
        return this.getData().length();
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        String string2 = this.getData();
        int n2 = string2.length();
        if (l < 1L || l > (long)n2) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        if (n < 0 || (long)n > (long)n2 - --l) {
            throw JDBCUtil.outOfRangeArgument("length: " + n);
        }
        return l == 0L && n == n2 ? string2 : string2.substring((int)l, (int)l + n);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.getData());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(this.getData().getBytes("US-ASCII"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public long position(String string2, long l) throws SQLException {
        String string3 = this.getData();
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        if (string2 == null || l > 0x80000000L) {
            return -1L;
        }
        int n = KMPSearchAlgorithm.search(string3, string2, null, (int)l);
        return n == -1 ? -1L : (long)(n + 1);
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        long l2;
        String string2 = this.getData();
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        if (clob == null) {
            return -1L;
        }
        long l3 = string2.length();
        if (--l > l3 - (l2 = clob.length())) {
            return -1L;
        }
        String string3 = clob instanceof JDBCClob ? ((JDBCClob)clob).data() : clob.getSubString(1L, (int)l2);
        int n = KMPSearchAlgorithm.search(string2, string3, null, (int)l);
        return n == -1 ? -1L : (long)(n + 1);
    }

    @Override
    public int setString(long l, String string2) throws SQLException {
        if (string2 == null) {
            throw JDBCUtil.nullArgument("str");
        }
        return this.setString(l, string2, 0, string2.length());
    }

    @Override
    public int setString(long l, String string2, int n, int n2) throws SQLException {
        StringBuffer stringBuffer;
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        String string3 = this.getData();
        if (string2 == null) {
            throw JDBCUtil.nullArgument("str");
        }
        int n3 = string2.length();
        if (n < 0 || n > n3) {
            throw JDBCUtil.outOfRangeArgument("offset: " + n);
        }
        if (n2 > n3 - n) {
            throw JDBCUtil.outOfRangeArgument("len: " + n2);
        }
        if (l < 1L || l > 1L + (long)(Integer.MAX_VALUE - n2)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        int n4 = (int)(l - 1L);
        int n5 = string3.length();
        if (n4 > n5 - n2) {
            stringBuffer = new StringBuffer(n4 + n2);
            stringBuffer.append(string3.substring(0, n4));
            string3 = null;
            stringBuffer.append(string2.substring(n, n + n2));
            string2 = null;
        } else {
            stringBuffer = new StringBuffer(string3);
            string3 = null;
            int n6 = n4;
            for (int i = 0; i < n2; ++i) {
                stringBuffer.setCharAt(n6, string2.charAt(n + i));
                ++n6;
            }
            string2 = null;
        }
        this.setData(stringBuffer.toString());
        return n2;
    }

    @Override
    public OutputStream setAsciiStream(final long l) throws SQLException {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        this.checkClosed();
        if (l < 1L || l > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        return new ByteArrayOutputStream(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    JDBCClob.this.setString(l, new String(this.toByteArray(), "US-ASCII"));
                }
                catch (SQLException sQLException) {
                    throw JavaSystem.toIOException(sQLException);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public Writer setCharacterStream(final long l) throws SQLException {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        this.checkClosed();
        if (l < 1L || l > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        return new StringWriter(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    JDBCClob.this.setString(l, this.toString());
                }
                catch (SQLException sQLException) {
                    throw JavaSystem.toIOException(sQLException);
                }
            }
        };
    }

    @Override
    public void truncate(long l) throws SQLException {
        String string2 = this.getData();
        long l2 = string2.length();
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        if (l != l2) {
            if (l < 0L || l > l2) {
                throw JDBCUtil.outOfRangeArgument("len: " + l);
            }
            this.setData(string2.substring(0, (int)l));
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.m_closed = true;
        this.m_data = null;
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        if (l2 > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("length: " + l2);
        }
        return new StringReader(this.getSubString(l, (int)l2));
    }

    public JDBCClob(String string2) throws SQLException {
        if (string2 == null) {
            throw JDBCUtil.nullArgument();
        }
        this.m_data = string2;
        this.m_createdByConnection = false;
    }

    protected JDBCClob() {
        this.m_data = "";
        this.m_createdByConnection = true;
    }

    protected synchronized void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    protected String data() throws SQLException {
        return this.getData();
    }

    private synchronized String getData() throws SQLException {
        this.checkClosed();
        return this.m_data;
    }

    private synchronized void setData(String string2) throws SQLException {
        this.checkClosed();
        this.m_data = string2;
    }
}

