/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.JDBCDataSource;

public class JDBCDataSourceFactory
implements ObjectFactory {
    private static final String urlName = "url";
    private static final String databaseName = "database";
    private static final String userName = "user";
    private static final String userNameName = "username";
    private static final String passwordName = "password";
    private static final String loginTimeoutName = "loginTimeout";
    private static final String bdsClassName = "org.hsqldb.jdbc.JDBCDataSource";
    private static final String poolClassName = "org.hsqldb.jdbc.JDBCPool";
    private static final String pdsClassName = "org.hsqldb.jdbc.pool.JDBCPooledDataSource";
    private static final String xdsClassName = "org.hsqldb.jdbc.pool.JDBCXADataSource";

    public static DataSource createDataSource(Properties properties) throws Exception {
        JDBCDataSource jDBCDataSource = (JDBCDataSource)Class.forName(bdsClassName).newInstance();
        String string2 = properties.getProperty(databaseName);
        if (string2 == null) {
            string2 = properties.getProperty(urlName);
        }
        jDBCDataSource.setDatabase(string2);
        string2 = properties.getProperty(userName);
        if (string2 == null) {
            string2 = properties.getProperty(userNameName);
        }
        jDBCDataSource.setUser(string2);
        string2 = properties.getProperty(passwordName);
        jDBCDataSource.setPassword(string2);
        string2 = properties.getProperty(loginTimeoutName);
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            try {
                jDBCDataSource.setLoginTimeout(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return jDBCDataSource;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (!(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        String string2 = reference.getClassName();
        if (bdsClassName.equals(string2) || poolClassName.equals(string2) || pdsClassName.equals(string2) || xdsClassName.equals(string2)) {
            String string3;
            JDBCCommonDataSource jDBCCommonDataSource = (JDBCCommonDataSource)Class.forName(string2).newInstance();
            RefAddr refAddr = reference.get(databaseName);
            if (refAddr == null) {
                throw new Exception(string2 + ": RefAddr not set: database");
            }
            Object object2 = refAddr.getContent();
            if (!(object2 instanceof String)) {
                throw new Exception(string2 + ": invalid RefAddr: database");
            }
            jDBCCommonDataSource.setDatabase((String)object2);
            refAddr = reference.get(userName);
            if (refAddr == null) {
                throw new Exception(string2 + ": RefAddr not set: user");
            }
            object2 = reference.get(userName).getContent();
            if (!(object2 instanceof String)) {
                throw new Exception(string2 + ": invalid RefAddr: user");
            }
            jDBCCommonDataSource.setUser((String)object2);
            refAddr = reference.get(passwordName);
            if (refAddr == null) {
                object2 = "";
            } else {
                object2 = reference.get(passwordName).getContent();
                if (!(object2 instanceof String)) {
                    throw new Exception(string2 + ": invalid RefAddr: password");
                }
            }
            jDBCCommonDataSource.setPassword((String)object2);
            refAddr = reference.get(loginTimeoutName);
            if (refAddr != null && (object2 = refAddr.getContent()) instanceof String && (string3 = ((String)object2).trim()).length() > 0) {
                try {
                    jDBCCommonDataSource.setLoginTimeout(Integer.parseInt(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return jDBCCommonDataSource;
        }
        return null;
    }
}

