/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.ColumnBase;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCNClob;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCSQLXML;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.StringInputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class JDBCResultSet
implements ResultSet {
    private RowSetNavigator navigator;
    protected ResultMetaData resultMetaData;
    private boolean translateTTIType;
    private int columnCount;
    private boolean wasNullValue;
    private ResultSetMetaData resultSetMetaData;
    private IntValueHashMap columnMap;
    private SQLWarning rootWarning;
    JDBCStatementBase statement;
    SessionInterface session;
    JDBCConnection connection;
    boolean isScrollable;
    boolean isUpdatable;
    boolean isInsertable;
    int rsProperties;
    int fetchSize;
    boolean autoClose;
    public Result result;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;
    JDBCPreparedStatement preparedStatement;
    boolean isRowUpdated;
    boolean isOnInsertRow;
    int currentUpdateRowNumber;

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
        return this.navigator.next();
    }

    @Override
    public void close() throws SQLException {
        if (this.navigator == null) {
            return;
        }
        if (ResultProperties.isHeld(this.rsProperties)) {
            this.session.closeNavigator(this.navigator.getId());
        } else {
            this.navigator.release();
        }
        this.navigator = null;
        if (this.autoClose && this.statement != null) {
            this.statement.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullValue;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        if (type.typeCode == 40) {
            ClobDataID clobDataID = (ClobDataID)this.getColumnInType(n, type);
            if (clobDataID == null) {
                return null;
            }
            long l = clobDataID.length(this.session);
            if (l > Integer.MAX_VALUE) {
                JDBCUtil.throwError(Error.error(5561));
            }
            return clobDataID.getSubString(this.session, 0L, (int)l);
        }
        return (String)this.getColumnInType(n, Type.SQL_VARCHAR);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BOOLEAN);
        return object == null ? false : (Boolean)object;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.TINYINT);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    @Override
    public short getShort(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_SMALLINT);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    @Override
    public int getInt(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_INTEGER);
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public long getLong(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BIGINT);
        return object == null ? 0L : ((Number)object).longValue();
    }

    @Override
    public float getFloat(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    @Override
    public double getDouble(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, 1);
        }
        return bigDecimal;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        if (type.typeCode == 30) {
            BlobDataID blobDataID = (BlobDataID)this.getColumnInType(n, type);
            if (blobDataID == null) {
                return null;
            }
            long l = blobDataID.length(this.session);
            if (l > Integer.MAX_VALUE) {
                JDBCUtil.throwError(Error.error(5561));
            }
            return blobDataID.getBytes(this.session, 0L, (int)l);
        }
        Object object = this.getColumnInType(n, Type.SQL_VARBINARY);
        if (object == null) {
            return null;
        }
        return ((BinaryData)object).getBytes();
    }

    @Override
    public Date getDate(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DATE);
        if (object == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, object);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_TIME);
        if (object == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, object);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_TIMESTAMP);
        if (object == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, object);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        String string2 = this.getString(n);
        if (string2 == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string2.getBytes("US-ASCII"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        String string2 = this.getString(n);
        if (string2 == null) {
            return null;
        }
        return new StringInputStream(string2);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            return ((BlobDataID)object).getBinaryStream(this.session);
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBinaryStream();
        }
        if (object instanceof BinaryData) {
            byte[] byArray = this.getBytes(n);
            return new ByteArrayInputStream(byArray);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public String getString(String string2) throws SQLException {
        return this.getString(this.findColumn(string2));
    }

    @Override
    public boolean getBoolean(String string2) throws SQLException {
        return this.getBoolean(this.findColumn(string2));
    }

    @Override
    public byte getByte(String string2) throws SQLException {
        return this.getByte(this.findColumn(string2));
    }

    @Override
    public short getShort(String string2) throws SQLException {
        return this.getShort(this.findColumn(string2));
    }

    @Override
    public int getInt(String string2) throws SQLException {
        return this.getInt(this.findColumn(string2));
    }

    @Override
    public long getLong(String string2) throws SQLException {
        return this.getLong(this.findColumn(string2));
    }

    @Override
    public float getFloat(String string2) throws SQLException {
        return this.getFloat(this.findColumn(string2));
    }

    @Override
    public double getDouble(String string2) throws SQLException {
        return this.getDouble(this.findColumn(string2));
    }

    @Override
    public BigDecimal getBigDecimal(String string2, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string2), n);
    }

    @Override
    public byte[] getBytes(String string2) throws SQLException {
        return this.getBytes(this.findColumn(string2));
    }

    @Override
    public Date getDate(String string2) throws SQLException {
        return this.getDate(this.findColumn(string2));
    }

    @Override
    public Time getTime(String string2) throws SQLException {
        return this.getTime(this.findColumn(string2));
    }

    @Override
    public Timestamp getTimestamp(String string2) throws SQLException {
        return this.getTimestamp(this.findColumn(string2));
    }

    @Override
    public InputStream getAsciiStream(String string2) throws SQLException {
        return this.getAsciiStream(this.findColumn(string2));
    }

    @Override
    public InputStream getUnicodeStream(String string2) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string2));
    }

    @Override
    public InputStream getBinaryStream(String string2) throws SQLException {
        return this.getBinaryStream(this.findColumn(string2));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return "";
        }
        return this.result.getMainString();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultSetMetaData == null) {
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, this.isUpdatable, this.isInsertable, this.connection);
        }
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        switch (type.typeCode) {
            case 50: {
                return this.getArray(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: 
            case 94: {
                return this.getTime(n);
            }
            case 93: 
            case 95: {
                return this.getTimestamp(n);
            }
            case 60: 
            case 61: {
                return this.getBytes(n);
            }
            case 14: {
                boolean bl = this.getBoolean(n);
                return this.wasNull() ? null : (bl ? Boolean.TRUE : Boolean.FALSE);
            }
            case 40: {
                return this.getClob(n);
            }
            case 30: {
                return this.getBlob(n);
            }
            case 1111: 
            case 2000: {
                Object object = this.getColumnInType(n, type);
                if (object == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)object).getObject();
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
        }
        return this.getColumnInType(n, type);
    }

    @Override
    public Object getObject(String string2) throws SQLException {
        return this.getObject(this.findColumn(string2));
    }

    @Override
    public int findColumn(String string2) throws SQLException {
        int n;
        int n2;
        this.checkClosed();
        if (string2 == null) {
            throw JDBCUtil.nullArgument();
        }
        if (this.columnMap != null && (n2 = this.columnMap.get((Object)string2, -1)) != -1) {
            return n2;
        }
        String[] stringArray = this.resultMetaData.columnLabels;
        n2 = -1;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!string2.equalsIgnoreCase(stringArray[i])) continue;
            n2 = i;
            break;
        }
        ColumnBase[] columnBaseArray = this.resultMetaData.columns;
        if (n2 < 0) {
            for (n = 0; n < this.columnCount; ++n) {
                if (!string2.equalsIgnoreCase(columnBaseArray[n].getNameString())) continue;
                n2 = n;
                break;
            }
        }
        if (n2 < 0) {
            n = string2.indexOf(46);
            if (n < 0) {
                throw JDBCUtil.sqlException(421, string2);
            }
            for (int i = 0; i < this.columnCount; ++i) {
                String string3;
                String string4 = columnBaseArray[i].getTableNameString();
                if (string4 == null || string4.length() == 0) continue;
                String string5 = columnBaseArray[i].getNameString();
                if (string2.equalsIgnoreCase(string4 + '.' + string5)) {
                    n2 = i;
                    break;
                }
                String string6 = columnBaseArray[i].getSchemaNameString();
                if (string6 == null || string6.length() == 0 || !string2.equalsIgnoreCase(string3 = new StringBuffer(string6).append('.').append(string4).append('.').append(string5).toString())) continue;
                n2 = i;
                break;
            }
        }
        if (n2 < 0) {
            throw JDBCUtil.sqlException(421, string2);
        }
        ++n2;
        if (this.columnMap == null) {
            this.columnMap = new IntValueHashMap();
        }
        this.columnMap.put(string2, n2);
        return n2;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return ((ClobDataID)object).getCharacterStream(this.session);
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Reader getCharacterStream(String string2) throws SQLException {
        return this.getCharacterStream(this.findColumn(string2));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        switch (type.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                type = Type.SQL_DECIMAL;
                break;
            }
            default: {
                type = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(n, type);
    }

    @Override
    public BigDecimal getBigDecimal(String string2) throws SQLException {
        return this.getBigDecimal(this.findColumn(string2));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.navigator.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.navigator.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.first();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.last();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.navigator.isAfterLast()) {
            return 0;
        }
        return this.navigator.getRowNumber() + 1;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        if (n > 0) {
            --n;
        } else if (n == 0) {
            return this.navigator.beforeFirst();
        }
        return this.navigator.absolute(n);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.relative(n);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.rootWarning = null;
        return this.navigator.previous();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1000: {
                break;
            }
            case 1001: {
                this.checkNotForwardOnly();
                break;
            }
            case 1002: {
                this.checkNotForwardOnly();
                break;
            }
            default: {
                throw JDBCUtil.notSupported();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return this.isRowUpdated;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, null);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, bl2);
    }

    @Override
    public void updateByte(int n, byte by2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setIntParameter(n, by2);
    }

    @Override
    public void updateShort(int n, short s2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setIntParameter(n, s2);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setIntParameter(n, n2);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setLongParameter(n, l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        Double d = new Double(f);
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, d);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        Double d2 = new Double(d);
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, d2);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, bigDecimal);
    }

    @Override
    public void updateString(int n, String string2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, string2);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, byArray);
    }

    @Override
    public void updateDate(int n, Date date2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, date2);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, timestamp);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream, n2);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream, n2);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader, n2);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setObject(n, object, 0, n2);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, object);
    }

    @Override
    public void updateNull(String string2) throws SQLException {
        this.updateNull(this.findColumn(string2));
    }

    @Override
    public void updateBoolean(String string2, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string2), bl);
    }

    @Override
    public void updateByte(String string2, byte by2) throws SQLException {
        this.updateByte(this.findColumn(string2), by2);
    }

    @Override
    public void updateShort(String string2, short s2) throws SQLException {
        this.updateShort(this.findColumn(string2), s2);
    }

    @Override
    public void updateInt(String string2, int n) throws SQLException {
        this.updateInt(this.findColumn(string2), n);
    }

    @Override
    public void updateLong(String string2, long l) throws SQLException {
        this.updateLong(this.findColumn(string2), l);
    }

    @Override
    public void updateFloat(String string2, float f) throws SQLException {
        this.updateFloat(this.findColumn(string2), f);
    }

    @Override
    public void updateDouble(String string2, double d) throws SQLException {
        this.updateDouble(this.findColumn(string2), d);
    }

    @Override
    public void updateBigDecimal(String string2, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string2), bigDecimal);
    }

    @Override
    public void updateString(String string2, String string3) throws SQLException {
        this.updateString(this.findColumn(string2), string3);
    }

    @Override
    public void updateBytes(String string2, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string2), byArray);
    }

    @Override
    public void updateDate(String string2, Date date2) throws SQLException {
        this.updateDate(this.findColumn(string2), date2);
    }

    @Override
    public void updateTime(String string2, Time time) throws SQLException {
        this.updateTime(this.findColumn(string2), time);
    }

    @Override
    public void updateTimestamp(String string2, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string2), timestamp);
    }

    @Override
    public void updateAsciiStream(String string2, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string2), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string2, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string2), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string2, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string2), reader, n);
    }

    @Override
    public void updateObject(String string2, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string2), object, n);
    }

    @Override
    public void updateObject(String string2, Object object) throws SQLException {
        this.updateObject(this.findColumn(string2), object);
    }

    @Override
    public void insertRow() throws SQLException {
        this.performInsert();
    }

    @Override
    public void updateRow() throws SQLException {
        this.performUpdate();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.performDelete();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.startInsert();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.endInsert();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return (Statement)((Object)this.statement);
    }

    public Object getObject(int n, Map map23) throws SQLException {
        return this.getObject(n);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            JDBCBlobClient jDBCBlobClient = new JDBCBlobClient(this.session, (BlobDataID)object);
            if (this.isUpdatable && this.resultMetaData.colIndexes[n - 1] > 0 && this.resultMetaData.columns[n - 1].isWriteable()) {
                jDBCBlobClient.setWritable(this, n - 1);
            }
            return jDBCBlobClient;
        }
        if (object instanceof Blob) {
            return (Blob)object;
        }
        if (object instanceof BinaryData) {
            byte[] byArray = this.getBytes(n);
            return new JDBCBlob(byArray);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            JDBCClobClient jDBCClobClient = new JDBCClobClient(this.session, (ClobDataID)object);
            if (this.isUpdatable && this.resultMetaData.colIndexes[n - 1] > 0 && this.resultMetaData.columns[n - 1].isWriteable()) {
                jDBCClobClient.setWritable(this, n - 1);
            }
            return jDBCClobClient;
        }
        if (object instanceof Clob) {
            return (Clob)object;
        }
        if (object instanceof String) {
            return new JDBCClob((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object[] objectArray = (Object[])this.getCurrent()[n - 1];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        if (this.trackNull(objectArray)) {
            return null;
        }
        return new JDBCArray(objectArray, type.collectionBaseType(), type, this.connection);
    }

    public Object getObject(String string2, Map map23) throws SQLException {
        return this.getObject(this.findColumn(string2), map23);
    }

    @Override
    public Ref getRef(String string2) throws SQLException {
        return this.getRef(this.findColumn(string2));
    }

    @Override
    public Blob getBlob(String string2) throws SQLException {
        return this.getBlob(this.findColumn(string2));
    }

    @Override
    public Clob getClob(String string2) throws SQLException {
        return this.getClob(this.findColumn(string2));
    }

    @Override
    public Array getArray(String string2) throws SQLException {
        return this.getArray(this.findColumn(string2));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        long l = timestampData.getSeconds() * 1000L;
        if (calendar != null) {
            l = HsqlDateTime.convertMillisToCalendar(calendar, l);
        }
        return new Date(l);
    }

    @Override
    public Date getDate(String string2, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string2), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        long l = (long)DateTimeType.normaliseTime(timeData.getSeconds()) * 1000L;
        if (!this.resultMetaData.columnTypes[--n].isDateTimeTypeWithZone()) {
            Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
            l = HsqlDateTime.convertMillisToCalendar(calendar2, l);
            l = HsqlDateTime.getNormalisedTime(l);
        }
        return new Time(l);
    }

    @Override
    public Time getTime(String string2, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string2), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Comparable<Calendar> comparable;
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        long l = timestampData.getSeconds() * 1000L;
        if (!this.resultMetaData.columnTypes[--n].isDateTimeTypeWithZone()) {
            Comparable<Calendar> comparable2 = comparable = calendar == null ? this.session.getCalendar() : calendar;
            if (calendar != null) {
                l = HsqlDateTime.convertMillisToCalendar((Calendar)comparable, l);
            }
        }
        comparable = new Timestamp(l);
        ((Timestamp)comparable).setNanos(timestampData.getNanos());
        return comparable;
    }

    @Override
    public Timestamp getTimestamp(String string2, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string2), calendar);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public URL getURL(String string2) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRef(String string2, Ref ref) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBlobParameter(n, blob);
    }

    @Override
    public void updateBlob(String string2, Blob blob) throws SQLException {
        int n = this.findColumn(string2);
        this.updateBlob(n, blob);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClobParameter(n, clob);
    }

    @Override
    public void updateClob(String string2, Clob clob) throws SQLException {
        int n = this.findColumn(string2);
        this.updateClob(n, clob);
    }

    @Override
    public void updateArray(int n, Array array2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, array2);
    }

    @Override
    public void updateArray(String string2, Array array2) throws SQLException {
        int n = this.findColumn(string2);
        this.updateArray(n, array2);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public RowId getRowId(String string2) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRowId(String string2, RowId rowId) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.navigator == null;
    }

    @Override
    public void updateNString(int n, String string2) throws SQLException {
        this.updateString(n, string2);
    }

    @Override
    public void updateNString(String string2, String string3) throws SQLException {
        this.updateString(string2, string3);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.updateClob(n, (Clob)nClob);
    }

    @Override
    public void updateNClob(String string2, NClob nClob) throws SQLException {
        this.updateClob(string2, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        String string2 = this.getString(n);
        return string2 == null ? null : new JDBCNClob(string2);
    }

    @Override
    public NClob getNClob(String string2) throws SQLException {
        return this.getNClob(this.findColumn(string2));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        SQLXML sQLXML;
        this.checkColumn(n);
        int n2 = this.resultMetaData.columnTypes[n - 1].typeCode;
        switch (n2) {
            case 137: {
                Object object = this.getObject(n);
                if (object == null) {
                    sQLXML = null;
                    break;
                }
                if (object instanceof SQLXML) {
                    sQLXML = (SQLXML)object;
                    break;
                }
                throw JDBCUtil.notSupported();
            }
            case 40: {
                Clob clob = this.getClob(n);
                if (clob == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(clob.getCharacterStream());
                break;
            }
            case 1: 
            case 12: {
                Reader reader = this.getCharacterStream(n);
                if (reader == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(reader);
                break;
            }
            case -9: 
            case -8: {
                Reader reader = this.getNCharacterStream(n);
                if (reader == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(reader);
                break;
            }
            case 30: {
                Blob blob = this.getBlob(n);
                if (blob == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(blob.getBinaryStream());
                break;
            }
            case 60: 
            case 61: {
                InputStream inputStream = this.getBinaryStream(n);
                if (inputStream == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(inputStream);
                break;
            }
            case 1111: 
            case 2000: {
                Object object = this.getObject(n);
                if (object == null) {
                    sQLXML = null;
                    break;
                }
                if (object instanceof SQLXML) {
                    sQLXML = (SQLXML)object;
                    break;
                }
                if (object instanceof String) {
                    sQLXML = new JDBCSQLXML((String)object);
                    break;
                }
                if (object instanceof byte[]) {
                    sQLXML = new JDBCSQLXML((byte[])object);
                    break;
                }
                if (object instanceof Blob) {
                    Blob blob = (Blob)object;
                    sQLXML = new JDBCSQLXML(blob.getBinaryStream());
                    break;
                }
                if (object instanceof Clob) {
                    Clob clob = (Clob)object;
                    sQLXML = new JDBCSQLXML(clob.getCharacterStream());
                    break;
                }
                throw JDBCUtil.notSupported();
            }
            default: {
                throw JDBCUtil.notSupported();
            }
        }
        return sQLXML;
    }

    @Override
    public SQLXML getSQLXML(String string2) throws SQLException {
        return this.getSQLXML(this.findColumn(string2));
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setSQLXML(n, sQLXML);
    }

    @Override
    public void updateSQLXML(String string2, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumn(string2), sQLXML);
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string2) throws SQLException {
        return this.getString(this.findColumn(string2));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string2) throws SQLException {
        return this.getCharacterStream(this.findColumn(string2));
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string2, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(string2, reader, l);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader, l);
    }

    @Override
    public void updateAsciiStream(String string2, InputStream inputStream, long l) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream, l);
    }

    @Override
    public void updateBinaryStream(String string2, InputStream inputStream, long l) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateCharacterStream(String string2, Reader reader, long l) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader, l);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBlob(n, inputStream, l);
    }

    @Override
    public void updateBlob(String string2, InputStream inputStream, long l) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setBlob(n, inputStream, l);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader, l);
    }

    @Override
    public void updateClob(String string2, Reader reader, long l) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader, l);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader, l);
    }

    @Override
    public void updateNClob(String string2, Reader reader, long l) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    @Override
    public void updateNCharacterStream(String string2, Reader reader) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    @Override
    public void updateAsciiStream(String string2, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream);
    }

    @Override
    public void updateBinaryStream(String string2, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream);
    }

    @Override
    public void updateCharacterStream(String string2, Reader reader) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBlob(n, inputStream);
    }

    @Override
    public void updateBlob(String string2, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setBlob(n, inputStream);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    @Override
    public void updateClob(String string2, Reader reader) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    @Override
    public void updateNClob(String string2, Reader reader) throws SQLException {
        int n = this.findColumn(string2);
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        return (T)this.getObject(n);
    }

    @Override
    public <T> T getObject(String string2, Class<T> clazz) throws SQLException {
        return this.getObject(this.findColumn(string2), clazz);
    }

    protected Object[] getCurrent() throws SQLException {
        RowSetNavigator rowSetNavigator = this.navigator;
        if (rowSetNavigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
        if (rowSetNavigator.isEmpty()) {
            throw JDBCUtil.sqlException(3603, 70);
        }
        if (rowSetNavigator.isBeforeFirst()) {
            throw JDBCUtil.sqlException(3603, 71);
        }
        if (rowSetNavigator.isAfterLast()) {
            throw JDBCUtil.sqlException(3603, 72);
        }
        Object[] objectArray = rowSetNavigator.getCurrent();
        if (objectArray == null) {
            throw JDBCUtil.sqlException(3601);
        }
        return objectArray;
    }

    private void checkClosed() throws SQLException {
        if (this.navigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
    }

    protected void checkColumn(int n) throws SQLException {
        if (this.navigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
        if (n < 1 || n > this.columnCount) {
            throw JDBCUtil.sqlException(421, String.valueOf(n));
        }
    }

    protected boolean trackNull(Object object) {
        this.wasNullValue = object == null;
        return this.wasNullValue;
    }

    protected Object getColumnInType(int n, Type type) throws SQLException {
        Object[] objectArray = this.getCurrent();
        this.checkColumn(n);
        Type type2 = this.resultMetaData.columnTypes[--n];
        Object object = objectArray[n];
        if (this.trackNull(object)) {
            return null;
        }
        if (this.translateTTIType && type.isIntervalType()) {
            type = ((IntervalType)type).getCharacterType();
        }
        if (type2.typeCode != type.typeCode) {
            try {
                object = type.convertToTypeJDBC(this.session, object, type2);
            }
            catch (Exception exception) {
                String string2 = object instanceof Number || object instanceof String ? object.toString() : "instance of " + object.getClass().getName();
                String string3 = "from SQL type " + type2.getNameString() + " to " + type.getJDBCClassName() + ", value: " + string2;
                JDBCUtil.throwError(Error.error(5561, string3));
            }
        }
        return object;
    }

    private void checkNotForwardOnly() throws SQLException {
        if (!this.isScrollable) {
            throw JDBCUtil.notSupported();
        }
    }

    private void checkUpdatable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdatable) {
            throw JDBCUtil.notUpdatableColumn();
        }
    }

    private void checkUpdatable(int n) throws SQLException {
        this.checkClosed();
        this.checkColumn(n);
        if (!this.isUpdatable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        if (this.resultMetaData.colIndexes[--n] == -1) {
            throw JDBCUtil.notUpdatableColumn();
        }
        if (!this.resultMetaData.columns[n].isWriteable()) {
            throw JDBCUtil.notUpdatableColumn();
        }
    }

    void startUpdate(int n) throws SQLException {
        this.checkUpdatable(n);
        if (this.currentUpdateRowNumber != this.navigator.getRowNumber()) {
            this.preparedStatement.clearParameters();
        }
        this.currentUpdateRowNumber = this.navigator.getRowNumber();
        this.isRowUpdated = true;
    }

    private void clearUpdates() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isRowUpdated = false;
    }

    private void startInsert() throws SQLException {
        this.checkUpdatable();
        this.isOnInsertRow = true;
    }

    private void endInsert() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isOnInsertRow = false;
    }

    private void performUpdate() throws SQLException {
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            boolean bl = this.preparedStatement.parameterSet[i] != null;
            this.preparedStatement.resultOut.metaData.columnTypes[i] = bl ? this.preparedStatement.parameterTypes[i] : Type.SQL_ALL_TYPES;
        }
        this.preparedStatement.resultOut.setActionType(91);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
        this.isRowUpdated = false;
    }

    private void performInsert() throws SQLException {
        this.checkUpdatable();
        for (int i = 0; i < this.columnCount; ++i) {
            boolean bl;
            boolean bl2 = bl = this.preparedStatement.parameterSet[i] != null;
            if (!bl) {
                throw JDBCUtil.sqlException(3606);
            }
            this.preparedStatement.resultOut.metaData.columnTypes[i] = this.preparedStatement.parameterTypes[i];
        }
        this.preparedStatement.resultOut.setActionType(55);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    private void performDelete() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        this.preparedStatement.resultOut.metaData.columnTypes[this.columnCount] = this.resultMetaData.columnTypes[this.columnCount];
        this.preparedStatement.resultOut.setActionType(18);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    RowSetNavigator getNavigator() {
        return this.navigator;
    }

    void setNavigator(RowSetNavigator rowSetNavigator) {
        this.navigator = rowSetNavigator;
    }

    public JDBCResultSet(JDBCConnection jDBCConnection, JDBCStatementBase jDBCStatementBase, Result result2, ResultMetaData resultMetaData) {
        this(jDBCConnection, result2, resultMetaData);
        this.statement = jDBCStatementBase;
        this.isScrollable = ResultProperties.isScrollable(this.rsProperties);
        if (ResultProperties.isUpdatable(this.rsProperties)) {
            this.isUpdatable = true;
            this.isInsertable = true;
            for (int i = 0; i < resultMetaData.colIndexes.length; ++i) {
                if (resultMetaData.colIndexes[i] >= 0) continue;
                this.isInsertable = false;
                break;
            }
            this.preparedStatement = new JDBCPreparedStatement(jDBCStatementBase.connection, this.result);
        }
    }

    public JDBCResultSet(JDBCConnection jDBCConnection, Result result2, ResultMetaData resultMetaData) {
        this.session = jDBCConnection == null ? null : jDBCConnection.sessionProxy;
        this.result = result2;
        this.connection = jDBCConnection;
        this.rsProperties = result2.rsProperties;
        this.navigator = result2.getNavigator();
        this.resultMetaData = resultMetaData;
        this.columnCount = this.resultMetaData.getColumnCount();
        if (jDBCConnection != null) {
            this.translateTTIType = jDBCConnection.isTranslateTTIType;
        }
    }

    public static JDBCResultSet newJDBCResultSet(Result result2, ResultMetaData resultMetaData) {
        return new JDBCResultSetBasic(result2, resultMetaData);
    }

    public static JDBCResultSet newEmptyResultSet() {
        ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(1);
        ColumnBase columnBase = new ColumnBase(null, null, null, "C1");
        columnBase.setType(Type.SQL_INTEGER);
        resultMetaData.columnTypes[0] = Type.SQL_INTEGER;
        resultMetaData.columns[0] = columnBase;
        Result result2 = Result.newSingleColumnResult(resultMetaData);
        return JDBCResultSet.newJDBCResultSet(result2, resultMetaData);
    }

    static class JDBCResultSetBasic
    extends JDBCResultSet {
        JDBCResultSetBasic(Result result2, ResultMetaData resultMetaData) {
            super(null, result2, resultMetaData);
        }

        @Override
        protected Object getColumnInType(int n, Type type) throws SQLException {
            Object[] objectArray = this.getCurrent();
            this.checkColumn(n);
            Type type2 = this.resultMetaData.columnTypes[--n];
            Object object = objectArray[n];
            if (this.trackNull(object)) {
                return null;
            }
            if (type2.typeCode != type.typeCode) {
                JDBCUtil.throwError(Error.error(5561));
            }
            return object;
        }

        @Override
        public Date getDate(int n) throws SQLException {
            return (Date)this.getColumnInType(n, Type.SQL_DATE);
        }

        @Override
        public Time getTime(int n) throws SQLException {
            return (Time)this.getColumnInType(n, Type.SQL_DATE);
        }

        @Override
        public Timestamp getTimestamp(int n) throws SQLException {
            return (Timestamp)this.getColumnInType(n, Type.SQL_DATE);
        }

        @Override
        public InputStream getBinaryStream(int n) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Reader getCharacterStream(int n) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Blob getBlob(int n) throws SQLException {
            this.checkColumn(n);
            Type type = this.resultMetaData.columnTypes[n - 1];
            Object object = this.getColumnInType(n, type);
            if (object == null) {
                return null;
            }
            if (object instanceof Blob) {
                return (Blob)object;
            }
            if (object instanceof byte[]) {
                return new JDBCBlob((byte[])object);
            }
            throw JDBCUtil.sqlException(5561);
        }

        @Override
        public Clob getClob(int n) throws SQLException {
            this.checkColumn(n);
            Type type = this.resultMetaData.columnTypes[n - 1];
            Object object = this.getColumnInType(n, type);
            if (object == null) {
                return null;
            }
            if (object instanceof Clob) {
                return (Clob)object;
            }
            if (object instanceof String) {
                return new JDBCClob((String)object);
            }
            throw JDBCUtil.sqlException(5561);
        }

        @Override
        public Time getTime(int n, Calendar calendar) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
            throw JDBCUtil.notSupported();
        }
    }
}

